/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.advancements;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class MultiblockTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("immersiveengineering", "multiblock_formed");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancements);
        if (listeners == null) {
            listeners = new Listeners(playerAdvancements);
            this.listeners.put(playerAdvancements, listeners);
        }
        listeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancements);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(playerAdvancements);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancements) {
        this.listeners.remove(playerAdvancements);
    }

    public Instance deserialize(JsonObject json, ConditionArrayParser context) {
        EntityPredicate.AndPredicate and = EntityPredicate.AndPredicate.func_234587_a_((JsonObject)json, (String)"player", (ConditionArrayParser)context);
        return new Instance(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"multiblock")), ItemPredicate.func_192492_a((JsonElement)json.get("item")), and);
    }

    public void trigger(ServerPlayerEntity player, MultiblockHandler.IMultiblock multiblock, ItemStack hammer) {
        Listeners listeners = this.listeners.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(multiblock, hammer);
        }
    }

    public static Instance create(ResourceLocation multiblock, ItemPredicate hammer) {
        return new Instance(multiblock, hammer, EntityPredicate.AndPredicate.field_234582_a_);
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(MultiblockHandler.IMultiblock multiblock, ItemStack hammer) {
            List list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(multiblock, hammer)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener1 : list) {
                    listener1.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends CriterionInstance {
        private final ResourceLocation multiblock;
        private final ItemPredicate hammer;

        public Instance(ResourceLocation multiblock, ItemPredicate hammer, EntityPredicate.AndPredicate and) {
            super(ID, and);
            this.multiblock = multiblock;
            this.hammer = hammer;
        }

        public boolean test(MultiblockHandler.IMultiblock multiblock, ItemStack hammer) {
            return this.multiblock.equals((Object)multiblock.getUniqueName()) && this.hammer.func_192493_a(hammer);
        }

        public JsonObject func_230240_a_(ConditionArraySerializer conditions) {
            JsonObject jsonobject = super.func_230240_a_(conditions);
            jsonobject.addProperty("multiblock", this.multiblock.toString());
            jsonobject.add("item", this.hammer.func_200319_a());
            return jsonobject;
        }
    }
}

