/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker.managers;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CrTIngredientUtil;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersiveengineering/Blueprint")
@ZenCodeType.Name(value="mods.immersiveengineering.Blueprint")
public class BlueprintCraftingRecipeManager
implements IRecipeManager {
    public IRecipeType<BlueprintCraftingRecipe> getRecipeType() {
        return BlueprintCraftingRecipe.TYPE;
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, final String blueprintCategory, IIngredientWithAmount[] inputs, IItemStack output) {
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", recipePath);
        IngredientWithSize[] ingredients = CrTIngredientUtil.getIngredientsWithSize(inputs);
        ItemStack results = output.getInternal();
        BlueprintCraftingRecipe recipe = new BlueprintCraftingRecipe(resourceLocation, blueprintCategory, results, ingredients);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe(this, recipe, null){

            public boolean validate(ILogger logger) {
                if (!BlueprintCraftingRecipe.recipeCategories.contains(blueprintCategory)) {
                    String format = "Blueprint Category '%s' does not exist!";
                    logger.error(String.format("Blueprint Category '%s' does not exist!", blueprintCategory));
                    return false;
                }
                return true;
            }
        });
    }
}

