/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei;

import blusunrize.immersiveengineering.client.gui.FluidSorterScreen;
import com.google.common.collect.ImmutableList;
import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraftforge.fluids.FluidStack;

public class FluidSorterGhostHandler
implements IGhostIngredientHandler<FluidSorterScreen> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(FluidSorterScreen gui, I ingredient, boolean doStart) {
        if (ingredient instanceof FluidStack) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int side = 0; side < 6; ++side) {
                for (int slot = 0; slot < 8; ++slot) {
                    builder.add((Object)new GhostFluidTarget(side, slot, gui));
                }
            }
            return builder.build();
        }
        return ImmutableList.of();
    }

    public void onComplete() {
    }

    private static class GhostFluidTarget
    implements IGhostIngredientHandler.Target<FluidStack> {
        final int side;
        final int slot;
        final FluidSorterScreen gui;
        Rectangle2d area;
        int lastGuiLeft;
        int lastGuiTop;

        public GhostFluidTarget(int side, int slot, FluidSorterScreen gui) {
            this.side = side;
            this.slot = slot;
            this.gui = gui;
            this.initRectangle();
        }

        private void initRectangle() {
            int x = 4 + this.side / 2 * 58 + (this.slot < 3 ? this.slot * 18 : (this.slot > 4 ? (this.slot - 5) * 18 : (this.slot == 3 ? 0 : 36)));
            int y = 22 + this.side % 2 * 76 + (this.slot < 3 ? 0 : (this.slot > 4 ? 36 : 18));
            this.area = new Rectangle2d(this.gui.getGuiLeft() + x, this.gui.getGuiTop() + y, 16, 16);
            this.lastGuiLeft = this.gui.getGuiLeft();
            this.lastGuiTop = this.gui.getGuiTop();
        }

        public Rectangle2d getArea() {
            if (this.lastGuiLeft != this.gui.getGuiLeft() || this.lastGuiTop != this.gui.getGuiTop()) {
                this.initRectangle();
            }
            return this.area;
        }

        public void accept(FluidStack ingredient) {
            this.gui.setFluidInSlot(this.side, this.slot, ingredient);
        }
    }
}

