/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.fluids;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.items.PotionBucketItem;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionFluid
extends Fluid {
    public static final Item bucket = new PotionBucketItem();

    public PotionFluid() {
        this.setRegistryName("immersiveengineering", "potion");
        IEContent.registeredIEFluids.add(this);
    }

    public static FluidStack getFluidStackForType(Potion type, int amount) {
        if (type == Potions.field_185230_b || type == null) {
            return new FluidStack((Fluid)Fluids.field_204546_a, amount);
        }
        FluidStack stack = new FluidStack(IEContent.fluidPotion, amount);
        stack.getOrCreateTag().func_74778_a("Potion", type.getRegistryName().toString());
        return stack;
    }

    public static Potion getType(FluidStack stack) {
        return PotionFluid.fromTag(stack.getTag());
    }

    public static Potion fromTag(@Nullable CompoundNBT tag) {
        if (tag == null || !tag.func_150297_b("Potion", 8)) {
            return Potions.field_185230_b;
        }
        ResourceLocation name = ResourceLocation.func_208304_a((String)tag.func_74779_i("Potion"));
        if (name == null) {
            return Potions.field_185230_b;
        }
        Potion result = (Potion)ForgeRegistries.POTION_TYPES.getValue(name);
        return result == Potions.field_185229_a ? Potions.field_185230_b : result;
    }

    @Nonnull
    public Item func_204524_b() {
        return Items.field_190931_a;
    }

    protected boolean func_215665_a(@Nonnull FluidState fluidState, @Nonnull IBlockReader blockReader, @Nonnull BlockPos pos, @Nonnull Fluid fluid, @Nonnull Direction direction) {
        return true;
    }

    @Nonnull
    protected Vector3d func_215663_a(@Nonnull IBlockReader blockReader, @Nonnull BlockPos pos, @Nonnull FluidState fluidState) {
        return Vector3d.field_186680_a;
    }

    public int func_205569_a(IWorldReader p_205569_1_) {
        return 0;
    }

    protected float func_210195_d() {
        return 0.0f;
    }

    public float func_215662_a(@Nonnull FluidState p_215662_1_, @Nonnull IBlockReader p_215662_2_, @Nonnull BlockPos p_215662_3_) {
        return 0.0f;
    }

    public float func_223407_a(@Nonnull FluidState p_223407_1_) {
        return 0.0f;
    }

    @Nonnull
    protected BlockState func_204527_a(@Nonnull FluidState state) {
        return Blocks.field_150350_a.func_176223_P();
    }

    public boolean func_207193_c(@Nonnull FluidState state) {
        return true;
    }

    public int func_207192_d(@Nonnull FluidState state) {
        return 0;
    }

    @Nonnull
    public VoxelShape func_215664_b(@Nonnull FluidState p_215664_1_, @Nonnull IBlockReader p_215664_2_, @Nonnull BlockPos p_215664_3_) {
        return VoxelShapes.func_197880_a();
    }

    protected FluidAttributes createAttributes() {
        FluidAttributes.Builder builder = FluidAttributes.builder((ResourceLocation)ImmersiveEngineering.rl("block/fluid/potion_still"), (ResourceLocation)ImmersiveEngineering.rl("block/fluid/potion_flow"));
        return new PotionFluidAttributes(builder, this);
    }

    public void addInformation(FluidStack fluidStack, List<ITextComponent> tooltip) {
        if (fluidStack != null && fluidStack.hasTag()) {
            List effects = PotionUtils.func_185185_a((CompoundNBT)fluidStack.getTag());
            if (effects.isEmpty()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("effect.none").func_240699_a_(TextFormatting.GRAY));
            } else {
                for (EffectInstance instance : effects) {
                    TranslationTextComponent itextcomponent = new TranslationTextComponent(instance.func_76453_d());
                    Effect effect = instance.func_188419_a();
                    if (instance.func_76458_c() > 0) {
                        itextcomponent.func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("potion.potency." + instance.func_76458_c()));
                    }
                    if (instance.func_76459_b() > 20) {
                        itextcomponent.func_240702_b_(" (").func_240702_b_(EffectUtils.func_188410_a((EffectInstance)instance, (float)1.0f)).func_240702_b_(")");
                    }
                    tooltip.add((ITextComponent)itextcomponent.func_240699_a_(effect.func_220303_e().func_220306_a()));
                }
            }
            Potion potionType = PotionUtils.func_185187_c((CompoundNBT)fluidStack.getTag());
            if (potionType != Potions.field_185229_a) {
                String modID = potionType.getRegistryName().func_110624_b();
                tooltip.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.potionMod", new Object[]{Utils.getModName(modID)}).func_240699_a_(TextFormatting.DARK_GRAY));
            }
        }
    }

    public static class PotionFluidAttributes
    extends FluidAttributes {
        protected PotionFluidAttributes(FluidAttributes.Builder builder, Fluid fluid) {
            super(builder, fluid);
        }

        public ITextComponent getDisplayName(FluidStack stack) {
            if (stack == null || !stack.hasTag()) {
                return super.getDisplayName(stack);
            }
            return new TranslationTextComponent(PotionUtils.func_185187_c((CompoundNBT)stack.getTag()).func_185174_b("item.minecraft.potion.effect."));
        }

        public int getColor(FluidStack stack) {
            if (stack == null || !stack.hasTag()) {
                return -16776961;
            }
            return 0xFF000000 | PotionUtils.func_185181_a((Collection)PotionUtils.func_185185_a((CompoundNBT)stack.getTag()));
        }

        public ItemStack getBucket(FluidStack stack) {
            return PotionBucketItem.forPotion(PotionFluid.getType(stack));
        }
    }
}

