/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.SpecialManualElements;
import blusunrize.lib.manual.gui.ManualScreen;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Locale;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;

public class ManualElementItem
extends SpecialManualElements {
    private final NonNullList<ItemStack> stacks;
    private final int yOffset;
    private final int lines;
    private final float scale;
    private final int longLineLen;
    private final int shortLineLen;
    private final int combinedLen;
    private final int itemsLastLine;

    static NonNullList<ItemStack> parseArray(ItemStack ... stacks) {
        NonNullList list = NonNullList.func_191197_a((int)stacks.length, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < stacks.length; ++i) {
            list.set(i, (Object)stacks[i]);
        }
        return list;
    }

    public ManualElementItem(ManualInstance manual, ItemStack ... stacks) {
        this(manual, ManualElementItem.parseArray(stacks));
    }

    public ManualElementItem(ManualInstance manual, NonNullList<ItemStack> stacks) {
        super(manual);
        this.stacks = stacks;
        int totalLength = stacks.size();
        this.scale = totalLength > 7 ? 1.0f : (totalLength > 4 ? 1.5f : 1.75f);
        int longLineLen = (int)(8.0f / this.scale);
        int shortLineLen = longLineLen - 1;
        int combinedLen = longLineLen + shortLineLen;
        this.lines = totalLength / combinedLen * 2 + totalLength % combinedLen / longLineLen + (totalLength % combinedLen % longLineLen > 0 ? 1 : 0);
        float avgPerLine = (float)totalLength / (float)this.lines;
        this.longLineLen = MathHelper.func_76123_f((float)avgPerLine);
        this.shortLineLen = MathHelper.func_76141_d((float)avgPerLine);
        this.combinedLen = longLineLen + shortLineLen;
        int itemsLastLines = totalLength % this.combinedLen;
        this.itemsLastLine = itemsLastLines == this.longLineLen ? this.longLineLen : (itemsLastLines == 0 ? this.shortLineLen : itemsLastLines % this.longLineLen);
        this.yOffset = this.lines * (int)(18.0f * this.scale);
    }

    @Override
    public void render(MatrixStack transform, ManualScreen gui, int x, int y, int mx, int my) {
        RenderHelper.func_227780_a_();
        this.highlighted = ItemStack.field_190927_a;
        int length = this.stacks.size();
        if (length > 0) {
            transform.func_227860_a_();
            transform.func_227862_a_(this.scale, this.scale, this.scale);
            for (int line = 0; line < this.lines; ++line) {
                int item;
                int perLine;
                int n = line == this.lines - 1 ? this.itemsLastLine : (perLine = line % 2 == 0 ? this.longLineLen : this.shortLineLen);
                if (line == 0 && perLine > length) {
                    perLine = length;
                }
                int w2 = perLine * (int)(18.0f * this.scale) / 2;
                for (int i = 0; i < perLine && (item = line / 2 * this.combinedLen + line % 2 * this.longLineLen + i) < length; ++i) {
                    int xx = x + 60 - w2 + (int)((float)(i * 18) * this.scale);
                    int yy = y + (this.lines < 2 ? 4 : 0) + line * (int)(18.0f * this.scale);
                    ManualUtils.renderItemStack(transform, (ItemStack)this.stacks.get(item), (int)((float)xx / this.scale), (int)((float)yy / this.scale), false);
                    if (mx < xx || !((float)mx < (float)xx + 16.0f * this.scale) || my < yy || !((float)my < (float)yy + 16.0f * this.scale)) continue;
                    this.highlighted = (ItemStack)this.stacks.get(item);
                }
            }
            transform.func_227865_b_();
        }
        RenderHelper.func_74518_a();
        RenderSystem.enableBlend();
        this.renderHighlightedTooltip(transform, gui, mx, my);
    }

    @Override
    public boolean listForSearch(String searchTag) {
        for (ItemStack stack : this.stacks) {
            if (!stack.func_200301_q().getString().toLowerCase(Locale.ENGLISH).contains(searchTag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getPixelsTaken() {
        return this.yOffset;
    }
}

