/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.items;

import com.hidoni.customizableelytra.config.Config;
import com.hidoni.customizableelytra.util.ElytraCustomizationUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BannerItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CustomizableElytraItem
extends ElytraItem
implements IDyeableArmorItem {
    public static final String LEFT_WING_TRANSLATION_KEY = "item.customizable_elytra.left_wing";
    public static final String RIGHT_WING_TRANSLATION_KEY = "item.customizable_elytra.right_wing";

    public CustomizableElytraItem(Item.Properties builder) {
        super(builder);
    }

    public int func_200886_f(ItemStack stack) {
        return this.getColor(stack, 0);
    }

    public int getColor(ItemStack stack, int index) {
        return ElytraCustomizationUtil.getData((ItemStack)stack).handler.getColor(index);
    }

    public boolean func_200883_f_(ItemStack stack) {
        CompoundNBT bannerTag = stack.func_179543_a("BlockEntityTag");
        CompoundNBT wingTag = stack.func_179543_a("WingInfo");
        return super.func_200883_f_(stack) || bannerTag != null || wingTag != null;
    }

    public void func_200884_g(ItemStack stack) {
        super.func_200884_g(stack);
        stack.func_196083_e("BlockEntityTag");
        stack.func_196083_e("WingInfo");
    }

    @Nullable
    public EquipmentSlotType getEquipmentSlot(ItemStack stack) {
        return EquipmentSlotType.CHEST;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        BannerItem.func_185054_a((ItemStack)stack, tooltip);
        CompoundNBT wingInfo = stack.func_179543_a("WingInfo");
        if (wingInfo != null) {
            CompoundNBT leftWing;
            if (wingInfo.func_74764_b("left")) {
                tooltip.add((ITextComponent)new TranslationTextComponent(LEFT_WING_TRANSLATION_KEY).func_240699_a_(TextFormatting.GRAY));
                leftWing = wingInfo.func_74775_l("left");
                this.applyWingTooltip(tooltip, flagIn, leftWing);
            }
            if (wingInfo.func_74764_b("right")) {
                tooltip.add((ITextComponent)new TranslationTextComponent(RIGHT_WING_TRANSLATION_KEY).func_240699_a_(TextFormatting.GRAY));
                leftWing = wingInfo.func_74775_l("right");
                this.applyWingTooltip(tooltip, flagIn, leftWing);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ResourceLocation getTextureLocation(BannerPattern bannerIn) {
        if (((Boolean)Config.useLowQualityElytraBanners.get()).booleanValue()) {
            return new ResourceLocation("customizableelytra", "entity/elytra_banner_low/" + bannerIn.func_190997_a());
        }
        return new ResourceLocation("customizableelytra", "entity/elytra_banner/" + bannerIn.func_190997_a());
    }

    public String func_77658_a() {
        return Items.field_185160_cR.func_77658_a();
    }

    private void applyWingTooltip(List<ITextComponent> tooltip, ITooltipFlag flagIn, CompoundNBT wingIn) {
        if (wingIn.func_74764_b("color")) {
            if (flagIn.func_194127_a()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.color", new Object[]{String.format("#%06X", wingIn.func_74762_e("color"))}).func_240699_a_(TextFormatting.GRAY));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.dyed").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
            }
        } else if (wingIn.func_74764_b("Patterns")) {
            ListNBT listnbt = wingIn.func_150295_c("Patterns", 10);
            for (int i = 0; i < listnbt.size() && i < 6; ++i) {
                CompoundNBT patternNBT = listnbt.func_150305_b(i);
                DyeColor dyecolor = DyeColor.func_196056_a((int)patternNBT.func_74762_e("Color"));
                BannerPattern bannerpattern = BannerPattern.func_190994_a((String)patternNBT.func_74779_i("Pattern"));
                if (bannerpattern == null) continue;
                tooltip.add((ITextComponent)new TranslationTextComponent("block.minecraft.banner." + bannerpattern.func_190997_a() + '.' + dyecolor.func_176762_d()).func_240699_a_(TextFormatting.GRAY));
            }
        }
    }
}

