/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.renderers;

import com.google.common.collect.ImmutableList;
import com.hidoni.customizableelytra.CustomizableElytra;
import com.hidoni.customizableelytra.items.CustomizableElytraItem;
import com.hidoni.customizableelytra.renderers.models.ElytraWingModel;
import com.hidoni.customizableelytra.renderers.models.MirroredElytraWingModel;
import com.hidoni.customizableelytra.setup.ModItems;
import com.hidoni.customizableelytra.util.ElytraCustomizationData;
import com.hidoni.customizableelytra.util.ElytraCustomizationUtil;
import com.hidoni.customizableelytra.util.SplitCustomizationHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.model.ElytraModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

public class CustomizableElytraLayer<T extends LivingEntity, M extends EntityModel<T>>
extends ElytraLayer<T, M> {
    private final ElytraModel<T> modelElytra = new ElytraModel();
    private final ElytraWingModel<T> leftElytraWing = new ElytraWingModel();
    private final MirroredElytraWingModel<T> rightElytraWing = new MirroredElytraWingModel();
    public static final ResourceLocation TEXTURE_DYEABLE_ELYTRA = new ResourceLocation("customizableelytra", "textures/entity/elytra.png");

    public CustomizableElytraLayer(IEntityRenderer<T, M> rendererIn) {
        super(rendererIn);
    }

    public void func_225628_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack elytra = this.tryFindElytra((LivingEntity)entitylivingbaseIn);
        if (elytra != ItemStack.field_190927_a) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, 0.0, 0.125);
            ElytraCustomizationData data = ElytraCustomizationUtil.getData(elytra);
            if (data.type != ElytraCustomizationData.CustomizationType.Split) {
                this.func_215332_c().func_217111_a(this.modelElytra);
                data.handler.render(matrixStackIn, bufferIn, packedLightIn, entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, this.modelElytra, this.getTextureWithCape(entitylivingbaseIn, elytra), elytra.func_77962_s());
            } else {
                ImmutableList models = ImmutableList.of(this.leftElytraWing, this.rightElytraWing);
                for (ElytraWingModel model : models) {
                    this.func_215332_c().func_217111_a((EntityModel)model);
                }
                ((SplitCustomizationHandler)data.handler).render(matrixStackIn, bufferIn, packedLightIn, entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, models, this.getTextureWithCape(entitylivingbaseIn, elytra), elytra.func_77962_s());
            }
            matrixStackIn.func_227865_b_();
        }
    }

    private ResourceLocation getTextureWithCape(T entitylivingbaseIn, ItemStack elytra) {
        AbstractClientPlayerEntity abstractclientplayerentity;
        ResourceLocation elytraTexture = entitylivingbaseIn instanceof AbstractClientPlayerEntity ? ((abstractclientplayerentity = (AbstractClientPlayerEntity)entitylivingbaseIn).func_184833_s() && abstractclientplayerentity.func_184834_t() != null ? abstractclientplayerentity.func_184834_t() : (abstractclientplayerentity.func_152122_n() && abstractclientplayerentity.func_110303_q() != null && abstractclientplayerentity.func_175148_a(PlayerModelPart.CAPE) ? abstractclientplayerentity.func_110303_q() : this.getElytraTexture(elytra, entitylivingbaseIn))) : this.getElytraTexture(elytra, entitylivingbaseIn);
        return elytraTexture;
    }

    public boolean shouldRender(ItemStack stack, LivingEntity entity) {
        return stack.func_77973_b() == ModItems.CUSTOMIZABLE_ELYTRA.get();
    }

    public ResourceLocation getElytraTexture(ItemStack stack, T entity) {
        if (stack.func_77973_b() == ModItems.CUSTOMIZABLE_ELYTRA.get() && ((CustomizableElytraItem)stack.func_77973_b()).func_200883_f_(stack)) {
            return TEXTURE_DYEABLE_ELYTRA;
        }
        return super.getElytraTexture(stack, entity);
    }

    public ItemStack getColytraSubItem(ItemStack stack) {
        ItemStack elytraStack;
        CompoundNBT colytraChestTag = stack.func_179543_a("colytra:ElytraUpgrade");
        if (colytraChestTag != null && (elytraStack = ItemStack.func_199557_a((CompoundNBT)colytraChestTag)).func_77973_b() == ModItems.CUSTOMIZABLE_ELYTRA.get()) {
            return elytraStack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getCurioElytra(LivingEntity entity) {
        Optional curio = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ModItems.CUSTOMIZABLE_ELYTRA.get(), entity);
        if (curio.isPresent()) {
            return (ItemStack)((ImmutableTriple)curio.get()).getRight();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack tryFindElytra(LivingEntity entity) {
        ItemStack elytra = entity.func_184582_a(EquipmentSlotType.CHEST);
        if (this.shouldRender(elytra, entity)) {
            return elytra;
        }
        if (CustomizableElytra.caelusLoaded) {
            if ((elytra = this.getColytraSubItem(elytra)) != ItemStack.field_190927_a) {
                return elytra;
            }
            if (CustomizableElytra.curiosLoaded) {
                return this.getCurioElytra(entity);
            }
        }
        return ItemStack.field_190927_a;
    }
}

