/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.misc.BananaLootModifier;
import com.github.alexthe666.alexsmobs.misc.BlossomLootModifier;
import com.github.alexthe666.alexsmobs.misc.MatchesBananaTagCondition;
import com.github.alexthe666.alexsmobs.misc.MatchesBlossomTagCondition;
import com.github.alexthe666.alexsmobs.misc.RecipeMimicreamRepair;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="alexsmobs", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonProxy {
    public static final LootConditionType MATCHES_BANANA_CONDTN = CommonProxy.registerLootCondition("alexsmobs:matches_banana_tag", new MatchesBananaTagCondition.Serializer());
    public static final LootConditionType MATCHES_BLOSSOM_CONDTN = CommonProxy.registerLootCondition("alexsmobs:matches_blossom_tag", new MatchesBlossomTagCondition.Serializer());
    public static SpecialRecipeSerializer MIMICREAM_RECIPE;

    @SubscribeEvent
    public static void registerModifierSerializers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        if (AMConfig.bananasDropFromLeaves) {
            event.getRegistry().register((IForgeRegistryEntry)new BananaLootModifier.Serializer().setRegistryName(new ResourceLocation("alexsmobs:banana_drop")));
        }
        if (AMConfig.acaciaBlossomsDropFromLeaves) {
            event.getRegistry().register((IForgeRegistryEntry)new BlossomLootModifier.Serializer().setRegistryName(new ResourceLocation("alexsmobs:blossom_drop")));
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        if (AMConfig.mimicreamRepair) {
            MIMICREAM_RECIPE = new SpecialRecipeSerializer(RecipeMimicreamRepair::new);
            MIMICREAM_RECIPE.setRegistryName(new ResourceLocation("alexsmobs:mimicream_repair_recipe"));
            event.getRegistry().register((IForgeRegistryEntry)MIMICREAM_RECIPE);
        }
    }

    private static LootConditionType registerLootCondition(String registryName, ILootSerializer<? extends ILootCondition> serializer) {
        return (LootConditionType)Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)new ResourceLocation(registryName), (Object)new LootConditionType(serializer));
    }

    public void init() {
    }

    public void clientInit() {
    }

    public Item.Properties setupISTER(Item.Properties group) {
        return group;
    }

    public PlayerEntity getClientSidePlayer() {
        return null;
    }

    public void openBookGUI(ItemStack itemStackIn) {
    }

    public Object getArmorModel(int armorId, LivingEntity entity) {
        return null;
    }

    public void onEntityStatus(Entity entity, byte updateKind) {
    }

    public void updateBiomeVisuals(int x, int z) {
    }

    public void setupParticles() {
    }

    public void setRenderViewEntity(Entity entity) {
    }

    public void resetRenderViewEntity() {
    }

    public int getPreviousPOV() {
        return 0;
    }

    public boolean isFarFromCamera(double x, double y, double z) {
        return true;
    }
}

