/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render.layer;

import com.github.alexthe666.alexsmobs.client.model.ModelMimicube;
import com.github.alexthe666.alexsmobs.client.render.RenderMimicube;
import com.github.alexthe666.alexsmobs.entity.EntityMimicube;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.ForgeHooksClient;

public class LayerMimicubeHelmet
extends LayerRenderer<EntityMimicube, ModelMimicube> {
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();
    private final BipedModel defaultBipedModel = new BipedModel(1.0f);
    private RenderMimicube renderer;

    public LayerMimicubeHelmet(RenderMimicube render) {
        super((IEntityRenderer)render);
        this.renderer = render;
    }

    public static ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlotType slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.func_77973_b();
        String texture = item.func_200880_d().func_200897_d();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlotType)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EntityMimicube cube, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ArmorItem armoritem;
        matrixStackIn.func_227860_a_();
        ItemStack itemstack = cube.func_184582_a(EquipmentSlotType.HEAD);
        float helmetSwap = MathHelper.func_219799_g((float)partialTicks, (float)cube.prevHelmetSwapProgress, (float)cube.helmetSwapProgress) * 0.2f;
        if (itemstack.func_77973_b() instanceof ArmorItem && (armoritem = (ArmorItem)itemstack.func_77973_b()).func_185083_B_() == EquipmentSlotType.HEAD) {
            BipedModel<?> a = this.defaultBipedModel;
            boolean notAVanillaModel = (a = this.getArmorModelHook((LivingEntity)cube, itemstack, EquipmentSlotType.HEAD, (BipedModel)a)) != this.defaultBipedModel;
            this.setModelSlotVisible(a, EquipmentSlotType.HEAD);
            boolean flag = false;
            ((ModelMimicube)this.renderer.func_217764_d()).root.func_228307_a_(matrixStackIn);
            ((ModelMimicube)this.renderer.func_217764_d()).innerbody.func_228307_a_(matrixStackIn);
            matrixStackIn.func_227861_a_(0.0, notAVanillaModel ? 0.25 : -0.75, 0.0);
            matrixStackIn.func_227862_a_(1.0f + 0.3f * (1.0f - helmetSwap), 1.0f + 0.3f * (1.0f - helmetSwap), 1.0f + 0.3f * (1.0f - helmetSwap));
            boolean flag1 = itemstack.func_77962_s();
            int clampedLight = helmetSwap > 0.0f ? (int)(-100.0f * helmetSwap) : packedLightIn;
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(360.0f * helmetSwap));
            if (armoritem instanceof IDyeableArmorItem) {
                int i = ((IDyeableArmorItem)armoritem).func_200886_f(itemstack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.renderArmor(cube, matrixStackIn, bufferIn, clampedLight, flag1, a, f, f1, f2, LayerMimicubeHelmet.getArmorResource((Entity)cube, itemstack, EquipmentSlotType.HEAD, null), notAVanillaModel);
                this.renderArmor(cube, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, LayerMimicubeHelmet.getArmorResource((Entity)cube, itemstack, EquipmentSlotType.HEAD, "overlay"), notAVanillaModel);
            } else {
                this.renderArmor(cube, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, LayerMimicubeHelmet.getArmorResource((Entity)cube, itemstack, EquipmentSlotType.HEAD, null), notAVanillaModel);
            }
        }
        matrixStackIn.func_227865_b_();
    }

    private void renderArmor(EntityMimicube entity, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, boolean glintIn, BipedModel modelIn, float red, float green, float blue, ResourceLocation armorResource, boolean notAVanillaModel) {
        IVertexBuilder ivertexbuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)bufferIn, (RenderType)RenderType.func_228640_c_((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
        if (notAVanillaModel) {
            ((ModelMimicube)this.renderer.func_217764_d()).func_217111_a((EntityModel)modelIn);
            modelIn.field_78115_e.field_78797_d = 0.0f;
            modelIn.field_78116_c.func_78793_a(0.0f, 1.0f, 0.0f);
            modelIn.field_178720_f.field_78797_d = 0.0f;
            modelIn.field_78116_c.func_217177_a((ModelRenderer)((ModelMimicube)this.renderer.func_217764_d()).body);
            modelIn.field_178720_f.func_217177_a((ModelRenderer)((ModelMimicube)this.renderer.func_217764_d()).body);
            modelIn.field_78115_e.func_217177_a((ModelRenderer)((ModelMimicube)this.renderer.func_217764_d()).body);
        }
        modelIn.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, red, green, blue, 1.0f);
    }

    protected void setModelSlotVisible(BipedModel p_188359_1_, EquipmentSlotType slotIn) {
        this.setModelVisible(p_188359_1_);
        switch (slotIn) {
            case HEAD: {
                p_188359_1_.field_78116_c.field_78806_j = true;
                p_188359_1_.field_178720_f.field_78806_j = true;
                break;
            }
            case CHEST: {
                p_188359_1_.field_78115_e.field_78806_j = true;
                p_188359_1_.field_178723_h.field_78806_j = true;
                p_188359_1_.field_178724_i.field_78806_j = true;
                break;
            }
            case LEGS: {
                p_188359_1_.field_78115_e.field_78806_j = true;
                p_188359_1_.field_178721_j.field_78806_j = true;
                p_188359_1_.field_178722_k.field_78806_j = true;
                break;
            }
            case FEET: {
                p_188359_1_.field_178721_j.field_78806_j = true;
                p_188359_1_.field_178722_k.field_78806_j = true;
            }
        }
    }

    protected void setModelVisible(BipedModel model) {
        model.func_178719_a(false);
    }

    protected BipedModel<?> getArmorModelHook(LivingEntity entity, ItemStack itemStack, EquipmentSlotType slot, BipedModel model) {
        return ForgeHooksClient.getArmorModel((LivingEntity)entity, (ItemStack)itemStack, (EquipmentSlotType)slot, (BipedModel)model);
    }
}

