/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ISemiAquatic;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIFindWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAILeaveWater;
import com.github.alexthe666.alexsmobs.entity.ai.BottomFeederAIWander;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticPathNavigator;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IShearable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IForgeShearable;

public class EntityAlligatorSnappingTurtle
extends AnimalEntity
implements ISemiAquatic,
IShearable,
IForgeShearable {
    public static final Predicate<LivingEntity> TARGET_PRED = animal -> !(animal instanceof EntityAlligatorSnappingTurtle) && EntityPredicates.field_188444_d.test(animal) && !(animal instanceof ArmorStandEntity) && animal.func_70089_S();
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityAlligatorSnappingTurtle.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> MOSS = EntityDataManager.func_187226_a(EntityAlligatorSnappingTurtle.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> WAITING = EntityDataManager.func_187226_a(EntityAlligatorSnappingTurtle.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ATTACK_TARGET_FLAG = EntityDataManager.func_187226_a(EntityAlligatorSnappingTurtle.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> LUNGE_FLAG = EntityDataManager.func_187226_a(EntityAlligatorSnappingTurtle.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> TURTLE_SCALE = EntityDataManager.func_187226_a(EntityAlligatorSnappingTurtle.class, (IDataSerializer)DataSerializers.field_187193_c);
    public float openMouthProgress;
    public float prevOpenMouthProgress;
    public float attackProgress;
    public float prevAttackProgress;
    public int chaseTime = 0;
    private int biteTick = 0;
    private int waitTime = 0;
    private int timeUntilWait = 0;
    private int mossTime = 0;

    protected EntityAlligatorSnappingTurtle(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 0.0f);
        this.field_70138_W = 1.0f;
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.ALLIGATOR_SNAPPING_TURTLE_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.ALLIGATOR_SNAPPING_TURTLE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.ALLIGATOR_SNAPPING_TURTLE_HURT;
    }

    public static boolean canTurtleSpawn(EntityType type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        boolean spawnBlock = BlockTags.func_199896_a().func_199910_a(AMTagRegistry.ALLIGATOR_SNAPPING_TURTLE_SPAWNS).func_230235_a_((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c());
        return spawnBlock && pos.func_177956_o() < worldIn.func_181545_F() + 4;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.alligatorSnappingTurtleSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 18.0).func_233815_a_(Attributes.field_233820_c_, 0.7).func_233815_a_(Attributes.field_233826_i_, 8.0).func_233815_a_(Attributes.field_233819_b_, 16.0).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f);
    }

    public float func_213355_cm() {
        return this.func_70631_g_() ? 0.3f : 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.3, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new AnimalAIFindWater((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AnimalAILeaveWater((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new BottomFeederAIWander((CreatureEntity)this, 1.0, 120, 150, 10));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]){

            public boolean func_75253_b() {
                return EntityAlligatorSnappingTurtle.this.chaseTime >= 0 && super.func_75253_b();
            }
        });
        this.field_70715_bh.func_75776_a(2, (Goal)new EntityAINearestTarget3D((MobEntity)this, LivingEntity.class, 2, false, true, TARGET_PRED){

            @Override
            protected AxisAlignedBB func_188511_a(double targetDistance) {
                return this.field_75299_d.func_174813_aQ().func_72314_b(0.5, 2.0, 0.5);
            }
        });
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == Items.field_196086_aW;
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public boolean func_70652_k(Entity entityIn) {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
        this.field_70180_af.func_187214_a(MOSS, (Object)0);
        this.field_70180_af.func_187214_a(TURTLE_SCALE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(WAITING, (Object)false);
        this.field_70180_af.func_187214_a(ATTACK_TARGET_FLAG, (Object)false);
        this.field_70180_af.func_187214_a(LUNGE_FLAG, (Object)false);
    }

    public void func_70071_h_() {
        boolean open;
        super.func_70071_h_();
        this.prevOpenMouthProgress = this.openMouthProgress;
        this.prevAttackProgress = this.attackProgress;
        boolean attack = (Boolean)this.field_70180_af.func_187225_a(LUNGE_FLAG);
        boolean bl = open = this.isWaiting() || (Boolean)this.field_70180_af.func_187225_a(ATTACK_TARGET_FLAG) != false && !attack;
        if (attack && this.attackProgress < 5.0f) {
            this.attackProgress += 1.0f;
        }
        if (!attack && this.attackProgress > 0.0f) {
            this.attackProgress -= 1.0f;
        }
        if (open && this.openMouthProgress < 5.0f) {
            this.openMouthProgress += 1.0f;
        }
        if (!open && this.openMouthProgress > 0.0f) {
            this.openMouthProgress -= 1.0f;
        }
        if (this.attackProgress == 4.0f && this.func_70089_S() && this.func_70638_az() != null && this.func_70685_l((Entity)this.func_70638_az()) && this.func_70032_d((Entity)this.func_70638_az()) < 2.3f) {
            float dmg = this.func_70631_g_() ? 1.0f : (float)this.func_110148_a(Attributes.field_233823_f_).func_111125_b();
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), dmg);
        }
        if (this.attackProgress > 4.0f) {
            this.biteTick = 5;
        }
        if (this.biteTick > 0) {
            --this.biteTick;
        }
        if (this.chaseTime < 0) {
            ++this.chaseTime;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F && this.func_70090_H());
            if (this.isWaiting()) {
                ++this.waitTime;
                this.timeUntilWait = 1500;
                if (this.waitTime > 1500 || this.func_70638_az() != null) {
                    this.setWaiting(false);
                }
            } else {
                --this.timeUntilWait;
                this.waitTime = 0;
            }
            if ((this.func_70638_az() == null || !this.func_70638_az().func_70089_S()) && this.timeUntilWait <= 0 && this.func_70090_H()) {
                this.setWaiting(true);
            }
            if (this.func_70638_az() != null && this.biteTick == 0) {
                this.setWaiting(false);
                ++this.chaseTime;
                this.field_70180_af.func_187227_b(ATTACK_TARGET_FLAG, (Object)true);
                this.func_70625_a((Entity)this.func_70638_az(), 360.0f, 40.0f);
                this.field_70761_aq = this.field_70177_z;
                if (this.func_70685_l((Entity)this.func_70638_az()) && this.func_70032_d((Entity)this.func_70638_az()) < 2.3f && this.openMouthProgress > 4.0f) {
                    this.field_70180_af.func_187227_b(LUNGE_FLAG, (Object)true);
                }
                float f = this.func_70032_d((Entity)this.func_70638_az());
                int n = this.func_70638_az() instanceof PlayerEntity ? 5 : 10;
                if (f > (float)n && this.chaseTime > 40) {
                    this.chaseTime = -50;
                    this.func_70624_b(null);
                    this.func_70604_c(null);
                    this.func_130011_c(null);
                    this.field_70717_bb = null;
                }
            } else {
                this.field_70180_af.func_187227_b(ATTACK_TARGET_FLAG, (Object)false);
                this.field_70180_af.func_187227_b(LUNGE_FLAG, (Object)false);
            }
            ++this.mossTime;
            if (this.func_70090_H() && this.mossTime > 12000) {
                this.mossTime = 0;
                this.setMoss(Math.min(10, this.getMoss() + 1));
            }
        }
    }

    @Nullable
    public LivingEntity func_70638_az() {
        return this.chaseTime < 0 ? null : super.func_70638_az();
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        if (this.chaseTime >= 0) {
            super.func_70624_b(entitylivingbaseIn);
        } else {
            super.func_70624_b(null);
        }
    }

    @Nullable
    public LivingEntity func_70643_av() {
        return this.chaseTime < 0 ? null : super.func_70643_av();
    }

    public void func_70604_c(@Nullable LivingEntity entitylivingbaseIn) {
        if (this.chaseTime >= 0) {
            super.func_70604_c(entitylivingbaseIn);
        } else {
            super.func_70604_c(null);
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setMoss(this.field_70146_Z.nextInt(6));
        this.setTurtleScale(0.8f + this.field_70146_Z.nextFloat() * 0.2f);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public float getTurtleScale() {
        return ((Float)this.field_70180_af.func_187225_a(TURTLE_SCALE)).floatValue();
    }

    public void setTurtleScale(float scale) {
        this.field_70180_af.func_187227_b(TURTLE_SCALE, (Object)Float.valueOf(scale));
    }

    protected PathNavigator func_175447_b(World worldIn) {
        SemiAquaticPathNavigator flyingpathnavigator = new SemiAquaticPathNavigator((MobEntity)this, worldIn){

            @Override
            public boolean func_188555_b(BlockPos pos) {
                return this.field_75513_b.func_180495_p(pos).func_204520_s().func_206888_e();
            }
        };
        return flyingpathnavigator;
    }

    public boolean isWaiting() {
        return (Boolean)this.field_70180_af.func_187225_a(WAITING);
    }

    public void setWaiting(boolean sit) {
        this.field_70180_af.func_187227_b(WAITING, (Object)sit);
    }

    public int getMoss() {
        return (Integer)this.field_70180_af.func_187225_a(MOSS);
    }

    public void setMoss(int moss) {
        this.field_70180_af.func_187227_b(MOSS, (Object)moss);
    }

    protected void updateAir(int air) {
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Waiting", this.isWaiting());
        compound.func_74768_a("MossLevel", this.getMoss());
        compound.func_74776_a("TurtleScale", this.getTurtleScale());
        compound.func_74768_a("MossTime", this.mossTime);
        compound.func_74768_a("WaitTime", this.waitTime);
        compound.func_74768_a("WaitTime2", this.timeUntilWait);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setWaiting(compound.func_74767_n("Waiting"));
        this.setMoss(compound.func_74762_e("MossLevel"));
        this.setTurtleScale(compound.func_74760_g("TurtleScale"));
        this.mossTime = compound.func_74762_e("MossTime");
        this.waitTime = compound.func_74762_e("WaitTime");
        this.timeUntilWait = compound.func_74762_e("WaitTime2");
    }

    @Override
    public boolean shouldEnterWater() {
        return true;
    }

    @Override
    public boolean shouldLeaveWater() {
        return false;
    }

    @Override
    public boolean shouldStopMoving() {
        return this.isWaiting();
    }

    @Override
    public int getWaterSearchRange() {
        return 10;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_204610_c(pos.func_177977_b()).func_206888_e() && worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a) ? 10.0f : super.func_205022_a(pos, worldIn);
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            if (this.field_70703_bu) {
                this.func_213317_d(this.func_213322_ci().func_186678_a(1.0));
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.72, 0.0));
            } else {
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.4));
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.08, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    public boolean func_230262_K__() {
        return this.func_70089_S() && this.getMoss() > 0;
    }

    public boolean isShearable(@Nonnull ItemStack item, World world, BlockPos pos) {
        return this.func_230262_K__();
    }

    public void func_230263_a_(SoundCategory category) {
        this.field_70170_p.func_217384_a(null, (Entity)this, SoundEvents.field_187763_eJ, category, 1.0f, 1.0f);
        if (!this.field_70170_p.func_201670_d()) {
            if (this.field_70146_Z.nextFloat() < (float)this.getMoss() * 0.05f) {
                this.func_199703_a((IItemProvider)AMItemRegistry.SPIKED_SCUTE);
            } else {
                this.func_199703_a((IItemProvider)Items.field_221600_aB);
            }
            this.setMoss(0);
        }
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable PlayerEntity player, @Nonnull ItemStack item, World world, BlockPos pos, int fortune) {
        world.func_217384_a(null, (Entity)this, SoundEvents.field_187763_eJ, player == null ? SoundCategory.BLOCKS : SoundCategory.PLAYERS, 1.0f, 1.0f);
        if (!world.func_201670_d()) {
            if (this.field_70146_Z.nextFloat() < (float)this.getMoss() * 0.05f) {
                this.setMoss(0);
                return Collections.singletonList(new ItemStack((IItemProvider)AMItemRegistry.SPIKED_SCUTE));
            }
            this.setMoss(0);
            return Collections.singletonList(new ItemStack((IItemProvider)Items.field_221600_aB));
        }
        return Collections.emptyList();
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (AgeableEntity)AMEntityRegistry.ALLIGATOR_SNAPPING_TURTLE.func_200721_a((World)p_241840_1_);
    }
}

