/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.IFollower;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHurtByTargetNotBaby;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.FlyingAIFollowOwner;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.message.MessageMosquitoMountPlayer;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTriggerRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityBaldEagle
extends TameableEntity
implements IFollower {
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityBaldEagle.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> TACKLING = EntityDataManager.func_187226_a(EntityBaldEagle.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_CAP = EntityDataManager.func_187226_a(EntityBaldEagle.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ATTACK_TICK = EntityDataManager.func_187226_a(EntityBaldEagle.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(EntityBaldEagle.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityBaldEagle.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> LAUNCHED = EntityDataManager.func_187226_a(EntityBaldEagle.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Ingredient TEMPT_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151078_bh, AMItemRegistry.FISH_OIL});
    public float prevAttackProgress;
    public float attackProgress;
    public float prevFlyProgress;
    public float flyProgress;
    public float prevTackleProgress;
    public float tackleProgress;
    public float prevSwoopProgress;
    public float swoopProgress;
    public float prevFlapAmount;
    public float flapAmount;
    public float birdPitch = 0.0f;
    public float prevBirdPitch = 0.0f;
    public float prevSitProgress;
    public float sitProgress;
    private boolean isLandNavigator;
    private int timeFlying;
    private BlockPos orbitPos = null;
    private double orbitDist = 5.0;
    private boolean orbitClockwise = false;
    private int passengerTimer = 0;
    private int launchTime = 0;
    private int lastPlayerControlTime = 0;
    private int returnControlTime = 0;
    private int tackleCapCooldown = 0;
    private boolean controlledFlag = false;
    private int chunkLoadCooldown;
    private int stillTicksCounter = 0;

    protected EntityBaldEagle(EntityType<? extends TameableEntity> type, World worldIn) {
        super(type, worldIn);
        this.switchNavigator(true);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 16.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f);
    }

    public static boolean canEagleSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return worldIn.func_226659_b_(pos, 0) > 8;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this){

            public boolean func_75250_a() {
                return super.func_75250_a() && (EntityBaldEagle.this.func_70086_ai() < 30 || EntityBaldEagle.this.func_70638_az() == null || !EntityBaldEagle.this.func_70638_az().func_203005_aq() && EntityBaldEagle.this.func_226278_cu_() > EntityBaldEagle.this.func_70638_az().func_226278_cu_());
            }
        });
        this.field_70714_bg.func_75776_a(1, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FlyingAIFollowOwner(this, 1.0, 25.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new AITackle());
        this.field_70714_bg.func_75776_a(4, (Goal)new AILandOnGlove());
        this.field_70714_bg.func_75776_a(5, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new TemptGoal((CreatureEntity)this, 1.1, TEMPT_ITEMS, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199805_a((ITag)ItemTags.field_206964_G), false));
        this.field_70714_bg.func_75776_a(8, (Goal)new AIWanderIdle());
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f){

            public boolean func_75250_a() {
                return EntityBaldEagle.this.returnControlTime == 0 && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this){

            public boolean func_75250_a() {
                return EntityBaldEagle.this.returnControlTime == 0 && super.func_75250_a();
            }
        });
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new AnimalAIHurtByTargetNotBaby((AnimalEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new EntityAINearestTarget3D((MobEntity)this, LivingEntity.class, 5, true, true, AMEntityRegistry.buildPredicateFromTag(EntityTypeTags.func_219762_a().func_199910_a(AMTagRegistry.BALD_EAGLE_TARGETS))){

            public boolean func_75250_a() {
                return super.func_75250_a() && !EntityBaldEagle.this.isLaunched() && EntityBaldEagle.this.getCommand() == 0;
            }
        });
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.BALD_EAGLE_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.BALD_EAGLE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.BALD_EAGLE_HURT;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.baldEagleSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.func_70909_n()) {
            LivingEntity livingentity = this.func_70902_q();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TameableEntity) {
                return ((TameableEntity)entityIn).func_152114_e(livingentity);
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151078_bh;
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new GroundPathNavigatorWide((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new MoveHelper(this);
            this.field_70699_by = new DirectPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    public boolean func_70039_c(CompoundNBT compound) {
        String s = this.func_70022_Q();
        compound.func_74778_a("id", s);
        super.func_70039_c(compound);
        return true;
    }

    public boolean func_184198_c(CompoundNBT compound) {
        if (!this.func_70909_n()) {
            return super.func_184198_c(compound);
        }
        String s = this.func_70022_Q();
        compound.func_74778_a("id", s);
        this.func_189511_e(compound);
        return true;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("BirdSitting", this.func_233685_eM_());
        compound.func_74757_a("Launched", this.isLaunched());
        compound.func_74757_a("HasCap", this.hasCap());
        compound.func_74768_a("EagleCommand", this.getCommand());
        compound.func_74768_a("LaunchTime", this.launchTime);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSitting(compound.func_74767_n("BirdSitting"));
        this.setLaunched(compound.func_74767_n("Launched"));
        this.setCap(compound.func_74767_n("HasCap"));
        this.setCommand(compound.func_74762_e("EagleCommand"));
        this.launchTime = compound.func_74762_e("LaunchTime");
    }

    public void func_213352_e(Vector3d vec3d) {
        if (!this.shouldHoodedReturn() && this.hasCap() && this.func_70909_n() && !this.func_184218_aH()) {
            super.func_213352_e(Vector3d.field_186680_a);
            return;
        }
        super.func_213352_e(vec3d);
    }

    public boolean func_70652_k(Entity entityIn) {
        if ((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) == 0 && this.attackProgress == 0.0f && entityIn.func_70089_S() && this.func_70032_d(entityIn) < entityIn.func_213311_cf() + 5.0f) {
            this.field_70180_af.func_187227_b(ATTACK_TICK, (Object)5);
        }
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(HAS_CAP, (Object)false);
        this.field_70180_af.func_187214_a(TACKLING, (Object)false);
        this.field_70180_af.func_187214_a(LAUNCHED, (Object)false);
        this.field_70180_af.func_187214_a(ATTACK_TICK, (Object)0);
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
    }

    public boolean func_233685_eM_() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void setSitting(boolean sit) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sit);
    }

    public int getCommand() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    public void setCommand(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)command);
    }

    public boolean isLaunched() {
        return (Boolean)this.field_70180_af.func_187225_a(LAUNCHED);
    }

    public void setLaunched(boolean flying) {
        this.field_70180_af.func_187227_b(LAUNCHED, (Object)flying);
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(FLYING);
    }

    public void setFlying(boolean flying) {
        if (flying && this.func_70631_g_()) {
            flying = false;
        }
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
    }

    public boolean hasCap() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_CAP);
    }

    public void setCap(boolean cap) {
        this.field_70180_af.func_187227_b(HAS_CAP, (Object)cap);
    }

    public boolean isTackling() {
        return (Boolean)this.field_70180_af.func_187225_a(TACKLING);
    }

    public void setTackling(boolean tackling) {
        this.field_70180_af.func_187227_b(TACKLING, (Object)tackling);
    }

    @Override
    public void followEntity(TameableEntity tameable, LivingEntity owner, double followSpeed) {
        if (this.func_70032_d((Entity)owner) > 15.0f) {
            this.setFlying(true);
            this.func_70605_aq().func_75642_a(owner.func_226277_ct_(), owner.func_226278_cu_() + (double)owner.func_213302_cg(), owner.func_226281_cx_(), followSpeed);
        } else if (this.isFlying() && !this.isOverWaterOrVoid()) {
            BlockPos vec = this.getCrowGround(this.func_233580_cy_());
            if (vec != null) {
                this.func_70605_aq().func_75642_a((double)vec.func_177958_n(), (double)vec.func_177956_o(), (double)vec.func_177952_p(), followSpeed);
            }
            if (this.field_70122_E) {
                this.setFlying(false);
            }
        } else {
            this.func_70661_as().func_75497_a((Entity)owner, followSpeed);
        }
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76368_d || source == DamageSource.field_82729_p || super.func_180431_b(source);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        ActionResultType type = super.func_230254_b_(player, hand);
        if (item.func_206844_a((ITag)ItemTags.field_206964_G) && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(10.0f);
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            return ActionResultType.CONSUME;
        }
        if (item == AMItemRegistry.FISH_OIL && !this.func_70909_n()) {
            if (itemstack.hasContainerItem()) {
                this.func_199701_a_(itemstack.getContainerItem());
            }
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            if (this.field_70146_Z.nextBoolean()) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                this.func_193101_c(player);
                this.setCommand(1);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return ActionResultType.CONSUME;
        }
        if (this.func_70909_n() && !this.func_70877_b(itemstack)) {
            if (!this.func_70631_g_() && item == AMItemRegistry.FALCONRY_HOOD) {
                if (!this.hasCap()) {
                    this.setCap(true);
                    if (!player.func_184812_l_()) {
                        itemstack.func_190918_g(1);
                    }
                    this.func_184185_a(SoundEvents.field_187728_s, this.func_70599_aP(), this.func_70647_i());
                    return ActionResultType.SUCCESS;
                }
            } else {
                boolean sit;
                if (item == Items.field_151097_aZ && this.hasCap()) {
                    this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                    if (!this.field_70170_p.field_72995_K && player instanceof ServerPlayerEntity) {
                        itemstack.func_96631_a(1, this.field_70146_Z, (ServerPlayerEntity)player);
                    }
                    this.func_199703_a((IItemProvider)AMItemRegistry.FALCONRY_HOOD);
                    this.setCap(false);
                    return ActionResultType.SUCCESS;
                }
                if (!(this.func_70631_g_() || this.getRidingEagles((LivingEntity)player) > 0 || player.func_184586_b(Hand.MAIN_HAND).func_77973_b() != AMItemRegistry.FALCONRY_GLOVE && player.func_184586_b(Hand.OFF_HAND).func_77973_b() != AMItemRegistry.FALCONRY_GLOVE)) {
                    this.field_184245_j = 30;
                    this.setLaunched(false);
                    this.func_184226_ay();
                    this.func_184205_a((Entity)player, true);
                    if (!this.field_70170_p.field_72995_K) {
                        AlexsMobs.sendMSGToAll(new MessageMosquitoMountPlayer(this.func_145782_y(), player.func_145782_y()));
                    }
                    return ActionResultType.SUCCESS;
                }
                this.setCommand((this.getCommand() + 1) % 3);
                if (this.getCommand() == 3) {
                    this.setCommand(0);
                }
                player.func_146105_b((ITextComponent)new TranslationTextComponent("entity.alexsmobs.all.command_" + this.getCommand(), new Object[]{this.func_200200_C_()}), true);
                boolean bl = sit = this.getCommand() == 2;
                if (sit) {
                    this.setSitting(true);
                    return ActionResultType.SUCCESS;
                }
                this.setSitting(false);
                return ActionResultType.SUCCESS;
            }
        }
        return type;
    }

    @Override
    public boolean shouldFollow() {
        return this.getCommand() == 1 && !this.isLaunched();
    }

    public int getRidingEagles(LivingEntity player) {
        int crowCount = 0;
        for (Entity e : player.func_184188_bt()) {
            if (!(e instanceof EntityBaldEagle)) continue;
            ++crowCount;
        }
        return crowCount;
    }

    public void func_70098_U() {
        Entity entity = this.func_184187_bx();
        if (!(!this.func_184218_aH() || entity.func_70089_S() && this.func_70089_S())) {
            this.func_184210_p();
        } else if (this.func_70909_n() && entity instanceof LivingEntity && this.func_152114_e((LivingEntity)entity)) {
            this.func_213293_j(0.0, 0.0, 0.0);
            this.func_70071_h_();
            if (this.func_184218_aH()) {
                Entity mount = this.func_184187_bx();
                if (mount instanceof PlayerEntity) {
                    float yawAdd = 0.0f;
                    if (((PlayerEntity)mount).func_184586_b(Hand.MAIN_HAND).func_77973_b() == AMItemRegistry.FALCONRY_GLOVE) {
                        yawAdd = ((PlayerEntity)mount).func_184591_cq() == HandSide.LEFT ? 135.0f : -135.0f;
                    } else if (((PlayerEntity)mount).func_184586_b(Hand.OFF_HAND).func_77973_b() == AMItemRegistry.FALCONRY_GLOVE) {
                        yawAdd = ((PlayerEntity)mount).func_184591_cq() == HandSide.LEFT ? -135.0f : 135.0f;
                    } else {
                        this.setCommand(2);
                        this.setSitting(true);
                        this.func_233575_bb_();
                        this.func_82149_j(mount);
                    }
                    float birdYaw = yawAdd * 0.5f;
                    this.field_70761_aq = MathHelper.func_76142_g((float)(((LivingEntity)mount).field_70761_aq + birdYaw));
                    this.field_70177_z = MathHelper.func_76142_g((float)(((LivingEntity)mount).field_70177_z + birdYaw));
                    this.field_70759_as = MathHelper.func_76142_g((float)(((LivingEntity)mount).field_70759_as + birdYaw));
                    float radius = 0.6f;
                    float angle = (float)Math.PI / 180 * (((LivingEntity)mount).field_70761_aq - 180.0f + yawAdd);
                    double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                    double extraZ = radius * MathHelper.func_76134_b((float)angle);
                    this.func_70107_b(mount.func_226277_ct_() + extraX, Math.max(mount.func_226278_cu_() + (double)(mount.func_213302_cg() * 0.45f), mount.func_226278_cu_()), mount.func_226281_cx_() + extraZ);
                }
                if (!mount.func_70089_S()) {
                    this.func_233575_bb_();
                }
            }
        } else {
            super.func_70098_U();
        }
    }

    public void func_70071_h_() {
        boolean sit;
        float yMot;
        super.func_70071_h_();
        this.prevAttackProgress = this.attackProgress;
        this.prevBirdPitch = this.birdPitch;
        this.prevTackleProgress = this.tackleProgress;
        this.prevFlyProgress = this.flyProgress;
        this.prevFlapAmount = this.flapAmount;
        this.prevSwoopProgress = this.swoopProgress;
        this.prevSitProgress = this.sitProgress;
        this.birdPitch = yMot = (float)(-((double)((float)this.func_213322_ci().field_72448_b) * 57.2957763671875));
        if (this.isFlying() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.isFlying() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.isTackling() && this.tackleProgress < 5.0f) {
            this.tackleProgress += 1.0f;
        }
        if (!this.isTackling() && this.tackleProgress > 0.0f) {
            this.tackleProgress -= 1.0f;
        }
        boolean bl = sit = this.func_233685_eM_() || this.func_184218_aH();
        if (sit && this.sitProgress < 5.0f) {
            this.sitProgress += 1.0f;
        }
        if (!sit && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        this.launchTime = this.isLaunched() ? ++this.launchTime : 0;
        if (this.lastPlayerControlTime > 0) {
            --this.lastPlayerControlTime;
        }
        if (this.lastPlayerControlTime <= 0) {
            this.controlledFlag = false;
        }
        if (yMot < 0.1f) {
            this.flapAmount = Math.min(-yMot * 0.2f, 1.0f);
            if (this.swoopProgress > 0.0f) {
                this.swoopProgress -= 1.0f;
            }
        } else {
            this.flapAmount = this.flapAmount > 0.0f ? (this.flapAmount -= Math.min(this.flapAmount, 0.1f)) : 0.0f;
            if (this.swoopProgress < yMot * 0.2f) {
                this.swoopProgress = Math.min(yMot * 0.2f, this.swoopProgress + 1.0f);
            }
        }
        if (this.isTackling()) {
            this.flapAmount = Math.min(2.0f, this.flapAmount + 0.2f);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isFlying() && this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (!this.isFlying() && !this.isLandNavigator) {
                this.switchNavigator(true);
            }
            if (!(!this.isTackling() || this.func_184207_aI() || this.func_70638_az() != null && this.func_70638_az().func_70089_S() || this.tackleCapCooldown != 0)) {
                this.setTackling(false);
            }
            if (this.isFlying()) {
                ++this.timeFlying;
                this.func_189654_d(true);
                if ((this.func_233685_eM_() || this.func_184218_aH() || this.func_70880_s()) && !this.isLaunched()) {
                    this.setFlying(false);
                }
                if (this.func_70638_az() != null && this.func_70638_az().func_226278_cu_() < this.func_226277_ct_() && !this.func_184207_aI()) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.9, 1.0));
                }
            } else {
                this.timeFlying = 0;
                this.func_189654_d(false);
            }
            if (this.func_203005_aq() && this.func_184207_aI()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)0.1f, 0.0));
            }
            if (this.func_233685_eM_() && !this.isLaunched()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)-0.1f, 0.0));
            }
            if (this.func_70638_az() != null && this.func_203005_aq()) {
                this.timeFlying = 0;
                this.setFlying(true);
            }
            if (this.isFlying() && this.field_70122_E && !this.func_203005_aq() && this.timeFlying > 30) {
                this.setFlying(false);
            }
        }
        if ((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) > 0) {
            if ((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) == 2 && this.func_70638_az() != null && (double)this.func_70032_d((Entity)this.func_70638_az()) < (double)this.func_70638_az().func_213311_cf() + 2.0) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 2.0f);
            }
            this.field_70180_af.func_187227_b(ATTACK_TICK, (Object)((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) - 1));
            if (this.attackProgress < 5.0f) {
                this.attackProgress += 1.0f;
            }
        } else if (this.attackProgress > 0.0f) {
            this.attackProgress -= 1.0f;
        }
        if (this.func_184218_aH()) {
            this.setFlying(false);
            this.setTackling(false);
        }
        if (this.field_184245_j > 0) {
            --this.field_184245_j;
        }
        if (this.returnControlTime > 0) {
            --this.returnControlTime;
        }
        if (this.tackleCapCooldown > 0) {
            --this.tackleCapCooldown;
        }
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (AgeableEntity)AMEntityRegistry.BALD_EAGLE.func_200721_a((World)p_241840_1_);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public Vector3d getBlockInViewAway(Vector3d fleePos, float radiusAdd) {
        float radius = -9.45f - (float)this.func_70681_au().nextInt(24) - radiusAdd;
        float neg = this.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.func_82615_a() + extraX, 0.0, fleePos.func_82616_c() + extraZ);
        BlockPos ground = this.getCrowGround(radialPos);
        int distFromGround = (int)this.func_226278_cu_() - ground.func_177956_o();
        int flightHeight = 7 + this.func_70681_au().nextInt(10);
        BlockPos newPos = ground.func_177981_b(distFromGround > 8 ? flightHeight : this.func_70681_au().nextInt(7) + 4);
        if (!this.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)newPos)) && this.func_195048_a(Vector3d.func_237489_a_((Vector3i)newPos)) > 1.0) {
            return Vector3d.func_237489_a_((Vector3i)newPos);
        }
        return null;
    }

    private BlockPos getCrowGround(BlockPos in) {
        BlockPos position = new BlockPos((double)in.func_177958_n(), this.func_226278_cu_(), (double)in.func_177952_p());
        while (position.func_177956_o() < 256 && !this.field_70170_p.func_204610_c(position).func_206888_e()) {
            position = position.func_177984_a();
        }
        while (position.func_177956_o() > 2 && this.field_70170_p.func_175623_d(position)) {
            position = position.func_177977_b();
        }
        return position;
    }

    public Vector3d getBlockGrounding(Vector3d fleePos) {
        float radius = -9.45f - (float)this.func_70681_au().nextInt(24);
        float neg = this.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.func_82615_a() + extraX, this.func_226278_cu_(), fleePos.func_82616_c() + extraZ);
        BlockPos ground = this.getCrowGround(radialPos);
        if (ground.func_177956_o() == 0) {
            return this.func_213303_ch();
        }
        ground = this.func_233580_cy_();
        while (ground.func_177956_o() > 2 && this.field_70170_p.func_175623_d(ground)) {
            ground = ground.func_177977_b();
        }
        if (!this.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)ground.func_177984_a()))) {
            return Vector3d.func_237489_a_((Vector3i)ground);
        }
        return null;
    }

    public boolean isTargetBlocked(Vector3d target) {
        Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() != RayTraceResult.Type.MISS;
    }

    private Vector3d getOrbitVec(Vector3d vector3d, float gatheringCircleDist) {
        Vector3d pos;
        float angle = (float)Math.PI / 180 * (float)this.orbitDist * (float)(this.orbitClockwise ? -this.field_70173_aa : this.field_70173_aa);
        double extraX = gatheringCircleDist * MathHelper.func_76126_a((float)angle);
        double extraZ = gatheringCircleDist * MathHelper.func_76134_b((float)angle);
        if (this.orbitPos != null && this.field_70170_p.func_175623_d(new BlockPos(pos = new Vector3d((double)this.orbitPos.func_177958_n() + extraX, (double)(this.orbitPos.func_177956_o() + this.field_70146_Z.nextInt(2) - 2), (double)this.orbitPos.func_177952_p() + extraZ)))) {
            return pos;
        }
        return null;
    }

    private boolean isOverWaterOrVoid() {
        BlockPos position = this.func_233580_cy_();
        while (position.func_177956_o() > 0 && this.field_70170_p.func_175623_d(position)) {
            position = position.func_177977_b();
        }
        return !this.field_70170_p.func_204610_c(position).func_206888_e() || position.func_177956_o() <= 0;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float radius = 0.3f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            passenger.field_70177_z = this.field_70761_aq + 90.0f;
            if (passenger instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)passenger;
                living.field_70761_aq = this.field_70761_aq + 90.0f;
            }
            double extraY = 0.0;
            if (passenger instanceof AbstractFishEntity && !passenger.func_203005_aq()) {
                extraY = 0.1f;
            }
            passenger.func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() - (double)0.3f + extraY + (double)(passenger.func_213302_cg() * 0.3f), this.func_226281_cx_() + extraZ);
            ++this.passengerTimer;
            if (this.func_70089_S() && this.passengerTimer > 0 && this.passengerTimer % 40 == 0) {
                passenger.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 1.0f);
            }
        }
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return true;
    }

    public Vector3d func_230268_c_(LivingEntity livingEntity) {
        return new Vector3d(this.func_226277_ct_(), this.func_174813_aQ().field_72338_b, this.func_226281_cx_());
    }

    public boolean shouldHoodedReturn() {
        if (this.func_70902_q() != null && (!this.func_70902_q().func_70089_S() || this.func_70902_q().func_225608_bj_())) {
            return true;
        }
        return !this.func_70089_S() || this.launchTime > 12000 || this.field_71087_bX || this.field_82153_h > 0 || this.field_70128_L;
    }

    public void remove(boolean keepData) {
        if (this.lastPlayerControlTime == 0 && !this.func_184218_aH()) {
            super.remove(keepData);
        }
    }

    public void directFromPlayer(float rotationYaw, float rotationPitch, boolean loadChunk, Entity over) {
        LivingEntity owner = this.func_70902_q();
        if (owner != null && this.func_70032_d((Entity)owner) > 150.0f) {
            this.returnControlTime = 100;
        }
        this.stillTicksCounter = Math.abs(this.field_70169_q - this.func_226277_ct_()) > (double)0.1f || Math.abs(this.field_70167_r - this.func_226278_cu_()) > (double)0.1f || Math.abs(this.field_70166_s - this.func_226281_cx_()) > (double)0.1f ? 0 : ++this.stillTicksCounter;
        int stillTPthreshold = AMConfig.falconryTeleportsBack ? 200 : 6000;
        this.setSitting(false);
        this.setLaunched(true);
        if ((this.returnControlTime > 0 && AMConfig.falconryTeleportsBack || this.stillTicksCounter > stillTPthreshold && this.func_70032_d((Entity)owner) > 30.0f) && owner != null) {
            this.func_82149_j((Entity)owner);
            this.returnControlTime = 0;
            this.stillTicksCounter = 0;
            this.launchTime = Math.max(this.launchTime, 12000);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.returnControlTime > 0 && owner != null) {
                double d0 = this.func_226277_ct_() - owner.func_226277_ct_();
                double d2 = this.func_226281_cx_() - owner.func_226281_cx_();
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) + 90.0f;
                this.func_70671_ap().func_75651_a((Entity)owner, 30.0f, 30.0f);
            } else {
                this.field_70761_aq = rotationYaw;
                this.field_70177_z = rotationYaw;
                this.field_70759_as = rotationYaw;
                this.field_70125_A = rotationPitch;
            }
            if (rotationPitch < 10.0f && this.func_233570_aj_()) {
                this.setFlying(true);
            }
            float yawOffset = rotationYaw + 90.0f;
            float rad = 3.0f;
            float speed = 1.2f;
            if (this.returnControlTime > 0) {
                this.func_70605_aq().func_75642_a(owner.func_226277_ct_(), owner.func_226278_cu_() + 10.0, owner.func_226281_cx_(), (double)speed);
            } else {
                this.func_70605_aq().func_75642_a(this.func_226277_ct_() + (double)(rad * 1.5f) * Math.cos((double)yawOffset * (Math.PI / 180)), this.func_226278_cu_() - (double)rad * Math.sin((double)rotationPitch * (Math.PI / 180)), this.func_226281_cx_() + (double)rad * Math.sin((double)yawOffset * (Math.PI / 180)), (double)speed);
            }
            if (loadChunk) {
                this.loadChunkOnServer(this.func_233580_cy_());
            }
            this.func_70604_c(null);
            this.func_70624_b(null);
            if (over == null) {
                List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g(3.0), EntityPredicates.field_188444_d);
                Entity closest = null;
                for (Entity e : list) {
                    if (closest != null && !(this.func_70032_d(e) < this.func_70032_d(closest))) continue;
                    closest = e;
                }
                over = closest;
            }
        }
        if (over != null && !this.func_184191_r(over) && over != owner && this.tackleCapCooldown == 0 && (double)this.func_70032_d(over) <= (double)over.func_213311_cf() + 4.0) {
            this.setTackling(true);
            if ((double)this.func_70032_d(over) <= (double)over.func_213311_cf() + 2.0) {
                float speedDamage = (float)Math.ceil(MathHelper.func_151237_a((double)(this.func_213322_ci().func_72433_c() + 0.2), (double)0.0, (double)1.2) * 3.333);
                over.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 5.0f + speedDamage + (float)this.field_70146_Z.nextInt(2));
                this.tackleCapCooldown = 22;
            }
        }
        this.lastPlayerControlTime = 10;
        this.controlledFlag = true;
    }

    public void func_241847_a(ServerWorld world, LivingEntity entity) {
        if (this.isLaunched() && this.hasCap() && this.func_70909_n() && this.func_70902_q() != null && this.func_70902_q() instanceof ServerPlayerEntity && this.func_70032_d((Entity)this.func_70902_q()) >= 100.0f) {
            AMAdvancementTriggerRegistry.BALD_EAGLE_CHALLENGE.trigger((ServerPlayerEntity)this.func_70902_q());
        }
        super.func_241847_a(world, entity);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity != null && this.func_70909_n() && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity) && this.isLaunched()) {
            amount = (amount + 1.0f) / 4.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public void loadChunkOnServer(BlockPos center) {
        if (!this.field_70170_p.field_72995_K) {
            ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    ChunkPos pos = new ChunkPos(this.func_233580_cy_().func_177982_a(i * 16, 0, j * 16));
                    serverWorld.func_217458_b(pos.field_77276_a, pos.field_77275_b, true);
                }
            }
        }
    }

    private class AILandOnGlove
    extends Goal {
        protected EntityBaldEagle eagle;
        private int seperateTime = 0;

        public AILandOnGlove() {
            this.eagle = EntityBaldEagle.this;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return this.eagle.isLaunched() && !this.eagle.controlledFlag && this.eagle.func_70909_n() && !this.eagle.func_184218_aH() && !this.eagle.func_184207_aI() && (this.eagle.func_70638_az() == null || !this.eagle.func_70638_az().func_70089_S());
        }

        public void func_75246_d() {
            LivingEntity owner;
            if (this.eagle.func_213322_ci().func_189985_c() < 0.03) {
                ++this.seperateTime;
            }
            if ((owner = this.eagle.func_70902_q()) != null) {
                if (this.seperateTime > 200) {
                    this.seperateTime = 0;
                    this.eagle.func_82149_j((Entity)owner);
                }
                this.eagle.setFlying(true);
                double d0 = this.eagle.func_226277_ct_() - owner.func_226277_ct_();
                double d2 = this.eagle.func_226281_cx_() - owner.func_226281_cx_();
                double xzDist = Math.sqrt(d0 * d0 + d2 * d2);
                double yAdd = xzDist > 14.0 ? 5.0 : 0.0;
                this.eagle.func_70605_aq().func_75642_a(owner.func_226277_ct_(), owner.func_226278_cu_() + yAdd + (double)owner.func_70047_e(), owner.func_226281_cx_(), 1.0);
                if ((double)this.eagle.func_70032_d((Entity)owner) < (double)owner.func_213311_cf() + 1.4) {
                    this.eagle.setLaunched(false);
                    if (this.eagle.getRidingEagles(owner) <= 0) {
                        this.eagle.func_184220_m((Entity)owner);
                        if (!this.eagle.field_70170_p.field_72995_K) {
                            AlexsMobs.sendMSGToAll(new MessageMosquitoMountPlayer(this.eagle.func_145782_y(), owner.func_145782_y()));
                        }
                    } else {
                        this.eagle.setCommand(2);
                        this.eagle.setSitting(true);
                    }
                }
            }
        }

        public void func_75251_c() {
            this.seperateTime = 0;
        }
    }

    private class AITackle
    extends Goal {
        protected EntityBaldEagle eagle;
        private int circleTime;
        private int maxCircleTime = 10;

        public AITackle() {
            this.eagle = EntityBaldEagle.this;
        }

        public boolean func_75250_a() {
            return this.eagle.func_70638_az() != null && !this.eagle.controlledFlag && !this.eagle.func_184207_aI();
        }

        public void func_75249_e() {
            this.eagle.orbitPos = null;
        }

        public void func_75251_c() {
            this.circleTime = 0;
            this.maxCircleTime = 60 + EntityBaldEagle.this.field_70146_Z.nextInt(60);
        }

        public void func_75246_d() {
            boolean smallPrey;
            LivingEntity target = this.eagle.func_70638_az();
            boolean bl = smallPrey = target != null && target.func_213302_cg() < 1.0f && target.func_213311_cf() < 0.7f && !(target instanceof EntityBaldEagle) || target instanceof AbstractFishEntity;
            if (this.eagle.orbitPos != null && this.circleTime < this.maxCircleTime) {
                Vector3d vec;
                ++this.circleTime;
                this.eagle.setTackling(false);
                this.eagle.setFlying(true);
                if (target != null) {
                    int up = 2 + this.eagle.func_70681_au().nextInt(4);
                    this.eagle.orbitPos = target.func_233580_cy_().func_177981_b((int)target.func_213302_cg());
                    for (int i = 0; this.eagle.field_70170_p.func_175623_d(this.eagle.orbitPos) && i < up; ++i) {
                        this.eagle.orbitPos = this.eagle.orbitPos.func_177984_a();
                    }
                }
                if ((vec = this.eagle.getOrbitVec(Vector3d.field_186680_a, 4 + EntityBaldEagle.this.field_70146_Z.nextInt(2))) != null) {
                    this.eagle.func_70605_aq().func_75642_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, (double)1.2f);
                }
            } else if (target != null) {
                if (this.eagle.isFlying() || this.eagle.func_203005_aq()) {
                    double d0 = this.eagle.func_226277_ct_() - target.func_226277_ct_();
                    double d2 = this.eagle.func_226281_cx_() - target.func_226281_cx_();
                    double xzDist = Math.sqrt(d0 * d0 + d2 * d2);
                    double yAddition = target.func_213302_cg();
                    if (xzDist > 15.0) {
                        yAddition = 3.0;
                    }
                    this.eagle.setTackling(true);
                    this.eagle.func_70605_aq().func_75642_a(target.func_226277_ct_(), target.func_226278_cu_() + yAddition, target.func_226281_cx_(), this.eagle.func_203005_aq() ? (double)1.3f : 1.0);
                } else {
                    this.eagle.func_70661_as().func_75497_a((Entity)target, 1.0);
                }
                if (this.eagle.func_70032_d((Entity)target) < target.func_213311_cf() + 2.5f) {
                    if (this.eagle.isTackling()) {
                        if (smallPrey) {
                            this.eagle.setFlying(true);
                            this.eagle.timeFlying = 0;
                            float radius = 0.3f;
                            float angle = (float)Math.PI / 180 * this.eagle.field_70761_aq;
                            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                            double extraZ = radius * MathHelper.func_76134_b((float)angle);
                            target.field_70177_z = this.eagle.field_70761_aq + 90.0f;
                            if (target instanceof LivingEntity) {
                                LivingEntity living = target;
                                living.field_70761_aq = this.eagle.field_70761_aq + 90.0f;
                            }
                            target.func_70107_b(this.eagle.func_226277_ct_() + extraX, this.eagle.func_226278_cu_() - (double)0.4f + (double)(target.func_213302_cg() * 0.45f), this.eagle.func_226281_cx_() + extraZ);
                            target.func_184205_a((Entity)this.eagle, true);
                        } else {
                            target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.eagle), 5.0f);
                            this.eagle.setFlying(false);
                            this.eagle.orbitPos = target.func_233580_cy_().func_177981_b(2);
                            this.circleTime = 0;
                            this.maxCircleTime = 60 + EntityBaldEagle.this.field_70146_Z.nextInt(60);
                        }
                    } else {
                        this.eagle.func_70652_k((Entity)target);
                    }
                } else if (this.eagle.func_70032_d((Entity)target) > 12.0f || target.func_203005_aq()) {
                    this.eagle.setFlying(true);
                }
            }
            if (this.eagle.isLaunched()) {
                this.eagle.setFlying(true);
            }
        }
    }

    private class AIWanderIdle
    extends Goal {
        protected final EntityBaldEagle eagle;
        protected double x;
        protected double y;
        protected double z;
        private boolean flightTarget = false;
        private int orbitResetCooldown = 0;
        private int maxOrbitTime = 360;
        private int orbitTime = 0;

        public AIWanderIdle() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.eagle = EntityBaldEagle.this;
        }

        public boolean func_75250_a() {
            if (this.orbitResetCooldown < 0) {
                ++this.orbitResetCooldown;
            }
            if (this.eagle.func_70638_az() != null && this.eagle.func_70638_az().func_70089_S() && !this.eagle.func_184207_aI() || this.eagle.func_184218_aH() || this.eagle.func_233685_eM_() || this.eagle.controlledFlag) {
                return false;
            }
            if (this.eagle.func_70681_au().nextInt(15) != 0 && !this.eagle.isFlying()) {
                return false;
            }
            if (this.eagle.func_70631_g_()) {
                this.flightTarget = false;
            } else if (this.eagle.func_203005_aq()) {
                this.flightTarget = true;
            } else if (this.eagle.hasCap()) {
                this.flightTarget = false;
            } else if (this.eagle.func_233570_aj_()) {
                this.flightTarget = EntityBaldEagle.this.field_70146_Z.nextBoolean();
            } else {
                if (this.orbitResetCooldown == 0 && EntityBaldEagle.this.field_70146_Z.nextInt(6) == 0) {
                    this.orbitResetCooldown = 400;
                    this.eagle.orbitPos = this.eagle.func_233580_cy_();
                    this.eagle.orbitDist = 4 + EntityBaldEagle.this.field_70146_Z.nextInt(5);
                    this.eagle.orbitClockwise = EntityBaldEagle.this.field_70146_Z.nextBoolean();
                    this.orbitTime = 0;
                    this.maxOrbitTime = (int)(360.0f + 360.0f * EntityBaldEagle.this.field_70146_Z.nextFloat());
                }
                this.flightTarget = this.eagle.func_184207_aI() || EntityBaldEagle.this.field_70146_Z.nextInt(7) > 0 && this.eagle.timeFlying < 700;
            }
            Vector3d lvt_1_1_ = this.getPosition();
            if (lvt_1_1_ == null) {
                return false;
            }
            this.x = lvt_1_1_.field_72450_a;
            this.y = lvt_1_1_.field_72448_b;
            this.z = lvt_1_1_.field_72449_c;
            return true;
        }

        public void func_75246_d() {
            if (this.orbitResetCooldown > 0) {
                --this.orbitResetCooldown;
            }
            if (this.orbitResetCooldown < 0) {
                ++this.orbitResetCooldown;
            }
            if (this.orbitResetCooldown > 0 && this.eagle.orbitPos != null) {
                if (this.orbitTime < this.maxOrbitTime && !this.eagle.func_203005_aq()) {
                    ++this.orbitTime;
                } else {
                    this.orbitTime = 0;
                    this.eagle.orbitPos = null;
                    this.orbitResetCooldown = -400 - EntityBaldEagle.this.field_70146_Z.nextInt(400);
                }
            }
            if (this.eagle.field_70123_F && !this.eagle.field_70122_E) {
                this.func_75251_c();
            }
            if (this.flightTarget) {
                this.eagle.func_70605_aq().func_75642_a(this.x, this.y, this.z, 1.0);
            } else if (this.eagle.isFlying() && !this.eagle.field_70122_E) {
                if (!this.eagle.func_203005_aq()) {
                    this.eagle.func_213317_d(this.eagle.func_213322_ci().func_216372_d((double)1.2f, (double)0.6f, (double)1.2f));
                }
            } else {
                this.eagle.func_70661_as().func_75492_a(this.x, this.y, this.z, 1.0);
            }
            if (!this.flightTarget && EntityBaldEagle.this.isFlying() && this.eagle.field_70122_E) {
                this.eagle.setFlying(false);
                this.orbitTime = 0;
                this.eagle.orbitPos = null;
                this.orbitResetCooldown = -400 - EntityBaldEagle.this.field_70146_Z.nextInt(400);
            }
            if (EntityBaldEagle.this.isFlying() && (!EntityBaldEagle.this.field_70170_p.func_175623_d(this.eagle.func_226270_aj_()) || this.eagle.field_70122_E) && !this.eagle.func_203005_aq() && this.eagle.timeFlying > 30) {
                this.eagle.setFlying(false);
                this.orbitTime = 0;
                this.eagle.orbitPos = null;
                this.orbitResetCooldown = -400 - EntityBaldEagle.this.field_70146_Z.nextInt(400);
            }
        }

        @Nullable
        protected Vector3d getPosition() {
            Vector3d vector3d = this.eagle.func_213303_ch();
            if (this.eagle.func_70909_n() && this.eagle.getCommand() == 1 && this.eagle.func_70902_q() != null) {
                vector3d = this.eagle.func_70902_q().func_213303_ch();
                this.eagle.orbitPos = this.eagle.func_70902_q().func_233580_cy_();
            }
            if (this.orbitResetCooldown > 0 && this.eagle.orbitPos != null) {
                return this.eagle.getOrbitVec(vector3d, 4 + EntityBaldEagle.this.field_70146_Z.nextInt(2));
            }
            if (this.eagle.func_184207_aI() || this.eagle.isOverWaterOrVoid()) {
                this.flightTarget = true;
            }
            if (this.flightTarget) {
                if (this.eagle.timeFlying < 500 || this.eagle.func_184207_aI() || this.eagle.isOverWaterOrVoid()) {
                    return this.eagle.getBlockInViewAway(vector3d, 0.0f);
                }
                return this.eagle.getBlockGrounding(vector3d);
            }
            return RandomPositionGenerator.func_75463_a((CreatureEntity)this.eagle, (int)10, (int)7);
        }

        public boolean func_75253_b() {
            if (this.eagle.func_233685_eM_()) {
                return false;
            }
            if (this.flightTarget) {
                return this.eagle.isFlying() && this.eagle.func_70092_e(this.x, this.y, this.z) > 2.0;
            }
            return !this.eagle.func_70661_as().func_75500_f() && !this.eagle.func_184207_aI();
        }

        public void func_75249_e() {
            if (this.flightTarget) {
                this.eagle.setFlying(true);
                this.eagle.func_70605_aq().func_75642_a(this.x, this.y, this.z, 1.0);
            } else {
                this.eagle.func_70661_as().func_75492_a(this.x, this.y, this.z, 1.0);
            }
        }

        public void func_75251_c() {
            this.eagle.func_70661_as().func_75499_g();
            super.func_75251_c();
        }
    }

    class MoveHelper
    extends MovementController {
        private final EntityBaldEagle parentEntity;

        public MoveHelper(EntityBaldEagle bird) {
            super((MobEntity)bird);
            this.parentEntity = bird;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                Vector3d vector3d = new Vector3d(this.field_75646_b - this.parentEntity.func_226277_ct_(), this.field_75647_c - this.parentEntity.func_226278_cu_(), this.field_75644_d - this.parentEntity.func_226281_cx_());
                double d5 = vector3d.func_72433_c();
                if (d5 < 0.3) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_186678_a(0.5));
                } else {
                    double d0 = this.field_75646_b - this.parentEntity.func_226277_ct_();
                    double d1 = this.field_75647_c - this.parentEntity.func_226278_cu_();
                    double d2 = this.field_75644_d - this.parentEntity.func_226281_cx_();
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(vector3d.func_186678_a(this.field_75645_e * 0.05 / d5)));
                    Vector3d vector3d1 = this.parentEntity.func_213322_ci();
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d1.field_72450_a, (double)vector3d1.field_72449_c)) * 57.295776f;
                }
            }
        }

        private boolean func_220673_a(Vector3d p_220673_1_, int p_220673_2_) {
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.parentEntity.field_70170_p.func_226665_a__((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_191194_a(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }
}

