/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAISwimBottom;
import com.github.alexthe666.alexsmobs.entity.ai.AquaticMoveController;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FindWaterGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class EntityBlobfish
extends WaterMobEntity
implements IFlyingAnimal {
    private static final DataParameter<Boolean> FROM_BUCKET = EntityDataManager.func_187226_a(EntityBlobfish.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> BLOBFISH_SCALE = EntityDataManager.func_187226_a(EntityBlobfish.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> DEPRESSURIZED = EntityDataManager.func_187226_a(EntityBlobfish.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SLIMED = EntityDataManager.func_187226_a(EntityBlobfish.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float squishFactor;
    public float prevSquishFactor;
    public float squishAmount;
    private boolean wasOnGround;

    protected EntityBlobfish(EntityType type, World world) {
        super(type, world);
        this.field_70765_h = new AquaticMoveController((CreatureEntity)this, 1.0f);
    }

    public static AttributeModifierMap.MutableAttribute func_234176_m_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 3.0);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.blobfishSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public static boolean func_223363_b(EntityType<? extends AbstractFishEntity> p_223363_0_, IWorld p_223363_1_, SpawnReason p_223363_2_, BlockPos p_223363_3_, Random p_223363_4_) {
        return p_223363_1_.func_180495_p(p_223363_3_).func_203425_a(Blocks.field_150355_j) && p_223363_1_.func_180495_p(p_223363_3_.func_177984_a()).func_203425_a(Blocks.field_150355_j);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    protected void func_209207_l(int p_209207_1_) {
        if (this.func_70089_S() && !this.func_203005_aq() && !this.isSlimed()) {
            this.func_70050_g(p_209207_1_ - 1);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, this.field_70146_Z.nextInt(2) == 0 ? 1.0f : 0.0f);
            }
        } else {
            this.func_70050_g(2000);
        }
    }

    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return p_213348_2_.field_220316_b * 0.65f;
    }

    public boolean func_213392_I() {
        return super.func_213392_I() || this.isFromBucket() || this.isSlimed();
    }

    public boolean func_213397_c(double p_213397_1_) {
        return !this.isFromBucket() && !this.func_145818_k_();
    }

    public int func_70641_bl() {
        return 4;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FROM_BUCKET, (Object)false);
        this.field_70180_af.func_187214_a(BLOBFISH_SCALE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(DEPRESSURIZED, (Object)false);
        this.field_70180_af.func_187214_a(SLIMED, (Object)false);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return super.func_213305_a(poseIn).func_220313_a(this.getBlobfishScale());
    }

    private boolean isFromBucket() {
        return (Boolean)this.field_70180_af.func_187225_a(FROM_BUCKET);
    }

    public void setFromBucket(boolean p_203706_1_) {
        this.field_70180_af.func_187227_b(FROM_BUCKET, (Object)p_203706_1_);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("FromBucket", this.isFromBucket());
        compound.func_74757_a("Depressurized", this.isDepressurized());
        compound.func_74757_a("Slimed", this.isSlimed());
        compound.func_74776_a("BlobfishScale", this.getBlobfishScale());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setFromBucket(compound.func_74767_n("FromBucket"));
        this.setDepressurized(compound.func_74767_n("Depressurized"));
        this.setSlimed(compound.func_74767_n("Slimed"));
        this.setBlobfishScale(compound.func_74760_g("BlobfishScale"));
    }

    private boolean hasClearance() {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int l1 = 0; l1 < 10; ++l1) {
            BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable.func_189532_c(this.func_226277_ct_(), this.func_226278_cu_() + (double)l1, this.func_226281_cx_()));
            if (blockstate.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            return false;
        }
        return true;
    }

    public float getBlobfishScale() {
        return ((Float)this.field_70180_af.func_187225_a(BLOBFISH_SCALE)).floatValue();
    }

    public void setBlobfishScale(float scale) {
        this.field_70180_af.func_187227_b(BLOBFISH_SCALE, (Object)Float.valueOf(scale));
    }

    public boolean isDepressurized() {
        return (Boolean)this.field_70180_af.func_187225_a(DEPRESSURIZED);
    }

    public void setDepressurized(boolean depressurized) {
        this.field_70180_af.func_187227_b(DEPRESSURIZED, (Object)depressurized);
    }

    public boolean isSlimed() {
        return (Boolean)this.field_70180_af.func_187225_a(SLIMED);
    }

    public void setSlimed(boolean slimed) {
        this.field_70180_af.func_187227_b(SLIMED, (Object)slimed);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new FindWaterGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new AnimalAISwimBottom((CreatureEntity)this, 1.0, 7));
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    protected ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack lvt_3_1_ = p_230254_1_.func_184586_b(p_230254_2_);
        if (lvt_3_1_.func_77973_b() == Items.field_151123_aH && this.func_70089_S() && !this.isSlimed()) {
            this.setSlimed(true);
            for (int i = 0; i < 6 + this.field_70146_Z.nextInt(3); ++i) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, lvt_3_1_), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, this.func_226278_cu_() + (double)(this.func_213302_cg() * 0.5f) + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg() * 0.5f), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, d0, d1, d2);
            }
            lvt_3_1_.func_190918_g(1);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (lvt_3_1_.func_77973_b() == Items.field_151131_as && this.func_70089_S()) {
            this.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
            lvt_3_1_.func_190918_g(1);
            ItemStack lvt_4_1_ = this.getFishBucket();
            this.setBucketData(lvt_4_1_);
            if (!this.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)p_230254_1_, lvt_4_1_);
            }
            if (lvt_3_1_.func_190926_b()) {
                p_230254_1_.func_184611_a(p_230254_2_, lvt_4_1_);
            } else if (!p_230254_1_.field_71071_by.func_70441_a(lvt_4_1_)) {
                p_230254_1_.func_71019_a(lvt_4_1_, false);
            }
            this.func_70106_y();
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_203817_bZ;
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
    }

    protected ItemStack getFishBucket() {
        ItemStack stack = new ItemStack((IItemProvider)AMItemRegistry.BLOBFISH_BUCKET);
        if (this.func_145818_k_()) {
            stack.func_200302_a(this.func_200201_e());
        }
        return stack;
    }

    protected void setBucketData(ItemStack bucket) {
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
        CompoundNBT compoundnbt = bucket.func_196082_o();
        compoundnbt.func_74776_a("BucketScale", this.getBlobfishScale());
        compoundnbt.func_74757_a("Slimed", this.isSlimed());
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setBlobfishScale(0.75f + this.field_70146_Z.nextFloat() * 0.5f);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_70071_h_() {
        float f2;
        super.func_70071_h_();
        this.prevSquishFactor = this.squishFactor;
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.field_70125_A = f2 = (float)(-((double)((float)this.func_213322_ci().field_72448_b * 2.2f) * 57.2957763671875));
        if (!this.func_70090_H()) {
            if (this.field_70122_E && !this.wasOnGround) {
                this.squishAmount = -0.35f;
            } else if (!this.field_70122_E && this.wasOnGround) {
                this.squishAmount = 2.0f;
            }
        }
        this.wasOnGround = this.field_70122_E;
        this.alterSquishAmount();
        boolean clear = this.hasClearance();
        if (this.isDepressurized() && clear) {
            this.setDepressurized(false);
        }
        if (!this.isDepressurized() && !clear) {
            this.setDepressurized(true);
        }
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203816_ay;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_203813_aA;
    }

    public static boolean canBlobfishSpawn(EntityType<EntityBlobfish> entityType, IServerWorld iServerWorld, SpawnReason reason, BlockPos pos, Random random) {
        return reason == SpawnReason.SPAWNER || pos.func_177956_o() <= AMConfig.blobfishSpawnHeight && iServerWorld.func_180495_p(pos).func_203425_a(Blocks.field_150355_j) && iServerWorld.func_180495_p(pos.func_177984_a()).func_203425_a(Blocks.field_150355_j);
    }
}

