/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityBoneSerpentPart;
import com.github.alexthe666.alexsmobs.entity.EntitySoulVulture;
import com.github.alexthe666.alexsmobs.entity.EntityStraddleboard;
import com.github.alexthe666.alexsmobs.entity.ai.BoneSerpentAIFindLava;
import com.github.alexthe666.alexsmobs.entity.ai.BoneSerpentAIJump;
import com.github.alexthe666.alexsmobs.entity.ai.BoneSerpentAIMeleeJump;
import com.github.alexthe666.alexsmobs.entity.ai.BoneSerpentAIRandomSwimming;
import com.github.alexthe666.alexsmobs.entity.ai.BoneSerpentPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreatheAirGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityBoneSerpent
extends MonsterEntity {
    private static final DataParameter<Optional<UUID>> CHILD_UUID = EntityDataManager.func_187226_a(EntityBoneSerpent.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final Predicate<LivingEntity> NOT_RIDING_STRADDLEBOARD_FRIENDLY = entity -> entity.func_70089_S() && (entity.func_184187_bx() == null || !(entity.func_184187_bx() instanceof EntityStraddleboard) || !((EntityStraddleboard)entity.func_184187_bx()).shouldSerpentFriend());
    private static final Predicate<EntityStraddleboard> STRADDLEBOARD_FRIENDLY = entity -> entity.func_184207_aI() && entity.shouldSerpentFriend();
    public int jumpCooldown = 0;
    private boolean isLandNavigator;
    private int boardCheckCooldown = 0;
    private EntityStraddleboard boardToBoast = null;

    protected EntityBoneSerpent(EntityType type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
        this.switchNavigator(false);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.boneSeprentSpawnRolls, this.func_70681_au(), spawnReasonIn) && super.func_213380_a(worldIn, spawnReasonIn);
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean func_204209_c(int sizeIn) {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.BONE_SERPENT_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.BONE_SERPENT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.BONE_SERPENT_HURT;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 25.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233821_d_, (double)1.45f);
    }

    public int func_82143_as() {
        return 256;
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        if (potioneffectIn.func_188419_a() == Effects.field_82731_v) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        if (worldIn.func_180495_p(pos).func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a) || worldIn.func_180495_p(pos).func_204520_s().func_206884_a((ITag)FluidTags.field_206960_b)) {
            return 10.0f;
        }
        return this.func_180799_ab() ? Float.NEGATIVE_INFINITY : 0.0f;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return true;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public static boolean canBoneSerpentSpawn(EntityType<EntityBoneSerpent> p_234314_0_, IWorld p_234314_1_, SpawnReason p_234314_2_, BlockPos p_234314_3_, Random p_234314_4_) {
        BlockPos.Mutable blockpos$mutable = p_234314_3_.func_239590_i_();
        do {
            blockpos$mutable.func_189536_c(Direction.UP);
        } while (p_234314_1_.func_204610_c((BlockPos)blockpos$mutable).func_206884_a((ITag)FluidTags.field_206960_b));
        return p_234314_1_.func_180495_p((BlockPos)blockpos$mutable).func_196958_f();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new BreatheAirGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new BoneSerpentAIFindLava(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new BoneSerpentAIMeleeJump(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BoneSerpentAIJump(this, 10));
        this.field_70714_bg.func_75776_a(3, (Goal)new BoneSerpentAIRandomSwimming((CreatureEntity)this, 1.0, 8));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        if (!AMConfig.neutralBoneSerpents) {
            this.field_70715_bh.func_75776_a(2, new EntityAINearestTarget3D<PlayerEntity>((MobEntity)this, PlayerEntity.class, 10, true, false, NOT_RIDING_STRADDLEBOARD_FRIENDLY));
            this.field_70715_bh.func_75776_a(3, new EntityAINearestTarget3D<AbstractVillagerEntity>((MobEntity)this, AbstractVillagerEntity.class, 10, true, false, NOT_RIDING_STRADDLEBOARD_FRIENDLY));
        }
        this.field_70715_bh.func_75776_a(4, new EntityAINearestTarget3D<WitherSkeletonEntity>((MobEntity)this, WitherSkeletonEntity.class, 10, true, false, NOT_RIDING_STRADDLEBOARD_FRIENDLY));
        this.field_70715_bh.func_75776_a(5, new EntityAINearestTarget3D<EntitySoulVulture>((MobEntity)this, EntitySoulVulture.class, 10, true, false, NOT_RIDING_STRADDLEBOARD_FRIENDLY));
    }

    public void func_213352_e(Vector3d travelVector) {
        boolean liquid;
        boolean bl = liquid = this.func_180799_ab() || this.func_70090_H();
        if (this.func_70613_aW() && liquid) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = this.func_175447_b(this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new BoneSerpentMoveController(this);
            this.field_70699_by = new BoneSerpentPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.getChildId() != null) {
            compound.func_186854_a("ChildUUID", this.getChildId());
        }
    }

    public void func_85033_bc() {
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a((double)0.2f, 0.0, (double)0.2f));
        entities.stream().filter(entity -> !(entity instanceof EntityBoneSerpentPart) && entity.func_70104_M()).forEach(entity -> entity.func_70108_f((Entity)this));
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76379_h || source == DamageSource.field_76369_e || source == DamageSource.field_76368_d || source == DamageSource.field_82729_p || source == DamageSource.field_76371_c || source.func_76347_k() || super.func_180431_b(source);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_186855_b("ChildUUID")) {
            this.setChildId(compound.func_186857_a("ChildUUID"));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CHILD_UUID, Optional.empty());
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.field_70180_af.func_187225_a(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.field_70170_p.field_72995_K) {
            return ((ServerWorld)this.field_70170_p).func_217461_a(id);
        }
        return null;
    }

    public void func_70071_h_() {
        Entity child;
        boolean ground;
        super.func_70071_h_();
        this.field_71087_bX = false;
        boolean bl = ground = !this.func_180799_ab() && !this.func_70090_H() && this.func_233570_aj_();
        if (this.jumpCooldown > 0) {
            float f2;
            --this.jumpCooldown;
            this.field_70125_A = f2 = (float)(-((double)((float)this.func_213322_ci().field_72448_b) * 57.2957763671875));
        }
        if (!ground && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (ground && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (!this.field_70170_p.field_72995_K && (child = this.getChild()) == null) {
            Object partParent = this;
            int segments = 7 + this.func_70681_au().nextInt(8);
            for (int i = 0; i < segments; ++i) {
                EntityBoneSerpentPart part = new EntityBoneSerpentPart(AMEntityRegistry.BONE_SERPENT_PART, (LivingEntity)partParent, 0.9f, 180.0f, 0.0f);
                part.setParent((Entity)partParent);
                part.setBodyIndex(i);
                if (partParent == this) {
                    this.setChildId(part.func_110124_au());
                }
                part.setInitialPartPos((Entity)this);
                partParent = part;
                if (i == segments - 1) {
                    part.setTail(true);
                }
                this.field_70170_p.func_217376_c((Entity)part);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.boardCheckCooldown <= 0) {
                this.boardCheckCooldown = 100 + this.field_70146_Z.nextInt(150);
                List list = this.field_70170_p.func_175647_a(EntityStraddleboard.class, this.func_174813_aQ().func_72314_b(100.0, 15.0, 100.0), STRADDLEBOARD_FRIENDLY);
                EntityStraddleboard closestBoard = null;
                for (EntityStraddleboard board : list) {
                    if (closestBoard != null && !(this.func_70032_d(closestBoard) > this.func_70032_d(board))) continue;
                    closestBoard = board;
                }
                this.boardToBoast = closestBoard;
            } else {
                --this.boardCheckCooldown;
            }
            if (this.boardToBoast != null) {
                if (this.func_70032_d(this.boardToBoast) > 200.0f) {
                    this.boardToBoast = null;
                } else {
                    if ((this.func_180799_ab() || this.func_70090_H()) && this.func_70032_d(this.boardToBoast) < 15.0f && this.jumpCooldown == 0) {
                        float up = 0.7f + this.func_70681_au().nextFloat() * 0.8f;
                        Vector3d vector3d1 = this.func_70040_Z();
                        this.func_213317_d(this.func_213322_ci().func_72441_c(vector3d1.func_82615_a() * 0.6, (double)up, vector3d1.func_82617_b() * 0.6));
                        this.func_70661_as().func_75499_g();
                        this.jumpCooldown = this.func_70681_au().nextInt(300) + 100;
                    }
                    if (this.func_70032_d(this.boardToBoast) > 5.0f) {
                        this.func_70661_as().func_75497_a((Entity)this.boardToBoast, 1.5);
                    } else {
                        this.func_70661_as().func_75499_g();
                    }
                }
            }
        }
    }

    public boolean func_70648_aU() {
        return true;
    }

    static class BoneSerpentMoveController
    extends MovementController {
        private final EntityBoneSerpent dolphin;

        public BoneSerpentMoveController(EntityBoneSerpent dolphinIn) {
            super((MobEntity)dolphinIn);
            this.dolphin = dolphinIn;
        }

        public void func_75641_c() {
            if (this.dolphin.func_70090_H() || this.dolphin.func_180799_ab()) {
                this.dolphin.func_213317_d(this.dolphin.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.dolphin.func_70661_as().func_75500_f()) {
                double d2;
                double d1;
                double d0 = this.field_75646_b - this.dolphin.func_226277_ct_();
                double d3 = d0 * d0 + (d1 = this.field_75647_c - this.dolphin.func_226278_cu_()) * d1 + (d2 = this.field_75644_d - this.dolphin.func_226281_cx_()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                } else {
                    float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.dolphin.field_70761_aq = this.dolphin.field_70177_z = this.func_75639_a(this.dolphin.field_70177_z, f, 10.0f);
                    this.dolphin.field_70759_as = this.dolphin.field_70177_z;
                    float f1 = (float)(this.field_75645_e * this.dolphin.func_233637_b_(Attributes.field_233821_d_));
                    if (this.dolphin.func_70090_H() || this.dolphin.func_180799_ab()) {
                        this.dolphin.func_70659_e(f1 * 0.02f);
                        float f2 = -((float)(MathHelper.func_181159_b((double)d1, (double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2))) * 57.2957763671875));
                        f2 = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)f2), (float)-85.0f, (float)85.0f);
                        this.dolphin.func_213317_d(this.dolphin.func_213322_ci().func_72441_c(0.0, (double)this.dolphin.func_70689_ay() * d1 * 0.6, 0.0));
                        this.dolphin.field_70125_A = this.func_75639_a(this.dolphin.field_70125_A, f2, 1.0f);
                        float f3 = MathHelper.func_76134_b((float)(this.dolphin.field_70125_A * ((float)Math.PI / 180)));
                        float f4 = MathHelper.func_76126_a((float)(this.dolphin.field_70125_A * ((float)Math.PI / 180)));
                        this.dolphin.field_191988_bg = f3 * f1;
                        this.dolphin.field_70701_bs = -f4 * f1;
                    } else {
                        this.dolphin.func_70659_e(f1 * 0.1f);
                    }
                }
            } else {
                this.dolphin.func_70659_e(0.0f);
                this.dolphin.func_184646_p(0.0f);
                this.dolphin.func_70657_f(0.0f);
                this.dolphin.func_191989_p(0.0f);
            }
        }
    }
}

