/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCentipedeHead;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIFleeLight;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IShearable;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;

public class EntityCockroach
extends AnimalEntity
implements IShearable,
IForgeShearable,
ITargetsDroppedItems {
    public static final ResourceLocation MARACA_LOOT = new ResourceLocation("alexsmobs", "entities/cockroach_maracas");
    public static final ResourceLocation MARACA_HEADLESS_LOOT = new ResourceLocation("alexsmobs", "entities/cockroach_maracas_headless");
    protected static final EntitySize STAND_SIZE = EntitySize.func_220311_c((float)0.7f, (float)0.9f);
    private static final DataParameter<Boolean> DANCING = EntityDataManager.func_187226_a(EntityCockroach.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HEADLESS = EntityDataManager.func_187226_a(EntityCockroach.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MARACAS = EntityDataManager.func_187226_a(EntityCockroach.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<UUID>> NEAREST_MUSICIAN = EntityDataManager.func_187226_a(EntityCockroach.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> RAINBOW = EntityDataManager.func_187226_a(EntityCockroach.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> BREADED = EntityDataManager.func_187226_a(EntityCockroach.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int randomWingFlapTick = 0;
    public float prevDanceProgress;
    public float danceProgress;
    private boolean prevStand = false;
    private boolean isJukeboxing;
    private BlockPos jukeboxPosition;
    private int laCucarachaTimer = 0;
    public int timeUntilNextEgg = this.field_70146_Z.nextInt(24000) + 24000;

    public EntityCockroach(EntityType type, World world) {
        super(type, world);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 6.0).func_233815_a_(Attributes.field_233821_d_, (double)0.35f);
    }

    public static boolean isValidLightLevel(IServerWorld p_223323_0_, BlockPos p_223323_1_, Random p_223323_2_) {
        if (p_223323_0_.func_226658_a_(LightType.SKY, p_223323_1_) > p_223323_2_.nextInt(32)) {
            return false;
        }
        int lvt_3_1_ = p_223323_0_.func_201672_e().func_72911_I() ? p_223323_0_.func_205049_d(p_223323_1_, 10) : p_223323_0_.func_201696_r(p_223323_1_);
        return lvt_3_1_ <= p_223323_2_.nextInt(8);
    }

    public static boolean canMonsterSpawnInLight(EntityType<? extends EntityCockroach> p_223325_0_, IServerWorld p_223325_1_, SpawnReason p_223325_2_, BlockPos p_223325_3_, Random p_223325_4_) {
        return EntityCockroach.isValidLightLevel(p_223325_1_, p_223325_3_, p_223325_4_) && EntityCockroach.func_223315_a(p_223325_0_, (IWorld)p_223325_1_, (SpawnReason)p_223325_2_, (BlockPos)p_223325_3_, (Random)p_223325_4_);
    }

    public static <T extends MobEntity> boolean canCockroachSpawn(EntityType<EntityCockroach> entityType, IServerWorld iServerWorld, SpawnReason reason, BlockPos pos, Random random) {
        return reason == SpawnReason.SPAWNER || !iServerWorld.func_226660_f_(pos) && pos.func_177956_o() <= 64 && EntityCockroach.canMonsterSpawnInLight(entityType, iServerWorld, reason, pos, random);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.func_213392_I();
    }

    public boolean func_213392_I() {
        return super.func_213392_I() || this.isBreaded() || this.isRainbow() || this.isDancing() || this.hasMaracas() || this.isHeadless();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.COCKROACH_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.COCKROACH_HURT;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.0, false, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{AMItemRegistry.MARACA, Items.field_151102_aT})));
        this.field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)this, EntityCentipedeHead.class, 16.0f, 1.3, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, 1.3, 1.0){

            public boolean func_75250_a() {
                return !EntityCockroach.this.isBreaded() && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new AnimalAIFleeLight((CreatureEntity)this, 1.0){

            @Override
            public boolean func_75250_a() {
                return !EntityCockroach.this.isBreaded() && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(6, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0, 80));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, new CreatureAITargetItems((CreatureEntity)this, false));
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean prev = super.func_70097_a(source, amount);
        if (prev) {
            this.randomWingFlapTick = 5 + this.field_70146_Z.nextInt(15);
            if (this.func_110143_aJ() <= 1.0f && amount > 0.0f && !this.isHeadless() && this.func_70681_au().nextInt(3) == 0) {
                this.setHeadless(true);
                if (!this.field_70170_p.field_72995_K) {
                    for (int i = 0; i < 3; ++i) {
                        ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_218421_R, this.func_226282_d_(0.52f), this.func_226283_e_(1.0), this.func_226287_g_(0.52f), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        return prev;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151102_aT;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Maracas", this.hasMaracas());
        compound.func_74757_a("Rainbow", this.isRainbow());
        compound.func_74757_a("Dancing", this.isDancing());
        compound.func_74757_a("Breaded", this.isBreaded());
        compound.func_74768_a("EggTime", this.timeUntilNextEgg);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setMaracas(compound.func_74767_n("Maracas"));
        this.setRainbow(compound.func_74767_n("Rainbow"));
        this.setDancing(compound.func_74767_n("Dancing"));
        this.setBreaded(compound.func_74767_n("Breaded"));
        if (compound.func_74764_b("EggTime")) {
            this.timeUntilNextEgg = compound.func_74762_e("EggTime");
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.hasMaracas() ? (this.isHeadless() ? MARACA_HEADLESS_LOOT : MARACA_LOOT) : super.func_184647_J();
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return 0.5f - worldIn.func_205052_D(pos);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.isDancing() ? STAND_SIZE.func_220313_a(this.func_213355_cm()) : super.func_213305_a(poseIn);
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76379_h || source == DamageSource.field_76369_e || source == DamageSource.field_76368_d || source == DamageSource.field_82729_p || super.func_180431_b(source);
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack lvt_3_1_ = p_230254_1_.func_184586_b(p_230254_2_);
        if ((lvt_3_1_.func_77973_b() == Items.field_221646_ak || lvt_3_1_.func_77973_b() == Items.field_221648_al) && this.func_70089_S() && this.isRainbow()) {
            this.setRainbow(false);
            for (int i = 0; i < 6 + this.field_70146_Z.nextInt(3); ++i) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)AMItemRegistry.MIMICREAM)), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, this.func_226278_cu_() + (double)(this.func_213302_cg() * 0.5f) + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg() * 0.5f), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, d0, d1, d2);
            }
            return ActionResultType.SUCCESS;
        }
        if (lvt_3_1_.func_77973_b() == AMItemRegistry.MIMICREAM && this.func_70089_S() && !this.isRainbow()) {
            this.setRainbow(true);
            for (int i = 0; i < 6 + this.field_70146_Z.nextInt(3); ++i) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, lvt_3_1_), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, this.func_226278_cu_() + (double)(this.func_213302_cg() * 0.5f) + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg() * 0.5f), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, d0, d1, d2);
            }
            lvt_3_1_.func_190918_g(1);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (lvt_3_1_.func_77973_b() == AMItemRegistry.MARACA && this.func_70089_S() && !this.hasMaracas()) {
            this.setMaracas(true);
            lvt_3_1_.func_190918_g(1);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (lvt_3_1_.func_77973_b() != AMItemRegistry.MARACA && this.func_70089_S() && this.hasMaracas()) {
            this.setMaracas(false);
            this.setDancing(false);
            this.func_199701_a_(new ItemStack((IItemProvider)AMItemRegistry.MARACA));
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DANCING, (Object)false);
        this.field_70180_af.func_187214_a(HEADLESS, (Object)false);
        this.field_70180_af.func_187214_a(MARACAS, (Object)false);
        this.field_70180_af.func_187214_a(NEAREST_MUSICIAN, Optional.empty());
        this.field_70180_af.func_187214_a(RAINBOW, (Object)false);
        this.field_70180_af.func_187214_a(BREADED, (Object)false);
    }

    public boolean isDancing() {
        return (Boolean)this.field_70180_af.func_187225_a(DANCING);
    }

    public void setDancing(boolean dancing) {
        this.field_70180_af.func_187227_b(DANCING, (Object)dancing);
    }

    public boolean isHeadless() {
        return (Boolean)this.field_70180_af.func_187225_a(HEADLESS);
    }

    public void setHeadless(boolean head) {
        this.field_70180_af.func_187227_b(HEADLESS, (Object)head);
    }

    public boolean hasMaracas() {
        return (Boolean)this.field_70180_af.func_187225_a(MARACAS);
    }

    public void setMaracas(boolean head) {
        this.field_70180_af.func_187227_b(MARACAS, (Object)head);
    }

    public boolean isBreaded() {
        return (Boolean)this.field_70180_af.func_187225_a(BREADED);
    }

    public void setBreaded(boolean breaded) {
        this.field_70180_af.func_187227_b(BREADED, (Object)breaded);
    }

    @Nullable
    public UUID getNearestMusicianId() {
        return ((Optional)this.field_70180_af.func_187225_a(NEAREST_MUSICIAN)).orElse(null);
    }

    public boolean isRainbow() {
        return (Boolean)this.field_70180_af.func_187225_a(RAINBOW);
    }

    public void setRainbow(boolean head) {
        this.field_70180_af.func_187227_b(RAINBOW, (Object)head);
    }

    public void func_70071_h_() {
        Entity musician;
        boolean dance;
        super.func_70071_h_();
        this.prevDanceProgress = this.danceProgress;
        boolean bl = dance = this.isJukeboxing || this.isDancing();
        if (this.jukeboxPosition == null || !this.jukeboxPosition.func_218137_a((IPosition)this.func_213303_ch(), 3.46) || !this.field_70170_p.func_180495_p(this.jukeboxPosition).func_203425_a(Blocks.field_150421_aI)) {
            this.isJukeboxing = false;
            this.jukeboxPosition = null;
        }
        if (this.func_70047_e() > this.func_213302_cg()) {
            this.func_213323_x_();
        }
        if (dance && this.danceProgress < 5.0f) {
            this.danceProgress += 1.0f;
        }
        if (!dance && this.danceProgress > 0.0f) {
            this.danceProgress -= 1.0f;
        }
        if (!this.field_70122_E || this.field_70146_Z.nextInt(200) == 0) {
            this.randomWingFlapTick = 5 + this.field_70146_Z.nextInt(15);
        }
        if (this.randomWingFlapTick > 0) {
            --this.randomWingFlapTick;
        }
        if (this.prevStand != dance) {
            if (this.hasMaracas()) {
                this.tellOthersImPlayingLaCucaracha();
            }
            this.func_213323_x_();
        }
        if (!this.hasMaracas() && (musician = this.getNearestMusician()) != null) {
            if (!musician.func_70089_S() || this.func_70032_d(musician) > 10.0f || musician instanceof EntityCockroach && !((EntityCockroach)musician).hasMaracas()) {
                this.setNearestMusician(null);
                this.setDancing(false);
            } else {
                this.setDancing(true);
            }
        }
        if (this.hasMaracas()) {
            ++this.laCucarachaTimer;
            if (this.laCucarachaTimer % 20 == 0 && this.field_70146_Z.nextFloat() < 0.3f) {
                this.tellOthersImPlayingLaCucaracha();
            }
            this.setDancing(true);
            if (!this.func_174814_R()) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)67);
            }
        } else {
            this.laCucarachaTimer = 0;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.func_70631_g_() && --this.timeUntilNextEgg <= 0) {
            ItemEntity dropped = this.func_199703_a((IItemProvider)AMItemRegistry.COCKROACH_OOTHECA);
            dropped.func_174869_p();
            this.timeUntilNextEgg = this.field_70146_Z.nextInt(24000) + 24000;
        }
        this.prevStand = dance;
    }

    private void tellOthersImPlayingLaCucaracha() {
        List list = this.field_70170_p.func_175647_a(EntityCockroach.class, this.getMusicianDistance(), null);
        for (EntityCockroach roach : list) {
            if (roach.hasMaracas()) continue;
            roach.setNearestMusician(this.func_110124_au());
        }
    }

    private AxisAlignedBB getMusicianDistance() {
        return this.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 67) {
            AlexsMobs.PROXY.onEntityStatus((Entity)this, id);
        } else {
            super.func_70103_a(id);
        }
    }

    public Entity getNearestMusician() {
        UUID id = this.getNearestMusicianId();
        if (id != null && !this.field_70170_p.field_72995_K) {
            return ((ServerWorld)this.field_70170_p).func_217461_a(id);
        }
        return null;
    }

    public void setNearestMusician(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(NEAREST_MUSICIAN, Optional.ofNullable(uniqueId));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_191987_a(BlockPos pos, boolean isPartying) {
        this.jukeboxPosition = pos;
        this.isJukeboxing = isPartying;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        EntityCockroach roach = (EntityCockroach)AMEntityRegistry.COCKROACH.func_200721_a((World)serverWorld);
        roach.setBreaded(true);
        return roach;
    }

    public boolean func_230262_K__() {
        return this.func_70089_S() && !this.func_70631_g_() && !this.isHeadless();
    }

    public boolean isShearable(@Nonnull ItemStack item, World world, BlockPos pos) {
        return this.func_230262_K__();
    }

    public void func_230263_a_(SoundCategory category) {
        this.func_70097_a(DamageSource.field_76377_j, 0.0f);
        this.field_70170_p.func_217384_a(null, (Entity)this, SoundEvents.field_187763_eJ, category, 1.0f, 1.0f);
        this.setHeadless(true);
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable PlayerEntity player, @Nonnull ItemStack item, World world, BlockPos pos, int fortune) {
        world.func_217384_a(null, (Entity)this, SoundEvents.field_187763_eJ, player == null ? SoundCategory.BLOCKS : SoundCategory.PLAYERS, 1.0f, 1.0f);
        this.func_70097_a(DamageSource.field_76377_j, 0.0f);
        if (!world.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_218421_R, this.func_226282_d_(0.52f), this.func_226283_e_(1.0), this.func_226287_g_(0.52f), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        this.setHeadless(true);
        return Collections.emptyList();
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.func_77973_b().func_219971_r() || stack.func_77973_b() == Items.field_151102_aT;
    }

    public void func_213352_e(Vector3d vec3d) {
        if (this.isDancing() || this.danceProgress > 0.0f) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            vec3d = Vector3d.field_186680_a;
        }
        super.func_213352_e(vec3d);
    }

    @Override
    public void onGetItem(ItemEntity e) {
        if (e.func_92059_d().func_77973_b() == AMItemRegistry.MARACA) {
            this.setMaracas(true);
        } else {
            if (e.func_92059_d().hasContainerItem()) {
                this.func_199701_a_(e.func_92059_d().getContainerItem().func_77946_l());
            }
            this.func_70691_i(5.0f);
            if (e.func_92059_d().func_77973_b() == Items.field_151025_P || e.func_92059_d().func_77973_b() == Items.field_151102_aT) {
                this.setBreaded(true);
            }
        }
    }
}

