/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.CrowAICircleCrops;
import com.github.alexthe666.alexsmobs.entity.ai.CrowAIFollowOwner;
import com.github.alexthe666.alexsmobs.entity.ai.CrowAIMelee;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.FlightMoveController;
import com.github.alexthe666.alexsmobs.message.MessageCrowDismount;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class EntityCrow
extends TameableEntity
implements ITargetsDroppedItems {
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityCrow.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ATTACK_TICK = EntityDataManager.func_187226_a(EntityCrow.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityCrow.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(EntityCrow.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<BlockPos>> PERCH_POS = EntityDataManager.func_187226_a(EntityCrow.class, (IDataSerializer)DataSerializers.field_187201_k);
    public float prevFlyProgress;
    public float flyProgress;
    public float prevAttackProgress;
    public float attackProgress;
    public int fleePumpkinFlag = 0;
    public boolean aiItemFlag = false;
    public boolean aiItemFrameFlag = false;
    public float prevSitProgress;
    public float sitProgress;
    private boolean isLandNavigator;
    private int timeFlying = 0;
    @Nullable
    private UUID seedThrowerID;
    private int heldItemTime = 0;
    private int checkPerchCooldown = 0;
    private boolean gatheringClockwise = false;

    protected EntityCrow(EntityType type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 16.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
        this.switchNavigator(false);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new CrowAIMelee(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new CrowAIFollowOwner(this, 1.0, 4.0f, 2.0f, true));
        this.field_70714_bg.func_75776_a(4, (Goal)new AIDepositChests());
        this.field_70714_bg.func_75776_a(4, (Goal)new AIScatter());
        this.field_70714_bg.func_75776_a(5, (Goal)new AIAvoidPumpkins());
        this.field_70714_bg.func_75776_a(5, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new CrowAICircleCrops(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new AIWalkIdle());
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, CreatureEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new AITargetItems((CreatureEntity)this, false, false, 40, 16));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{PlayerEntity.class}).func_220794_a(new Class[0]));
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.crowSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public static <T extends MobEntity> boolean canCrowSpawn(EntityType<EntityCrow> crow, IWorld worldIn, SpawnReason reason, BlockPos p_223317_3_, Random random) {
        BlockState blockstate = worldIn.func_180495_p(p_223317_3_.func_177977_b());
        return (blockstate.func_235714_a_((ITag)BlockTags.field_206952_E) || blockstate.func_203425_a(Blocks.field_196658_i) || blockstate.func_235714_a_((ITag)BlockTags.field_200031_h) || blockstate.func_203425_a(Blocks.field_150350_a)) && worldIn.func_226659_b_(p_223317_3_, 0) > 8;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.func_70909_n()) {
            LivingEntity livingentity = this.func_70902_q();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TameableEntity) {
                return ((TameableEntity)entityIn).func_152114_e(livingentity);
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new GroundPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new FlightMoveController((MobEntity)this, 0.7f, false);
            this.field_70699_by = new DirectPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return false;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean prev;
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        this.func_233687_w_(false);
        if (entity != null && this.func_70909_n() && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 4.0f;
        }
        if ((prev = super.func_70097_a(source, amount)) && !this.func_184614_ca().func_190926_b()) {
            this.func_199701_a_(this.func_184614_ca().func_77946_l());
            this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        }
        return prev;
    }

    public void func_70098_U() {
        Entity entity = this.func_184187_bx();
        if (this.func_184218_aH() && !entity.func_70089_S()) {
            this.func_184210_p();
        } else if (this.func_70909_n() && entity instanceof LivingEntity && this.func_152114_e((LivingEntity)entity)) {
            this.func_213293_j(0.0, 0.0, 0.0);
            this.func_70071_h_();
            Entity riding = this.func_184187_bx();
            if (this.func_184218_aH()) {
                int i = riding.func_184188_bt().indexOf(this);
                float radius = 0.43f;
                float angle = (float)Math.PI / 180 * (((PlayerEntity)riding).field_70761_aq + (float)(i == 0 ? -90 : 90));
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                double extraY = riding.func_225608_bj_() ? 1.25 : 1.45;
                this.field_70759_as = ((PlayerEntity)riding).field_70759_as;
                this.field_70126_B = ((PlayerEntity)riding).field_70759_as;
                this.func_70107_b(riding.func_226277_ct_() + extraX, riding.func_226278_cu_() + extraY, riding.func_226281_cx_() + extraZ);
                if (!riding.func_70089_S() || this.field_184245_j == 0 && riding.func_225608_bj_() || ((PlayerEntity)riding).func_184613_cA() || this.func_70638_az() != null && this.func_70638_az().func_70089_S()) {
                    this.func_233575_bb_();
                    if (!this.field_70170_p.field_72995_K) {
                        AlexsMobs.sendMSGToAll(new MessageCrowDismount(this.func_145782_y(), riding.func_145782_y()));
                    }
                }
            }
        }
    }

    public int getRidingCrows(LivingEntity player) {
        int crowCount = 0;
        for (Entity e : player.func_184188_bt()) {
            if (!(e instanceof EntityCrow)) continue;
            ++crowCount;
        }
        return crowCount;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151080_bb && this.func_70909_n();
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        ActionResultType type = super.func_230254_b_(player, hand);
        if (!this.func_184614_ca().func_190926_b() && type != ActionResultType.SUCCESS) {
            this.func_199701_a_(this.func_184614_ca().func_77946_l());
            this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            return ActionResultType.SUCCESS;
        }
        if (type == ActionResultType.PASS && this.func_70909_n() && this.func_152114_e((LivingEntity)player) && !this.func_70877_b(itemstack)) {
            boolean sit;
            if (this.isCrowEdible(itemstack) && this.func_184614_ca().func_190926_b()) {
                ItemStack cop = itemstack.func_77946_l();
                cop.func_190920_e(1);
                this.func_184611_a(Hand.MAIN_HAND, cop);
                itemstack.func_190918_g(1);
            }
            this.setCommand(this.getCommand() + 1);
            if (this.getCommand() == 4) {
                this.setCommand(0);
            }
            if (this.getCommand() == 3) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("entity.alexsmobs.crow.command_3", new Object[]{this.func_200200_C_()}), true);
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("entity.alexsmobs.all.command_" + this.getCommand(), new Object[]{this.func_200200_C_()}), true);
            }
            boolean bl = sit = this.getCommand() == 2;
            if (sit) {
                this.setSitting(true);
                return ActionResultType.SUCCESS;
            }
            this.setSitting(false);
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_70071_h_() {
        BlockState below;
        super.func_70071_h_();
        this.prevAttackProgress = this.attackProgress;
        this.prevFlyProgress = this.flyProgress;
        this.prevSitProgress = this.sitProgress;
        if ((this.func_233685_eM_() || this.func_184218_aH()) && this.sitProgress < 5.0f) {
            this.sitProgress += 1.0f;
        }
        if (!this.func_233685_eM_() && !this.func_184218_aH() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.isFlying() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.isFlying() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.fleePumpkinFlag > 0) {
            --this.fleePumpkinFlag;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isFlying() && this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (!this.isFlying() && !this.isLandNavigator) {
                this.switchNavigator(true);
            }
            if (this.isFlying()) {
                ++this.timeFlying;
                this.func_189654_d(true);
                if (this.func_233685_eM_() || this.func_184218_aH() || this.func_70880_s()) {
                    this.setFlying(false);
                }
            } else {
                this.timeFlying = 0;
                this.func_189654_d(false);
            }
        }
        if (!this.func_184614_ca().func_190926_b()) {
            ++this.heldItemTime;
            if (this.heldItemTime > 60 && this.isCrowEdible(this.func_184614_ca()) && (!this.func_70909_n() || this.func_110143_aJ() < this.func_110138_aP())) {
                this.heldItemTime = 0;
                this.func_70691_i(4.0f);
                this.func_184185_a(SoundEvents.field_192797_eu, this.func_70599_aP(), this.func_70647_i());
                if (this.func_184614_ca().func_77973_b() == Items.field_151080_bb && this.seedThrowerID != null && !this.func_70909_n()) {
                    if (this.func_70681_au().nextFloat() < 0.3f) {
                        this.func_70903_f(true);
                        this.setCommand(1);
                        this.func_184754_b(this.seedThrowerID);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    } else {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                    }
                }
                if (this.func_184614_ca().hasContainerItem()) {
                    this.func_199701_a_(this.func_184614_ca().getContainerItem());
                }
                this.func_184614_ca().func_190918_g(1);
            }
        } else {
            this.heldItemTime = 0;
        }
        if (this.field_184245_j > 0) {
            --this.field_184245_j;
        }
        if ((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) > 0) {
            this.field_70180_af.func_187227_b(ATTACK_TICK, (Object)((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) - 1));
            if (this.attackProgress < 5.0f) {
                this.attackProgress += 1.0f;
            }
        } else if (this.attackProgress > 0.0f) {
            this.attackProgress -= 1.0f;
        }
        if (this.checkPerchCooldown > 0) {
            --this.checkPerchCooldown;
        }
        if (this.func_70909_n() && this.checkPerchCooldown == 0) {
            this.checkPerchCooldown = 50;
            below = this.func_233568_aJ_();
            if (below.func_177230_c() == Blocks.field_150407_cf) {
                this.func_70691_i(1.0f);
                this.field_70170_p.func_72960_a((Entity)this, (byte)67);
                this.setPerchPos(this.func_226270_aj_());
            }
        }
        if (this.getCommand() == 3 && this.func_70909_n() && this.getPerchPos() != null && this.checkPerchCooldown == 0) {
            this.checkPerchCooldown = 120;
            below = this.field_70170_p.func_180495_p(this.getPerchPos());
            if (below.func_177230_c() != Blocks.field_150407_cf) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)68);
                this.setPerchPos(null);
                this.setCommand(2);
                this.setSitting(true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 67) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
            }
        } else if (id == 68) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197609_b, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Flying", this.isFlying());
        compound.func_74757_a("MonkeySitting", this.func_233685_eM_());
        compound.func_74768_a("Command", this.getCommand());
        if (this.getPerchPos() != null) {
            compound.func_74768_a("PerchX", this.getPerchPos().func_177958_n());
            compound.func_74768_a("PerchY", this.getPerchPos().func_177956_o());
            compound.func_74768_a("PerchZ", this.getPerchPos().func_177952_p());
        }
    }

    public void func_213352_e(Vector3d vec3d) {
        if (this.func_233685_eM_()) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            vec3d = Vector3d.field_186680_a;
        }
        super.func_213352_e(vec3d);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setFlying(compound.func_74767_n("Flying"));
        this.setSitting(compound.func_74767_n("MonkeySitting"));
        this.setCommand(compound.func_74762_e("Command"));
        if (compound.func_74764_b("PerchX") && compound.func_74764_b("PerchY") && compound.func_74764_b("PerchZ")) {
            this.setPerchPos(new BlockPos(compound.func_74762_e("PerchX"), compound.func_74762_e("PerchY"), compound.func_74762_e("PerchZ")));
        }
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(FLYING);
    }

    public void setFlying(boolean flying) {
        if (flying && this.func_70631_g_()) {
            return;
        }
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
    }

    public int getCommand() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    public void setCommand(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)command);
    }

    public boolean func_233685_eM_() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void setSitting(boolean sit) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sit);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(ATTACK_TICK, (Object)0);
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(PERCH_POS, Optional.empty());
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76368_d || source == DamageSource.field_82729_p || source == DamageSource.field_76367_g || super.func_180431_b(source);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return (AgeableEntity)AMEntityRegistry.CROW.func_200721_a((World)serverWorld);
    }

    public boolean isTargetBlocked(Vector3d target) {
        Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() != RayTraceResult.Type.MISS;
    }

    public int func_70627_aG() {
        return 60;
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.CROW_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.CROW_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.CROW_HURT;
    }

    public Vector3d getBlockInViewAway(Vector3d fleePos, float radiusAdd) {
        float radius = -9.45f - (float)this.func_70681_au().nextInt(24) - radiusAdd;
        float neg = this.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.func_82615_a() + extraX, 0.0, fleePos.func_82616_c() + extraZ);
        BlockPos ground = this.getCrowGround(radialPos);
        int distFromGround = (int)this.func_226278_cu_() - ground.func_177956_o();
        int flightHeight = 4 + this.func_70681_au().nextInt(10);
        BlockPos newPos = ground.func_177981_b(distFromGround > 8 ? flightHeight : this.func_70681_au().nextInt(6) + 1);
        if (!this.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)newPos)) && this.func_195048_a(Vector3d.func_237489_a_((Vector3i)newPos)) > 1.0) {
            return Vector3d.func_237489_a_((Vector3i)newPos);
        }
        return null;
    }

    private BlockPos getCrowGround(BlockPos in) {
        BlockPos position = new BlockPos((double)in.func_177958_n(), this.func_226278_cu_(), (double)in.func_177952_p());
        while (position.func_177956_o() > 2 && this.field_70170_p.func_175623_d(position)) {
            position = position.func_177977_b();
        }
        return position;
    }

    public Vector3d getBlockGrounding(Vector3d fleePos) {
        float radius = -9.45f - (float)this.func_70681_au().nextInt(24);
        float neg = this.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.func_82615_a() + extraX, this.func_226278_cu_(), fleePos.func_82616_c() + extraZ);
        BlockPos ground = this.getCrowGround(radialPos);
        if (ground.func_177956_o() == 0) {
            return this.func_213303_ch();
        }
        ground = this.func_233580_cy_();
        while (ground.func_177956_o() > 2 && this.field_70170_p.func_175623_d(ground)) {
            ground = ground.func_177977_b();
        }
        if (!this.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)ground.func_177984_a()))) {
            return Vector3d.func_237489_a_((Vector3i)ground);
        }
        return null;
    }

    private boolean isOverWater() {
        BlockPos position = this.func_233580_cy_();
        while (position.func_177956_o() > 2 && this.field_70170_p.func_175623_d(position)) {
            position = position.func_177977_b();
        }
        return !this.field_70170_p.func_204610_c(position).func_206888_e();
    }

    public void peck() {
        this.field_70180_af.func_187227_b(ATTACK_TICK, (Object)7);
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return this.isCrowEdible(stack) || this.func_70909_n();
    }

    private boolean isCrowEdible(ItemStack stack) {
        return stack.func_77973_b().func_219971_r() || ItemTags.func_199903_a().func_199910_a(AMTagRegistry.CROW_FOODSTUFFS).func_230235_a_((Object)stack.func_77973_b());
    }

    @Override
    public double getMaxDistToItem() {
        return 1.0;
    }

    @Override
    public void onGetItem(ItemEntity e) {
        ItemStack duplicate = e.func_92059_d().func_77946_l();
        duplicate.func_190920_e(1);
        if (!this.func_184586_b(Hand.MAIN_HAND).func_190926_b() && !this.field_70170_p.field_72995_K) {
            this.func_70099_a(this.func_184586_b(Hand.MAIN_HAND), 0.0f);
        }
        this.func_184611_a(Hand.MAIN_HAND, duplicate);
        this.seedThrowerID = e.func_92059_d().func_77973_b() == Items.field_151080_bb && !this.func_70909_n() ? e.func_200214_m() : null;
    }

    public BlockPos getPerchPos() {
        return ((Optional)this.field_70180_af.func_187225_a(PERCH_POS)).orElse(null);
    }

    public void setPerchPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(PERCH_POS, Optional.ofNullable(pos));
    }

    private Vector3d getGatheringVec(Vector3d vector3d, float gatheringCircleDist) {
        Vector3d pos;
        float angle = 0.13962634f * (float)(this.gatheringClockwise ? -this.field_70173_aa : this.field_70173_aa);
        double extraX = gatheringCircleDist * MathHelper.func_76126_a((float)angle);
        double extraZ = gatheringCircleDist * MathHelper.func_76134_b((float)angle);
        if (this.getPerchPos() != null && this.field_70170_p.func_175623_d(new BlockPos(pos = new Vector3d((double)this.getPerchPos().func_177958_n() + extraX, (double)(this.getPerchPos().func_177956_o() + 2), (double)this.getPerchPos().func_177952_p() + extraZ)))) {
            return pos;
        }
        return null;
    }

    private class AIDepositChests
    extends Goal {
        protected final Sorter theNearestAttackableTargetSorter;
        protected final Predicate<ItemFrameEntity> targetEntitySelector;
        protected int executionChance = 8;
        protected boolean mustUpdate;
        private ItemFrameEntity targetEntity;
        private Vector3d flightTarget = null;
        private int cooldown = 0;
        private ITag tag;

        AIDepositChests() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.theNearestAttackableTargetSorter = new Sorter((Entity)EntityCrow.this);
            this.targetEntitySelector = new Predicate<ItemFrameEntity>(){

                public boolean apply(@Nullable ItemFrameEntity e) {
                    LazyOptional handler;
                    BlockPos hangingPosition = e.func_174857_n().func_177972_a(e.func_174811_aO().func_176734_d());
                    TileEntity entity = e.field_70170_p.func_175625_s(hangingPosition);
                    if (entity != null && (handler = entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, e.func_174811_aO().func_176734_d())) != null && handler.isPresent()) {
                        return e.func_82335_i().func_77969_a(EntityCrow.this.func_184614_ca());
                    }
                    return false;
                }
            };
        }

        public boolean func_75250_a() {
            List list;
            if (EntityCrow.this.func_184218_aH() || EntityCrow.this.aiItemFlag || EntityCrow.this.func_184207_aI() || EntityCrow.this.func_233685_eM_() || EntityCrow.this.getCommand() != 3) {
                return false;
            }
            if (EntityCrow.this.func_184614_ca().func_190926_b()) {
                return false;
            }
            if (!this.mustUpdate) {
                long worldTime = EntityCrow.this.field_70170_p.func_82737_E() % 10L;
                if (EntityCrow.this.func_70654_ax() >= 100 && worldTime != 0L) {
                    return false;
                }
                if (EntityCrow.this.func_70681_au().nextInt(this.executionChance) != 0 && worldTime != 0L) {
                    return false;
                }
            }
            if ((list = EntityCrow.this.field_70170_p.func_175647_a(ItemFrameEntity.class, this.getTargetableArea(this.getTargetDistance()), this.targetEntitySelector)).isEmpty()) {
                return false;
            }
            Collections.sort(list, this.theNearestAttackableTargetSorter);
            this.targetEntity = (ItemFrameEntity)list.get(0);
            this.mustUpdate = false;
            EntityCrow.this.aiItemFrameFlag = true;
            return true;
        }

        public boolean func_75253_b() {
            return this.targetEntity != null && EntityCrow.this.getCommand() == 3 && !EntityCrow.this.func_184614_ca().func_190926_b();
        }

        public void func_75251_c() {
            this.flightTarget = null;
            this.targetEntity = null;
            EntityCrow.this.aiItemFrameFlag = false;
        }

        public void func_75246_d() {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.flightTarget != null) {
                EntityCrow.this.setFlying(true);
                if (EntityCrow.this.field_70123_F) {
                    EntityCrow.this.func_70605_aq().func_75642_a(this.flightTarget.field_72450_a, EntityCrow.this.func_226278_cu_() + 1.0, this.flightTarget.field_72449_c, 1.0);
                } else {
                    EntityCrow.this.func_70605_aq().func_75642_a(this.flightTarget.field_72450_a, this.flightTarget.field_72448_b, this.flightTarget.field_72449_c, 1.0);
                }
            }
            if (this.targetEntity != null) {
                this.flightTarget = this.targetEntity.func_213303_ch();
                if (EntityCrow.this.func_70032_d((Entity)this.targetEntity) < 2.0f) {
                    try {
                        BlockPos hangingPosition = this.targetEntity.func_174857_n().func_177972_a(this.targetEntity.func_174811_aO().func_176734_d());
                        TileEntity entity = this.targetEntity.field_70170_p.func_175625_s(hangingPosition);
                        Direction deposit = this.targetEntity.func_174811_aO();
                        LazyOptional handler = entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, deposit);
                        if (handler.orElse(null) != null && this.cooldown == 0) {
                            ItemStack duplicate = EntityCrow.this.func_184586_b(Hand.MAIN_HAND).func_77946_l();
                            ItemStack insertSimulate = ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)handler.orElse(null)), (ItemStack)duplicate, (boolean)true);
                            if (!insertSimulate.equals(duplicate)) {
                                ItemStack shrunkenStack = ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)handler.orElse(null)), (ItemStack)duplicate, (boolean)false);
                                if (shrunkenStack.func_190926_b()) {
                                    EntityCrow.this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                                } else {
                                    EntityCrow.this.func_184611_a(Hand.MAIN_HAND, shrunkenStack);
                                }
                                EntityCrow.this.peck();
                            } else {
                                this.cooldown = 20;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.func_75251_c();
                }
            }
        }

        protected double getTargetDistance() {
            return 4.0;
        }

        protected AxisAlignedBB getTargetableArea(double targetDistance) {
            Vector3d renderCenter = new Vector3d(EntityCrow.this.func_226277_ct_(), EntityCrow.this.func_226278_cu_(), EntityCrow.this.func_226281_cx_());
            AxisAlignedBB aabb = new AxisAlignedBB(-16.0, -16.0, -16.0, 16.0, 16.0, 16.0);
            return aabb.func_191194_a(renderCenter);
        }

        public class Sorter
        implements Comparator<Entity> {
            private final Entity theEntity;

            public Sorter(Entity theEntityIn) {
                this.theEntity = theEntityIn;
            }

            @Override
            public int compare(Entity p_compare_1_, Entity p_compare_2_) {
                double d1;
                double d0 = this.theEntity.func_70068_e(p_compare_1_);
                return d0 < (d1 = this.theEntity.func_70068_e(p_compare_2_)) ? -1 : (d0 > d1 ? 1 : 0);
            }
        }
    }

    private class AITargetItems
    extends CreatureAITargetItems {
        public AITargetItems(CreatureEntity creature, boolean checkSight, boolean onlyNearby, int tickThreshold, int radius) {
            super(creature, checkSight, onlyNearby, tickThreshold, radius);
            this.executionChance = 1;
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            ((EntityCrow)this.field_75299_d).aiItemFlag = false;
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && !((EntityCrow)this.field_75299_d).func_233685_eM_() && (this.field_75299_d.func_70638_az() == null || !this.field_75299_d.func_70638_az().func_70089_S());
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && !((EntityCrow)this.field_75299_d).func_233685_eM_() && (this.field_75299_d.func_70638_az() == null || !this.field_75299_d.func_70638_az().func_70089_S());
        }

        @Override
        protected void moveTo() {
            EntityCrow crow = (EntityCrow)this.field_75299_d;
            if (this.targetEntity != null) {
                crow.aiItemFlag = true;
                if (this.field_75299_d.func_70032_d((Entity)this.targetEntity) < 2.0f) {
                    crow.func_70605_aq().func_75642_a(this.targetEntity.func_226277_ct_(), this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.0);
                    crow.peck();
                }
                if (this.field_75299_d.func_70032_d((Entity)this.targetEntity) > 8.0f || crow.isFlying()) {
                    crow.setFlying(true);
                    float f = (float)(crow.func_226277_ct_() - this.targetEntity.func_226277_ct_());
                    float f1 = 1.8f;
                    float f2 = (float)(crow.func_226281_cx_() - this.targetEntity.func_226281_cx_());
                    float xzDist = MathHelper.func_76129_c((float)(f * f + f2 * f2));
                    if (!crow.func_70685_l((Entity)this.targetEntity)) {
                        crow.func_70605_aq().func_75642_a(this.targetEntity.func_226277_ct_(), 1.0 + crow.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.0);
                    } else {
                        if (xzDist < 5.0f) {
                            f1 = 0.0f;
                        }
                        crow.func_70605_aq().func_75642_a(this.targetEntity.func_226277_ct_(), (double)f1 + this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.0);
                    }
                } else {
                    this.field_75299_d.func_70661_as().func_75492_a(this.targetEntity.func_226277_ct_(), this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.0);
                }
            }
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            this.moveTo();
        }
    }

    private class AIAvoidPumpkins
    extends Goal {
        private final int searchLength;
        private final int field_203113_j;
        protected BlockPos destinationBlock;
        protected int runDelay = 70;
        private Vector3d flightTarget;

        private AIAvoidPumpkins() {
            this.searchLength = 20;
            this.field_203113_j = 1;
        }

        public boolean func_75253_b() {
            return this.destinationBlock != null && this.isPumpkin(EntityCrow.this.field_70170_p, this.destinationBlock.func_239590_i_()) && this.isCloseToPumpkin(16.0);
        }

        public boolean isCloseToPumpkin(double dist) {
            return this.destinationBlock == null || EntityCrow.this.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.destinationBlock)) < dist * dist;
        }

        public boolean func_75250_a() {
            if (EntityCrow.this.func_70909_n()) {
                return false;
            }
            if (this.runDelay > 0) {
                --this.runDelay;
                return false;
            }
            this.runDelay = 70 + EntityCrow.this.field_70146_Z.nextInt(150);
            return this.searchForDestination();
        }

        public void func_75249_e() {
            EntityCrow.this.fleePumpkinFlag = 200;
            Vector3d vec = EntityCrow.this.getBlockInViewAway(Vector3d.func_237489_a_((Vector3i)this.destinationBlock), 10.0f);
            if (vec != null) {
                this.flightTarget = vec;
                EntityCrow.this.setFlying(true);
                EntityCrow.this.func_70605_aq().func_75642_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 1.0);
            }
        }

        public void func_75246_d() {
            if (this.isCloseToPumpkin(16.0)) {
                Vector3d vec;
                EntityCrow.this.fleePumpkinFlag = 200;
                if ((this.flightTarget == null || EntityCrow.this.func_195048_a(this.flightTarget) < 2.0) && (vec = EntityCrow.this.getBlockInViewAway(Vector3d.func_237489_a_((Vector3i)this.destinationBlock), 10.0f)) != null) {
                    this.flightTarget = vec;
                    EntityCrow.this.setFlying(true);
                }
                if (this.flightTarget != null) {
                    EntityCrow.this.func_70605_aq().func_75642_a(this.flightTarget.field_72450_a, this.flightTarget.field_72448_b, this.flightTarget.field_72449_c, 1.0);
                }
            }
        }

        public void func_75251_c() {
            this.flightTarget = null;
        }

        protected boolean searchForDestination() {
            int lvt_1_1_ = this.searchLength;
            int lvt_2_1_ = this.field_203113_j;
            BlockPos lvt_3_1_ = EntityCrow.this.func_233580_cy_();
            BlockPos.Mutable lvt_4_1_ = new BlockPos.Mutable();
            for (int lvt_5_1_ = -8; lvt_5_1_ <= 2; ++lvt_5_1_) {
                for (int lvt_6_1_ = 0; lvt_6_1_ < lvt_1_1_; ++lvt_6_1_) {
                    int lvt_7_1_ = 0;
                    while (lvt_7_1_ <= lvt_6_1_) {
                        int lvt_8_1_;
                        int n = lvt_8_1_ = lvt_7_1_ < lvt_6_1_ && lvt_7_1_ > -lvt_6_1_ ? lvt_6_1_ : 0;
                        while (lvt_8_1_ <= lvt_6_1_) {
                            lvt_4_1_.func_239621_a_((Vector3i)lvt_3_1_, lvt_7_1_, lvt_5_1_ - 1, lvt_8_1_);
                            if (this.isPumpkin(EntityCrow.this.field_70170_p, lvt_4_1_)) {
                                this.destinationBlock = lvt_4_1_;
                                return true;
                            }
                            lvt_8_1_ = lvt_8_1_ > 0 ? -lvt_8_1_ : 1 - lvt_8_1_;
                        }
                        lvt_7_1_ = lvt_7_1_ > 0 ? -lvt_7_1_ : 1 - lvt_7_1_;
                    }
                }
            }
            return false;
        }

        private boolean isPumpkin(World world, BlockPos.Mutable lvt_4_1_) {
            return BlockTags.func_199896_a().func_199910_a(AMTagRegistry.CROW_FEARS).func_230235_a_((Object)world.func_180495_p((BlockPos)lvt_4_1_).func_177230_c());
        }
    }

    private class AIScatter
    extends Goal {
        protected final Sorter theNearestAttackableTargetSorter;
        protected final Predicate<? super Entity> targetEntitySelector;
        protected int executionChance = 8;
        protected boolean mustUpdate;
        private Entity targetEntity;
        private Vector3d flightTarget = null;
        private int cooldown = 0;
        private ITag tag;

        AIScatter() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.tag = EntityTypeTags.func_219762_a().func_199910_a(AMTagRegistry.SCATTERS_CROWS);
            this.theNearestAttackableTargetSorter = new Sorter((Entity)EntityCrow.this);
            this.targetEntitySelector = new Predicate<Entity>(){

                public boolean apply(@Nullable Entity e) {
                    return e.func_70089_S() && e.func_200600_R().func_220341_a(AIScatter.this.tag) || e instanceof PlayerEntity && !((PlayerEntity)e).func_184812_l_();
                }
            };
        }

        public boolean func_75250_a() {
            List list;
            if (EntityCrow.this.func_184218_aH() || EntityCrow.this.aiItemFlag || EntityCrow.this.func_184207_aI() || EntityCrow.this.func_70909_n()) {
                return false;
            }
            if (!this.mustUpdate) {
                long worldTime = EntityCrow.this.field_70170_p.func_82737_E() % 10L;
                if (EntityCrow.this.func_70654_ax() >= 100 && worldTime != 0L) {
                    return false;
                }
                if (EntityCrow.this.func_70681_au().nextInt(this.executionChance) != 0 && worldTime != 0L) {
                    return false;
                }
            }
            if ((list = EntityCrow.this.field_70170_p.func_175647_a(Entity.class, this.getTargetableArea(this.getTargetDistance()), this.targetEntitySelector)).isEmpty()) {
                return false;
            }
            Collections.sort(list, this.theNearestAttackableTargetSorter);
            this.targetEntity = (Entity)list.get(0);
            this.mustUpdate = false;
            return true;
        }

        public boolean func_75253_b() {
            return this.targetEntity != null && !EntityCrow.this.func_70909_n();
        }

        public void func_75251_c() {
            this.flightTarget = null;
            this.targetEntity = null;
        }

        public void func_75246_d() {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.flightTarget != null) {
                EntityCrow.this.setFlying(true);
                EntityCrow.this.func_70605_aq().func_75642_a(this.flightTarget.field_72450_a, this.flightTarget.field_72448_b, this.flightTarget.field_72449_c, 1.0);
                if (this.cooldown == 0 && EntityCrow.this.isTargetBlocked(this.flightTarget)) {
                    this.cooldown = 30;
                    this.flightTarget = null;
                }
            }
            if (this.targetEntity != null) {
                Vector3d vec;
                if ((EntityCrow.this.field_70122_E || this.flightTarget == null || this.flightTarget != null && EntityCrow.this.func_195048_a(this.flightTarget) < 3.0) && (vec = EntityCrow.this.getBlockInViewAway(this.targetEntity.func_213303_ch(), 0.0f)) != null && vec.func_82617_b() > EntityCrow.this.func_226278_cu_()) {
                    this.flightTarget = vec;
                }
                if (EntityCrow.this.func_70032_d(this.targetEntity) > 20.0f) {
                    this.func_75251_c();
                }
            }
        }

        protected double getTargetDistance() {
            return 4.0;
        }

        protected AxisAlignedBB getTargetableArea(double targetDistance) {
            Vector3d renderCenter = new Vector3d(EntityCrow.this.func_226277_ct_(), EntityCrow.this.func_226278_cu_() + 0.5, EntityCrow.this.func_226281_cx_());
            AxisAlignedBB aabb = new AxisAlignedBB(-2.0, -2.0, -2.0, 2.0, 2.0, 2.0);
            return aabb.func_191194_a(renderCenter);
        }

        public class Sorter
        implements Comparator<Entity> {
            private final Entity theEntity;

            public Sorter(Entity theEntityIn) {
                this.theEntity = theEntityIn;
            }

            @Override
            public int compare(Entity p_compare_1_, Entity p_compare_2_) {
                double d1;
                double d0 = this.theEntity.func_70068_e(p_compare_1_);
                return d0 < (d1 = this.theEntity.func_70068_e(p_compare_2_)) ? -1 : (d0 > d1 ? 1 : 0);
            }
        }
    }

    private class AIWalkIdle
    extends Goal {
        protected final EntityCrow crow;
        protected double x;
        protected double y;
        protected double z;
        private boolean flightTarget = false;

        public AIWalkIdle() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.crow = EntityCrow.this;
        }

        public boolean func_75250_a() {
            Vector3d lvt_1_1_;
            if (this.crow.func_184207_aI() || EntityCrow.this.getCommand() == 1 || EntityCrow.this.aiItemFlag || this.crow.func_70638_az() != null && this.crow.func_70638_az().func_70089_S() || this.crow.func_184218_aH() || this.crow.func_233685_eM_()) {
                return false;
            }
            if (this.crow.func_70681_au().nextInt(30) != 0 && !this.crow.isFlying()) {
                return false;
            }
            if (this.crow.func_233570_aj_()) {
                this.flightTarget = EntityCrow.this.field_70146_Z.nextBoolean();
            } else {
                boolean bl = this.flightTarget = EntityCrow.this.field_70146_Z.nextInt(5) > 0 && this.crow.timeFlying < 200;
            }
            if (this.crow.getCommand() == 3) {
                if (this.crow.aiItemFrameFlag) {
                    return false;
                }
                this.flightTarget = true;
            }
            if ((lvt_1_1_ = this.getPosition()) == null) {
                return false;
            }
            this.x = lvt_1_1_.field_72450_a;
            this.y = lvt_1_1_.field_72448_b;
            this.z = lvt_1_1_.field_72449_c;
            return true;
        }

        public void func_75246_d() {
            if (this.flightTarget) {
                this.crow.func_70605_aq().func_75642_a(this.x, this.y, this.z, 1.0);
            } else {
                this.crow.func_70661_as().func_75492_a(this.x, this.y, this.z, 1.0);
            }
            if (!this.flightTarget && EntityCrow.this.isFlying() && this.crow.field_70122_E) {
                this.crow.setFlying(false);
            }
            if (EntityCrow.this.isFlying() && this.crow.field_70122_E && this.crow.timeFlying > 10) {
                this.crow.setFlying(false);
            }
        }

        @Nullable
        protected Vector3d getPosition() {
            Vector3d vector3d = this.crow.func_213303_ch();
            if (this.crow.getCommand() == 3 && this.crow.getPerchPos() != null) {
                return this.crow.getGatheringVec(vector3d, 4 + EntityCrow.this.field_70146_Z.nextInt(2));
            }
            if (this.crow.isOverWater()) {
                this.flightTarget = true;
            }
            if (this.flightTarget) {
                if (this.crow.timeFlying < 50 || this.crow.isOverWater()) {
                    return this.crow.getBlockInViewAway(vector3d, 0.0f);
                }
                return this.crow.getBlockGrounding(vector3d);
            }
            return RandomPositionGenerator.func_75463_a((CreatureEntity)this.crow, (int)10, (int)7);
        }

        public boolean func_75253_b() {
            if (this.crow.aiItemFlag || this.crow.func_233685_eM_() || EntityCrow.this.getCommand() == 1) {
                return false;
            }
            if (this.flightTarget) {
                return this.crow.isFlying() && this.crow.func_70092_e(this.x, this.y, this.z) > 2.0;
            }
            return !this.crow.func_70661_as().func_75500_f() && !this.crow.func_184207_aI();
        }

        public void func_75249_e() {
            if (this.flightTarget) {
                this.crow.setFlying(true);
                this.crow.func_70605_aq().func_75642_a(this.x, this.y, this.z, 1.0);
            } else {
                this.crow.func_70661_as().func_75492_a(this.x, this.y, this.z, 1.0);
            }
        }

        public void func_75251_c() {
            this.crow.func_70661_as().func_75499_g();
            super.func_75251_c();
        }
    }
}

