/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityEndergrade;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.FlightMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.message.MessageMosquitoDismount;
import com.github.alexthe666.alexsmobs.message.MessageMosquitoMountPlayer;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityEnderiophage
extends AnimalEntity
implements IMob,
IFlyingAnimal {
    private static final DataParameter<Float> PHAGE_PITCH = EntityDataManager.func_187226_a(EntityEnderiophage.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityEnderiophage.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MISSING_EYE = EntityDataManager.func_187226_a(EntityEnderiophage.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> PHAGE_SCALE = EntityDataManager.func_187226_a(EntityEnderiophage.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final Predicate<LivingEntity> ENDERGRADE_OR_INFECTED = entity -> entity instanceof EntityEndergrade || entity.func_70644_a(AMEffectRegistry.ENDER_FLU);
    public float prevPhagePitch;
    public float tentacleAngle;
    public float lastTentacleAngle;
    public float phageRotation;
    public float prevFlyProgress;
    public float flyProgress;
    public int passengerIndex = 0;
    public float prevEnderiophageScale = 1.0f;
    private float rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
    private int slowDownTicks = 0;
    private float randomMotionSpeed;
    private boolean isLandNavigator;
    private int timeFlying = 0;
    private int fleeAfterStealTime = 0;
    private int attachTime = 0;
    private int dismountCooldown = 0;
    private int squishCooldown = 0;
    private CreatureEntity angryEnderman = null;

    protected EntityEnderiophage(EntityType type, World world) {
        super(type, world);
        this.switchNavigator(false);
        this.field_70728_aV = 5;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233819_b_, 16.0).func_233815_a_(Attributes.field_233821_d_, (double)0.15f).func_233815_a_(Attributes.field_233823_f_, 2.0);
    }

    public static boolean canEnderiophageSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return true;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.enderiophageSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public int func_70641_bl() {
        return 2;
    }

    public float getPhageScale() {
        return ((Float)this.field_70180_af.func_187225_a(PHAGE_SCALE)).floatValue();
    }

    public void setPhageScale(float scale) {
        this.field_70180_af.func_187227_b(PHAGE_SCALE, (Object)Float.valueOf(scale));
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FlyTowardsTarget(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AIWalkIdle());
        this.field_70715_bh.func_75776_a(1, (Goal)new EntityAINearestTarget3D((MobEntity)this, EndermanEntity.class, 15, true, true, null){

            public boolean func_75250_a() {
                return EntityEnderiophage.this.isMissingEye() && super.func_75250_a();
            }

            public boolean func_75253_b() {
                return EntityEnderiophage.this.isMissingEye() && super.func_75253_b();
            }
        });
        this.field_70715_bh.func_75776_a(1, (Goal)new EntityAINearestTarget3D((MobEntity)this, LivingEntity.class, 15, true, true, ENDERGRADE_OR_INFECTED){

            public boolean func_75250_a() {
                return !EntityEnderiophage.this.isMissingEye() && EntityEnderiophage.this.fleeAfterStealTime == 0 && super.func_75250_a();
            }

            public boolean func_75253_b() {
                return !EntityEnderiophage.this.isMissingEye() && super.func_75253_b();
            }
        });
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{EndermanEntity.class}));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new GroundPathNavigatorWide((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new FlightMoveController((MobEntity)this, 1.0f, false, true);
            this.field_70699_by = new DirectPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PHAGE_PITCH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(PHAGE_SCALE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(MISSING_EYE, (Object)false);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setStandardFleeTime() {
        this.fleeAfterStealTime = 20;
    }

    public void func_70098_U() {
        Entity entity = this.func_184187_bx();
        if (this.func_184218_aH() && !entity.func_70089_S()) {
            this.func_184210_p();
        } else {
            this.func_213293_j(0.0, 0.0, 0.0);
            this.func_70071_h_();
            if (this.func_184218_aH()) {
                ++this.attachTime;
                Entity mount = this.func_184187_bx();
                if (mount instanceof LivingEntity) {
                    this.passengerIndex = mount.func_184188_bt().indexOf((Object)this);
                    this.field_70761_aq = ((LivingEntity)mount).field_70761_aq;
                    this.field_70177_z = ((LivingEntity)mount).field_70177_z;
                    this.field_70759_as = ((LivingEntity)mount).field_70759_as;
                    this.field_70126_B = ((LivingEntity)mount).field_70759_as;
                    float radius = mount.func_213311_cf();
                    float angle = (float)Math.PI / 180 * (((LivingEntity)mount).field_70761_aq + (float)this.passengerIndex * 90.0f);
                    double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                    double extraZ = radius * MathHelper.func_76134_b((float)angle);
                    this.func_70107_b(mount.func_226277_ct_() + extraX, Math.max(mount.func_226278_cu_() + (double)(mount.func_70047_e() * 0.25f), mount.func_226278_cu_()), mount.func_226281_cx_() + extraZ);
                    if (!mount.func_70089_S() || mount instanceof PlayerEntity && ((PlayerEntity)mount).func_184812_l_()) {
                        this.func_233575_bb_();
                    }
                    this.setPhagePitch(0.0f);
                    if (!this.field_70170_p.field_72995_K && this.attachTime > 15) {
                        LivingEntity target = (LivingEntity)mount;
                        float dmg = 1.0f;
                        if (target.func_110143_aJ() > target.func_110138_aP() * 0.2f) {
                            dmg = 6.0f;
                        }
                        if (((double)target.func_110143_aJ() < 1.5 || mount.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), dmg)) && mount instanceof LivingEntity) {
                            this.dismountCooldown = 100;
                            if (mount instanceof EndermanEntity) {
                                this.setMissingEye(false);
                                this.func_184185_a(SoundEvents.field_193777_bb, this.func_70599_aP(), this.func_70647_i());
                                this.func_70691_i(5.0f);
                                ((EndermanEntity)mount).func_195064_c(new EffectInstance(Effects.field_76440_q, 400));
                                this.fleeAfterStealTime = 400;
                                this.setFlying(true);
                                this.angryEnderman = (CreatureEntity)mount;
                            } else if (this.field_70146_Z.nextInt(3) == 0) {
                                if (!this.isMissingEye()) {
                                    if (target.func_70660_b(AMEffectRegistry.ENDER_FLU) == null) {
                                        target.func_195064_c(new EffectInstance(AMEffectRegistry.ENDER_FLU, 12000));
                                    } else {
                                        EffectInstance inst = target.func_70660_b(AMEffectRegistry.ENDER_FLU);
                                        int duration = 12000;
                                        int level = 0;
                                        if (inst != null) {
                                            duration = inst.func_76459_b();
                                            level = inst.func_76458_c();
                                        }
                                        target.func_195063_d(AMEffectRegistry.ENDER_FLU);
                                        target.func_195064_c(new EffectInstance(AMEffectRegistry.ENDER_FLU, duration, Math.min(level + 1, 4)));
                                    }
                                    this.func_70691_i(5.0f);
                                    this.func_184185_a(SoundEvents.field_187635_cQ, this.func_70599_aP(), this.func_70647_i());
                                    this.setMissingEye(true);
                                }
                                if (!this.field_70170_p.field_72995_K) {
                                    this.func_70624_b(null);
                                    this.func_130011_c(null);
                                    this.func_70604_c(null);
                                    this.field_70714_bg.func_220888_c().forEach(Goal::func_75251_c);
                                    this.field_70715_bh.func_220888_c().forEach(Goal::func_75251_c);
                                }
                            }
                        }
                        if (((LivingEntity)mount).func_110143_aJ() <= 0.0f || this.fleeAfterStealTime > 0 || this.isMissingEye() && !(mount instanceof EndermanEntity) || !this.isMissingEye() && mount instanceof EndermanEntity) {
                            this.func_233575_bb_();
                            this.func_70624_b(null);
                            this.dismountCooldown = 100;
                            AlexsMobs.sendMSGToAll(new MessageMosquitoDismount(this.func_145782_y(), mount.func_145782_y()));
                            this.setFlying(true);
                        }
                    }
                }
            }
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    public void onSpawnFromEffect() {
        this.prevEnderiophageScale = 0.2f;
        this.setPhageScale(0.2f);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.ENDERIOPHAGE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.ENDERIOPHAGE_HURT;
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
        this.func_184185_a(AMSoundRegistry.ENDERIOPHAGE_WALK, 0.4f, 1.0f);
    }

    protected float func_203009_ad() {
        return this.field_82151_R + 0.3f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevEnderiophageScale = this.getPhageScale();
        float extraMotionSlow = 1.0f;
        float extraMotionSlowY = 1.0f;
        if (this.slowDownTicks > 0) {
            --this.slowDownTicks;
            extraMotionSlow = 0.33f;
            extraMotionSlowY = 0.1f;
        }
        if (this.dismountCooldown > 0) {
            --this.dismountCooldown;
        }
        if (this.squishCooldown > 0) {
            --this.squishCooldown;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (!this.func_184218_aH() && this.attachTime != 0) {
                this.attachTime = 0;
            }
            if (this.fleeAfterStealTime > 0) {
                if (this.angryEnderman != null) {
                    Vector3d vec = this.getBlockInViewAway(this.angryEnderman.func_213303_ch(), 10.0f);
                    if (this.fleeAfterStealTime < 5) {
                        if (this.angryEnderman instanceof IAngerable) {
                            ((IAngerable)this.angryEnderman).func_241356_K__();
                        }
                        try {
                            this.angryEnderman.field_70714_bg.func_220888_c().forEach(Goal::func_75251_c);
                            this.angryEnderman.field_70715_bh.func_220888_c().forEach(Goal::func_75251_c);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.angryEnderman = null;
                    }
                    if (vec != null) {
                        this.setFlying(true);
                        this.func_70605_aq().func_75642_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, (double)1.3f);
                    }
                }
                --this.fleeAfterStealTime;
            }
        }
        this.field_70761_aq = this.field_70177_z;
        this.field_70759_as = this.field_70177_z;
        this.setPhagePitch(-90.0f);
        if (this.func_70089_S() && this.isFlying() && this.randomMotionSpeed > 0.75f && this.func_213322_ci().func_189985_c() > 0.02 && this.field_70170_p.field_72995_K) {
            float pitch = -this.getPhagePitch() / 90.0f;
            float radius = this.func_213311_cf() * 0.2f * -pitch;
            float angle = (float)Math.PI / 180 * this.field_70177_z;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraY = 0.2f - (1.0f - pitch) * 0.15f;
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double motX = extraX * 8.0 + this.field_70146_Z.nextGaussian() * (double)0.05f;
            double motY = -0.1f;
            double motZ = extraZ + this.field_70146_Z.nextGaussian() * (double)0.05f;
            this.field_70170_p.func_195594_a((IParticleData)AMParticleRegistry.DNA, this.func_226277_ct_() + extraX, this.func_226278_cu_() + extraY, this.func_226281_cx_() + extraZ, motX, motY, motZ);
        }
        this.prevPhagePitch = this.getPhagePitch();
        this.prevFlyProgress = this.flyProgress;
        if (this.isFlying() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.isFlying() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        this.lastTentacleAngle = this.tentacleAngle;
        this.phageRotation += this.rotationVelocity;
        if ((double)this.phageRotation > Math.PI * 2) {
            if (this.field_70170_p.field_72995_K) {
                this.phageRotation = (float)Math.PI * 2;
            } else {
                this.phageRotation = (float)((double)this.phageRotation - Math.PI * 2);
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)19);
            }
        }
        if (this.phageRotation < (float)Math.PI) {
            float f = this.phageRotation / (float)Math.PI;
            this.tentacleAngle = MathHelper.func_76126_a((float)(f * f * (float)Math.PI)) * 4.275f;
            if ((double)f > 0.75) {
                if (this.squishCooldown == 0 && this.isFlying()) {
                    this.squishCooldown = 20;
                    this.func_184185_a(AMSoundRegistry.ENDERIOPHAGE_SQUISH, 3.0f, this.func_70647_i());
                }
                this.randomMotionSpeed = 1.0f;
            } else {
                this.randomMotionSpeed = 0.01f;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isFlying() && this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (!this.isFlying() && !this.isLandNavigator) {
                this.switchNavigator(true);
            }
            if (this.isFlying()) {
                this.func_213293_j(this.func_213322_ci().field_72450_a * (double)this.randomMotionSpeed * (double)extraMotionSlow, this.func_213322_ci().field_72448_b * (double)this.randomMotionSpeed * (double)extraMotionSlowY, this.func_213322_ci().field_72449_c * (double)this.randomMotionSpeed * (double)extraMotionSlow);
                ++this.timeFlying;
                if (this.func_233570_aj_() && this.timeFlying > 100) {
                    this.setFlying(false);
                }
            } else {
                this.timeFlying = 0;
            }
            if (this.isMissingEye() && this.func_70638_az() != null && !(this.func_70638_az() instanceof EndermanEntity)) {
                this.func_70624_b(null);
            }
        }
        if (!this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
        if (this.isFlying()) {
            float phageDist = -((float)((Math.abs(this.func_213322_ci().func_82615_a()) + Math.abs(this.func_213322_ci().func_82616_c())) * 6.0));
            this.incrementPhagePitch(phageDist * 1.0f);
            this.setPhagePitch(MathHelper.func_76131_a((float)this.getPhagePitch(), (float)-90.0f, (float)10.0f));
            float plateau = 2.0f;
            if (this.getPhagePitch() > plateau) {
                this.decrementPhagePitch(phageDist * Math.abs(this.getPhagePitch()) / 90.0f);
            }
            if (this.getPhagePitch() < -plateau) {
                this.incrementPhagePitch(phageDist * Math.abs(this.getPhagePitch()) / 90.0f);
            }
            if (this.getPhagePitch() > 2.0f) {
                this.decrementPhagePitch(1.0f);
            } else if (this.getPhagePitch() < -2.0f) {
                this.incrementPhagePitch(1.0f);
            }
            if (this.field_70123_F) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)0.2f, 0.0));
            }
        } else {
            if (this.getPhagePitch() > 0.0f) {
                float decrease = Math.min(2.0f, this.getPhagePitch());
                this.decrementPhagePitch(decrease);
            }
            if (this.getPhagePitch() < 0.0f) {
                float decrease = Math.min(2.0f, -this.getPhagePitch());
                this.incrementPhagePitch(decrease);
            }
        }
        if (this.getPhageScale() < 1.0f) {
            this.setPhageScale(this.getPhageScale() + 0.05f);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Flying", this.isFlying());
        compound.func_74757_a("MissingEye", this.isMissingEye());
        compound.func_74768_a("SlowDownTicks", this.slowDownTicks);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setFlying(compound.func_74767_n("Flying"));
        this.setMissingEye(compound.func_74767_n("MissingEye"));
        this.slowDownTicks = compound.func_74762_e("SlowDownTicks");
    }

    public boolean isMissingEye() {
        return (Boolean)this.field_70180_af.func_187225_a(MISSING_EYE);
    }

    public void setMissingEye(boolean missingEye) {
        this.field_70180_af.func_187227_b(MISSING_EYE, (Object)missingEye);
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(FLYING);
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
    }

    public float getPhagePitch() {
        return ((Float)this.field_70180_af.func_187225_a(PHAGE_PITCH)).floatValue();
    }

    public void setPhagePitch(float pitch) {
        this.field_70180_af.func_187227_b(PHAGE_PITCH, (Object)Float.valueOf(pitch));
    }

    public void incrementPhagePitch(float pitch) {
        this.field_70180_af.func_187227_b(PHAGE_PITCH, (Object)Float.valueOf(this.getPhagePitch() + pitch));
    }

    public void decrementPhagePitch(float pitch) {
        this.field_70180_af.func_187227_b(PHAGE_PITCH, (Object)Float.valueOf(this.getPhagePitch() - pitch));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.8f;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return null;
    }

    private boolean isOverWaterOrVoid() {
        BlockPos position = this.func_233580_cy_();
        while (position.func_177956_o() > 1 && this.field_70170_p.func_175623_d(position)) {
            position = position.func_177977_b();
        }
        return !this.field_70170_p.func_204610_c(position).func_206888_e() || position.func_177956_o() < 1;
    }

    public Vector3d getBlockInViewAway(Vector3d fleePos, float radiusAdd) {
        float radius = -9.45f - (float)this.func_70681_au().nextInt(24) - radiusAdd;
        float neg = this.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.func_82615_a() + extraX, 0.0, fleePos.func_82616_c() + extraZ);
        BlockPos ground = this.getPhageGround(radialPos);
        int distFromGround = (int)this.func_226278_cu_() - ground.func_177956_o();
        int flightHeight = 6 + this.func_70681_au().nextInt(10);
        BlockPos newPos = ground.func_177981_b(distFromGround > 8 || this.fleeAfterStealTime > 0 ? flightHeight : this.func_70681_au().nextInt(6) + 5);
        if (!this.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)newPos)) && this.func_195048_a(Vector3d.func_237489_a_((Vector3i)newPos)) > 1.0) {
            return Vector3d.func_237489_a_((Vector3i)newPos);
        }
        return null;
    }

    private BlockPos getPhageGround(BlockPos in) {
        BlockPos position = new BlockPos((double)in.func_177958_n(), this.func_226278_cu_(), (double)in.func_177952_p());
        while (position.func_177956_o() > 1 && this.field_70170_p.func_175623_d(position)) {
            position = position.func_177977_b();
        }
        if (position.func_177956_o() < 2) {
            return position.func_177981_b(60 + this.field_70146_Z.nextInt(5));
        }
        return position;
    }

    public Vector3d getBlockGrounding(Vector3d fleePos) {
        float radius = -9.45f - (float)this.func_70681_au().nextInt(24);
        float neg = this.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.func_82615_a() + extraX, this.func_226278_cu_(), fleePos.func_82616_c() + extraZ);
        BlockPos ground = this.getPhageGround(radialPos);
        if (ground.func_177956_o() == 0) {
            return Vector3d.func_237490_a_((Vector3i)ground, (double)(50 + this.field_70146_Z.nextInt(20)));
        }
        ground = this.func_233580_cy_();
        while (ground.func_177956_o() > 1 && this.field_70170_p.func_175623_d(ground)) {
            ground = ground.func_177977_b();
        }
        if (!this.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)ground.func_177984_a()))) {
            return Vector3d.func_237489_a_((Vector3i)ground);
        }
        return null;
    }

    public boolean isTargetBlocked(Vector3d target) {
        Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() != RayTraceResult.Type.MISS;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EndermanEntity) {
            amount = (amount + 1.0f) * 0.35f;
            this.angryEnderman = (EndermanEntity)entity;
        }
        return super.func_70097_a(source, amount);
    }

    public class FlyTowardsTarget
    extends Goal {
        private final EntityEnderiophage parentEntity;

        public FlyTowardsTarget(EntityEnderiophage phage) {
            this.parentEntity = phage;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !this.parentEntity.func_184218_aH() && this.parentEntity.func_70638_az() != null && !this.isBittenByPhage((Entity)this.parentEntity.func_70638_az()) && this.parentEntity.fleeAfterStealTime == 0;
        }

        public boolean func_75253_b() {
            return this.parentEntity.func_70638_az() != null && !this.isBittenByPhage((Entity)this.parentEntity.func_70638_az()) && !this.parentEntity.field_70123_F && !this.parentEntity.func_184218_aH() && this.parentEntity.isFlying() && this.parentEntity.func_70605_aq().func_75640_a() && this.parentEntity.fleeAfterStealTime == 0 && (this.parentEntity.func_70638_az() instanceof EndermanEntity || !this.parentEntity.isMissingEye());
        }

        public boolean isBittenByPhage(Entity entity) {
            int phageCount = 0;
            for (Entity e : entity.func_184188_bt()) {
                if (!(e instanceof EntityEnderiophage)) continue;
                ++phageCount;
            }
            return phageCount > 3;
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() != null) {
                boolean isWithinReach;
                float width = this.parentEntity.func_70638_az().func_213311_cf() + this.parentEntity.func_213311_cf() + 2.0f;
                boolean bl = isWithinReach = this.parentEntity.func_70068_e((Entity)this.parentEntity.func_70638_az()) < (double)(width * width);
                if (this.parentEntity.isFlying() || isWithinReach) {
                    this.parentEntity.func_70605_aq().func_75642_a(this.parentEntity.func_70638_az().func_226277_ct_(), this.parentEntity.func_70638_az().func_226278_cu_(), this.parentEntity.func_70638_az().func_226281_cx_(), isWithinReach ? 1.6 : 1.0);
                } else {
                    this.parentEntity.func_70661_as().func_75492_a(this.parentEntity.func_70638_az().func_226277_ct_(), this.parentEntity.func_70638_az().func_226278_cu_(), this.parentEntity.func_70638_az().func_226281_cx_(), 1.2);
                }
                if (this.parentEntity.func_70638_az().func_226278_cu_() > this.parentEntity.func_226278_cu_() + (double)1.2f) {
                    this.parentEntity.setFlying(true);
                }
                if (this.parentEntity.dismountCooldown == 0 && this.parentEntity.func_174813_aQ().func_72314_b(0.3, 0.3, 0.3).func_72326_a(this.parentEntity.func_70638_az().func_174813_aQ()) && !this.isBittenByPhage((Entity)this.parentEntity.func_70638_az())) {
                    this.parentEntity.func_184205_a((Entity)this.parentEntity.func_70638_az(), true);
                    if (!this.parentEntity.field_70170_p.field_72995_K) {
                        AlexsMobs.sendMSGToAll(new MessageMosquitoMountPlayer(this.parentEntity.func_145782_y(), this.parentEntity.func_70638_az().func_145782_y()));
                    }
                }
            }
        }
    }

    private class AIWalkIdle
    extends Goal {
        protected final EntityEnderiophage phage;
        protected double x;
        protected double y;
        protected double z;
        private boolean flightTarget = false;

        public AIWalkIdle() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.phage = EntityEnderiophage.this;
        }

        public boolean func_75250_a() {
            Vector3d lvt_1_1_;
            if (this.phage.func_184207_aI() || this.phage.func_70638_az() != null && this.phage.func_70638_az().func_70089_S() || this.phage.func_184218_aH()) {
                return false;
            }
            if (this.phage.func_70681_au().nextInt(30) != 0 && !this.phage.isFlying() && this.phage.fleeAfterStealTime == 0) {
                return false;
            }
            if (this.phage.func_233570_aj_()) {
                this.flightTarget = EntityEnderiophage.this.field_70146_Z.nextInt(12) == 0;
            } else {
                boolean bl = this.flightTarget = EntityEnderiophage.this.field_70146_Z.nextInt(5) > 0 && this.phage.timeFlying < 100;
            }
            if (this.phage.fleeAfterStealTime > 0) {
                this.flightTarget = true;
            }
            if ((lvt_1_1_ = this.getPosition()) == null) {
                return false;
            }
            this.x = lvt_1_1_.field_72450_a;
            this.y = lvt_1_1_.field_72448_b;
            this.z = lvt_1_1_.field_72449_c;
            return true;
        }

        public void func_75246_d() {
            if (this.flightTarget) {
                this.phage.func_70605_aq().func_75642_a(this.x, this.y, this.z, EntityEnderiophage.this.fleeAfterStealTime == 0 ? (double)1.3f : 1.0);
            } else {
                this.phage.func_70661_as().func_75492_a(this.x, this.y, this.z, EntityEnderiophage.this.fleeAfterStealTime == 0 ? (double)1.3f : 1.0);
            }
            if (!this.flightTarget && EntityEnderiophage.this.isFlying() && this.phage.field_70122_E) {
                this.phage.setFlying(false);
            }
            if (EntityEnderiophage.this.isFlying() && this.phage.field_70122_E && this.phage.timeFlying > 100 && this.phage.fleeAfterStealTime == 0) {
                this.phage.setFlying(false);
            }
        }

        @Nullable
        protected Vector3d getPosition() {
            Vector3d vector3d = this.phage.func_213303_ch();
            if (this.phage.isOverWaterOrVoid()) {
                this.flightTarget = true;
            }
            if (this.flightTarget) {
                if (this.phage.timeFlying < 50 || EntityEnderiophage.this.fleeAfterStealTime > 0 || this.phage.isOverWaterOrVoid()) {
                    return this.phage.getBlockInViewAway(vector3d, 0.0f);
                }
                return this.phage.getBlockGrounding(vector3d);
            }
            return RandomPositionGenerator.func_75463_a((CreatureEntity)this.phage, (int)10, (int)7);
        }

        public boolean func_75253_b() {
            if (this.flightTarget) {
                return this.phage.isFlying() && this.phage.func_70092_e(this.x, this.y, this.z) > 2.0;
            }
            return !this.phage.func_70661_as().func_75500_f() && !this.phage.func_184207_aI();
        }

        public void func_75249_e() {
            if (this.flightTarget) {
                this.phage.setFlying(true);
                this.phage.func_70605_aq().func_75642_a(this.x, this.y, this.z, EntityEnderiophage.this.fleeAfterStealTime == 0 ? (double)1.3f : 1.0);
            } else {
                this.phage.func_70661_as().func_75492_a(this.x, this.y, this.z, 1.0);
            }
        }

        public void func_75251_c() {
            this.phage.func_70661_as().func_75499_g();
            super.func_75251_c();
        }
    }
}

