/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIRideParent;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.GorillaAIFollowCaravan;
import com.github.alexthe666.alexsmobs.entity.ai.GorillaAIForageLeaves;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAITempt;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityGorilla
extends TameableEntity
implements IAnimatedEntity,
ITargetsDroppedItems {
    public static final Animation ANIMATION_BREAKBLOCK_R = Animation.create((int)20);
    public static final Animation ANIMATION_BREAKBLOCK_L = Animation.create((int)20);
    public static final Animation ANIMATION_POUNDCHEST = Animation.create((int)40);
    public static final Animation ANIMATION_ATTACK = Animation.create((int)20);
    protected static final EntitySize SILVERBACK_SIZE = EntitySize.func_220311_c((float)1.15f, (float)1.85f);
    private static final DataParameter<Boolean> SILVERBACK = EntityDataManager.func_187226_a(EntityGorilla.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> STANDING = EntityDataManager.func_187226_a(EntityGorilla.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityGorilla.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> EATING = EntityDataManager.func_187226_a(EntityGorilla.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int maxStandTime = 75;
    public float prevStandProgress;
    public float prevSitProgress;
    public float standProgress;
    public float sitProgress;
    public boolean forcedSit = false;
    private int animationTick;
    private Animation currentAnimation;
    private int standingTime = 0;
    private int eatingTime;
    @Nullable
    private EntityGorilla caravanHead;
    @Nullable
    private EntityGorilla caravanTail;
    private int sittingTime = 0;
    private int maxSitTime = 75;
    @Nullable
    private UUID bananaThrowerID = null;
    private boolean hasSilverbackAttributes = false;

    protected EntityGorilla(EntityType type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LEAVES, 0.0f);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233826_i_, 0.0).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233820_c_, 0.5).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    public static boolean isBanana(ItemStack stack) {
        return ItemTags.func_199903_a().func_199910_a(AMTagRegistry.BANANAS).func_230235_a_((Object)stack.func_77973_b());
    }

    public static boolean canGorillaSpawn(EntityType<EntityGorilla> gorilla, IWorld worldIn, SpawnReason reason, BlockPos p_223317_3_, Random random) {
        BlockState blockstate = worldIn.func_180495_p(p_223317_3_.func_177977_b());
        return (blockstate.func_235714_a_((ITag)BlockTags.field_206952_E) || blockstate.func_203425_a(Blocks.field_196658_i) || blockstate.func_235714_a_((ITag)BlockTags.field_200031_h) || blockstate.func_203425_a(Blocks.field_150350_a)) && worldIn.func_226659_b_(p_223317_3_, 0) > 8;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.gorillaSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return this.func_70909_n() && EntityGorilla.isBanana(stack);
    }

    public int func_70641_bl() {
        return 8;
    }

    public boolean func_204209_c(int sizeIn) {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        this.func_233687_w_(false);
        if (entity != null && this.func_70909_n() && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new GorillaAIFollowCaravan(this, 0.8));
        this.field_70714_bg.func_75776_a(4, (Goal)new TameableAITempt((AnimalEntity)this, 1.1, Ingredient.func_199805_a((ITag)ItemTags.func_199903_a().func_199910_a(AMTagRegistry.BANANAS)), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new AnimalAIRideParent((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(6, (Goal)new AIWalkIdle(this, 0.8));
        this.field_70714_bg.func_75776_a(5, (Goal)new GorillaAIForageLeaves(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, new CreatureAITargetItems((CreatureEntity)this, false));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.GORILLA_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.GORILLA_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.GORILLA_HURT;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_ATTACK);
        }
        return true;
    }

    public void func_213352_e(Vector3d vec3d) {
        if (this.func_233685_eM_()) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            vec3d = Vector3d.field_186680_a;
        }
        super.func_213352_e(vec3d);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (spawnDataIn instanceof AgeableEntity.AgeableData) {
            AgeableEntity.AgeableData lvt_6_1_ = (AgeableEntity.AgeableData)spawnDataIn;
            if (lvt_6_1_.func_226257_a_() == 0) {
                this.setSilverback(true);
            }
        } else {
            this.setSilverback(this.func_70681_au().nextBoolean());
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Nullable
    public EntityGorilla getNearestSilverback(IWorld world, double dist) {
        List list = world.func_217357_a(this.getClass(), this.func_174813_aQ().func_72314_b(dist, dist / 2.0, dist));
        if (list.isEmpty()) {
            return null;
        }
        EntityGorilla gorilla = null;
        double d0 = Double.MAX_VALUE;
        for (EntityGorilla gorrila2 : list) {
            double d1;
            if (!gorrila2.isSilverback() || (d1 = this.func_70068_e((Entity)gorrila2)) > d0) continue;
            d0 = d1;
            gorilla = gorrila2;
        }
        return gorilla;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.isSilverback() && !this.func_70631_g_() ? SILVERBACK_SIZE : super.func_213305_a(poseIn);
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            this.setSitting(false);
            passenger.field_70177_z = this.field_70177_z;
            if (passenger instanceof EntityGorilla) {
                EntityGorilla babyGorilla = (EntityGorilla)passenger;
                babyGorilla.setStanding(this.isStanding());
                babyGorilla.setSitting(this.func_233685_eM_());
            }
            float sitAdd = -0.03f * this.sitProgress;
            float standAdd = -0.03f * this.standProgress;
            float radius = standAdd + sitAdd;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            passenger.func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + this.func_70042_X() + passenger.func_70033_W(), this.func_226281_cx_() + extraZ);
        }
    }

    public boolean func_82171_bF() {
        return false;
    }

    public double func_70042_X() {
        return (double)this.func_213302_cg() * (double)0.55f * (double)this.getGorillaScale() * (double)(this.isSilverback() ? 0.75f : 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SILVERBACK, (Object)false);
        this.field_70180_af.func_187214_a(STANDING, (Object)false);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(EATING, (Object)false);
    }

    public boolean isSilverback() {
        return (Boolean)this.field_70180_af.func_187225_a(SILVERBACK);
    }

    public void setSilverback(boolean silver) {
        this.field_70180_af.func_187227_b(SILVERBACK, (Object)silver);
    }

    public boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(STANDING);
    }

    public void setStanding(boolean standing) {
        this.field_70180_af.func_187227_b(STANDING, (Object)standing);
    }

    public boolean func_233685_eM_() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void setSitting(boolean sit) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sit);
    }

    public boolean isEating() {
        return (Boolean)this.field_70180_af.func_187225_a(EATING);
    }

    public void setEating(boolean eating) {
        this.field_70180_af.func_187227_b(EATING, (Object)eating);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Silverback", this.isSilverback());
        compound.func_74757_a("Standing", this.isStanding());
        compound.func_74757_a("GorillaSitting", this.func_233685_eM_());
        compound.func_74757_a("ForcedToSit", this.forcedSit);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSilverback(compound.func_74767_n("Silverback"));
        this.setStanding(compound.func_74767_n("Standing"));
        this.setSitting(compound.func_74767_n("GorillaSitting"));
        this.forcedSit = compound.func_74767_n("ForcedToSit");
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (itemstack.func_77973_b() == Items.field_151057_cb) {
            return super.func_230254_b_(player, hand);
        }
        if (this.func_70909_n() && EntityGorilla.isBanana(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(5.0f);
            this.func_175505_a(player, itemstack);
            this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
            return ActionResultType.SUCCESS;
        }
        ActionResultType type = super.func_230254_b_(player, hand);
        if (type != ActionResultType.SUCCESS && this.func_70909_n() && this.func_152114_e((LivingEntity)player) && !this.func_70877_b(itemstack)) {
            if (this.func_233685_eM_()) {
                this.forcedSit = false;
                this.setSitting(false);
                return ActionResultType.SUCCESS;
            }
            this.forcedSit = true;
            this.setSitting(true);
            return ActionResultType.SUCCESS;
        }
        return type;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
        if (animation == ANIMATION_POUNDCHEST) {
            this.maxStandTime = 45;
            this.setStanding(true);
        }
        if (animation == ANIMATION_ATTACK) {
            this.maxStandTime = 10;
            this.setStanding(true);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_184586_b(Hand.MAIN_HAND).func_190926_b() && this.canTargetItem(this.func_184586_b(Hand.MAIN_HAND))) {
            this.setEating(true);
            this.setSitting(true);
            this.setStanding(false);
        }
        if (this.isEating() && !this.canTargetItem(this.func_184586_b(Hand.MAIN_HAND))) {
            this.setEating(false);
            this.eatingTime = 0;
            if (!this.forcedSit) {
                this.setSitting(true);
            }
        }
        if (this.isEating()) {
            ++this.eatingTime;
            if (!ItemTags.field_206963_E.func_230235_a_((Object)this.func_184614_ca().func_77973_b())) {
                for (int i = 0; i < 3; ++i) {
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, this.func_184586_b(Hand.MAIN_HAND)), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, this.func_226278_cu_() + (double)(this.func_213302_cg() * 0.5f) + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg() * 0.5f), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, d0, d1, d2);
                }
            }
            if (this.eatingTime % 5 == 0) {
                this.func_184185_a(SoundEvents.field_219674_hn, this.func_70599_aP(), this.func_70647_i());
            }
            if (this.eatingTime > 100) {
                ItemStack stack = this.func_184586_b(Hand.MAIN_HAND);
                if (!stack.func_190926_b()) {
                    this.func_70691_i(4.0f);
                    if (EntityGorilla.isBanana(stack) && this.bananaThrowerID != null) {
                        if (this.func_70681_au().nextFloat() < 0.3f) {
                            this.func_70903_f(true);
                            this.func_184754_b(this.bananaThrowerID);
                            PlayerEntity player = this.field_70170_p.func_217371_b(this.bananaThrowerID);
                            if (player instanceof ServerPlayerEntity) {
                                CriteriaTriggers.field_193136_w.func_193178_a((ServerPlayerEntity)player, (AnimalEntity)this);
                            }
                            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                        } else {
                            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                        }
                    }
                    if (stack.hasContainerItem()) {
                        this.func_199701_a_(stack.getContainerItem());
                    }
                    stack.func_190918_g(1);
                }
                this.eatingTime = 0;
            }
        }
        this.prevSitProgress = this.sitProgress;
        this.prevStandProgress = this.standProgress;
        if (this.func_233685_eM_() && this.sitProgress < 10.0f) {
            this.sitProgress += 1.0f;
        }
        if (!this.func_233685_eM_() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.isStanding() && this.standProgress < 10.0f) {
            this.standProgress += 1.0f;
        }
        if (!this.isStanding() && this.standProgress > 0.0f) {
            this.standProgress -= 1.0f;
        }
        if (this.func_184218_aH() && this.func_184187_bx() instanceof EntityGorilla && !this.func_70631_g_()) {
            this.func_233575_bb_();
        }
        if (this.isStanding() && ++this.standingTime > this.maxStandTime) {
            this.setStanding(false);
            this.standingTime = 0;
            this.maxStandTime = 75 + this.field_70146_Z.nextInt(50);
        }
        if (this.func_233685_eM_() && !this.forcedSit && ++this.sittingTime > this.maxSitTime) {
            this.setSitting(false);
            this.sittingTime = 0;
            this.maxSitTime = 75 + this.field_70146_Z.nextInt(50);
        }
        if (!this.forcedSit && this.func_233685_eM_() && (this.func_70638_az() != null || this.isStanding()) && !this.isEating()) {
            this.setSitting(false);
        }
        if (!(this.field_70170_p.field_72995_K || this.getAnimation() != NO_ANIMATION || this.isStanding() || this.func_233685_eM_() || this.field_70146_Z.nextInt(1500) != 0)) {
            this.maxSitTime = 300 + this.field_70146_Z.nextInt(250);
            this.setSitting(true);
        }
        if (this.forcedSit && !this.func_184207_aI() && this.func_70909_n()) {
            this.setSitting(true);
        }
        if (this.isSilverback() && this.field_70146_Z.nextInt(600) == 0 && this.getAnimation() == NO_ANIMATION && !this.func_233685_eM_() && this.sitProgress == 0.0f && !this.func_175446_cd() && this.func_184614_ca().func_190926_b()) {
            this.setAnimation(ANIMATION_POUNDCHEST);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.getAnimation() == ANIMATION_ATTACK && this.getAnimationTick() == 10) {
            float f1 = this.field_70177_z * ((float)Math.PI / 180);
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-MathHelper.func_76126_a((float)f1) * 0.02f), 0.0, (double)(MathHelper.func_76134_b((float)f1) * 0.02f)));
            this.func_70638_az().func_233627_a_(1.0f, this.func_70638_az().func_226277_ct_() - this.func_226277_ct_(), this.func_70638_az().func_226281_cx_() - this.func_226281_cx_());
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111125_b());
        }
        if (this.isSilverback() && !this.func_70631_g_() && !this.hasSilverbackAttributes) {
            this.hasSilverbackAttributes = true;
            this.func_213323_x_();
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(50.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(10.0);
            this.func_70691_i(50.0f);
        }
        if (!this.isSilverback() && !this.func_70631_g_() && this.hasSilverbackAttributes) {
            this.hasSilverbackAttributes = false;
            this.func_213323_x_();
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(30.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(8.0);
            this.func_70691_i(30.0f);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return ItemTags.func_199903_a().func_199910_a(AMTagRegistry.GORILLA_FOODSTUFFS).func_230235_a_((Object)stack.func_77973_b());
    }

    @Override
    public void onGetItem(ItemEntity targetEntity) {
        ItemStack duplicate = targetEntity.func_92059_d().func_77946_l();
        duplicate.func_190920_e(1);
        if (!this.func_184586_b(Hand.MAIN_HAND).func_190926_b() && !this.field_70170_p.field_72995_K) {
            this.func_70099_a(this.func_184586_b(Hand.MAIN_HAND), 0.0f);
        }
        this.func_184611_a(Hand.MAIN_HAND, duplicate);
        if (EntityGorilla.isBanana(targetEntity.func_92059_d()) && !this.func_70909_n()) {
            this.bananaThrowerID = targetEntity.func_200214_m();
        }
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BREAKBLOCK_R, ANIMATION_BREAKBLOCK_L, ANIMATION_POUNDCHEST, ANIMATION_ATTACK};
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (AgeableEntity)AMEntityRegistry.GORILLA.func_200721_a((World)p_241840_1_);
    }

    public void leaveCaravan() {
        if (this.caravanHead != null) {
            this.caravanHead.caravanTail = null;
        }
        this.caravanHead = null;
    }

    public void joinCaravan(EntityGorilla caravanHeadIn) {
        this.caravanHead = caravanHeadIn;
        this.caravanHead.caravanTail = this;
    }

    public boolean hasCaravanTrail() {
        return this.caravanTail != null;
    }

    public boolean inCaravan() {
        return this.caravanHead != null;
    }

    @Nullable
    public EntityGorilla getCaravanHead() {
        return this.caravanHead;
    }

    public float getGorillaScale() {
        return this.func_70631_g_() ? 0.5f : (this.isSilverback() ? 1.3f : 1.0f);
    }

    public boolean isDonkeyKong() {
        String s = TextFormatting.func_110646_a((String)this.func_200200_C_().getString());
        return s != null && (s.toLowerCase().contains("donkey") && s.toLowerCase().contains("kong") || s.toLowerCase().equals("dk"));
    }

    public boolean isFunkyKong() {
        String s = TextFormatting.func_110646_a((String)this.func_200200_C_().getString());
        return s != null && s.toLowerCase().contains("funky") && s.toLowerCase().contains("kong");
    }

    private class AIWalkIdle
    extends RandomWalkingGoal {
        public AIWalkIdle(EntityGorilla entityGorilla2, double v) {
            super((CreatureEntity)entityGorilla2, v);
        }

        public boolean func_75250_a() {
            this.field_179481_f = EntityGorilla.this.isSilverback() ? 10 : 120;
            return super.func_75250_a();
        }

        @Nullable
        protected Vector3d func_190864_f() {
            return RandomPositionGenerator.func_75463_a((CreatureEntity)this.field_75457_a, (int)(EntityGorilla.this.isSilverback() ? 25 : 10), (int)7);
        }
    }
}

