/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ai.HummingbirdAIPollinate;
import com.github.alexthe666.alexsmobs.entity.ai.HummingbirdAIWander;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityHummingbird
extends AnimalEntity {
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityHummingbird.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityHummingbird.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CROPS_POLLINATED = EntityDataManager.func_187226_a(EntityHummingbird.class, (IDataSerializer)DataSerializers.field_187192_b);
    public float flyProgress;
    public float prevFlyProgress;
    public float movingProgress;
    public float prevMovingProgress;
    public int hummingStill = 0;
    public int pollinateCooldown = 0;
    private int loopSoundTick = 0;

    protected EntityHummingbird(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelper((MobEntity)this, 90, false);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 16.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
        this.func_184644_a(PathNodeType.LEAVES, 0.0f);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.hummingbirdSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.HUMMINGBIRD_IDLE;
    }

    public int func_70627_aG() {
        return 60;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.HUMMINGBIRD_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.HUMMINGBIRD_HURT;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 4.0).func_233815_a_(Attributes.field_233822_e_, 7.0).func_233815_a_(Attributes.field_233823_f_, 0.0).func_233815_a_(Attributes.field_233821_d_, (double)0.45f);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b().func_206844_a((ITag)ItemTags.field_226159_I_);
    }

    public int func_70641_bl() {
        return 7;
    }

    public boolean func_204209_c(int sizeIn) {
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new TemptGoal((CreatureEntity)this, 1.0, Ingredient.func_199805_a((ITag)ItemTags.field_226159_I_), false));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowParentGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new HummingbirdAIPollinate(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new HummingbirdAIWander(this, 16, 6, 30, 1.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new SwimGoal((MobEntity)this));
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, worldIn){

            public boolean func_188555_b(BlockPos pos) {
                return !this.field_75513_b.func_180495_p(pos.func_177979_c(2)).func_196958_f();
            }
        };
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(false);
        flyingpathnavigator.func_192878_b(true);
        return flyingpathnavigator;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected boolean func_191957_ae() {
        return true;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? sizeIn.field_220316_b * 0.5f : sizeIn.field_220316_b * 0.5f;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_180495_p(pos).func_196958_f() ? 10.0f : 0.0f;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("CropsPollinated", this.getCropsPollinated());
        compound.func_74768_a("PollinateCooldown", this.pollinateCooldown);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setCropsPollinated(compound.func_74762_e("CropsPollinated"));
        this.pollinateCooldown = compound.func_74762_e("PollinateCooldown");
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(CROPS_POLLINATED, (Object)0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setVariant(this.func_70681_au().nextInt(3));
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(FLYING);
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public int getCropsPollinated() {
        return (Integer)this.field_70180_af.func_187225_a(CROPS_POLLINATED);
    }

    public void setCropsPollinated(int crops) {
        this.field_70180_af.func_187227_b(CROPS_POLLINATED, (Object)crops);
    }

    public void func_70071_h_() {
        boolean flag;
        super.func_70071_h_();
        Vector3d vector3d = this.func_213322_ci();
        boolean bl = flag = this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c >= 0.001;
        if (!this.field_70122_E && vector3d.field_72448_b < 0.0) {
            this.func_213317_d(vector3d.func_216372_d(1.0, 0.4, 1.0));
        }
        this.setFlying(true);
        this.func_189654_d(true);
        if (this.isFlying() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.isFlying() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (flag && this.movingProgress < 5.0f) {
            this.movingProgress += 1.0f;
        }
        if (!flag && this.movingProgress > 0.0f) {
            this.movingProgress -= 1.0f;
        }
        this.hummingStill = this.func_213322_ci().func_189985_c() < 1.0E-7 ? ++this.hummingStill : 0;
        if (this.pollinateCooldown > 0) {
            --this.pollinateCooldown;
        }
        if (this.loopSoundTick == 0) {
            this.func_184185_a(AMSoundRegistry.HUMMINGBIRD_LOOP, this.func_70599_aP() * 0.33f, this.func_70647_i());
        }
        ++this.loopSoundTick;
        if (this.loopSoundTick > 27) {
            this.loopSoundTick = 0;
        }
        this.prevFlyProgress = this.flyProgress;
        this.prevMovingProgress = this.movingProgress;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return (AgeableEntity)AMEntityRegistry.HUMMINGBIRD.func_200721_a((World)serverWorld);
    }

    public static <T extends MobEntity> boolean canHummingbirdSpawn(EntityType<EntityHummingbird> hummingbird, IWorld worldIn, SpawnReason reason, BlockPos p_223317_3_, Random random) {
        BlockState blockstate = worldIn.func_180495_p(p_223317_3_.func_177977_b());
        return (blockstate.func_235714_a_((ITag)BlockTags.field_206952_E) || blockstate.func_203425_a(Blocks.field_196658_i) || blockstate.func_235714_a_((ITag)BlockTags.field_200031_h) || blockstate.func_203425_a(Blocks.field_150350_a)) && worldIn.func_226659_b_(p_223317_3_, 0) > 8;
    }

    private static class MoveHelper
    extends MovementController {
        private final int field_226323_i_;
        private final boolean field_226324_j_;

        public MoveHelper(MobEntity p_i225710_1_, int p_i225710_2_, boolean p_i225710_3_) {
            super(p_i225710_1_);
            this.field_226323_i_ = p_i225710_2_;
            this.field_226324_j_ = p_i225710_3_;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                double d2;
                double d1;
                this.field_188491_h = MovementController.Action.WAIT;
                double d0 = this.field_75646_b - this.field_75648_a.func_226277_ct_();
                double d3 = d0 * d0 + (d1 = this.field_75647_c - this.field_75648_a.func_226278_cu_()) * d1 + (d2 = this.field_75644_d - this.field_75648_a.func_226281_cx_()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_70657_f(0.0f);
                    this.field_75648_a.func_191989_p(0.0f);
                    return;
                }
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.field_75648_a.func_233637_b_(Attributes.field_233822_e_));
                this.field_75648_a.func_213317_d(this.field_75648_a.func_213322_ci().func_72441_c(d0 / d3 * 0.5 * this.field_75645_e, d1 / d3 * 0.5 * this.field_75645_e, d2 / d3 * 0.5 * this.field_75645_e));
                double d4 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                float f2 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d4) * 57.2957763671875));
                this.field_75648_a.field_70125_A = this.func_75639_a(this.field_75648_a.field_70125_A, f2, this.field_226323_i_);
            } else {
                this.field_75648_a.func_189654_d(true);
                this.field_75648_a.func_70657_f(0.0f);
                this.field_75648_a.func_191989_p(0.0f);
            }
        }
    }
}

