/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.IFollower;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHurtByTargetNotBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIRideParent;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.entity.ai.KangarooAIMelee;
import com.github.alexthe666.alexsmobs.entity.ai.TameableAIFollowOwner;
import com.github.alexthe666.alexsmobs.message.MessageKangarooEat;
import com.github.alexthe666.alexsmobs.message.MessageKangarooInventorySync;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.JumpController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.DispenserContainer;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityKangaroo
extends TameableEntity
implements IInventoryChangedListener,
IAnimatedEntity,
IFollower {
    public static final Animation ANIMATION_EAT_GRASS = Animation.create((int)30);
    public static final Animation ANIMATION_KICK = Animation.create((int)15);
    public static final Animation ANIMATION_PUNCH_R = Animation.create((int)13);
    public static final Animation ANIMATION_PUNCH_L = Animation.create((int)13);
    private static final DataParameter<Boolean> STANDING = EntityDataManager.func_187226_a(EntityKangaroo.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityKangaroo.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(EntityKangaroo.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> VISUAL_FLAG = EntityDataManager.func_187226_a(EntityKangaroo.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> POUCH_TICK = EntityDataManager.func_187226_a(EntityKangaroo.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HELMET_INDEX = EntityDataManager.func_187226_a(EntityKangaroo.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SWORD_INDEX = EntityDataManager.func_187226_a(EntityKangaroo.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CHEST_INDEX = EntityDataManager.func_187226_a(EntityKangaroo.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> FORCED_SIT = EntityDataManager.func_187226_a(EntityKangaroo.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float prevPouchProgress;
    public float pouchProgress;
    public float sitProgress;
    public float prevSitProgress;
    public float standProgress;
    public float prevStandProgress;
    public float totalMovingProgress;
    public float prevTotalMovingProgress;
    public int maxStandTime = 75;
    public Inventory kangarooInventory;
    private int animationTick;
    private Animation currentAnimation;
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int currentMoveTypeDuration;
    private int standingTime = 0;
    private int sittingTime = 0;
    private int maxSitTime = 75;
    private int eatCooldown = 0;
    private int carrotFeedings = 0;
    private int clientArmorCooldown = 0;

    protected EntityKangaroo(EntityType type, World world) {
        super(type, world);
        this.initKangarooInventory();
        this.field_70767_i = new JumpHelperController(this);
        this.field_70765_h = new MoveHelperController(this);
    }

    public static <T extends MobEntity> boolean canKangarooSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        boolean spawnBlock = BlockTags.func_199896_a().func_199910_a(AMTagRegistry.KANGAROO_SPAWNS).func_230235_a_((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c());
        return spawnBlock && worldIn.func_226659_b_(pos, 0) > 8;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 22.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233823_f_, 4.0);
    }

    protected void func_110159_bB() {
        super.func_110159_bB();
        Entity lvt_1_1_ = this.func_110166_bE();
        if (lvt_1_1_ != null && lvt_1_1_.field_70170_p == this.field_70170_p) {
            this.func_213390_a(lvt_1_1_.func_233580_cy_(), 5);
            float lvt_2_1_ = this.func_70032_d(lvt_1_1_);
            if (this.func_233685_eM_()) {
                if (lvt_2_1_ > 10.0f) {
                    this.func_110160_i(true, true);
                }
                return;
            }
            this.func_142017_o(lvt_2_1_);
            if (lvt_2_1_ > 10.0f) {
                this.func_110160_i(true, true);
                this.field_70714_bg.func_220880_a(Goal.Flag.MOVE);
            } else if (lvt_2_1_ > 6.0f) {
                double lvt_3_1_ = (lvt_1_1_.func_226277_ct_() - this.func_226277_ct_()) / (double)lvt_2_1_;
                double lvt_5_1_ = (lvt_1_1_.func_226278_cu_() - this.func_226278_cu_()) / (double)lvt_2_1_;
                double lvt_7_1_ = (lvt_1_1_.func_226281_cx_() - this.func_226281_cx_()) / (double)lvt_2_1_;
                this.func_213317_d(this.func_213322_ci().func_72441_c(Math.copySign(lvt_3_1_ * lvt_3_1_ * 0.4, lvt_3_1_), Math.copySign(lvt_5_1_ * lvt_5_1_ * 0.4, lvt_5_1_), Math.copySign(lvt_7_1_ * lvt_7_1_ * 0.4, lvt_7_1_)));
            } else {
                this.field_70714_bg.func_220886_b(Goal.Flag.MOVE);
                float lvt_3_2_ = 2.0f;
                try {
                    Vector3d lvt_4_1_ = new Vector3d(lvt_1_1_.func_226277_ct_() - this.func_226277_ct_(), lvt_1_1_.func_226278_cu_() - this.func_226278_cu_(), lvt_1_1_.func_226281_cx_() - this.func_226281_cx_()).func_72432_b().func_186678_a((double)Math.max(lvt_2_1_ - 2.0f, 0.0f));
                    this.func_70661_as().func_75492_a(this.func_226277_ct_() + lvt_4_1_.field_72450_a, this.func_226278_cu_() + lvt_4_1_.field_72448_b, this.func_226281_cx_() + lvt_4_1_.field_72449_c, this.func_190634_dg());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean forcedSit() {
        return (Boolean)this.field_70180_af.func_187225_a(FORCED_SIT);
    }

    public boolean isRoger() {
        String s = TextFormatting.func_110646_a((String)this.func_200200_C_().getString());
        return s != null && s.toLowerCase().equals("roger");
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.emuSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.KANGAROO_IDLE;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.KANGAROO_IDLE;
    }

    private void initKangarooInventory() {
        Inventory animalchest = this.kangarooInventory;
        this.kangarooInventory = new Inventory(9){

            public void func_174886_c(PlayerEntity player) {
                EntityKangaroo.this.field_70180_af.func_187227_b(POUCH_TICK, (Object)10);
                EntityKangaroo.this.resetKangarooSlots();
            }
        };
        this.kangarooInventory.func_110134_a((IInventoryChangedListener)this);
        if (animalchest != null) {
            int i = Math.min(animalchest.func_70302_i_(), this.kangarooInventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = animalchest.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.kangarooInventory.func_70299_a(j, itemstack.func_77946_l());
            }
            this.resetKangarooSlots();
        }
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        for (int i = 0; i < this.kangarooInventory.func_70302_i_(); ++i) {
            this.func_199701_a_(this.kangarooInventory.func_70301_a(i));
        }
        this.kangarooInventory.func_174888_l();
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        ActionResultType type = super.func_230254_b_(player, hand);
        if (!this.func_70909_n() && item == Items.field_151172_bF) {
            this.func_175505_a(player, itemstack);
            this.func_184185_a(SoundEvents.field_187711_cp, this.func_70599_aP(), this.func_70647_i());
            ++this.carrotFeedings;
            if (this.carrotFeedings > 10 && this.func_70681_au().nextInt(2) == 0 || this.carrotFeedings > 15) {
                this.func_193101_c(player);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.func_70909_n() && this.func_110143_aJ() < this.func_110138_aP() && item.func_219971_r() && item.func_219967_s() != null && !item.func_219967_s().func_221467_c()) {
            this.func_175505_a(player, itemstack);
            this.func_184185_a(SoundEvents.field_187711_cp, this.func_70599_aP(), this.func_70647_i());
            this.func_70691_i(item.func_219967_s().func_221466_a());
            return ActionResultType.SUCCESS;
        }
        if (type != ActionResultType.SUCCESS && this.func_70909_n() && this.func_152114_e((LivingEntity)player) && !this.func_70877_b(itemstack)) {
            boolean sit;
            if (player.func_225608_bj_()) {
                this.openGUI(player);
                this.func_184226_ay();
                this.field_70180_af.func_187227_b(POUCH_TICK, (Object)-1);
                return ActionResultType.SUCCESS;
            }
            this.setCommand(this.getCommand() + 1);
            if (this.getCommand() == 3) {
                this.setCommand(0);
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("entity.alexsmobs.all.command_" + this.getCommand(), new Object[]{this.func_200200_C_()}), true);
            boolean bl = sit = this.getCommand() == 2;
            if (sit) {
                this.field_70180_af.func_187227_b(FORCED_SIT, (Object)true);
                this.setSitting(true);
                return ActionResultType.SUCCESS;
            }
            this.field_70180_af.func_187227_b(FORCED_SIT, (Object)false);
            this.maxSitTime = 0;
            this.setSitting(false);
            return ActionResultType.SUCCESS;
        }
        return type;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("KangarooSitting", this.func_233685_eM_());
        compound.func_74757_a("KangarooSittingForced", this.forcedSit());
        compound.func_74757_a("Standing", this.isStanding());
        compound.func_74768_a("Command", this.getCommand());
        compound.func_74768_a("HelmetInvIndex", ((Integer)this.field_70180_af.func_187225_a(HELMET_INDEX)).intValue());
        compound.func_74768_a("SwordInvIndex", ((Integer)this.field_70180_af.func_187225_a(SWORD_INDEX)).intValue());
        compound.func_74768_a("ChestInvIndex", ((Integer)this.field_70180_af.func_187225_a(CHEST_INDEX)).intValue());
        if (this.kangarooInventory != null) {
            ListNBT nbttaglist = new ListNBT();
            for (int i = 0; i < this.kangarooInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.kangarooInventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                CompoundNBT CompoundNBT2 = new CompoundNBT();
                CompoundNBT2.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(CompoundNBT2);
                nbttaglist.add((Object)CompoundNBT2);
            }
            compound.func_218657_a("Items", (INBT)nbttaglist);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSitting(compound.func_74767_n("KangarooSitting"));
        this.field_70180_af.func_187227_b(FORCED_SIT, (Object)compound.func_74767_n("KangarooSittingForced"));
        this.setStanding(compound.func_74767_n("Standing"));
        this.setCommand(compound.func_74762_e("Command"));
        this.field_70180_af.func_187227_b(HELMET_INDEX, (Object)compound.func_74762_e("HelmetInvIndex"));
        this.field_70180_af.func_187227_b(SWORD_INDEX, (Object)compound.func_74762_e("SwordInvIndex"));
        this.field_70180_af.func_187227_b(CHEST_INDEX, (Object)compound.func_74762_e("ChestInvIndex"));
        if (this.kangarooInventory != null) {
            ListNBT nbttaglist = compound.func_150295_c("Items", 10);
            this.initKangarooInventory();
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundNBT CompoundNBT2 = nbttaglist.func_150305_b(i);
                int j = CompoundNBT2.func_74771_c("Slot") & 0xFF;
                this.kangarooInventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)CompoundNBT2));
            }
        } else {
            ListNBT nbttaglist = compound.func_150295_c("Items", 10);
            this.initKangarooInventory();
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundNBT CompoundNBT3 = nbttaglist.func_150305_b(i);
                int j = CompoundNBT3.func_74771_c("Slot") & 0xFF;
                this.initKangarooInventory();
                this.kangarooInventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)CompoundNBT3));
            }
        }
        this.resetKangarooSlots();
    }

    public void openGUI(PlayerEntity playerEntity) {
        if (!this.field_70170_p.field_72995_K && !this.func_184196_w((Entity)playerEntity)) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerEntity), (INamedContainerProvider)new INamedContainerProvider(){

                public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
                    return new DispenserContainer(p_createMenu_1_, p_createMenu_2_, (IInventory)EntityKangaroo.this.kangarooInventory);
                }

                public ITextComponent func_145748_c_() {
                    return new TranslationTextComponent("entity.alexsmobs.kangaroo.pouch");
                }
            });
        }
    }

    public boolean func_233685_eM_() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void setSitting(boolean sit) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sit);
    }

    public boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(STANDING);
    }

    public void setStanding(boolean standing) {
        this.field_70180_af.func_187227_b(STANDING, (Object)standing);
    }

    public int getCommand() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    public void setCommand(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)command);
    }

    public int getVisualFlag() {
        return (Integer)this.field_70180_af.func_187225_a(VISUAL_FLAG);
    }

    public void setVisualFlag(int visualFlag) {
        this.field_70180_af.func_187227_b(VISUAL_FLAG, (Object)visualFlag);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STANDING, (Object)false);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(FORCED_SIT, (Object)false);
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
        this.field_70180_af.func_187214_a(VISUAL_FLAG, (Object)0);
        this.field_70180_af.func_187214_a(POUCH_TICK, (Object)0);
        this.field_70180_af.func_187214_a(CHEST_INDEX, (Object)-1);
        this.field_70180_af.func_187214_a(HELMET_INDEX, (Object)-1);
        this.field_70180_af.func_187214_a(SWORD_INDEX, (Object)-1);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new GroundPathNavigatorWide((MobEntity)this, worldIn, 2.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new KangarooAIMelee(this, 1.2, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new TameableAIFollowOwner(this, 1.2, 5.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new AnimalAIRideParent((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151172_bF}), false));
        this.field_70714_bg.func_75776_a(5, (Goal)new AnimalAIWanderRanged((CreatureEntity)this, 110, 1.2, 10, 7));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new AnimalAIHurtByTargetNotBaby((AnimalEntity)this, new Class[0]));
    }

    protected boolean func_184219_q(Entity passenger) {
        return super.func_184219_q(passenger) && (Integer)this.field_70180_af.func_187225_a(POUCH_TICK) == 0;
    }

    public double func_70042_X() {
        return (double)this.func_213302_cg() * (double)0.35f;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.updateClientInventory();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        boolean moving = this.func_213322_ci().func_189985_c() > 0.03;
        int pouchTick = (Integer)this.field_70180_af.func_187225_a(POUCH_TICK);
        this.prevTotalMovingProgress = this.totalMovingProgress;
        this.prevPouchProgress = this.pouchProgress;
        this.prevSitProgress = this.sitProgress;
        this.prevStandProgress = this.standProgress;
        if (this.func_233685_eM_() && this.sitProgress < 5.0f) {
            this.sitProgress += 1.0f;
        }
        if (this.eatCooldown > 0) {
            --this.eatCooldown;
        }
        if (!this.func_233685_eM_() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.isStanding() && this.standProgress < 5.0f) {
            this.standProgress += 1.0f;
        }
        if (!this.isStanding() && this.standProgress > 0.0f) {
            this.standProgress -= 1.0f;
        }
        if (moving && this.totalMovingProgress < 5.0f) {
            this.totalMovingProgress += 1.0f;
        }
        if (!moving && this.totalMovingProgress > 0.0f) {
            this.totalMovingProgress -= 1.0f;
        }
        if (pouchTick != 0 && this.pouchProgress < 5.0f) {
            this.pouchProgress += 1.0f;
        }
        if (pouchTick == 0 && this.pouchProgress > 0.0f) {
            this.pouchProgress -= 1.0f;
        }
        if (pouchTick > 0) {
            this.field_70180_af.func_187227_b(POUCH_TICK, (Object)(pouchTick - 1));
        }
        if (this.isStanding() && ++this.standingTime > this.maxStandTime) {
            this.setStanding(false);
            this.standingTime = 0;
            this.maxStandTime = 75 + this.field_70146_Z.nextInt(50);
        }
        if (this.func_233685_eM_() && !this.forcedSit() && ++this.sittingTime > this.maxSitTime) {
            this.setSitting(false);
            this.sittingTime = 0;
            this.maxSitTime = 75 + this.field_70146_Z.nextInt(50);
        }
        if (!(this.field_70170_p.field_72995_K || this.getAnimation() != NO_ANIMATION || this.getCommand() == 1 || this.isStanding() || this.func_233685_eM_() || this.field_70146_Z.nextInt(1500) != 0)) {
            this.maxSitTime = 500 + this.field_70146_Z.nextInt(350);
            this.setSitting(true);
        }
        if (!this.forcedSit() && this.func_233685_eM_() && (this.func_70638_az() != null || this.isStanding())) {
            this.setSitting(false);
        }
        if (this.getAnimation() == NO_ANIMATION && !this.isStanding() && !this.func_233685_eM_() && this.field_70146_Z.nextInt(1500) == 0) {
            this.maxStandTime = 75 + this.field_70146_Z.nextInt(50);
            this.setStanding(true);
        }
        if (this.forcedSit() && !this.func_184207_aI() && this.func_70909_n()) {
            this.setSitting(true);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa == 1) {
                this.updateClientInventory();
            }
            if (!moving && this.getAnimation() == NO_ANIMATION && !this.func_233685_eM_() && !this.isStanding() && (this.func_70681_au().nextInt(180) == 0 || this.func_110143_aJ() < this.func_110138_aP() && this.func_70681_au().nextInt(40) == 0) && this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()).func_203425_a(Blocks.field_196658_i)) {
                this.setAnimation(ANIMATION_EAT_GRASS);
            }
            if (this.getAnimation() == ANIMATION_EAT_GRASS && this.getAnimationTick() == 20 && this.func_110143_aJ() < this.func_110138_aP() && this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()).func_203425_a(Blocks.field_196658_i)) {
                this.func_70691_i(6.0f);
                this.field_70170_p.func_217379_c(2001, this.func_233580_cy_().func_177977_b(), Block.func_196246_j((BlockState)Blocks.field_196658_i.func_176223_P()));
                this.field_70170_p.func_180501_a(this.func_233580_cy_().func_177977_b(), Blocks.field_150346_d.func_176223_P(), 2);
            }
            if (this.func_110143_aJ() < this.func_110138_aP() && this.func_70909_n() && this.eatCooldown == 0) {
                this.eatCooldown = 20 + this.field_70146_Z.nextInt(40);
                if (!this.kangarooInventory.func_191420_l()) {
                    ItemStack foodStack = ItemStack.field_190927_a;
                    for (int i = 0; i < this.kangarooInventory.func_70302_i_(); ++i) {
                        ItemStack stack = this.kangarooInventory.func_70301_a(i);
                        if (!stack.func_77973_b().func_219971_r() || stack.func_77973_b().func_219967_s() == null || stack.func_77973_b().func_219967_s().func_221467_c()) continue;
                        foodStack = stack;
                    }
                    if (!foodStack.func_190926_b() && foodStack.func_77973_b().func_219967_s() != null) {
                        AlexsMobs.sendMSGToAll(new MessageKangarooEat(this.func_145782_y(), foodStack));
                        this.func_70691_i(foodStack.func_77973_b().func_219967_s().func_221466_a() * 2);
                        foodStack.func_190918_g(1);
                        this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
                    }
                }
            }
        }
        if (this.jumpTicks < this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.func_70637_d(false);
        }
        LivingEntity attackTarget = this.func_70638_az();
        if (attackTarget != null && this.func_70685_l((Entity)attackTarget)) {
            if (this.func_70032_d((Entity)attackTarget) < attackTarget.func_213311_cf() + this.func_213311_cf() + 1.0f) {
                if (this.getAnimation() == ANIMATION_KICK && this.getAnimationTick() == 8) {
                    attackTarget.func_233627_a_(1.3f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                    this.func_70652_k((Entity)this.func_70638_az());
                }
                if (this.getAnimation() == ANIMATION_PUNCH_L && this.getAnimationTick() == 6) {
                    float rot = this.field_70177_z + 90.0f;
                    attackTarget.func_233627_a_(0.85f, (double)MathHelper.func_76126_a((float)(rot * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(rot * ((float)Math.PI / 180)))));
                    this.func_70652_k((Entity)this.func_70638_az());
                }
                if (this.getAnimation() == ANIMATION_PUNCH_R && this.getAnimationTick() == 6) {
                    float rot = this.field_70177_z - 90.0f;
                    attackTarget.func_233627_a_(0.85f, (double)MathHelper.func_76126_a((float)(rot * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(rot * ((float)Math.PI / 180)))));
                    this.func_70652_k((Entity)this.func_70638_az());
                }
            }
            this.func_70625_a((Entity)attackTarget, 360.0f, 360.0f);
        }
        if (this.func_70631_g_() && attackTarget != null) {
            this.func_70624_b(null);
        }
        if (this.func_184207_aI()) {
            this.field_70180_af.func_187227_b(POUCH_TICK, (Object)10);
            this.setStanding(true);
            this.maxStandTime = 25;
        }
        if (this.func_70631_g_() && this.func_184218_aH() && this.func_184187_bx() instanceof EntityKangaroo) {
            EntityKangaroo mount = (EntityKangaroo)this.func_184187_bx();
            this.field_70177_z = mount.field_70761_aq;
            this.field_70759_as = mount.field_70761_aq;
            this.field_70761_aq = mount.field_70761_aq;
        }
        if (this.func_184218_aH() && this.func_184187_bx() instanceof EntityKangaroo && !this.func_70631_g_()) {
            this.func_233575_bb_();
        }
        if (this.clientArmorCooldown > 0) {
            --this.clientArmorCooldown;
        }
        if (this.field_70173_aa > 5 && !this.field_70170_p.field_72995_K && this.clientArmorCooldown == 0 && this.func_70909_n()) {
            this.updateClientInventory();
            this.clientArmorCooldown = (600 + this.field_70146_Z.nextInt(600)) * 20;
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean prev = super.func_70652_k(entityIn);
        if (prev && !this.func_184614_ca().func_190926_b()) {
            this.damageItem(this.func_184614_ca());
        }
        return prev;
    }

    public boolean func_70097_a(DamageSource src, float amount) {
        boolean prev = super.func_70097_a(src, amount);
        if (prev) {
            if (!this.func_184582_a(EquipmentSlotType.HEAD).func_190926_b()) {
                this.damageItem(this.func_184582_a(EquipmentSlotType.HEAD));
            }
            if (!this.func_184582_a(EquipmentSlotType.CHEST).func_190926_b()) {
                this.damageItem(this.func_184582_a(EquipmentSlotType.CHEST));
            }
        }
        return prev;
    }

    private void damageItem(ItemStack stack) {
        if (stack != null) {
            stack.func_96631_a(1, this.func_70681_au(), null);
            if (stack.func_77952_i() < 0) {
                stack.func_190918_g(1);
            }
        }
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || source == DamageSource.field_76368_d;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.func_70909_n()) {
            LivingEntity livingentity = this.func_70902_q();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TameableEntity) {
                return ((TameableEntity)entityIn).func_152114_e(livingentity);
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    public MovementController func_70605_aq() {
        return this.field_70765_h;
    }

    public boolean func_184186_bw() {
        return false;
    }

    public void func_213352_e(Vector3d vec3d) {
        if (this.func_233685_eM_() || this.getAnimation() == ANIMATION_EAT_GRASS) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            vec3d = Vector3d.field_186680_a;
        }
        super.func_213352_e(vec3d);
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    public PathNavigator func_70661_as() {
        return this.field_70699_by;
    }

    private void enableJumpControl() {
        if (this.field_70767_i instanceof JumpHelperController) {
            ((JumpHelperController)this.field_70767_i).setCanJump(true);
        }
    }

    private void disableJumpControl() {
        if (this.field_70767_i instanceof JumpHelperController) {
            ((JumpHelperController)this.field_70767_i).setCanJump(false);
        }
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.field_70765_h.func_75638_b() < 2.0 ? 2 : 1;
    }

    private void calculateRotationYaw(double x, double z) {
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(z - this.func_226281_cx_()), (double)(x - this.func_226277_ct_())) * 57.2957763671875) - 90.0f;
    }

    public boolean func_230269_aK_() {
        return false;
    }

    public void func_70619_bc() {
        super.func_70619_bc();
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        if (this.field_70122_E) {
            LivingEntity livingentity;
            if (!this.wasOnGround) {
                this.func_70637_d(false);
                this.checkLandingDelay();
            }
            if (this.currentMoveTypeDuration == 0 && (livingentity = this.func_70638_az()) != null && this.func_70068_e((Entity)livingentity) < 16.0) {
                this.calculateRotationYaw(livingentity.func_226277_ct_(), livingentity.func_226281_cx_());
                this.field_70765_h.func_75642_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), this.field_70765_h.func_75638_b());
                this.startJumping();
                this.wasOnGround = true;
            }
            if (this.field_70767_i instanceof JumpHelperController) {
                JumpHelperController rabbitController = (JumpHelperController)this.field_70767_i;
                if (!rabbitController.getIsJumping()) {
                    if (this.field_70765_h.func_75640_a() && this.currentMoveTypeDuration == 0) {
                        Path path = this.field_70699_by.func_75505_d();
                        Vector3d vector3d = new Vector3d(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f());
                        if (path != null && !path.func_75879_b()) {
                            vector3d = path.func_75878_a((Entity)this);
                        }
                        this.startJumping();
                    }
                } else if (!rabbitController.canJump()) {
                    this.enableJumpControl();
                }
            }
        }
        this.wasOnGround = this.field_70122_E;
    }

    public float getJumpCompletion(float partialTicks) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + partialTicks) / (float)this.jumpDuration;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
        if (animation == ANIMATION_KICK) {
            this.setStanding(true);
            this.maxStandTime = 30;
        } else if (animation == ANIMATION_PUNCH_R) {
            this.setStanding(true);
            this.maxStandTime = 15;
        } else if (animation == ANIMATION_PUNCH_L) {
            this.setStanding(true);
            this.maxStandTime = 15;
        }
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_EAT_GRASS, ANIMATION_KICK, ANIMATION_PUNCH_L, ANIMATION_PUNCH_R};
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return (AgeableEntity)AMEntityRegistry.KANGAROO.func_200721_a((World)serverWorld);
    }

    public void setMovementSpeed(double newSpeed) {
        this.func_70661_as().func_75489_a(newSpeed);
        this.field_70765_h.func_75642_a(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f(), newSpeed);
    }

    protected float func_175134_bD() {
        return 0.5f;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == Items.field_221599_aA || item == Items.field_221674_ay;
    }

    public void resetKangarooSlots() {
        if (!this.field_70170_p.field_72995_K) {
            int swordIndex = -1;
            double swordDamage = 0.0;
            int helmetIndex = -1;
            double helmetArmor = 0.0;
            int chestplateIndex = -1;
            double chestplateArmor = 0.0;
            for (int i = 0; i < this.kangarooInventory.func_70302_i_(); ++i) {
                double prot;
                ItemStack stack = this.kangarooInventory.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                double dmg = this.getDamageForItem(stack);
                if (dmg > 0.0 && dmg > swordDamage) {
                    swordDamage = dmg;
                    swordIndex = i;
                }
                if (stack.func_77973_b().canEquip(stack, EquipmentSlotType.HEAD, (Entity)this) && !this.func_70631_g_() && helmetIndex == -1) {
                    helmetIndex = i;
                }
                if (!(stack.func_77973_b() instanceof ArmorItem) || this.func_70631_g_()) continue;
                ArmorItem armorItem = (ArmorItem)stack.func_77973_b();
                if (armorItem.func_185083_B_() == EquipmentSlotType.HEAD && (prot = this.getProtectionForItem(stack, EquipmentSlotType.HEAD)) > 0.0 && prot > helmetArmor) {
                    helmetArmor = prot;
                    helmetIndex = i;
                }
                if (armorItem.func_185083_B_() != EquipmentSlotType.CHEST || !((prot = this.getProtectionForItem(stack, EquipmentSlotType.CHEST)) > 0.0) || !(prot > chestplateArmor)) continue;
                chestplateArmor = prot;
                chestplateIndex = i;
            }
            this.field_70180_af.func_187227_b(SWORD_INDEX, (Object)swordIndex);
            this.field_70180_af.func_187227_b(CHEST_INDEX, (Object)chestplateIndex);
            this.field_70180_af.func_187227_b(HELMET_INDEX, (Object)helmetIndex);
            this.updateClientInventory();
        }
    }

    private void updateClientInventory() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 9; ++i) {
                AlexsMobs.sendMSGToAll(new MessageKangarooInventorySync(this.func_145782_y(), i, this.kangarooInventory.func_70301_a(i)));
            }
        }
    }

    @Nullable
    private Map<EquipmentSlotType, ItemStack> func_241354_r_() {
        EnumMap map = null;
        block4: for (EquipmentSlotType equipmentslottype : EquipmentSlotType.values()) {
            ItemStack itemstack;
            switch (equipmentslottype.func_188453_a()) {
                case HAND: {
                    itemstack = this.getItemInHand(equipmentslottype);
                    break;
                }
                case ARMOR: {
                    itemstack = this.getArmorInSlot(equipmentslottype);
                    break;
                }
                default: {
                    continue block4;
                }
            }
            ItemStack itemstack1 = this.func_184582_a(equipmentslottype);
            if (ItemStack.func_77989_b((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            MinecraftForge.EVENT_BUS.post((Event)new LivingEquipmentChangeEvent((LivingEntity)this, equipmentslottype, itemstack, itemstack1));
            if (map == null) {
                map = Maps.newEnumMap(EquipmentSlotType.class);
            }
            map.put(equipmentslottype, itemstack1);
            if (!itemstack.func_190926_b()) {
                this.func_233645_dx_().func_233785_a_(itemstack.func_111283_C(equipmentslottype));
            }
            if (itemstack1.func_190926_b()) continue;
            this.func_233645_dx_().func_233793_b_(itemstack1.func_111283_C(equipmentslottype));
        }
        return map;
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        switch (slotIn.func_188453_a()) {
            case HAND: {
                return this.getItemInHand(slotIn);
            }
            case ARMOR: {
                return this.getArmorInSlot(slotIn);
            }
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack getArmorInSlot(EquipmentSlotType slot) {
        int helmIndex = (Integer)this.field_70180_af.func_187225_a(HELMET_INDEX);
        int chestIndex = (Integer)this.field_70180_af.func_187225_a(CHEST_INDEX);
        return slot == EquipmentSlotType.HEAD && helmIndex >= 0 ? this.kangarooInventory.func_70301_a(helmIndex) : (slot == EquipmentSlotType.CHEST && chestIndex >= 0 ? this.kangarooInventory.func_70301_a(chestIndex) : ItemStack.field_190927_a);
    }

    private ItemStack getItemInHand(EquipmentSlotType slot) {
        int index = (Integer)this.field_70180_af.func_187225_a(SWORD_INDEX);
        return slot == EquipmentSlotType.MAINHAND && index >= 0 ? this.kangarooInventory.func_70301_a(index) : ItemStack.field_190927_a;
    }

    public double getDamageForItem(ItemStack itemStack) {
        Multimap map = itemStack.func_111283_C(EquipmentSlotType.MAINHAND);
        if (!map.isEmpty()) {
            double d = 0.0;
            for (AttributeModifier mod : map.get((Object)Attributes.field_233823_f_)) {
                d += mod.func_111164_d();
            }
            return d;
        }
        return 0.0;
    }

    public double getProtectionForItem(ItemStack itemStack, EquipmentSlotType type) {
        Multimap map = itemStack.func_111283_C(type);
        if (!map.isEmpty()) {
            double d = 0.0;
            for (AttributeModifier mod : map.get((Object)Attributes.field_233826_i_)) {
                d += mod.func_111164_d();
            }
            return d;
        }
        return 0.0;
    }

    protected void func_70664_aZ() {
        double d1;
        super.func_70664_aZ();
        double d0 = this.field_70765_h.func_75638_b();
        if (!(d0 > 0.0) || (d1 = EntityKangaroo.func_213296_b((Vector3d)this.func_213322_ci())) < 0.01) {
            // empty if block
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)1);
        }
    }

    public boolean hasJumper() {
        return this.field_70767_i instanceof JumpHelperController;
    }

    public void startJumping() {
        if (!this.func_233685_eM_() || this.func_70090_H()) {
            this.func_70637_d(true);
            this.jumpDuration = 16;
            this.jumpTicks = 0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 1) {
            this.func_233569_aL_();
            this.jumpDuration = 16;
            this.jumpTicks = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    @Override
    public boolean shouldFollow() {
        return this.getCommand() == 1;
    }

    public void func_76316_a(IInventory iInventory) {
        this.resetKangarooSlots();
    }

    public class JumpHelperController
    extends JumpController {
        private final EntityKangaroo kangaroo;
        private boolean canJump;

        public JumpHelperController(EntityKangaroo kangaroo) {
            super((MobEntity)kangaroo);
            this.kangaroo = kangaroo;
        }

        public boolean getIsJumping() {
            return this.field_75662_b;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJumpIn) {
            this.canJump = canJumpIn;
        }

        public void func_75661_b() {
            if (this.field_75662_b) {
                this.kangaroo.startJumping();
                this.field_75662_b = false;
            }
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final EntityKangaroo kangaroo;
        private double nextJumpSpeed;

        public MoveHelperController(EntityKangaroo kangaroo) {
            super((MobEntity)kangaroo);
            this.kangaroo = kangaroo;
        }

        public void func_75641_c() {
            if (this.kangaroo.hasJumper() && this.kangaroo.field_70122_E && !this.kangaroo.field_70703_bu && !((JumpHelperController)this.kangaroo.field_70767_i).getIsJumping()) {
                this.kangaroo.setMovementSpeed(0.0);
            } else if (this.func_75640_a()) {
                this.kangaroo.setMovementSpeed(this.nextJumpSpeed);
            }
            super.func_75641_c();
        }

        public void func_75642_a(double x, double y, double z, double speedIn) {
            if (this.kangaroo.func_70090_H()) {
                speedIn = 1.5;
            }
            super.func_75642_a(x, y, z, speedIn);
            if (speedIn > 0.0) {
                this.nextJumpSpeed = speedIn;
            }
        }
    }
}

