/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ISemiAquatic;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIFindWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAILeaveWater;
import com.github.alexthe666.alexsmobs.entity.ai.BottomFeederAIWander;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticPathNavigator;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class EntityLobster
extends WaterMobEntity
implements ISemiAquatic {
    private static final DataParameter<Boolean> FROM_BUCKET = EntityDataManager.func_187226_a(EntityLobster.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ATTACK_TICK = EntityDataManager.func_187226_a(EntityLobster.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityLobster.class, (IDataSerializer)DataSerializers.field_187192_b);
    public float attackProgress;
    public float prevAttackProgress;
    private int attackCooldown = 0;

    protected EntityLobster(EntityType type, World p_i48565_2_) {
        super(type, p_i48565_2_);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 0.0f);
    }

    public int func_70641_bl() {
        return 7;
    }

    public boolean func_204209_c(int sizeIn) {
        return false;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 5.0).func_233815_a_(Attributes.field_233826_i_, 2.0).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233821_d_, (double)0.15f);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.lobsterSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.LOBSTER_HURT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.LOBSTER_HURT;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public static String getVariantName(int variant) {
        switch (variant) {
            case 1: {
                return "blue";
            }
            case 2: {
                return "yellow";
            }
            case 3: {
                return "redblue";
            }
        }
        return "red";
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new AnimalAIFindWater((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AnimalAILeaveWater((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new BottomFeederAIWander((CreatureEntity)this, 1.0, 10, 50));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            if (this.field_70703_bu) {
                this.func_213317_d(this.func_213322_ci().func_186678_a(1.4));
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.72, 0.0));
            } else {
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.4));
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.08, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(ATTACK_TICK, (Object)0);
        this.field_70180_af.func_187214_a(FROM_BUCKET, (Object)false);
    }

    protected ItemStack getFishBucket() {
        ItemStack stack = new ItemStack((IItemProvider)AMItemRegistry.LOBSTER_BUCKET);
        if (this.func_145818_k_()) {
            stack.func_200302_a(this.func_200201_e());
        }
        return stack;
    }

    protected void setBucketData(ItemStack bucket) {
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
        CompoundNBT compoundnbt = bucket.func_196082_o();
        compoundnbt.func_74768_a("BucketVariantTag", this.getVariant());
    }

    public boolean func_213392_I() {
        return super.func_213392_I() || this.isFromBucket();
    }

    protected ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (itemstack.func_77973_b() == Items.field_151131_as && this.func_70089_S()) {
            this.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
            itemstack.func_190918_g(1);
            ItemStack itemstack1 = this.getFishBucket();
            this.setBucketData(itemstack1);
            if (!this.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)p_230254_1_, itemstack1);
            }
            if (itemstack.func_190926_b()) {
                p_230254_1_.func_184611_a(p_230254_2_, itemstack1);
            } else if (!p_230254_1_.field_71071_by.func_70441_a(itemstack1)) {
                p_230254_1_.func_71019_a(itemstack1, false);
            }
            this.func_70106_y();
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_204610_c(pos.func_177977_b()).func_206888_e() && worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a) ? 10.0f : super.func_205022_a(pos, worldIn);
    }

    public boolean func_70652_k(Entity entityIn) {
        this.field_70180_af.func_187227_b(ATTACK_TICK, (Object)5);
        return super.func_70652_k(entityIn);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevAttackProgress = this.attackProgress;
        if ((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) > 0) {
            if (this.attackProgress == 3.0f) {
                this.func_184185_a(AMSoundRegistry.LOBSTER_ATTACK, this.func_70599_aP(), this.func_70647_i());
            }
            if ((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) == 2 && this.func_70638_az() != null && (double)this.func_70032_d((Entity)this.func_70638_az()) < 1.3) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 2.0f);
            }
            this.field_70180_af.func_187227_b(ATTACK_TICK, (Object)((Integer)this.field_70180_af.func_187225_a(ATTACK_TICK) - 1));
            if (this.attackProgress < 5.0f) {
                this.attackProgress += 1.0f;
            }
        } else if (this.attackProgress > 0.0f) {
            this.attackProgress -= 1.0f;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) <= 1.0f && this.attackCooldown == 0) {
            this.func_70625_a((Entity)this.func_70638_az(), 180.0f, 20.0f);
            this.func_70652_k((Entity)this.func_70638_az());
            this.attackCooldown = 20;
        }
    }

    protected void func_209207_l(int air) {
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74757_a("FromBucket", this.isFromBucket());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setFromBucket(compound.func_74767_n("FromBucket"));
    }

    private boolean isFromBucket() {
        return (Boolean)this.field_70180_af.func_187225_a(FROM_BUCKET);
    }

    public void setFromBucket(boolean p_203706_1_) {
        this.field_70180_af.func_187227_b(FROM_BUCKET, (Object)p_203706_1_);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        float variantChange = this.func_70681_au().nextFloat();
        if (variantChange <= 0.05f) {
            this.setVariant(3);
        } else if (variantChange <= 0.1f) {
            this.setVariant(2);
        } else if (variantChange <= 0.25f) {
            this.setVariant(1);
        } else {
            this.setVariant(0);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        SemiAquaticPathNavigator flyingpathnavigator = new SemiAquaticPathNavigator((MobEntity)this, worldIn){

            @Override
            public boolean func_188555_b(BlockPos pos) {
                return this.field_75513_b.func_180495_p(pos).func_204520_s().func_206888_e();
            }
        };
        return flyingpathnavigator;
    }

    @Override
    public boolean shouldEnterWater() {
        return true;
    }

    @Override
    public boolean shouldLeaveWater() {
        return false;
    }

    @Override
    public boolean shouldStopMoving() {
        return false;
    }

    @Override
    public int getWaterSearchRange() {
        return 5;
    }

    public static <T extends MobEntity> boolean canLobsterSpawn(EntityType type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        boolean spawnBlock = BlockTags.func_199896_a().func_199910_a(AMTagRegistry.LOBSTER_SPAWNS).func_230235_a_((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c());
        return spawnBlock || worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
    }
}

