/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.IFollower;
import com.github.alexthe666.alexsmobs.entity.ISemiAquatic;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIFindWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAILeaveWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalSwimMoveControllerSink;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.entity.ai.MantisShrimpAIBreakBlocks;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticAIRandomSwimming;
import com.github.alexthe666.alexsmobs.entity.ai.SemiAquaticPathNavigator;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityMantisShrimp
extends TameableEntity
implements ISemiAquatic,
IFollower {
    private static final DataParameter<Float> RIGHT_EYE_PITCH = EntityDataManager.func_187226_a(EntityMantisShrimp.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> RIGHT_EYE_YAW = EntityDataManager.func_187226_a(EntityMantisShrimp.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> LEFT_EYE_PITCH = EntityDataManager.func_187226_a(EntityMantisShrimp.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> LEFT_EYE_YAW = EntityDataManager.func_187226_a(EntityMantisShrimp.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> PUNCH_TICK = EntityDataManager.func_187226_a(EntityMantisShrimp.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityMantisShrimp.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(EntityMantisShrimp.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityMantisShrimp.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MOISTNESS = EntityDataManager.func_187226_a(EntityMantisShrimp.class, (IDataSerializer)DataSerializers.field_187192_b);
    public float prevRightPitch;
    public float prevRightYaw;
    public float prevLeftPitch;
    public float prevLeftYaw;
    public float prevInWaterProgress;
    public float inWaterProgress;
    public float prevPunchProgress;
    public float punchProgress;
    private int leftLookCooldown = 0;
    private int rightLookCooldown = 0;
    private float targetRightPitch;
    private float targetRightYaw;
    private float targetLeftPitch;
    private float targetLeftYaw;
    private boolean isLandNavigator;
    private int fishFeedings;
    private int moistureAttackTime = 0;

    protected EntityMantisShrimp(EntityType type, World world) {
        super(type, world);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 0.0f);
        this.switchNavigator(false);
        this.field_70138_W = 1.0f;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.MANTIS_SHRIMP_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.MANTIS_SHRIMP_HURT;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof ShulkerEntity || entity instanceof ShulkerBulletEntity) {
            amount = (amount + 1.0f) * 0.33f;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_241847_a(ServerWorld world, LivingEntity entity) {
        if (entity.func_200600_R() == EntityType.field_200738_ad) {
            CompoundNBT fishNbt = new CompoundNBT();
            entity.func_213281_b(fishNbt);
            fishNbt.func_74778_a("DeathLootTable", LootTables.field_186419_a.toString());
            entity.func_70037_a(fishNbt);
            entity.func_199703_a((IItemProvider)Items.field_190930_cZ);
        }
        super.func_241847_a(world, entity);
    }

    public static boolean canMantisShrimpSpawn(EntityType type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        BlockPos downPos = pos;
        while (downPos.func_177956_o() > 1 && !worldIn.func_204610_c(downPos).func_206888_e()) {
            downPos = downPos.func_177977_b();
        }
        boolean spawnBlock = BlockTags.func_199896_a().func_199910_a(AMTagRegistry.MANTIS_SHRIMP_SPAWNS).func_230235_a_((Object)worldIn.func_180495_p(downPos).func_177230_c());
        return spawnBlock && downPos.func_177956_o() < worldIn.func_181545_F() + 1;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233820_c_, 0.1).func_233815_a_(Attributes.field_233826_i_, 8.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.func_70909_n();
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.mantisShrimpSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new MantisShrimpAIBreakBlocks(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowOwner(this, 1.3, 4.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, (double)1.2f, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new AnimalAIFindWater((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new AnimalAILeaveWater((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new BreedGoal((AnimalEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (Goal)new TemptGoal((CreatureEntity)this, 1.0, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196088_aY, AMItemRegistry.LOBSTER_TAIL, AMItemRegistry.COOKED_LOBSTER_TAIL}), false));
        this.field_70714_bg.func_75776_a(7, (Goal)new SemiAquaticAIRandomSwimming((AnimalEntity)this, 1.0, 30));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new EntityAINearestTarget3D((MobEntity)this, LivingEntity.class, 120, false, true, AMEntityRegistry.buildPredicateFromTag(EntityTypeTags.func_219762_a().func_199910_a(AMTagRegistry.MANTIS_SHRIMP_TARGETS))){

            public boolean func_75250_a() {
                return EntityMantisShrimp.this.getCommand() != 3 && !EntityMantisShrimp.this.func_233685_eM_() && super.func_75250_a();
            }
        });
        this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new GroundPathNavigatorWide((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new AnimalSwimMoveControllerSink((CreatureEntity)this, 1.0f, 1.0f);
            this.field_70699_by = new SemiAquaticPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_233685_eM_()) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            travelVector = Vector3d.field_186680_a;
            super.func_213352_e(travelVector);
            return;
        }
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else {
            super.func_213352_e(travelVector);
        }
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_76369_e || source == DamageSource.field_76368_d || source == DamageSource.field_82729_p || super.func_180431_b(source);
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RIGHT_EYE_PITCH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(RIGHT_EYE_YAW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(LEFT_EYE_PITCH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(LEFT_EYE_YAW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(PUNCH_TICK, (Object)0);
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(MOISTNESS, (Object)60000);
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return this.func_70909_n() && (item == AMItemRegistry.LOBSTER_TAIL || item == AMItemRegistry.COOKED_LOBSTER_TAIL);
    }

    public boolean func_70652_k(Entity entityIn) {
        this.punch();
        return true;
    }

    public void punch() {
        this.field_70180_af.func_187227_b(PUNCH_TICK, (Object)4);
    }

    public float getEyeYaw(boolean left) {
        return ((Float)this.field_70180_af.func_187225_a(left ? LEFT_EYE_YAW : RIGHT_EYE_YAW)).floatValue();
    }

    public float getEyePitch(boolean left) {
        return ((Float)this.field_70180_af.func_187225_a(left ? LEFT_EYE_PITCH : RIGHT_EYE_PITCH)).floatValue();
    }

    public void setEyePitch(boolean left, float pitch) {
        this.field_70180_af.func_187227_b(left ? LEFT_EYE_PITCH : RIGHT_EYE_PITCH, (Object)Float.valueOf(pitch));
    }

    public void setEyeYaw(boolean left, float yaw) {
        this.field_70180_af.func_187227_b(left ? LEFT_EYE_YAW : RIGHT_EYE_YAW, (Object)Float.valueOf(yaw));
    }

    public int getCommand() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    public void setCommand(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)command);
    }

    public boolean func_233685_eM_() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void setSitting(boolean sit) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sit);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int command) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)command);
    }

    public int getMoistness() {
        return (Integer)this.field_70180_af.func_187225_a(MOISTNESS);
    }

    public void setMoistness(int p_211137_1_) {
        this.field_70180_af.func_187227_b(MOISTNESS, (Object)p_211137_1_);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_175446_cd()) {
            this.func_70050_g(this.func_205010_bg());
        } else if (this.func_203008_ap() || this.func_184614_ca().func_77973_b() == Items.field_151131_as) {
            this.setMoistness(60000);
        } else {
            this.setMoistness(this.getMoistness() - 1);
            if (this.getMoistness() <= 0 && this.moistureAttackTime-- <= 0) {
                this.setCommand(0);
                this.setSitting(false);
                this.func_70097_a(DamageSource.field_205132_u, this.field_70146_Z.nextInt(2) == 0 ? 1.0f : 0.0f);
                this.moistureAttackTime = 20;
            }
        }
        if (this.func_70644_a(Effects.field_188424_y)) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.5, 1.0));
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        ActionResultType type = super.func_230254_b_(player, hand);
        if (!this.func_70909_n() && item == Items.field_196088_aY) {
            this.func_175505_a(player, itemstack);
            this.func_184185_a(SoundEvents.field_232840_oa_, this.func_70599_aP(), this.func_70647_i());
            ++this.fishFeedings;
            if (this.fishFeedings > 10 && this.func_70681_au().nextInt(6) == 0 || this.fishFeedings > 30) {
                this.func_193101_c(player);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.func_70909_n() && item.func_206844_a((ITag)ItemTags.field_206964_G)) {
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_175505_a(player, itemstack);
                this.func_184185_a(SoundEvents.field_232840_oa_, this.func_70599_aP(), this.func_70647_i());
                this.func_70691_i(5.0f);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        if (type != ActionResultType.SUCCESS && this.func_70909_n() && this.func_152114_e((LivingEntity)player)) {
            if (player.func_225608_bj_()) {
                if (this.func_184614_ca().func_190926_b()) {
                    ItemStack cop = itemstack.func_77946_l();
                    cop.func_190920_e(1);
                    this.func_184611_a(Hand.MAIN_HAND, cop);
                    itemstack.func_190918_g(1);
                    return ActionResultType.SUCCESS;
                }
                this.func_199701_a_(this.func_184614_ca().func_77946_l());
                this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                return ActionResultType.SUCCESS;
            }
            if (!this.func_70877_b(itemstack)) {
                boolean sit;
                this.setCommand(this.getCommand() + 1);
                if (this.getCommand() == 4) {
                    this.setCommand(0);
                }
                if (this.getCommand() == 3) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("entity.alexsmobs.mantis_shrimp.command_3", new Object[]{this.func_200200_C_()}), true);
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("entity.alexsmobs.all.command_" + this.getCommand(), new Object[]{this.func_200200_C_()}), true);
                }
                boolean bl = sit = this.getCommand() == 2;
                if (sit) {
                    this.setSitting(true);
                    return ActionResultType.SUCCESS;
                }
                this.setSitting(false);
                return ActionResultType.SUCCESS;
            }
        }
        return type;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("MantisShrimpSitting", this.func_233685_eM_());
        compound.func_74768_a("Command", this.getCommand());
        compound.func_74768_a("Moisture", this.getMoistness());
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSitting(compound.func_74767_n("MantisShrimpSitting"));
        this.setCommand(compound.func_74762_e("Command"));
        this.setVariant(compound.func_74762_e("Variant"));
        this.setMoistness(compound.func_74762_e("Moisture"));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70631_g_() && this.func_70047_e() > this.func_213302_cg()) {
            this.func_213323_x_();
        }
        this.prevLeftPitch = this.getEyePitch(true);
        this.prevRightPitch = this.getEyePitch(false);
        this.prevLeftYaw = this.getEyeYaw(true);
        this.prevRightYaw = this.getEyeYaw(false);
        this.prevInWaterProgress = this.inWaterProgress;
        this.prevPunchProgress = this.punchProgress;
        this.updateEyes();
        if (this.func_233685_eM_() && this.func_70661_as().func_75500_f()) {
            this.func_70661_as().func_75499_g();
        }
        if (this.func_70090_H() && this.inWaterProgress < 5.0f) {
            this.inWaterProgress += 1.0f;
        }
        if (!this.func_70090_H() && this.inWaterProgress > 0.0f) {
            this.inWaterProgress -= 1.0f;
        }
        if (this.func_70090_H() && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!this.func_70090_H() && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if ((Integer)this.field_70180_af.func_187225_a(PUNCH_TICK) > 0) {
            if ((Integer)this.field_70180_af.func_187225_a(PUNCH_TICK) == 2 && this.func_70638_az() != null && (double)this.func_70032_d((Entity)this.func_70638_az()) < 2.8) {
                if (this.func_70638_az() instanceof AbstractFishEntity && !this.func_70909_n()) {
                    AbstractFishEntity fish = (AbstractFishEntity)this.func_70638_az();
                    CompoundNBT fishNbt = new CompoundNBT();
                    fish.func_213281_b(fishNbt);
                    fishNbt.func_74778_a("DeathLootTable", LootTables.field_186419_a.toString());
                    fish.func_70037_a(fishNbt);
                }
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_));
                this.func_70638_az().func_233627_a_(1.7f, this.func_226277_ct_() - this.func_70638_az().func_226277_ct_(), this.func_226281_cx_() - this.func_70638_az().func_226281_cx_());
                float knockbackResist = (float)MathHelper.func_151237_a((double)(1.0 - this.func_233637_b_(Attributes.field_233820_c_)), (double)0.0, (double)1.0);
                this.func_70638_az().func_213317_d(this.func_70638_az().func_213322_ci().func_72441_c(0.0, (double)(knockbackResist * 0.8f), 0.0));
                if (!this.func_70638_az().func_70090_H()) {
                    this.func_70638_az().func_70015_d(2);
                }
            }
            if (this.punchProgress == 1.0f) {
                this.func_184185_a(AMSoundRegistry.MANTIS_SHRIMP_SNAP, this.func_70647_i(), this.func_70599_aP());
            }
            if (this.punchProgress == 2.0f && this.field_70170_p.field_72995_K && this.func_70090_H()) {
                for (int i = 0; i < 10 + this.field_70146_Z.nextInt(8); ++i) {
                    double d2 = this.field_70146_Z.nextGaussian() * 0.6;
                    double d0 = this.field_70146_Z.nextGaussian() * 0.2;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.6;
                    float radius = this.func_213311_cf() * 0.85f;
                    float angle = (float)Math.PI / 180 * this.field_70761_aq;
                    double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle))) + this.field_70146_Z.nextFloat() * 0.5f - 0.25f;
                    double extraZ = radius * MathHelper.func_76134_b((float)angle) + this.field_70146_Z.nextFloat() * 0.5f - 0.25f;
                    BasicParticleType data = ParticleTypes.field_197612_e;
                    this.field_70170_p.func_195594_a((IParticleData)data, this.func_226277_ct_() + extraX, this.func_226278_cu_() + (double)(this.func_213302_cg() * 0.3f) + (double)(this.field_70146_Z.nextFloat() * 0.15f), this.func_226281_cx_() + extraZ, d0, d1, d2);
                }
            }
            if (this.punchProgress < 2.0f) {
                this.punchProgress += 1.0f;
            }
            this.field_70180_af.func_187227_b(PUNCH_TICK, (Object)((Integer)this.field_70180_af.func_187225_a(PUNCH_TICK) - 1));
        } else if (this.punchProgress > 0.0f) {
            this.punchProgress -= 0.25f;
        }
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.func_70909_n()) {
            LivingEntity livingentity = this.func_70902_q();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TameableEntity) {
                return ((TameableEntity)entityIn).func_152114_e(livingentity);
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    private void updateEyes() {
        float leftPitchDist = Math.abs(this.getEyePitch(true) - this.targetLeftPitch);
        float rightPitchDist = Math.abs(this.getEyePitch(false) - this.targetRightPitch);
        float leftYawDist = Math.abs(this.getEyeYaw(true) - this.targetLeftYaw);
        float rightYawDist = Math.abs(this.getEyeYaw(false) - this.targetRightYaw);
        if (this.rightLookCooldown == 0 && this.field_70146_Z.nextInt(20) == 0 && rightPitchDist < 0.5f && rightYawDist < 0.5f) {
            this.targetRightPitch = MathHelper.func_76131_a((float)(this.field_70146_Z.nextFloat() * 60.0f - 30.0f), (float)-30.0f, (float)30.0f);
            this.targetRightYaw = MathHelper.func_76131_a((float)(this.field_70146_Z.nextFloat() * 60.0f - 30.0f), (float)-30.0f, (float)30.0f);
            this.rightLookCooldown = 3 + this.field_70146_Z.nextInt(15);
        }
        if (this.leftLookCooldown == 0 && this.field_70146_Z.nextInt(20) == 0 && leftPitchDist < 0.5f && leftYawDist < 0.5f) {
            this.targetLeftPitch = MathHelper.func_76131_a((float)(this.field_70146_Z.nextFloat() * 60.0f - 30.0f), (float)-30.0f, (float)30.0f);
            this.targetLeftYaw = MathHelper.func_76131_a((float)(this.field_70146_Z.nextFloat() * 60.0f - 30.0f), (float)-30.0f, (float)30.0f);
            this.leftLookCooldown = 3 + this.field_70146_Z.nextInt(15);
        }
        if (this.getEyePitch(true) < this.targetLeftPitch && leftPitchDist > 0.5f) {
            this.setEyePitch(true, this.getEyePitch(true) + Math.min(leftPitchDist, 4.0f));
        }
        if (this.getEyePitch(true) > this.targetLeftPitch && leftPitchDist > 0.5f) {
            this.setEyePitch(true, this.getEyePitch(true) - Math.min(leftPitchDist, 4.0f));
        }
        if (this.getEyePitch(false) < this.targetRightPitch && rightPitchDist > 0.5f) {
            this.setEyePitch(false, this.getEyePitch(false) + Math.min(rightPitchDist, 4.0f));
        }
        if (this.getEyePitch(false) > this.targetRightPitch && rightPitchDist > 0.5f) {
            this.setEyePitch(false, this.getEyePitch(false) - Math.min(rightPitchDist, 4.0f));
        }
        if (this.getEyeYaw(true) < this.targetLeftYaw && leftYawDist > 0.5f) {
            this.setEyeYaw(true, this.getEyeYaw(true) + Math.min(leftYawDist, 4.0f));
        }
        if (this.getEyeYaw(true) > this.targetLeftYaw && leftYawDist > 0.5f) {
            this.setEyeYaw(true, this.getEyeYaw(true) - Math.min(leftYawDist, 4.0f));
        }
        if (this.getEyeYaw(false) < this.targetRightYaw && rightYawDist > 0.5f) {
            this.setEyeYaw(false, this.getEyeYaw(false) + Math.min(rightYawDist, 4.0f));
        }
        if (this.getEyeYaw(false) > this.targetRightYaw && rightYawDist > 0.5f) {
            this.setEyeYaw(false, this.getEyeYaw(false) - Math.min(rightYawDist, 4.0f));
        }
        if (this.rightLookCooldown > 0) {
            --this.rightLookCooldown;
        }
        if (this.leftLookCooldown > 0) {
            --this.leftLookCooldown;
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setVariant(this.func_70681_au().nextInt(3));
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        EntityMantisShrimp shrimp = (EntityMantisShrimp)AMEntityRegistry.MANTIS_SHRIMP.func_200721_a((World)serverWorld);
        shrimp.setVariant(this.func_70681_au().nextInt(3));
        return shrimp;
    }

    @Override
    public boolean shouldEnterWater() {
        return (this.func_184614_ca().func_190926_b() || this.func_184614_ca().func_77973_b() != Items.field_151131_as) && !this.func_233685_eM_();
    }

    @Override
    public boolean shouldLeaveWater() {
        return this.func_184614_ca().func_77973_b() == Items.field_151131_as;
    }

    @Override
    public boolean shouldStopMoving() {
        return this.func_233685_eM_();
    }

    @Override
    public int getWaterSearchRange() {
        return 16;
    }

    @Override
    public boolean shouldFollow() {
        return this.getCommand() == 1;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    protected void updateAir(int p_209207_1_) {
    }

    public class FollowOwner
    extends Goal {
        private final EntityMantisShrimp tameable;
        private final IWorldReader world;
        private final double followSpeed;
        private final float maxDist;
        private final float minDist;
        private final boolean teleportToLeaves;
        private LivingEntity owner;
        private int timeToRecalcPath;
        private float oldWaterCost;

        public FollowOwner(EntityMantisShrimp p_i225711_1_, double p_i225711_2_, float p_i225711_4_, float p_i225711_5_, boolean p_i225711_6_) {
            this.tameable = p_i225711_1_;
            this.world = p_i225711_1_.field_70170_p;
            this.followSpeed = p_i225711_2_;
            this.minDist = p_i225711_4_;
            this.maxDist = p_i225711_5_;
            this.teleportToLeaves = p_i225711_6_;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity lvt_1_1_ = this.tameable.func_70902_q();
            if (lvt_1_1_ == null) {
                return false;
            }
            if (lvt_1_1_.func_175149_v()) {
                return false;
            }
            if (this.tameable.func_233685_eM_() || this.tameable.getCommand() != 1) {
                return false;
            }
            if (this.tameable.func_70068_e((Entity)lvt_1_1_) < (double)(this.minDist * this.minDist)) {
                return false;
            }
            if (this.tameable.func_70638_az() != null && this.tameable.func_70638_az().func_70089_S()) {
                return false;
            }
            this.owner = lvt_1_1_;
            return true;
        }

        public boolean func_75253_b() {
            if (this.tameable.func_70661_as().func_75500_f()) {
                return false;
            }
            if (this.tameable.func_233685_eM_() || this.tameable.getCommand() != 1) {
                return false;
            }
            if (this.tameable.func_70638_az() != null && this.tameable.func_70638_az().func_70089_S()) {
                return false;
            }
            return this.tameable.func_70068_e((Entity)this.owner) > (double)(this.maxDist * this.maxDist);
        }

        public void func_75249_e() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.tameable.func_184643_a(PathNodeType.WATER);
            this.tameable.func_184644_a(PathNodeType.WATER, 0.0f);
        }

        public void func_75251_c() {
            this.owner = null;
            this.tameable.func_70661_as().func_75499_g();
            this.tameable.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
        }

        public void func_75246_d() {
            this.tameable.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.tameable.func_70646_bf());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                if (!this.tameable.func_110167_bD() && !this.tameable.func_184218_aH()) {
                    if (this.tameable.func_70068_e((Entity)this.owner) >= 144.0) {
                        this.tryToTeleportNearEntity();
                    } else {
                        this.tameable.func_70661_as().func_75497_a((Entity)this.owner, this.followSpeed);
                    }
                }
            }
        }

        private void tryToTeleportNearEntity() {
            BlockPos lvt_1_1_ = this.owner.func_233580_cy_();
            for (int lvt_2_1_ = 0; lvt_2_1_ < 10; ++lvt_2_1_) {
                int lvt_3_1_ = this.getRandomNumber(-3, 3);
                int lvt_4_1_ = this.getRandomNumber(-1, 1);
                int lvt_5_1_ = this.getRandomNumber(-3, 3);
                boolean lvt_6_1_ = this.tryToTeleportToLocation(lvt_1_1_.func_177958_n() + lvt_3_1_, lvt_1_1_.func_177956_o() + lvt_4_1_, lvt_1_1_.func_177952_p() + lvt_5_1_);
                if (!lvt_6_1_) continue;
                return;
            }
        }

        private boolean tryToTeleportToLocation(int p_226328_1_, int p_226328_2_, int p_226328_3_) {
            if (Math.abs((double)p_226328_1_ - this.owner.func_226277_ct_()) < 2.0 && Math.abs((double)p_226328_3_ - this.owner.func_226281_cx_()) < 2.0) {
                return false;
            }
            if (!this.isTeleportFriendlyBlock(new BlockPos(p_226328_1_, p_226328_2_, p_226328_3_))) {
                return false;
            }
            this.tameable.func_70012_b((double)p_226328_1_ + 0.5, p_226328_2_, (double)p_226328_3_ + 0.5, this.tameable.field_70177_z, this.tameable.field_70125_A);
            this.tameable.func_70661_as().func_75499_g();
            return true;
        }

        private boolean isTeleportFriendlyBlock(BlockPos p_226329_1_) {
            PathNodeType lvt_2_1_ = WalkNodeProcessor.func_237231_a_((IBlockReader)this.world, (BlockPos.Mutable)p_226329_1_.func_239590_i_());
            if (this.world.func_204610_c(p_226329_1_).func_206884_a((ITag)FluidTags.field_206959_a) || !this.world.func_204610_c(p_226329_1_).func_206884_a((ITag)FluidTags.field_206959_a) && this.world.func_204610_c(p_226329_1_.func_177977_b()).func_206884_a((ITag)FluidTags.field_206959_a)) {
                return true;
            }
            if (lvt_2_1_ != PathNodeType.WALKABLE || this.tameable.getMoistness() < 2000) {
                return false;
            }
            BlockState lvt_3_1_ = this.world.func_180495_p(p_226329_1_.func_177977_b());
            if (!this.teleportToLeaves && lvt_3_1_.func_177230_c() instanceof LeavesBlock) {
                return false;
            }
            BlockPos lvt_4_1_ = p_226329_1_.func_177973_b((Vector3i)this.tameable.func_233580_cy_());
            return this.world.func_226665_a__((Entity)this.tameable, this.tameable.func_174813_aQ().func_186670_a(lvt_4_1_));
        }

        private int getRandomNumber(int p_226327_1_, int p_226327_2_) {
            return this.tameable.func_70681_au().nextInt(p_226327_2_ - p_226327_1_ + 1) + p_226327_1_;
        }
    }
}

