/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.message.MessageMungusBiomeChange;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IShearable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityMungus
extends AnimalEntity
implements ITargetsDroppedItems,
IShearable,
IForgeShearable {
    protected static final DataParameter<Optional<BlockPos>> TARGETED_BLOCK_POS = EntityDataManager.func_187226_a(EntityMungus.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Boolean> ALT_ORDER_MUSHROOMS = EntityDataManager.func_187226_a(EntityMungus.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> REVERTING = EntityDataManager.func_187226_a(EntityMungus.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> MUSHROOM_COUNT = EntityDataManager.func_187226_a(EntityMungus.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SACK_SWELL = EntityDataManager.func_187226_a(EntityMungus.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> EXPLOSION_DISABLED = EntityDataManager.func_187226_a(EntityMungus.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<BlockState>> MUSHROOM_STATE = EntityDataManager.func_187226_a(EntityMungus.class, (IDataSerializer)DataSerializers.field_187197_g);
    private static final int WIDTH_BITS = (int)Math.round(Math.log(16.0) / Math.log(2.0)) - 2;
    private static HashMap<String, String> MUSHROOM_TO_BIOME = new HashMap();
    private static HashMap<String, String> MUSHROOM_TO_BLOCK = new HashMap();
    private static boolean initBiomeData = false;
    public float prevSwellProgress = 0.0f;
    public float swellProgress = 0.0f;
    private int beamCounter = 0;
    private int mosquitoAttackCooldown = 0;
    private boolean hasExploded;

    protected EntityMungus(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
        EntityMungus.initBiomeData();
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 15.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    public static boolean canMungusSpawn(EntityType type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_200132_m();
    }

    public static BlockState getMushroomBlockstate(Item item) {
        if (item instanceof BlockItem && MUSHROOM_TO_BIOME.containsKey(item.getRegistryName().toString())) {
            return ((BlockItem)item).func_179223_d().func_176223_P();
        }
        return null;
    }

    private static void initBiomeData() {
        if (!initBiomeData || MUSHROOM_TO_BIOME.isEmpty()) {
            initBiomeData = true;
            for (String string : AMConfig.mungusBiomeMatches) {
                String[] split = string.split("\\|");
                if (split.length < 2) continue;
                MUSHROOM_TO_BIOME.put(split[0], split[1]);
                MUSHROOM_TO_BLOCK.put(split[0], split[2]);
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.MUNGUS_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.MUNGUS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.MUNGUS_HURT;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.mungusSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.0, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[0]), false){

            protected boolean func_188508_a(ItemStack stack) {
                return EntityMungus.this.shouldFollowMushroom(stack) || stack.func_77973_b() == Items.field_151009_A;
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new AITargetMushrooms());
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(7, (Goal)new AnimalAIWanderRanged((CreatureEntity)this, 60, 1.0, 14, 7));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 15.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, new CreatureAITargetItems((CreatureEntity)this, false, 10));
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.prevSwellProgress = this.swellProgress;
        if (this.isReverting() && AMConfig.mungusBiomeTransformationType == 2) {
            this.swellProgress += 0.5f;
            if (this.swellProgress >= 10.0f) {
                this.explode();
                this.swellProgress = 0.0f;
                this.field_70180_af.func_187227_b(REVERTING, (Object)false);
            }
        } else if (this.func_70089_S() && this.swellProgress > 0.0f) {
            this.swellProgress -= 1.0f;
        }
        if (((Boolean)this.field_70180_af.func_187225_a(EXPLOSION_DISABLED)).booleanValue()) {
            if (this.mosquitoAttackCooldown < 0) {
                ++this.mosquitoAttackCooldown;
            }
            if (this.mosquitoAttackCooldown > 200) {
                this.mosquitoAttackCooldown = 0;
                this.field_70180_af.func_187227_b(EXPLOSION_DISABLED, (Object)false);
            }
        }
    }

    protected void func_70609_aI() {
        super.func_70609_aI();
        if (this.getMushroomCount() >= 5 && AMConfig.mungusBiomeTransformationType > 0 && !this.func_70631_g_() && !((Boolean)this.field_70180_af.func_187225_a(EXPLOSION_DISABLED)).booleanValue()) {
            this.swellProgress += 1.0f;
            if (this.field_70725_aQ == 20 && !this.hasExploded) {
                this.hasExploded = true;
                this.explode();
            }
        }
    }

    private void explode() {
        for (int i = 0; i < 5; ++i) {
            float r1 = 6.0f * (this.field_70146_Z.nextFloat() - 0.5f);
            float r2 = 2.0f * (this.field_70146_Z.nextFloat() - 0.5f);
            float r3 = 6.0f * (this.field_70146_Z.nextFloat() - 0.5f);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_() + (double)r1, this.func_226278_cu_() + 0.5 + (double)r2, this.func_226281_cx_() + (double)r3, (double)(r1 * 4.0f), (double)(r2 * 4.0f), (double)(r3 * 4.0f));
        }
        int radius = 3;
        int j = 3 + this.field_70170_p.field_73012_v.nextInt(1);
        int k = 3 + this.field_70170_p.field_73012_v.nextInt(1);
        int l = 3 + this.field_70170_p.field_73012_v.nextInt(1);
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        float ff = f * f;
        double ffDouble = ff;
        BlockPos center = this.func_233580_cy_();
        BlockState transformState = Blocks.field_150391_bh.func_176223_P();
        Biome biome = (Biome)this.field_70170_p.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230516_a_(Biomes.field_76789_p);
        ITag transformMatches = BlockTags.func_199896_a().func_199910_a(AMTagRegistry.MUNGUS_REPLACE_MUSHROOM);
        if (this.getMushroomState() != null) {
            Block block;
            String mushroomKey = this.getMushroomState().func_177230_c().getRegistryName().toString();
            if (MUSHROOM_TO_BLOCK.containsKey(mushroomKey) && (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(MUSHROOM_TO_BLOCK.get(mushroomKey)))) != null) {
                transformState = block.func_176223_P();
                if (block == Blocks.field_235372_ml_) {
                    transformMatches = BlockTags.func_199896_a().func_199910_a(AMTagRegistry.MUNGUS_REPLACE_NETHER);
                }
                if (block == Blocks.field_235381_mu_) {
                    transformMatches = BlockTags.func_199896_a().func_199910_a(AMTagRegistry.MUNGUS_REPLACE_NETHER);
                }
            }
            if (this.getBiomeKeyFromShroom() != null) {
                biome = this.getBiomeKeyFromShroom();
            }
        }
        BlockState finalTransformState = transformState;
        ITag finalTransformReplace = transformMatches;
        if (AMConfig.mungusBiomeTransformationType == 2 && !this.field_70170_p.field_72995_K) {
            this.transformBiome(center, biome);
        }
        this.func_184185_a(SoundEvents.field_187539_bB, this.func_70599_aP(), this.func_70647_i());
        if (!this.isReverting()) {
            BlockPos.func_218281_b((BlockPos)center.func_177982_a(-j, -k, -l), (BlockPos)center.func_177982_a(j, k, l)).forEach(blockpos -> {
                if (blockpos.func_177951_i((Vector3i)center) <= ffDouble && this.field_70170_p.field_73012_v.nextFloat() > (float)blockpos.func_177951_i((Vector3i)center) / ff) {
                    if (this.field_70170_p.func_180495_p(blockpos).func_235714_a_(finalTransformReplace) && !this.field_70170_p.func_180495_p(blockpos.func_177984_a()).func_200132_m()) {
                        this.field_70170_p.func_175656_a(blockpos, finalTransformState);
                    }
                    if (this.field_70170_p.field_73012_v.nextInt(4) == 0 && this.field_70170_p.func_180495_p(blockpos).func_185904_a().func_76220_a() && this.field_70170_p.func_204610_c(blockpos.func_177984_a()).func_206888_e() && !this.field_70170_p.func_180495_p(blockpos.func_177984_a()).func_200132_m()) {
                        this.field_70170_p.func_175656_a(blockpos.func_177984_a(), this.getMushroomState().getBlockState());
                    }
                }
            });
        }
    }

    public void disableExplosion() {
        this.field_70180_af.func_187227_b(EXPLOSION_DISABLED, (Object)true);
    }

    private Biome getBiomeKeyFromShroom() {
        MutableRegistry registry = this.field_70170_p.func_241828_r().func_243612_b(Registry.field_239720_u_);
        BlockState state = this.getMushroomState();
        if (state == null) {
            return null;
        }
        String blockRegName = state.func_177230_c().getRegistryName().toString();
        String str = MUSHROOM_TO_BIOME.get(blockRegName);
        if (str != null) {
            return registry.func_241873_b(new ResourceLocation(str)).orElse(null);
        }
        return null;
    }

    private void transformBiome(BlockPos pos, Biome biome) {
        Chunk chunk = this.field_70170_p.func_175726_f(pos);
        BiomeContainer container = chunk.func_225549_i_();
        if (((Boolean)this.field_70180_af.func_187225_a(REVERTING)).booleanValue()) {
            int lvt_4_1_ = chunk.func_76632_l().func_180334_c() >> 2;
            int lvt_5_1_ = chunk.func_76632_l().func_180333_d() >> 2;
            ChunkGenerator chunkgenerator = ((ServerWorld)this.field_70170_p).func_72863_F().func_201711_g();
            Biome b = null;
            for (int lvt_6_1_ = 0; lvt_6_1_ < container.field_227054_f_.length; ++lvt_6_1_) {
                int lvt_7_1_ = lvt_6_1_ & BiomeContainer.field_227050_b_;
                int lvt_8_1_ = lvt_6_1_ >> WIDTH_BITS + WIDTH_BITS & BiomeContainer.field_227051_c_;
                int lvt_9_1_ = lvt_6_1_ >> WIDTH_BITS & BiomeContainer.field_227050_b_;
                container.field_227054_f_[lvt_6_1_] = b = chunkgenerator.func_202090_b().func_225526_b_(lvt_4_1_ + lvt_7_1_, lvt_8_1_, lvt_5_1_ + lvt_9_1_);
            }
            if (b != null && !this.field_70170_p.field_72995_K) {
                AlexsMobs.sendMSGToAll(new MessageMungusBiomeChange(this.func_145782_y(), pos.func_177958_n(), pos.func_177952_p(), b.getRegistryName().toString()));
            }
        } else {
            if (biome == null) {
                return;
            }
            if (container != null && !this.field_70170_p.field_72995_K) {
                for (int i = 0; i < container.field_227054_f_.length; ++i) {
                    container.field_227054_f_[i] = biome;
                }
                AlexsMobs.sendMSGToAll(new MessageMungusBiomeChange(this.func_145782_y(), pos.func_177958_n(), pos.func_177952_p(), biome.getRegistryName().toString()));
            }
        }
    }

    private boolean shouldFollowMushroom(ItemStack stack) {
        BlockState state = EntityMungus.getMushroomBlockstate(stack.func_77973_b());
        if (state != null) {
            if (this.getMushroomCount() == 0) {
                return true;
            }
            return this.getMushroomState().func_177230_c() == state.func_177230_c();
        }
        return false;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        ActionResultType type = super.func_230254_b_(player, hand);
        if (itemstack.func_77973_b() == Items.field_151170_bI && !this.func_70631_g_()) {
            this.field_70180_af.func_187227_b(REVERTING, (Object)true);
            this.func_175505_a(player, itemstack);
            return ActionResultType.SUCCESS;
        }
        if (this.shouldFollowMushroom(itemstack) && this.getMushroomCount() < 5) {
            this.field_70180_af.func_187227_b(REVERTING, (Object)false);
            BlockState state = EntityMungus.getMushroomBlockstate(itemstack.func_77973_b());
            this.func_184185_a(SoundEvents.field_232750_iS_, this.func_70599_aP(), this.func_70647_i());
            if (this.getMushroomState() != null && state != null && state.func_177230_c() != this.getMushroomState().func_177230_c()) {
                this.setMushroomCount(0);
            }
            this.setMushroomState(state);
            this.func_175505_a(player, itemstack);
            this.setMushroomCount(this.getMushroomCount() + 1);
            return ActionResultType.SUCCESS;
        }
        return type;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean prev = super.func_70097_a(source, amount);
        if (prev) {
            this.setBeamTarget(null);
            this.beamCounter = Math.min(this.beamCounter, -1200);
        }
        return prev;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MUSHROOM_STATE, Optional.empty());
        this.func_184212_Q().func_187214_a(TARGETED_BLOCK_POS, Optional.empty());
        this.field_70180_af.func_187214_a(ALT_ORDER_MUSHROOMS, (Object)false);
        this.field_70180_af.func_187214_a(REVERTING, (Object)false);
        this.field_70180_af.func_187214_a(EXPLOSION_DISABLED, (Object)false);
        this.field_70180_af.func_187214_a(MUSHROOM_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(SACK_SWELL, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        BlockState blockstate = this.getMushroomState();
        if (blockstate != null) {
            compound.func_218657_a("MushroomState", (INBT)NBTUtil.func_190009_a((BlockState)blockstate));
        }
        compound.func_74768_a("MushroomCount", this.getMushroomCount());
        compound.func_74768_a("Sack", this.getSackSwell());
        compound.func_74768_a("BeamCounter", this.beamCounter);
        compound.func_74757_a("AltMush", ((Boolean)this.field_70180_af.func_187225_a(ALT_ORDER_MUSHROOMS)).booleanValue());
        if (this.getBeamTarget() != null) {
            compound.func_218657_a("BeamTarget", (INBT)NBTUtil.func_186859_a((BlockPos)this.getBeamTarget()));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        BlockState blockstate = null;
        if (compound.func_150297_b("MushroomState", 10) && (blockstate = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("MushroomState"))).func_196958_f()) {
            blockstate = null;
        }
        if (compound.func_150297_b("BeamTarget", 10)) {
            this.setBeamTarget(NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("BeamTarget")));
        }
        this.setMushroomState(blockstate);
        this.setMushroomCount(compound.func_74762_e("MushroomCount"));
        this.setSackSwell(compound.func_74762_e("Sack"));
        this.beamCounter = compound.func_74762_e("BeamCounter");
        this.field_70180_af.func_187227_b(ALT_ORDER_MUSHROOMS, (Object)compound.func_74767_n("AltMush"));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.getBeamTarget() != null) {
            BlockPos t = this.getBeamTarget();
            if (this.isMushroomTarget(t) && this.canSeeMushroom(t)) {
                BlockState state;
                this.func_70671_ap().func_75650_a((double)((float)t.func_177958_n() + 0.5f), (double)((float)t.func_177956_o() + 0.15f), (double)((float)t.func_177952_p() + 0.5f), 90.0f, 90.0f);
                this.func_70671_ap().func_75649_a();
                double d5 = 1.0;
                double eyeHeight = this.func_226278_cu_() + 1.0;
                if (this.beamCounter % 20 == 0) {
                    this.func_184185_a(AMSoundRegistry.MUNGUS_LASER_LOOP, this.func_70647_i(), this.func_70599_aP());
                }
                ++this.beamCounter;
                double d0 = (double)((float)t.func_177958_n() + 0.5f) - this.func_226277_ct_();
                double d1 = (double)((float)t.func_177956_o() + 0.5f) - eyeHeight;
                double d2 = (double)((float)t.func_177952_p() + 0.5f) - this.func_226281_cx_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d0 /= d3;
                d1 /= d3;
                d2 /= d3;
                for (double d4 = this.field_70146_Z.nextDouble(); d4 < d3 - 0.5; d4 += 1.0 - d5 + this.field_70146_Z.nextDouble()) {
                    if (!(this.field_70146_Z.nextFloat() < 0.1f)) continue;
                    float r1 = 0.3f * (this.field_70146_Z.nextFloat() - 0.5f);
                    float r2 = 0.3f * (this.field_70146_Z.nextFloat() - 0.5f);
                    float r3 = 0.3f * (this.field_70146_Z.nextFloat() - 0.5f);
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197596_G, this.func_226277_ct_() + d0 * d4 + (double)r1, eyeHeight + d1 * d4 + (double)r2, this.func_226281_cx_() + d2 * d4 + (double)r3, (double)(r1 * 4.0f), (double)(r2 * 4.0f), (double)(r3 * 4.0f));
                }
                if (this.beamCounter > 200 && (state = this.field_70170_p.func_180495_p(t)).func_177230_c() instanceof IGrowable) {
                    IGrowable igrowable = (IGrowable)state.func_177230_c();
                    boolean flag = false;
                    if (igrowable.func_176473_a((IBlockReader)this.field_70170_p, t, state, this.field_70170_p.field_72995_K)) {
                        for (int i = 0; i < 5; ++i) {
                            float r1 = 3.0f * (this.field_70146_Z.nextFloat() - 0.5f);
                            float r2 = 2.0f * (this.field_70146_Z.nextFloat() - 0.5f);
                            float r3 = 3.0f * (this.field_70146_Z.nextFloat() - 0.5f);
                            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, (double)((float)t.func_177958_n() + 0.5f + r1), (double)((float)t.func_177956_o() + 0.5f + r2), (double)((float)t.func_177952_p() + 0.5f + r3), (double)(r1 * 4.0f), (double)(r2 * 4.0f), (double)(r3 * 4.0f));
                        }
                        if (!this.field_70170_p.field_72995_K) {
                            this.field_70170_p.func_217379_c(2005, t, 0);
                            igrowable.func_225535_a_((ServerWorld)this.field_70170_p, this.field_70170_p.field_73012_v, t, state);
                            boolean bl = flag = this.field_70170_p.func_180495_p(t).func_177230_c() != state.func_177230_c();
                        }
                    }
                    if (!flag) {
                        int grown = 0;
                        int maxGrow = 2 + this.field_70146_Z.nextInt(3);
                        for (int i = 0; i < 15; ++i) {
                            BlockPos pos = t.func_177982_a(this.field_70146_Z.nextInt(10) - 5, this.field_70146_Z.nextInt(4) - 2, this.field_70146_Z.nextInt(10) - 5);
                            if (grown >= maxGrow || !this.field_70170_p.func_180495_p(pos).func_196958_f() || !this.field_70170_p.func_180495_p(pos.func_177977_b()).func_200132_m()) continue;
                            this.field_70170_p.func_175656_a(pos, state);
                            ++grown;
                        }
                    }
                    this.func_184185_a(AMSoundRegistry.MUNGUS_LASER_END, this.func_70647_i(), this.func_70599_aP());
                    this.setBeamTarget(null);
                    this.beamCounter = -1200;
                    if (this.getMushroomCount() > 0) {
                        this.setMushroomCount(this.getMushroomCount() - 1);
                    }
                }
            } else {
                this.setBeamTarget(null);
            }
        }
        if (this.beamCounter < 0) {
            ++this.beamCounter;
        }
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151009_A;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.field_70180_af.func_187227_b(ALT_ORDER_MUSHROOMS, (Object)this.field_70146_Z.nextBoolean());
        this.setMushroomCount(this.field_70146_Z.nextInt(2));
        this.setMushroomState(this.field_70146_Z.nextBoolean() ? Blocks.field_150338_P.func_176223_P() : Blocks.field_150337_Q.func_176223_P());
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public int getMushroomCount() {
        return (Integer)this.field_70180_af.func_187225_a(MUSHROOM_COUNT);
    }

    public void setMushroomCount(int command) {
        this.field_70180_af.func_187227_b(MUSHROOM_COUNT, (Object)command);
    }

    public int getSackSwell() {
        return (Integer)this.field_70180_af.func_187225_a(SACK_SWELL);
    }

    public void setSackSwell(int command) {
        this.field_70180_af.func_187227_b(SACK_SWELL, (Object)command);
    }

    @Nullable
    public BlockPos getBeamTarget() {
        return ((Optional)this.func_184212_Q().func_187225_a(TARGETED_BLOCK_POS)).orElse(null);
    }

    public void setBeamTarget(@Nullable BlockPos beamTarget) {
        this.func_184212_Q().func_187227_b(TARGETED_BLOCK_POS, Optional.ofNullable(beamTarget));
    }

    public boolean isAltOrderMushroom() {
        return (Boolean)this.field_70180_af.func_187225_a(ALT_ORDER_MUSHROOMS);
    }

    @Nullable
    public BlockState getMushroomState() {
        return ((Optional)this.field_70180_af.func_187225_a(MUSHROOM_STATE)).orElse(null);
    }

    public void setMushroomState(@Nullable BlockState state) {
        this.field_70180_af.func_187227_b(MUSHROOM_STATE, Optional.ofNullable(state));
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (AgeableEntity)AMEntityRegistry.MUNGUS.func_200721_a((World)p_241840_1_);
    }

    public boolean isMushroomTarget(BlockPos pos) {
        if (this.getMushroomState() != null) {
            return this.field_70170_p.func_180495_p(pos).func_177230_c() == this.getMushroomState().func_177230_c();
        }
        return false;
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return this.shouldFollowMushroom(stack) && this.getMushroomCount() < 5;
    }

    @Override
    public void onGetItem(ItemEntity e) {
        if (this.shouldFollowMushroom(e.func_92059_d())) {
            BlockState state = EntityMungus.getMushroomBlockstate(e.func_92059_d().func_77973_b());
            if (this.getMushroomState() != null && state != null && state.func_177230_c() != this.getMushroomState().func_177230_c()) {
                this.setMushroomCount(0);
            }
            this.func_184185_a(SoundEvents.field_232750_iS_, this.func_70599_aP(), this.func_70647_i());
            this.setMushroomState(state);
            this.setMushroomCount(this.getMushroomCount() + 1);
        }
    }

    private boolean canSeeMushroom(BlockPos destinationBlock) {
        Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        Vector3d blockVec = Vector3d.func_237489_a_((Vector3i)destinationBlock);
        BlockRayTraceResult result = this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, blockVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        return result.func_216350_a().equals((Object)destinationBlock);
    }

    public boolean func_230262_K__() {
        return this.func_70089_S() && this.getMushroomState() != null && this.getMushroomCount() > 0;
    }

    public boolean isShearable(@Nonnull ItemStack item, World world, BlockPos pos) {
        return this.func_230262_K__();
    }

    public void func_230263_a_(SoundCategory category) {
        this.field_70170_p.func_217384_a(null, (Entity)this, SoundEvents.field_187763_eJ, category, 1.0f, 1.0f);
        if (!this.field_70170_p.func_201670_d() && this.getMushroomState() != null && this.getMushroomCount() > 0) {
            this.setMushroomCount(this.getMushroomCount() - 1);
            if (this.getMushroomCount() <= 0) {
                this.setMushroomState(null);
                this.setBeamTarget(null);
                this.beamCounter = Math.min(-1200, this.beamCounter);
            }
        }
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable PlayerEntity player, @Nonnull ItemStack item, World world, BlockPos pos, int fortune) {
        world.func_217384_a(null, (Entity)this, SoundEvents.field_187763_eJ, player == null ? SoundCategory.BLOCKS : SoundCategory.PLAYERS, 1.0f, 1.0f);
        if (!world.func_201670_d() && this.getMushroomState() != null && this.getMushroomCount() > 0) {
            this.setMushroomCount(this.getMushroomCount() - 1);
            if (this.getMushroomCount() <= 0) {
                this.setMushroomState(null);
                this.setBeamTarget(null);
                this.beamCounter = Math.min(-1200, this.beamCounter);
            }
        }
        return Collections.emptyList();
    }

    public boolean isReverting() {
        return (Boolean)this.field_70180_af.func_187225_a(REVERTING);
    }

    public boolean isWarpedMoscoReady() {
        return this.getMushroomState() == Blocks.field_235373_mm_.func_176223_P() && this.getMushroomCount() >= 5;
    }

    class AITargetMushrooms
    extends Goal {
        private final int searchLength;
        protected BlockPos destinationBlock;
        protected int runDelay = 70;

        private AITargetMushrooms() {
            this.searchLength = 20;
        }

        public boolean func_75253_b() {
            return this.destinationBlock != null && EntityMungus.this.isMushroomTarget((BlockPos)this.destinationBlock.func_239590_i_()) && this.isCloseToShroom(32.0);
        }

        public boolean isCloseToShroom(double dist) {
            return this.destinationBlock == null || EntityMungus.this.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.destinationBlock)) < dist * dist;
        }

        public boolean func_75250_a() {
            if (EntityMungus.this.getBeamTarget() != null || EntityMungus.this.beamCounter < 0 || EntityMungus.this.getMushroomCount() <= 0) {
                return false;
            }
            if (this.runDelay > 0) {
                --this.runDelay;
                return false;
            }
            this.runDelay = 70 + EntityMungus.this.field_70146_Z.nextInt(150);
            return this.searchForDestination();
        }

        public void func_75249_e() {
        }

        public void func_75246_d() {
            if (this.destinationBlock == null || !EntityMungus.this.isMushroomTarget(this.destinationBlock) || EntityMungus.this.beamCounter < 0) {
                this.func_75251_c();
            } else if (!EntityMungus.this.canSeeMushroom(this.destinationBlock)) {
                EntityMungus.this.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n(), (double)this.destinationBlock.func_177956_o(), (double)this.destinationBlock.func_177952_p(), 1.0);
            } else {
                EntityMungus.this.setBeamTarget(this.destinationBlock);
                if (!EntityMungus.this.func_70880_s()) {
                    EntityMungus.this.func_70661_as().func_75499_g();
                }
            }
        }

        public void func_75251_c() {
            EntityMungus.this.setBeamTarget(null);
        }

        protected boolean searchForDestination() {
            int lvt_1_1_ = this.searchLength;
            BlockPos lvt_3_1_ = EntityMungus.this.func_233580_cy_();
            BlockPos.Mutable lvt_4_1_ = new BlockPos.Mutable();
            for (int lvt_5_1_ = -5; lvt_5_1_ <= 5; ++lvt_5_1_) {
                for (int lvt_6_1_ = 0; lvt_6_1_ < lvt_1_1_; ++lvt_6_1_) {
                    int lvt_7_1_ = 0;
                    while (lvt_7_1_ <= lvt_6_1_) {
                        int lvt_8_1_;
                        int n = lvt_8_1_ = lvt_7_1_ < lvt_6_1_ && lvt_7_1_ > -lvt_6_1_ ? lvt_6_1_ : 0;
                        while (lvt_8_1_ <= lvt_6_1_) {
                            lvt_4_1_.func_239621_a_((Vector3i)lvt_3_1_, lvt_7_1_, lvt_5_1_ - 1, lvt_8_1_);
                            if (this.isMushroom(EntityMungus.this.field_70170_p, lvt_4_1_)) {
                                this.destinationBlock = lvt_4_1_;
                                return true;
                            }
                            lvt_8_1_ = lvt_8_1_ > 0 ? -lvt_8_1_ : 1 - lvt_8_1_;
                        }
                        lvt_7_1_ = lvt_7_1_ > 0 ? -lvt_7_1_ : 1 - lvt_7_1_;
                    }
                }
            }
            return false;
        }

        private boolean isMushroom(World world, BlockPos.Mutable lvt_4_1_) {
            return EntityMungus.this.isMushroomTarget((BlockPos)lvt_4_1_);
        }
    }
}

