/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHurtByTargetNotBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIPanicBaby;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.SnowLeopardAIMelee;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntitySnowLeopard
extends AnimalEntity
implements IAnimatedEntity,
ITargetsDroppedItems {
    public static final Animation ANIMATION_ATTACK_R = Animation.create((int)13);
    public static final Animation ANIMATION_ATTACK_L = Animation.create((int)13);
    private int animationTick;
    private Animation currentAnimation;
    public float prevSneakProgress;
    public float sneakProgress;
    public float prevTackleProgress;
    public float tackleProgress;
    public float prevSitProgress;
    public float sitProgress;
    private static final DataParameter<Boolean> TACKLING = EntityDataManager.func_187226_a(EntitySnowLeopard.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntitySnowLeopard.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SL_SNEAKING = EntityDataManager.func_187226_a(EntitySnowLeopard.class, (IDataSerializer)DataSerializers.field_187198_h);
    private boolean hasSlowedDown = false;
    private int sittingTime = 0;
    private int maxSitTime = 75;

    protected EntitySnowLeopard(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 2.0f;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.snowLeopardSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public static <T extends MobEntity> boolean canSnowLeopardSpawn(EntityType<EntitySnowLeopard> snowleperd, IWorld worldIn, SpawnReason reason, BlockPos p_223317_3_, Random random) {
        BlockState blockstate = worldIn.func_180495_p(p_223317_3_.func_177977_b());
        return (blockstate.func_235714_a_((ITag)BlockTags.field_242172_aH) || blockstate.func_203425_a(Blocks.field_150346_d) || blockstate.func_203425_a(Blocks.field_196658_i)) && worldIn.func_226659_b_(p_223317_3_, 0) > 8;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == AMItemRegistry.MOOSE_RIBS || stack.func_77973_b() == AMItemRegistry.COOKED_MOOSE_RIBS;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AnimalAIPanicBaby(this, 1.25));
        this.field_70714_bg.func_75776_a(3, (Goal)new SnowLeopardAIMelee(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(7, (Goal)new AnimalAIWanderRanged((CreatureEntity)this, 60, 1.0, 14, 7));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 15.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new AnimalAIHurtByTargetNotBaby(this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 10, false, true, AMEntityRegistry.buildPredicateFromTag(EntityTypeTags.func_219762_a().func_199910_a(AMTagRegistry.SNOW_LEOPARD_TARGETS))));
        this.field_70715_bh.func_75776_a(3, new CreatureAITargetItems((CreatureEntity)this, false, 30));
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233821_d_, (double)0.35f).func_233815_a_(Attributes.field_233819_b_, 64.0);
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.SNOW_LEOPARD_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.SNOW_LEOPARD_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.SNOW_LEOPARD_HURT;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(SL_SNEAKING, (Object)false);
        this.field_70180_af.func_187214_a(TACKLING, (Object)false);
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void setSitting(boolean bar) {
        this.field_70180_af.func_187227_b(SITTING, (Object)bar);
    }

    public boolean isTackling() {
        return (Boolean)this.field_70180_af.func_187225_a(TACKLING);
    }

    public void setTackling(boolean bar) {
        this.field_70180_af.func_187227_b(TACKLING, (Object)bar);
    }

    public boolean isSLSneaking() {
        return (Boolean)this.field_70180_af.func_187225_a(SL_SNEAKING);
    }

    public void setSlSneaking(boolean bar) {
        this.field_70180_af.func_187227_b(SL_SNEAKING, (Object)bar);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return (AgeableEntity)AMEntityRegistry.SNOW_LEOPARD.func_200721_a((World)serverWorld);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevSitProgress = this.sitProgress;
        this.prevSneakProgress = this.sneakProgress;
        this.prevTackleProgress = this.tackleProgress;
        if (this.isSitting() && this.sitProgress < 5.0f) {
            this.sitProgress += 0.5f;
        }
        if (!this.isSitting() && this.sitProgress > 0.0f) {
            this.sitProgress -= 0.5f;
        }
        if (this.isSLSneaking() && this.sneakProgress < 5.0f) {
            this.sneakProgress += 1.0f;
        }
        if (!this.isSLSneaking() && this.sneakProgress > 0.0f) {
            this.sneakProgress -= 1.0f;
        }
        if (this.isTackling() && this.tackleProgress < 3.0f) {
            this.tackleProgress += 1.0f;
        }
        if (!this.isTackling() && this.tackleProgress > 0.0f) {
            this.tackleProgress -= 1.0f;
        }
        if (this.isSLSneaking() && !this.hasSlowedDown) {
            this.hasSlowedDown = true;
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.25);
        }
        if (!this.isSLSneaking() && this.hasSlowedDown) {
            this.hasSlowedDown = false;
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.35f);
        }
        if (this.isTackling()) {
            this.field_70761_aq = this.field_70177_z;
        }
        if (this.isSitting() && ++this.sittingTime > this.maxSitTime) {
            this.setSitting(false);
            this.sittingTime = 0;
        }
        if (this.func_70638_az() != null && this.isSitting()) {
            this.setSitting(false);
        }
        if (!this.field_70170_p.field_72995_K && this.getAnimation() == NO_ANIMATION && this.func_70638_az() == null && !this.isSitting() && this.field_70146_Z.nextInt(200) == 0) {
            this.maxSitTime = 2600 + this.field_70146_Z.nextInt(2600);
            this.setSitting(true);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void func_213352_e(Vector3d vec3d) {
        if (this.isSitting()) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            vec3d = Vector3d.field_186680_a;
        }
        super.func_213352_e(vec3d);
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_ATTACK_L, ANIMATION_ATTACK_R};
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.func_77973_b().func_219971_r() && stack.func_77973_b().func_219967_s() != null && stack.func_77973_b().func_219967_s().func_221467_c();
    }

    @Override
    public void onGetItem(ItemEntity e) {
        this.func_70691_i(5.0f);
    }
}

