/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.LeashKnotEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class EntitySpectre
extends AnimalEntity
implements IFlyingAnimal {
    private static final DataParameter<Integer> CARDINAL_ORDINAL = EntityDataManager.func_187226_a(EntitySpectre.class, (IDataSerializer)DataSerializers.field_187192_b);
    public float birdPitch = 0.0f;
    public float prevBirdPitch = 0.0f;
    public Vector3d lurePos = null;

    protected EntitySpectre(EntityType type, World world) {
        super(type, world);
        this.field_70765_h = new MoveHelperController(this);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.spectreSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public static boolean canSpectreSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
        return true;
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.SPECTRE_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.SPECTRE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.SPECTRE_HURT;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 50.0).func_233815_a_(Attributes.field_233819_b_, 64.0).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233821_d_, 1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CARDINAL_ORDINAL, (Object)Direction.NORTH.func_176745_a());
    }

    public int getCardinalInt() {
        return (Integer)this.field_70180_af.func_187225_a(CARDINAL_ORDINAL);
    }

    public void setCardinalInt(int command) {
        this.field_70180_af.func_187227_b(CARDINAL_ORDINAL, (Object)command);
    }

    public Direction getCardinalDirection() {
        return Direction.func_82600_a((int)this.getCardinalInt());
    }

    public void setCardinalDirection(Direction dir) {
        this.setCardinalInt(dir.func_176745_a());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new TemptHeartGoal(this, 1.0, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{AMItemRegistry.SOUL_HEART}), false));
        this.field_70714_bg.func_75776_a(2, (Goal)new FlyGoal(this));
    }

    public boolean func_180431_b(DamageSource source) {
        return !source.func_82725_o() && source != DamageSource.field_76380_i || super.func_180431_b(source);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.field_70125_A = 0.0f;
        this.randomizeDirection();
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void func_70071_h_() {
        float f2;
        super.func_70071_h_();
        Vector3d vector3d1 = this.func_213322_ci();
        this.field_70761_aq = this.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d1.field_72450_a, (double)vector3d1.field_72449_c)) * 57.295776f;
        this.prevBirdPitch = this.birdPitch;
        this.field_70145_X = true;
        this.birdPitch = f2 = (float)(-((double)((float)this.func_213322_ci().field_72448_b * 0.5f) * 57.2957763671875));
        if (this.func_110166_bE() != null && !(this.func_110166_bE() instanceof LeashKnotEntity)) {
            Entity entity = this.func_110166_bE();
            float f = this.func_70032_d(entity);
            if (f > 10.0f) {
                double d0 = (this.func_226277_ct_() - entity.func_226277_ct_()) / (double)f;
                double d1 = (this.func_226278_cu_() - entity.func_226278_cu_()) / (double)f;
                double d2 = (this.func_226281_cx_() - entity.func_226281_cx_()) / (double)f;
                entity.func_213317_d(entity.func_213322_ci().func_72441_c(Math.copySign(d0 * d0 * 0.4, d0), Math.copySign(d1 * d1 * 0.4, d1), Math.copySign(d2 * d2 * 0.4, d2)));
            }
            entity.field_70143_R = 0.0f;
            if (entity.func_213322_ci().field_72448_b < 0.0) {
                entity.func_213317_d(entity.func_213322_ci().func_216372_d(1.0, (double)0.7f, 1.0));
            }
            if (entity.func_225608_bj_()) {
                this.func_110160_i(true, true);
            }
        }
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return null;
    }

    protected void func_110159_bB() {
        if (this.func_110166_bE() != null) {
            if (this.func_110166_bE().func_184218_aH() || this.func_110166_bE() instanceof LeashKnotEntity) {
                super.func_110159_bB();
                return;
            }
            float f = this.func_70032_d(this.func_110166_bE());
            if (f > 30.0f) {
                double lvt_3_1_ = (this.func_110166_bE().func_226277_ct_() - this.func_226277_ct_()) / (double)f;
                double lvt_5_1_ = (this.func_110166_bE().func_226278_cu_() - this.func_226278_cu_()) / (double)f;
                double lvt_7_1_ = (this.func_110166_bE().func_226281_cx_() - this.func_226281_cx_()) / (double)f;
                this.func_213317_d(this.func_213322_ci().func_72441_c(Math.copySign(lvt_3_1_ * lvt_3_1_ * 0.4, lvt_3_1_), Math.copySign(lvt_5_1_ * lvt_5_1_ * 0.4, lvt_5_1_), Math.copySign(lvt_7_1_ * lvt_7_1_ * 0.4, lvt_7_1_)));
            }
        }
        if (this.field_110170_bx != null) {
            this.func_110165_bF();
        }
        if (!(this.func_110166_bE() == null || this.func_70089_S() && this.func_110166_bE().func_70089_S())) {
            this.func_110160_i(true, true);
        }
    }

    private void randomizeDirection() {
        this.setCardinalInt(2 + this.field_70146_Z.nextInt(3));
    }

    class TemptHeartGoal
    extends Goal {
        protected final EntitySpectre creature;
        private final EntityPredicate ENTITY_PREDICATE = new EntityPredicate().func_221013_a(64.0).func_221008_a().func_221011_b().func_221009_d().func_221014_c();
        private final double speed;
        private final Ingredient temptItem;
        protected PlayerEntity closestPlayer;
        private int delayTemptCounter;

        public TemptHeartGoal(EntitySpectre p_i47822_1_, double p_i47822_2_, Ingredient p_i47822_4_, boolean p_i47822_5_) {
            this(p_i47822_1_, p_i47822_2_, p_i47822_5_, p_i47822_4_);
        }

        public TemptHeartGoal(EntitySpectre p_i47823_1_, double p_i47823_2_, boolean p_i47823_4_, Ingredient p_i47823_5_) {
            this.creature = p_i47823_1_;
            this.speed = p_i47823_2_;
            this.temptItem = p_i47823_5_;
        }

        public boolean func_75250_a() {
            if (this.delayTemptCounter > 0) {
                --this.delayTemptCounter;
                return false;
            }
            this.closestPlayer = this.creature.field_70170_p.func_217370_a(this.ENTITY_PREDICATE, (LivingEntity)this.creature);
            if (this.closestPlayer == null || this.creature.func_110166_bE() == this.closestPlayer) {
                return false;
            }
            return this.isTempting(this.closestPlayer.func_184614_ca()) || this.isTempting(this.closestPlayer.func_184592_cb());
        }

        protected boolean isTempting(ItemStack p_188508_1_) {
            return this.temptItem.test(p_188508_1_);
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        public void func_75249_e() {
            this.creature.lurePos = this.closestPlayer.func_213303_ch();
        }

        public void func_75251_c() {
            this.closestPlayer = null;
            this.delayTemptCounter = 100;
            this.creature.lurePos = null;
        }

        public void func_75246_d() {
            this.creature.func_70671_ap().func_75651_a((Entity)this.closestPlayer, (float)(this.creature.func_184649_cE() + 20), (float)this.creature.func_70646_bf());
            if (this.creature.func_70068_e((Entity)this.closestPlayer) < 6.25) {
                this.creature.func_70661_as().func_75499_g();
            } else {
                this.creature.func_70605_aq().func_75642_a(this.closestPlayer.func_226277_ct_(), this.closestPlayer.func_226278_cu_() + (double)this.closestPlayer.func_70047_e(), this.closestPlayer.func_226281_cx_(), this.speed);
            }
        }
    }

    private class FlyGoal
    extends Goal {
        private final EntitySpectre parentEntity;
        boolean island = false;
        float circlingTime = 0.0f;
        float circleDistance = 14.0f;
        float maxCirclingTime = 80.0f;
        boolean clockwise = false;
        private BlockPos target = null;
        private int islandCheckTime = 20;

        public FlyGoal(EntitySpectre sunbird) {
            this.parentEntity = sunbird;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (this.parentEntity.lurePos != null) {
                return false;
            }
            MovementController movementcontroller = this.parentEntity.func_70605_aq();
            this.clockwise = EntitySpectre.this.field_70146_Z.nextBoolean();
            this.circleDistance = 5 + EntitySpectre.this.field_70146_Z.nextInt(10);
            if (!movementcontroller.func_75640_a() || this.target == null) {
                BlockPos blockPos = this.target = this.island ? this.getIslandPos(this.parentEntity.func_233580_cy_()) : this.getBlockFromDirection();
                if (this.target != null) {
                    this.parentEntity.func_70605_aq().func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 1.0);
                }
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.parentEntity.lurePos == null;
        }

        public void func_75251_c() {
            this.island = false;
            this.islandCheckTime = 0;
            this.circleDistance = 5 + EntitySpectre.this.field_70146_Z.nextInt(10);
            this.circlingTime = 0.0f;
            this.clockwise = EntitySpectre.this.field_70146_Z.nextBoolean();
            this.target = null;
        }

        public void func_75246_d() {
            if (this.islandCheckTime-- <= 0) {
                this.islandCheckTime = 20;
                if (this.circlingTime == 0.0f) {
                    boolean bl = this.island = this.parentEntity.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, this.parentEntity.func_233580_cy_()).func_177956_o() > 2;
                    if (this.island) {
                        this.parentEntity.randomizeDirection();
                    }
                }
            }
            if (this.island) {
                this.circlingTime += 1.0f;
                if (this.circlingTime > 100.0f) {
                    this.island = false;
                    this.islandCheckTime = 1200;
                }
            } else if (this.circlingTime > 0.0f) {
                this.circlingTime -= 1.0f;
            }
            if (this.target == null) {
                BlockPos blockPos = this.target = this.island ? this.getIslandPos(this.parentEntity.func_233580_cy_()) : this.getBlockFromDirection();
            }
            if (!this.island) {
                this.parentEntity.field_70177_z = this.parentEntity.getCardinalDirection().func_185119_l();
            }
            if (this.target != null) {
                this.parentEntity.func_70605_aq().func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 1.0);
                if (this.parentEntity.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.target)) < 5.5) {
                    this.target = null;
                }
            }
        }

        public BlockPos getBlockFromDirection() {
            float radius = 15.0f;
            BlockPos forwards = this.parentEntity.func_233580_cy_().func_177967_a(this.parentEntity.getCardinalDirection(), (int)Math.ceil(radius));
            int height = 0;
            height = EntitySpectre.this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, forwards).func_177956_o() < 15 ? 70 + EntitySpectre.this.field_70146_Z.nextInt(2) : EntitySpectre.this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, forwards).func_177956_o() + 10 + EntitySpectre.this.field_70146_Z.nextInt(10);
            return new BlockPos(forwards.func_177958_n(), height, forwards.func_177952_p());
        }

        public BlockPos getIslandPos(BlockPos orbit) {
            float angle = 0.05235988f * (this.clockwise ? -this.circlingTime : this.circlingTime);
            double extraX = this.circleDistance * MathHelper.func_76126_a((float)angle);
            double extraZ = this.circleDistance * MathHelper.func_76134_b((float)angle);
            int height = EntitySpectre.this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, orbit).func_177956_o();
            if (height < 3) {
                this.island = false;
                return this.getBlockFromDirection();
            }
            BlockPos pos = new BlockPos((double)orbit.func_177958_n() + extraX, (double)Math.min(height + 10, orbit.func_177956_o() + EntitySpectre.this.field_70146_Z.nextInt(3) - EntitySpectre.this.field_70146_Z.nextInt(1)), (double)orbit.func_177952_p() + extraZ);
            return pos;
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final EntitySpectre parentEntity;

        public MoveHelperController(EntitySpectre sunbird) {
            super((MobEntity)sunbird);
            this.parentEntity = sunbird;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                Vector3d vector3d = new Vector3d(this.field_75646_b - this.parentEntity.func_226277_ct_(), this.field_75647_c - this.parentEntity.func_226278_cu_(), this.field_75644_d - this.parentEntity.func_226281_cx_());
                double d5 = vector3d.func_72433_c();
                if (d5 < 0.3) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_186678_a(0.5));
                } else {
                    double d0 = this.field_75646_b - this.parentEntity.func_226277_ct_();
                    double d1 = this.field_75647_c - this.parentEntity.func_226278_cu_();
                    double d2 = this.field_75644_d - this.parentEntity.func_226281_cx_();
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(vector3d.func_186678_a(this.field_75645_e * 0.05 / d5)));
                    Vector3d vector3d1 = this.parentEntity.func_213322_ci();
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d1.field_72450_a, (double)vector3d1.field_72449_c)) * 57.295776f;
                }
            }
        }

        private boolean func_220673_a(Vector3d p_220673_1_, int p_220673_2_) {
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.parentEntity.field_70170_p.func_226665_a__((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_191194_a(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }
}

