/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.enchantment.AMEnchantmentRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityStraddleboard
extends Entity
implements IJumpingMount {
    private static final DataParameter<ItemStack> ITEMSTACK = EntityDataManager.func_187226_a(EntityStraddleboard.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(EntityStraddleboard.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(EntityStraddleboard.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> ROCKING_TICKS = EntityDataManager.func_187226_a(EntityStraddleboard.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityStraddleboard.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DEFAULT_COLOR = EntityDataManager.func_187226_a(EntityStraddleboard.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float boardRot = 0.0f;
    public float prevBoardRot = 0.0f;
    private double lastYd;
    private boolean rocking;
    private boolean downwards;
    private float rockingIntensity;
    private float rockingAngle;
    private float prevRockingAngle;
    private boolean jumpOutOfLava = false;
    private float outOfControlTicks;
    private BoatEntity.Status status;
    private BoatEntity.Status previousStatus;
    private float momentum;
    private double waterLevel;
    private float boatGlide;
    private int extinguishTimer = 0;

    public EntityStraddleboard(EntityType<?> p_i48580_1_, World p_i48580_2_) {
        super(p_i48580_1_, p_i48580_2_);
        this.field_70156_m = true;
    }

    public EntityStraddleboard(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(AMEntityRegistry.STRADDLEBOARD, world);
    }

    public EntityStraddleboard(World worldIn, double x, double y, double z) {
        this(AMEntityRegistry.STRADDLEBOARD, worldIn);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public static boolean func_242378_a(Entity p_242378_0_, Entity entity) {
        return (entity.func_241845_aY() || entity.func_70104_M()) && !p_242378_0_.func_184223_x(entity);
    }

    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(ITEMSTACK, (Object)new ItemStack((IItemProvider)AMItemRegistry.STRADDLEBOARD));
        this.field_70180_af.func_187214_a(ROCKING_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(DEFAULT_COLOR, (Object)true);
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
        this.field_70180_af.func_187214_a(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean func_241849_j(Entity entity) {
        return EntityStraddleboard.func_242378_a(this, entity);
    }

    public boolean func_241845_aY() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    protected Vector3d func_241839_a(Direction.Axis axis, TeleportationRepositioner.Result result) {
        return LivingEntity.func_242288_h((Vector3d)super.func_241839_a(axis, result));
    }

    public double func_70042_X() {
        return 0.9;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            this.func_70018_K();
            this.setRockingTicks(25);
            boolean bl = flag = source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamageTaken() > 40.0f) {
                if (!flag) {
                    PlayerEntity p = null;
                    if (source.func_76346_g() instanceof PlayerEntity) {
                        p = (PlayerEntity)source.func_76346_g();
                    }
                    if (this.func_184179_bs() != null && this.func_184179_bs() instanceof PlayerEntity) {
                        p = (PlayerEntity)this.func_184179_bs();
                    }
                    boolean dropItem = true;
                    if (p != null && this.getEnchant(AMEnchantmentRegistry.STRADDLE_BOARDRETURN) > 0 && p.func_191521_c(this.getItemBoard())) {
                        dropItem = false;
                    }
                    if (dropItem && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                        this.func_199701_a_(this.getItemBoard());
                    }
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    private ItemStack getItemBoard() {
        return this.getItemStack();
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn instanceof EntityStraddleboard) {
            if (entityIn.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entityIn);
            }
        } else if (entityIn.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b) {
            super.func_70108_f(entityIn);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70057_ab() {
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    private BoatEntity.Status getBoatStatus() {
        BoatEntity.Status boatentity$status = this.getUnderwaterStatus();
        if (boatentity$status != null) {
            this.waterLevel = this.func_174813_aQ().field_72337_e;
            return boatentity$status;
        }
        if (this.checkInWater()) {
            return BoatEntity.Status.IN_WATER;
        }
        float f = this.getBoatGlide();
        if (f > 0.0f) {
            this.boatGlide = f;
            return BoatEntity.Status.ON_LAND;
        }
        return BoatEntity.Status.IN_AIR;
    }

    public float getBoatGlide() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b - 0.001, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        int i = MathHelper.func_76128_c((double)axisalignedbb1.field_72340_a) - 1;
        int j = MathHelper.func_76143_f((double)axisalignedbb1.field_72336_d) + 1;
        int k = MathHelper.func_76128_c((double)axisalignedbb1.field_72338_b) - 1;
        int l = MathHelper.func_76143_f((double)axisalignedbb1.field_72337_e) + 1;
        int i1 = MathHelper.func_76128_c((double)axisalignedbb1.field_72339_c) - 1;
        int j1 = MathHelper.func_76143_f((double)axisalignedbb1.field_72334_f) + 1;
        VoxelShape voxelshape = VoxelShapes.func_197881_a((AxisAlignedBB)axisalignedbb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutable.func_181079_c(l1, k2, i2);
                    BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
                    if (blockstate.func_177230_c() instanceof LilyPadBlock || !VoxelShapes.func_197879_c((VoxelShape)blockstate.func_196952_d((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable).func_197751_a((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
                    f += blockstate.getSlipperiness((IWorldReader)this.field_70170_p, (BlockPos)blockpos$mutable, (Entity)this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    private boolean checkInWater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72338_b - 0.001));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.waterLevel = Double.MIN_VALUE;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && !fluidstate.func_206884_a((ITag)FluidTags.field_206960_b)) continue;
                    float f = (float)l1 + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= axisalignedbb.field_72338_b < (double)f;
                }
            }
        }
        return flag;
    }

    private void updateMotion() {
        double d0 = -0.04f;
        double d1 = this.func_189652_ae() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        this.momentum = 0.05f;
        if (this.previousStatus == BoatEntity.Status.IN_AIR && this.status != BoatEntity.Status.IN_AIR && this.status != BoatEntity.Status.ON_LAND) {
            this.waterLevel = this.func_226283_e_(1.0);
            this.func_70107_b(this.func_226277_ct_(), (double)(this.getWaterLevelAbove() - this.func_213302_cg()) + 0.25, this.func_226281_cx_());
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 1.0, 1.0));
            this.lastYd = 0.0;
            this.status = BoatEntity.Status.IN_WATER;
        } else {
            if (this.status == BoatEntity.Status.IN_WATER) {
                d2 = (this.waterLevel - this.func_226278_cu_()) / (double)this.func_213302_cg();
                this.momentum = 0.9f;
            } else if (this.status == BoatEntity.Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                this.momentum = 0.9f;
            } else if (this.status == BoatEntity.Status.UNDER_WATER) {
                d2 = 0.01f;
                this.momentum = 0.45f;
            } else if (this.status == BoatEntity.Status.IN_AIR) {
                this.momentum = 0.9f;
            } else if (this.status == BoatEntity.Status.ON_LAND) {
                this.momentum = this.boatGlide;
                if (this.func_184179_bs() instanceof PlayerEntity) {
                    this.boatGlide /= 2.0f;
                }
            }
            Vector3d vector3d = this.func_213322_ci();
            this.func_213293_j(vector3d.field_72450_a * (double)this.momentum, vector3d.field_72448_b + d1, vector3d.field_72449_c * (double)this.momentum);
            if (d2 > 0.0) {
                Vector3d vector3d1 = this.func_213322_ci();
                this.func_213293_j(vector3d1.field_72450_a, (vector3d1.field_72448_b + d2 * 0.06153846016296973) * 0.75, vector3d1.field_72449_c);
            }
        }
    }

    public boolean isDefaultColor() {
        return (Boolean)this.field_70180_af.func_187225_a(DEFAULT_COLOR);
    }

    public void setDefaultColor(boolean bar) {
        this.field_70180_af.func_187227_b(DEFAULT_COLOR, (Object)bar);
    }

    public int getColor() {
        if (this.isDefaultColor()) {
            return 11387863;
        }
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public void setColor(int index) {
        this.field_70180_af.func_187227_b(COLOR, (Object)index);
    }

    @Nullable
    private BoatEntity.Status getUnderwaterStatus() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double d0 = axisalignedbb.field_72337_e + 0.001;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)d0);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && (!fluidstate.func_206884_a((ITag)FluidTags.field_206960_b) || !(d0 < (double)((float)blockpos$mutable.func_177956_o() + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable))))) continue;
                    if (!fluidstate.func_206889_d()) {
                        return BoatEntity.Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? BoatEntity.Status.UNDER_WATER : null;
    }

    public void func_70071_h_() {
        float f2;
        this.prevBoardRot = this.boardRot;
        super.func_70071_h_();
        this.previousStatus = this.status;
        this.status = this.getBoatStatus();
        this.func_234318_eL_();
        this.func_145775_I();
        if (this.func_70094_T()) {
            this.func_213282_i(this.func_226277_ct_(), (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.func_226281_cx_());
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        if (this.func_180799_ab()) {
            this.func_189654_d(true);
            if (this.field_233554_M_.getDouble((Object)FluidTags.field_206960_b) >= (double)this.func_213302_cg()) {
                this.func_213293_j(0.0, 0.1, 0.0);
            }
        } else {
            this.func_189654_d(false);
        }
        this.field_70125_A = f2 = (float)(-((double)((float)this.func_213322_ci().field_72448_b * 0.5f) * 57.2957763671875));
        if (this.extinguishTimer > 0) {
            --this.extinguishTimer;
        }
        this.updateRocking();
        Entity controller = this.func_184179_bs();
        if (controller instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)controller;
            if (this.field_70173_aa % 50 == 0 && this.getEnchant(AMEnchantmentRegistry.STRADDLE_LAVAWAX) > 0) {
                player.func_195064_c(new EffectInstance(Effects.field_76426_n, 100, 0, true, false));
            }
            if (player.func_223314_ad() > 0 && this.extinguishTimer == 0) {
                player.func_70066_B();
            }
            this.field_70177_z = player.field_70126_B;
            Vector3d vector3d = this.func_213322_ci();
            if (vector3d.field_72448_b > -0.5) {
                this.field_70143_R = 1.0f;
            }
            Vector3d vector3d1 = player.func_70040_Z();
            float f = player.field_70125_A * ((float)Math.PI / 180);
            double d1 = Math.sqrt(vector3d1.field_72450_a * vector3d1.field_72450_a + vector3d1.field_72449_c * vector3d1.field_72449_c);
            double d3 = Math.sqrt(EntityStraddleboard.func_213296_b((Vector3d)vector3d));
            double d4 = vector3d1.func_72433_c();
            float f1 = MathHelper.func_76134_b((float)f);
            f1 = (float)((double)f1 * (double)f1 * Math.min(1.0, d4 / 0.4));
            double d5 = vector3d.field_72448_b * -0.1 * (double)f1;
            float slow = player.field_191988_bg < 0.0f ? 0.0f : player.field_191988_bg * 0.115f;
            float threshold = 0.05f;
            if (this.field_70126_B - this.field_70177_z > threshold) {
                this.boardRot += 2.0f;
                slow *= 0.0f;
            } else if (this.field_70126_B - this.field_70177_z < -threshold) {
                this.boardRot -= 2.0f;
                slow *= 0.0f;
            } else if (this.boardRot > 0.0f) {
                this.boardRot = Math.max(this.boardRot - 10.0f, 0.0f);
            } else if (this.boardRot < 0.0f) {
                this.boardRot = Math.min(this.boardRot + 10.0f, 0.0f);
            }
            this.boardRot = MathHelper.func_76131_a((float)this.boardRot, (float)-25.0f, (float)25.0f);
            vector3d = vector3d.func_72441_c(vector3d1.field_72450_a * (double)slow / d1, 0.0, vector3d1.field_72449_c * (double)slow / d1);
            if (d1 > 0.0) {
                vector3d = vector3d.func_72441_c((vector3d1.field_72450_a / d1 * d3 - vector3d.field_72450_a) * 0.1, 0.0, (vector3d1.field_72449_c / d1 * d3 - vector3d.field_72449_c) * 0.1);
            }
            this.func_213317_d(vector3d.func_216372_d((double)0.99f, 1.0, (double)0.99f));
            if (player.func_70094_T()) {
                player.func_233575_bb_();
                this.func_70097_a(DamageSource.field_76377_j, 100.0f);
            }
        }
        this.updateMotion();
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    public double func_226280_cw_() {
        return this.func_226278_cu_() + (double)0.3f;
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        if (!this.field_70170_p.field_72995_K) {
            EntityStraddleboard copy = (EntityStraddleboard)AMEntityRegistry.STRADDLEBOARD.func_200721_a(this.field_70170_p);
            CompoundNBT tag = new CompoundNBT();
            this.func_213281_b(tag);
            copy.func_70037_a(tag);
            copy.func_82149_j(passenger);
            this.field_70170_p.func_217376_c((Entity)copy);
        }
        this.func_70106_y();
    }

    private void func_234318_eL_() {
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof PlayerEntity)) continue;
            PlayerEntity player = (PlayerEntity)passenger;
            return player;
        }
        return null;
    }

    private void updateRocking() {
        if (this.field_70170_p.field_72995_K) {
            int i = this.getRockingTicks();
            this.rockingIntensity = i > 0 ? (this.rockingIntensity += 1.0f) : (this.rockingIntensity -= 0.1f);
            this.rockingIntensity = MathHelper.func_76131_a((float)this.rockingIntensity, (float)0.0f, (float)1.0f);
            this.prevRockingAngle = this.rockingAngle;
            this.rockingAngle = 10.0f * (float)Math.sin(0.5f * (float)this.field_70170_p.func_82737_E()) * this.rockingIntensity;
        } else {
            int k;
            if (!this.rocking) {
                this.setRockingTicks(0);
            }
            if ((k = this.getRockingTicks()) > 0) {
                this.setRockingTicks(--k);
                int j = 60 - k - 1;
                if (j > 0 && k == 0) {
                    this.setRockingTicks(0);
                    Vector3d vector3d = this.func_213322_ci();
                    if (this.downwards) {
                        this.func_213317_d(vector3d.func_72441_c(0.0, -0.7, 0.0));
                        this.func_184226_ay();
                    } else {
                        this.func_213293_j(vector3d.field_72450_a, this.func_205708_a(PlayerEntity.class) ? 2.7 : 0.6, vector3d.field_72449_c);
                    }
                }
                this.rocking = false;
            }
        }
    }

    public float getWaterLevelAbove() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72337_e - this.lastYd));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(l1, k1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) || fluidstate.func_206884_a((ITag)FluidTags.field_206960_b)) {
                        f = Math.max(f, fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos$mutable.func_177956_o() + f;
        }
        return l + 1;
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (player.func_226563_dT_()) {
            return ActionResultType.PASS;
        }
        if (!this.field_70170_p.field_72995_K) {
            return player.func_184220_m((Entity)this) ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
        return ActionResultType.SUCCESS;
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_TAKEN)).floatValue();
    }

    public void setDamageTaken(float damageTaken) {
        this.field_70180_af.func_187227_b(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    private int getRockingTicks() {
        return (Integer)this.field_70180_af.func_187225_a(ROCKING_TICKS);
    }

    private void setRockingTicks(int ticks) {
        this.field_70180_af.func_187227_b(ROCKING_TICKS, (Object)ticks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRockingAngle(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevRockingAngle, (float)this.rockingAngle);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setDefaultColor(compound.func_74767_n("IsDefColor"));
        if (compound.func_74764_b("BoardStack")) {
            this.setItemStack(ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("BoardStack")));
        }
        this.setColor(compound.func_74762_e("Color"));
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74757_a("IsDefColor", this.isDefaultColor());
        compound.func_74768_a("Color", this.getColor());
        if (!this.getItemStack().func_190926_b()) {
            CompoundNBT stackTag = new CompoundNBT();
            this.getItemStack().func_77955_b(stackTag);
            compound.func_218657_a("BoardStack", (INBT)stackTag);
        }
    }

    public void func_110206_u(int i) {
    }

    public boolean func_184776_b() {
        return this.field_70170_p.func_180495_p(this.func_226270_aj_()).func_204520_s().func_206884_a((ITag)FluidTags.field_206960_b);
    }

    public void func_184775_b(int i) {
        this.jumpOutOfLava = true;
        this.field_70160_al = true;
        float scaled = (float)i * 0.01f + 0.1f * (float)this.getEnchant(AMEnchantmentRegistry.STRADDLE_JUMP);
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)(scaled * 1.5f), 0.0));
    }

    private int getEnchant(Enchantment enchantment) {
        return EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)this.getItemBoard());
    }

    public boolean shouldSerpentFriend() {
        return this.getEnchant(AMEnchantmentRegistry.STRADDLE_SERPENTFRIEND) > 0;
    }

    public void func_184777_r_() {
    }

    public void setItemStack(ItemStack item) {
        this.field_70180_af.func_187227_b(ITEMSTACK, (Object)item);
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(ITEMSTACK);
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

