/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityStraddler;
import com.github.alexthe666.alexsmobs.entity.ISemiAquatic;
import com.github.alexthe666.alexsmobs.entity.ai.AquaticMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.BoneSerpentPathNavigator;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityStradpole
extends WaterMobEntity {
    private static final DataParameter<Boolean> FROM_BUCKET = EntityDataManager.func_187226_a(EntityStradpole.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DESPAWN_SOON = EntityDataManager.func_187226_a(EntityStradpole.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> LAUNCHED = EntityDataManager.func_187226_a(EntityStradpole.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<UUID>> PARENT_UUID = EntityDataManager.func_187226_a(EntityStradpole.class, (IDataSerializer)DataSerializers.field_187203_m);
    public float swimPitch = 0.0f;
    public float prevSwimPitch = 0.0f;
    private int despawnTimer = 0;
    private int ricochetCount = 0;

    protected EntityStradpole(EntityType type, World world) {
        super(type, world);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
        this.field_70765_h = new AquaticMoveController((CreatureEntity)this, 1.4f);
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203816_ay;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_203813_aA;
    }

    public int func_70641_bl() {
        return 2;
    }

    protected ItemStack getFishBucket() {
        ItemStack stack = new ItemStack((IItemProvider)AMItemRegistry.STRADPOLE_BUCKET);
        if (this.func_145818_k_()) {
            stack.func_200302_a(this.func_200201_e());
        }
        return stack;
    }

    protected ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (itemstack.func_77973_b() == AMItemRegistry.MOSQUITO_LARVA) {
            if (!p_230254_1_.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            if (this.field_70146_Z.nextFloat() < 0.45f) {
                EntityStraddler straddler = (EntityStraddler)AMEntityRegistry.STRADDLER.func_200721_a(this.field_70170_p);
                straddler.func_82149_j((Entity)this);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_217376_c((Entity)straddler);
                }
                this.func_70106_y();
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (itemstack.func_77973_b() == Items.field_151129_at && this.func_70089_S()) {
            this.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
            itemstack.func_190918_g(1);
            ItemStack itemstack1 = this.getFishBucket();
            if (!this.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)p_230254_1_, itemstack1);
            }
            if (itemstack.func_190926_b()) {
                p_230254_1_.func_184611_a(p_230254_2_, itemstack1);
            } else if (!p_230254_1_.field_71071_by.func_70441_a(itemstack1)) {
                p_230254_1_.func_71019_a(itemstack1, false);
            }
            this.func_70106_y();
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 4.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PARENT_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(DESPAWN_SOON, (Object)false);
        this.field_70180_af.func_187214_a(LAUNCHED, (Object)false);
        this.field_70180_af.func_187214_a(FROM_BUCKET, (Object)false);
    }

    private boolean isFromBucket() {
        return (Boolean)this.field_70180_af.func_187225_a(FROM_BUCKET);
    }

    public void setFromBucket(boolean p_203706_1_) {
        this.field_70180_af.func_187227_b(FROM_BUCKET, (Object)p_203706_1_);
    }

    @Nullable
    public UUID getParentId() {
        return ((Optional)this.field_70180_af.func_187225_a(PARENT_UUID)).orElse(null);
    }

    public void setParentId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(PARENT_UUID, Optional.ofNullable(uniqueId));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.getParentId() != null) {
            compound.func_186854_a("ParentUUID", this.getParentId());
        }
        compound.func_74757_a("FromBucket", this.isFromBucket());
        compound.func_74757_a("DespawnSoon", this.isDespawnSoon());
    }

    public boolean func_213392_I() {
        return super.func_213392_I() || this.isFromBucket();
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.stradpoleSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public static boolean canStradpoleSpawn(EntityType<EntityStradpole> p_234314_0_, IWorld p_234314_1_, SpawnReason p_234314_2_, BlockPos p_234314_3_, Random p_234314_4_) {
        if (p_234314_1_.func_204610_c(p_234314_3_).func_206884_a((ITag)FluidTags.field_206960_b) && !p_234314_1_.func_204610_c(p_234314_3_.func_177977_b()).func_206884_a((ITag)FluidTags.field_206960_b)) {
            return p_234314_1_.func_175623_d(p_234314_3_.func_177984_a());
        }
        return false;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_186855_b("ParentUUID")) {
            this.setParentId(compound.func_186857_a("ParentUUID"));
        }
        this.setFromBucket(compound.func_74767_n("FromBucket"));
        this.setDespawnSoon(compound.func_74767_n("DespawnSoon"));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new StradpoleAISwim(this, 1.0, 10));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        if (!worldIn.func_180495_p(pos).func_204520_s().func_206888_e()) {
            return 15.0f;
        }
        return Float.NEGATIVE_INFINITY;
    }

    public boolean isDespawnSoon() {
        return (Boolean)this.field_70180_af.func_187225_a(DESPAWN_SOON);
    }

    public void setDespawnSoon(boolean despawnSoon) {
        this.field_70180_af.func_187227_b(DESPAWN_SOON, (Object)despawnSoon);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new BoneSerpentPathNavigator((MobEntity)this, worldIn);
    }

    public void func_70071_h_() {
        float f2;
        float f = 1.0f;
        if (((Boolean)this.field_70180_af.func_187225_a(LAUNCHED)).booleanValue()) {
            this.field_70761_aq = this.field_70177_z;
            RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, this::func_230298_a_);
            if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                this.onImpact(raytraceresult);
            }
            f = 0.1f;
        }
        super.func_70071_h_();
        boolean liquid = this.func_70090_H() || this.func_180799_ab();
        this.prevSwimPitch = this.swimPitch;
        this.swimPitch = f2 = (float)(-((double)((float)this.func_213322_ci().field_72448_b * (liquid ? 2.5f : f)) * 57.2957763671875));
        if (this.field_70122_E && !this.func_70090_H() && !this.func_180799_ab()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.2f)));
            this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
            this.field_70122_E = false;
            this.field_70160_al = true;
        }
        this.func_189654_d(false);
        if (liquid) {
            this.func_189654_d(true);
        }
        if (this.isDespawnSoon()) {
            ++this.despawnTimer;
            if (this.despawnTimer > 100) {
                this.despawnTimer = 0;
                this.func_70656_aK();
                this.func_70106_y();
            }
        }
    }

    private void onImpact(RayTraceResult raytraceresult) {
        BlockRayTraceResult traceResult;
        BlockState blockstate;
        RayTraceResult.Type raytraceresult$type = raytraceresult.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.ENTITY) {
            this.onEntityHit((EntityRayTraceResult)raytraceresult);
        } else if (raytraceresult$type == RayTraceResult.Type.BLOCK && !(blockstate = this.field_70170_p.func_180495_p((traceResult = (BlockRayTraceResult)raytraceresult).func_216350_a())).func_196952_d((IBlockReader)this.field_70170_p, traceResult.func_216350_a()).func_197766_b()) {
            Direction face = traceResult.func_216354_b();
            Vector3d prevMotion = this.func_213322_ci();
            double motionX = prevMotion.func_82615_a();
            double motionY = prevMotion.func_82617_b();
            double motionZ = prevMotion.func_82616_c();
            switch (face) {
                case EAST: 
                case WEST: {
                    motionX = -motionX;
                    break;
                }
                case SOUTH: 
                case NORTH: {
                    motionZ = -motionZ;
                    break;
                }
                default: {
                    motionY = -motionY;
                }
            }
            this.func_213293_j(motionX, motionY, motionZ);
            if (this.field_70173_aa > 200 || this.ricochetCount > 20) {
                this.field_70180_af.func_187227_b(LAUNCHED, (Object)false);
            } else {
                ++this.ricochetCount;
            }
        }
    }

    public Entity getParent() {
        UUID id = this.getParentId();
        if (id != null && !this.field_70170_p.field_72995_K) {
            return ((ServerWorld)this.field_70170_p).func_217461_a(id);
        }
        return null;
    }

    private void onEntityHit(EntityRayTraceResult raytraceresult) {
        Entity entity = this.getParent();
        if (entity instanceof LivingEntity && !this.field_70170_p.field_72995_K && raytraceresult.func_216348_a() instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)raytraceresult.func_216348_a();
            target.func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)((LivingEntity)entity)).func_76349_b(), 3.0f);
            target.func_233627_a_(0.7f, entity.func_226277_ct_() - this.func_226277_ct_(), entity.func_226281_cx_() - this.func_226281_cx_());
            this.field_70180_af.func_187227_b(LAUNCHED, (Object)false);
        }
    }

    protected boolean func_230298_a_(Entity p_230298_1_) {
        return !p_230298_1_.func_175149_v() && !(p_230298_1_ instanceof EntityStraddler) && !(p_230298_1_ instanceof EntityStradpole);
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean func_230285_a_(Fluid p_230285_1_) {
        return p_230285_1_.func_207185_a((ITag)FluidTags.field_206960_b);
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && (this.func_70090_H() || this.func_180799_ab())) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.05, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    protected void func_209207_l(int p_209207_1_) {
    }

    public void shoot(double p_70186_1_, double p_70186_3_, double p_70186_5_, float p_70186_7_, float p_70186_8_) {
        Vector3d lvt_9_1_ = new Vector3d(p_70186_1_, p_70186_3_, p_70186_5_).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_70186_8_, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_70186_8_, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_70186_8_).func_186678_a((double)p_70186_7_);
        this.func_213317_d(lvt_9_1_);
        float lvt_10_1_ = MathHelper.func_76133_a((double)EntityStradpole.func_213296_b((Vector3d)lvt_9_1_));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)lvt_9_1_.field_72450_a, (double)lvt_9_1_.field_72449_c) * 57.2957763671875);
        this.field_70127_C = this.field_70125_A = (float)(MathHelper.func_181159_b((double)lvt_9_1_.field_72448_b, (double)lvt_10_1_) * 57.2957763671875);
        this.field_70761_aq = this.field_70177_z;
        this.field_70759_as = this.field_70177_z;
        this.field_70758_at = this.field_70177_z;
        this.field_70126_B = this.field_70177_z;
        this.setDespawnSoon(true);
        this.field_70180_af.func_187227_b(LAUNCHED, (Object)true);
    }

    class StradpoleAISwim
    extends RandomWalkingGoal {
        public StradpoleAISwim(EntityStradpole creature, double speed, int chance) {
            super((CreatureEntity)creature, speed, chance, false);
        }

        public boolean func_75250_a() {
            if (!this.field_75457_a.func_180799_ab() && !this.field_75457_a.func_70090_H() || this.field_75457_a.func_184218_aH() || this.field_75457_a.func_70638_az() != null || !this.field_75457_a.func_70090_H() && !this.field_75457_a.func_180799_ab() && this.field_75457_a instanceof ISemiAquatic && !((ISemiAquatic)this.field_75457_a).shouldEnterWater()) {
                return false;
            }
            if (!this.field_179482_g && this.field_75457_a.func_70681_au().nextInt(this.field_179481_f) != 0) {
                return false;
            }
            Vector3d vector3d = this.func_190864_f();
            if (vector3d == null) {
                return false;
            }
            this.field_75455_b = vector3d.field_72450_a;
            this.field_75456_c = vector3d.field_72448_b;
            this.field_75453_d = vector3d.field_72449_c;
            this.field_179482_g = false;
            return true;
        }

        @Nullable
        protected Vector3d func_190864_f() {
            Vector3d vector3d;
            if (this.field_75457_a.func_70681_au().nextFloat() < 0.3f && (vector3d = this.findSurfaceTarget(this.field_75457_a, 15, 7)) != null) {
                return vector3d;
            }
            vector3d = RandomPositionGenerator.func_75463_a((CreatureEntity)this.field_75457_a, (int)7, (int)3);
            int i = 0;
            while (vector3d != null && !this.field_75457_a.field_70170_p.func_204610_c(new BlockPos(vector3d)).func_206884_a((ITag)FluidTags.field_206960_b) && !this.field_75457_a.field_70170_p.func_180495_p(new BlockPos(vector3d)).func_196957_g((IBlockReader)this.field_75457_a.field_70170_p, new BlockPos(vector3d), PathType.WATER) && i++ < 15) {
                vector3d = RandomPositionGenerator.func_75463_a((CreatureEntity)this.field_75457_a, (int)10, (int)7);
            }
            return vector3d;
        }

        private boolean canJumpTo(BlockPos pos, int dx, int dz, int scale) {
            BlockPos blockpos = pos.func_177982_a(dx * scale, 0, dz * scale);
            return this.field_75457_a.field_70170_p.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206960_b) || this.field_75457_a.field_70170_p.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a) && !this.field_75457_a.field_70170_p.func_180495_p(blockpos).func_185904_a().func_76230_c();
        }

        private boolean isAirAbove(BlockPos pos, int dx, int dz, int scale) {
            return this.field_75457_a.field_70170_p.func_180495_p(pos.func_177982_a(dx * scale, 1, dz * scale)).func_196958_f() && this.field_75457_a.field_70170_p.func_180495_p(pos.func_177982_a(dx * scale, 2, dz * scale)).func_196958_f();
        }

        private Vector3d findSurfaceTarget(CreatureEntity creature, int i, int i1) {
            BlockPos upPos = creature.func_233580_cy_();
            while (creature.field_70170_p.func_204610_c(upPos).func_206884_a((ITag)FluidTags.field_206959_a) || creature.field_70170_p.func_204610_c(upPos).func_206884_a((ITag)FluidTags.field_206960_b)) {
                upPos = upPos.func_177984_a();
            }
            if (this.isAirAbove(upPos.func_177977_b(), 0, 0, 0) && this.canJumpTo(upPos.func_177977_b(), 0, 0, 0)) {
                return new Vector3d((double)((float)upPos.func_177958_n() + 0.5f), (double)((float)upPos.func_177956_o() - 1.0f), (double)((float)upPos.func_177952_p() + 0.5f));
            }
            return null;
        }
    }
}

