/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityCrimsonMosquito;
import com.github.alexthe666.alexsmobs.entity.IFollower;
import com.github.alexthe666.alexsmobs.entity.ISemiAquatic;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIFindWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAILeaveWater;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.entity.ai.AquaticMoveController;
import com.github.alexthe666.alexsmobs.entity.ai.BoneSerpentPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.WarpedToadAIRandomSwimming;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.JumpController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityWarpedToad
extends TameableEntity
implements ITargetsDroppedItems,
IFollower,
ISemiAquatic {
    private static final DataParameter<Float> TONGUE_LENGTH = EntityDataManager.func_187226_a(EntityWarpedToad.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> TONGUE_OUT = EntityDataManager.func_187226_a(EntityWarpedToad.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityWarpedToad.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(EntityWarpedToad.class, (IDataSerializer)DataSerializers.field_187192_b);
    public float blinkProgress;
    public float prevBlinkProgress;
    public float attackProgress;
    public float prevAttackProgress;
    public float sitProgress;
    public float prevSitProgress;
    public float swimProgress;
    public float prevSwimProgress;
    private boolean isLandNavigator;
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int currentMoveTypeDuration;
    private int swimTimer = -100;

    protected EntityWarpedToad(EntityType entityType, World world) {
        super(entityType, world);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
        this.switchNavigator(false);
    }

    public static boolean canWarpedToadSpawn(EntityType<? extends MobEntity> typeIn, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        BlockPos blockpos = pos.func_177977_b();
        boolean spawnBlock = worldIn.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206960_b) || worldIn.func_180495_p(blockpos).func_200132_m();
        return reason == SpawnReason.SPAWNER || spawnBlock;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233820_c_, 0.25).func_233815_a_(Attributes.field_233821_d_, (double)0.35f);
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.WARPED_TOAD_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.WARPED_TOAD_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.WARPED_TOAD_HURT;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.warpedToadSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public int func_70641_bl() {
        return 5;
    }

    public boolean func_204209_c(int sizeIn) {
        return false;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        this.func_233687_w_(false);
        if (entity != null && this.func_70909_n() && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 3.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("MonkeySitting", this.func_233685_eM_());
        compound.func_74768_a("Command", this.getCommand());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSitting(compound.func_74767_n("MonkeySitting"));
        this.setCommand(compound.func_74762_e("Command"));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TongueAttack(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowOwner(this, 1.3, 4.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new AnimalAIFindWater((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AnimalAILeaveWater((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.0, Ingredient.func_199805_a((ITag)ItemTags.func_199903_a().func_199910_a(AMTagRegistry.INSECT_ITEMS)), false));
        this.field_70714_bg.func_75776_a(5, (Goal)new WarpedToadAIRandomSwimming(this, 1.0, 7));
        this.field_70714_bg.func_75776_a(6, (Goal)new AnimalAIWanderRanged((CreatureEntity)this, 60, 1.0, 5, 4));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, new CreatureAITargetItems((CreatureEntity)this, false));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(4, new EntityAINearestTarget3D<LivingEntity>((MobEntity)this, LivingEntity.class, 50, false, true, AMEntityRegistry.buildPredicateFromTag(EntityTypeTags.func_219762_a().func_199910_a(AMTagRegistry.WARPED_TOAD_TARGETS))));
        this.field_70715_bh.func_75776_a(5, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && (this.func_70090_H() || this.func_180799_ab())) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    protected float func_175134_bD() {
        return 0.5f;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected void func_70664_aZ() {
        double d1;
        super.func_70664_aZ();
        double d0 = this.field_70765_h.func_75638_b();
        if (!(d0 > 0.0) || (d1 = EntityWarpedToad.func_213296_b((Vector3d)this.func_213322_ci())) < 0.01) {
            // empty if block
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)1);
        }
    }

    public void setMovementSpeed(double newSpeed) {
        this.func_70661_as().func_75489_a(newSpeed);
        this.field_70765_h.func_75642_a(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f(), newSpeed);
    }

    public void func_70637_d(boolean jumping) {
        super.func_70637_d(jumping);
        if (jumping) {
            // empty if block
        }
    }

    public void startJumping() {
        this.func_70637_d(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    public void func_70619_bc() {
        super.func_70619_bc();
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        if (this.field_70122_E) {
            LivingEntity livingentity;
            if (!this.wasOnGround) {
                this.func_70637_d(false);
                this.checkLandingDelay();
            }
            if (this.currentMoveTypeDuration == 0 && (livingentity = this.func_70638_az()) != null && this.func_70068_e((Entity)livingentity) < 16.0) {
                this.calculateRotationYaw(livingentity.func_226277_ct_(), livingentity.func_226281_cx_());
                this.field_70765_h.func_75642_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), this.field_70765_h.func_75638_b());
                this.startJumping();
                this.wasOnGround = true;
            }
            if (this.field_70767_i instanceof JumpHelperController) {
                JumpHelperController rabbitController = (JumpHelperController)this.field_70767_i;
                if (!rabbitController.getIsJumping()) {
                    if (this.field_70765_h.func_75640_a() && this.currentMoveTypeDuration == 0) {
                        Path path = this.field_70699_by.func_75505_d();
                        Vector3d vector3d = new Vector3d(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f());
                        if (path != null && !path.func_75879_b()) {
                            vector3d = path.func_75878_a((Entity)this);
                        }
                        this.calculateRotationYaw(vector3d.field_72450_a, vector3d.field_72449_c);
                        this.startJumping();
                    }
                } else if (!rabbitController.canJump()) {
                    this.enableJumpControl();
                }
            }
        }
        this.wasOnGround = this.field_70122_E;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == AMItemRegistry.MOSQUITO_LARVA && this.func_70909_n();
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        ActionResultType type = super.func_230254_b_(player, hand);
        if (!this.func_70909_n() && item == AMItemRegistry.MOSQUITO_LARVA) {
            this.func_175505_a(player, itemstack);
            this.func_184185_a(SoundEvents.field_232840_oa_, this.func_70599_aP(), this.func_70647_i());
            if (this.func_70681_au().nextInt(3) == 0) {
                this.func_193101_c(player);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return ActionResultType.SUCCESS;
        }
        if (this.func_70909_n() && ItemTags.func_199903_a().func_199910_a(AMTagRegistry.INSECT_ITEMS).func_230235_a_((Object)itemstack.func_77973_b())) {
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_175505_a(player, itemstack);
                this.func_184185_a(SoundEvents.field_232840_oa_, this.func_70599_aP(), this.func_70647_i());
                this.func_70691_i(5.0f);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        if (type != ActionResultType.SUCCESS && this.func_70909_n() && this.func_152114_e((LivingEntity)player) && !this.func_70877_b(itemstack)) {
            boolean sit;
            this.setCommand(this.getCommand() + 1);
            if (this.getCommand() == 3) {
                this.setCommand(0);
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("entity.alexsmobs.all.command_" + this.getCommand(), new Object[]{this.func_200200_C_()}), true);
            boolean bl = sit = this.getCommand() == 2;
            if (sit) {
                this.setSitting(true);
                return ActionResultType.SUCCESS;
            }
            this.setSitting(false);
            return ActionResultType.SUCCESS;
        }
        return type;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.func_70909_n()) {
            LivingEntity livingentity = this.func_70902_q();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TameableEntity) {
                return ((TameableEntity)entityIn).func_152114_e(livingentity);
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    public boolean func_230269_aK_() {
        return false;
    }

    private void calculateRotationYaw(double x, double z) {
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(z - this.func_226281_cx_()), (double)(x - this.func_226277_ct_())) * 57.2957763671875) - 90.0f;
    }

    private void enableJumpControl() {
        if (this.field_70767_i instanceof JumpHelperController) {
            ((JumpHelperController)this.field_70767_i).setCanJump(true);
        }
    }

    private void disableJumpControl() {
        if (this.field_70767_i instanceof JumpHelperController) {
            ((JumpHelperController)this.field_70767_i).setCanJump(false);
        }
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.field_70765_h.func_75638_b() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70631_g_() && this.func_70047_e() > this.func_213302_cg()) {
            this.func_213323_x_();
        }
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.func_70637_d(false);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70090_H() || this.func_180799_ab()) {
                if (this.swimTimer < 0) {
                    this.swimTimer = 0;
                }
                ++this.swimTimer;
            } else {
                if (this.swimTimer > 0) {
                    this.swimTimer = 0;
                }
                --this.swimTimer;
            }
        }
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70767_i = new JumpHelperController(this);
            this.field_70765_h = new MoveHelperController(this);
            this.field_70699_by = this.func_175447_b(this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70767_i = new JumpController((MobEntity)this);
            this.field_70765_h = new AquaticMoveController((CreatureEntity)this, 1.2f);
            this.field_70699_by = new BoneSerpentPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TONGUE_LENGTH, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(TONGUE_OUT, (Object)false);
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
    }

    public int getCommand() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    public void setCommand(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)command);
    }

    public boolean func_233685_eM_() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void setSitting(boolean sit) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sit);
    }

    public void func_70071_h_() {
        LivingEntity entityIn;
        boolean isTechnicalBlinking;
        super.func_70071_h_();
        this.prevBlinkProgress = this.blinkProgress;
        this.prevAttackProgress = this.attackProgress;
        this.prevSitProgress = this.sitProgress;
        this.prevSwimProgress = this.swimProgress;
        this.field_70138_W = 1.0f;
        boolean bl = isTechnicalBlinking = this.field_70173_aa % 50 > 42;
        if (isTechnicalBlinking && this.blinkProgress < 5.0f) {
            this.blinkProgress += 1.0f;
        }
        if (!isTechnicalBlinking && this.blinkProgress > 0.0f) {
            this.blinkProgress -= 1.0f;
        }
        if (this.isTongueOut() && this.attackProgress < 5.0f) {
            this.attackProgress += 1.0f;
        }
        if ((entityIn = this.func_70638_az()) != null && this.attackProgress > 0.0f) {
            if (this.isTongueOut()) {
                float f1;
                double d0 = entityIn.func_226277_ct_() - this.func_226277_ct_();
                double d2 = entityIn.func_226281_cx_() - this.func_226281_cx_();
                double d1 = entityIn.func_226280_cw_() - this.func_226280_cw_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.field_70125_A = f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875));
                this.field_70761_aq = this.field_70177_z = f;
                this.field_70759_as = this.field_70177_z;
            } else {
                if (entityIn instanceof EntityCrimsonMosquito) {
                    ((EntityCrimsonMosquito)entityIn).setShrink(true);
                }
                this.field_70125_A = 0.0f;
                float radius = this.attackProgress * 0.2f * 1.2f * (this.getTongueLength() - this.getTongueLength() * 0.4f);
                float angle = (float)Math.PI / 180 * this.field_70761_aq;
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                double yHelp = entityIn.func_213302_cg();
                Vector3d minus = new Vector3d(this.func_226277_ct_() + extraX - this.func_70638_az().func_226277_ct_(), (double)this.func_70047_e() - yHelp - this.func_70638_az().func_226278_cu_(), this.func_226281_cx_() + extraZ - this.func_70638_az().func_226281_cx_());
                this.func_70638_az().func_213317_d(minus);
                if (this.attackProgress == 0.5f) {
                    float damage = (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e();
                    if (entityIn instanceof EntityCrimsonMosquito) {
                        damage = Float.MAX_VALUE;
                    }
                    entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), damage);
                }
            }
            if (this.attackProgress != 5.0f || !((double)entityIn.func_213302_cg() < 0.89) && !(entityIn instanceof EntityCrimsonMosquito) || !entityIn.func_184196_w((Entity)this)) {
                // empty if block
            }
        }
        if (!this.field_70170_p.field_72995_K && this.isTongueOut() && this.attackProgress == 5.0f) {
            this.setTongueOut(false);
            this.attackProgress = 4.0f;
        }
        if (!this.isTongueOut() && this.attackProgress > 0.0f) {
            this.attackProgress -= 0.5f;
        }
        if (this.func_233685_eM_() && this.sitProgress < 5.0f) {
            this.sitProgress += 1.0f;
        }
        if (!this.func_233685_eM_() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.shouldSwim() && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!this.shouldSwim() && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (this.shouldSwim() && this.swimProgress < 5.0f) {
            this.swimProgress += 1.0f;
        }
        if (!this.shouldSwim() && this.swimProgress > 0.0f) {
            this.swimProgress -= 1.0f;
        }
    }

    public boolean shouldSwim() {
        return this.func_70090_H() || this.func_180799_ab();
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return ItemTags.func_199903_a().func_199910_a(AMTagRegistry.INSECT_ITEMS).func_230235_a_((Object)stack.func_77973_b());
    }

    @Override
    public void onGetItem(ItemEntity e) {
        this.func_70691_i(5.0f);
    }

    public boolean isBlinking() {
        return this.blinkProgress > 1.0f || this.blinkProgress < -1.0f || this.attackProgress > 1.0f;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return (AgeableEntity)AMEntityRegistry.WARPED_TOAD.func_200721_a((World)serverWorld);
    }

    public float getTongueLength() {
        return ((Float)this.field_70180_af.func_187225_a(TONGUE_LENGTH)).floatValue();
    }

    public void setTongueLength(float length) {
        this.field_70180_af.func_187227_b(TONGUE_LENGTH, (Object)Float.valueOf(length));
    }

    public float getJumpCompletion(float partialTicks) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + partialTicks) / (float)this.jumpDuration;
    }

    public boolean func_96092_aw() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 1) {
            this.func_233569_aL_();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean hasJumper() {
        return this.field_70767_i instanceof JumpHelperController;
    }

    @Override
    public boolean shouldEnterWater() {
        return this.swimTimer < -200 && !this.func_233685_eM_() && this.getCommand() != 1;
    }

    @Override
    public boolean shouldLeaveWater() {
        return this.swimTimer > 600 && !this.func_233685_eM_() && this.getCommand() != 1;
    }

    @Override
    public boolean shouldStopMoving() {
        return this.func_233685_eM_();
    }

    private boolean isTongueOut() {
        return (Boolean)this.field_70180_af.func_187225_a(TONGUE_OUT);
    }

    private void setTongueOut(boolean out) {
        this.field_70180_af.func_187227_b(TONGUE_OUT, (Object)out);
    }

    @Override
    public int getWaterSearchRange() {
        return 8;
    }

    @Override
    public boolean shouldFollow() {
        return this.getCommand() == 1;
    }

    public class FollowOwner
    extends Goal {
        private final EntityWarpedToad tameable;
        private final IWorldReader world;
        private final double followSpeed;
        private final float maxDist;
        private final float minDist;
        private final boolean teleportToLeaves;
        private LivingEntity owner;
        private int timeToRecalcPath;
        private float oldWaterCost;

        public FollowOwner(EntityWarpedToad p_i225711_1_, double p_i225711_2_, float p_i225711_4_, float p_i225711_5_, boolean p_i225711_6_) {
            this.tameable = p_i225711_1_;
            this.world = p_i225711_1_.field_70170_p;
            this.followSpeed = p_i225711_2_;
            this.minDist = p_i225711_4_;
            this.maxDist = p_i225711_5_;
            this.teleportToLeaves = p_i225711_6_;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            if (!(p_i225711_1_.func_70661_as() instanceof GroundPathNavigator) && !(p_i225711_1_.func_70661_as() instanceof FlyingPathNavigator)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean func_75250_a() {
            LivingEntity lvt_1_1_ = this.tameable.func_70902_q();
            if (lvt_1_1_ == null) {
                return false;
            }
            if (lvt_1_1_.func_175149_v()) {
                return false;
            }
            if (this.tameable.func_233685_eM_() || this.tameable.getCommand() != 1) {
                return false;
            }
            if (this.tameable.func_70068_e((Entity)lvt_1_1_) < (double)(this.minDist * this.minDist)) {
                return false;
            }
            this.owner = lvt_1_1_;
            return true;
        }

        public boolean func_75253_b() {
            if (this.tameable.func_70661_as().func_75500_f()) {
                return false;
            }
            if (this.tameable.func_233685_eM_() || this.tameable.getCommand() != 1) {
                return false;
            }
            return this.tameable.func_70068_e((Entity)this.owner) > (double)(this.maxDist * this.maxDist);
        }

        public void func_75249_e() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.tameable.func_184643_a(PathNodeType.WATER);
            this.tameable.func_184644_a(PathNodeType.WATER, 0.0f);
        }

        public void func_75251_c() {
            this.owner = null;
            this.tameable.func_70661_as().func_75499_g();
            this.tameable.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
        }

        public void func_75246_d() {
            this.tameable.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.tameable.func_70646_bf());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                if (!this.tameable.func_110167_bD() && !this.tameable.func_184218_aH()) {
                    if (this.tameable.func_70068_e((Entity)this.owner) >= 144.0) {
                        this.tryToTeleportNearEntity();
                    } else {
                        this.tameable.func_70661_as().func_75497_a((Entity)this.owner, this.followSpeed);
                    }
                }
            }
        }

        private void tryToTeleportNearEntity() {
            BlockPos lvt_1_1_ = this.owner.func_233580_cy_();
            for (int lvt_2_1_ = 0; lvt_2_1_ < 10; ++lvt_2_1_) {
                int lvt_3_1_ = this.getRandomNumber(-3, 3);
                int lvt_4_1_ = this.getRandomNumber(-1, 1);
                int lvt_5_1_ = this.getRandomNumber(-3, 3);
                boolean lvt_6_1_ = this.tryToTeleportToLocation(lvt_1_1_.func_177958_n() + lvt_3_1_, lvt_1_1_.func_177956_o() + lvt_4_1_, lvt_1_1_.func_177952_p() + lvt_5_1_);
                if (!lvt_6_1_) continue;
                return;
            }
        }

        private boolean tryToTeleportToLocation(int p_226328_1_, int p_226328_2_, int p_226328_3_) {
            if (Math.abs((double)p_226328_1_ - this.owner.func_226277_ct_()) < 2.0 && Math.abs((double)p_226328_3_ - this.owner.func_226281_cx_()) < 2.0) {
                return false;
            }
            if (!this.isTeleportFriendlyBlock(new BlockPos(p_226328_1_, p_226328_2_, p_226328_3_))) {
                return false;
            }
            this.tameable.func_70012_b((double)p_226328_1_ + 0.5, p_226328_2_, (double)p_226328_3_ + 0.5, this.tameable.field_70177_z, this.tameable.field_70125_A);
            this.tameable.func_70661_as().func_75499_g();
            return true;
        }

        private boolean isTeleportFriendlyBlock(BlockPos p_226329_1_) {
            PathNodeType lvt_2_1_ = WalkNodeProcessor.func_237231_a_((IBlockReader)this.world, (BlockPos.Mutable)p_226329_1_.func_239590_i_());
            if (lvt_2_1_ != PathNodeType.WALKABLE) {
                return false;
            }
            BlockState lvt_3_1_ = this.world.func_180495_p(p_226329_1_.func_177977_b());
            if (!this.teleportToLeaves && lvt_3_1_.func_177230_c() instanceof LeavesBlock) {
                return false;
            }
            BlockPos lvt_4_1_ = p_226329_1_.func_177973_b((Vector3i)this.tameable.func_233580_cy_());
            return this.world.func_226665_a__((Entity)this.tameable, this.tameable.func_174813_aQ().func_186670_a(lvt_4_1_));
        }

        private int getRandomNumber(int p_226327_1_, int p_226327_2_) {
            return this.tameable.func_70681_au().nextInt(p_226327_2_ - p_226327_1_ + 1) + p_226327_1_;
        }
    }

    public class TongueAttack
    extends Goal {
        private final EntityWarpedToad parentEntity;
        private int spitCooldown = 0;
        private BlockPos shootPos = null;

        public TongueAttack(EntityWarpedToad toad) {
            this.parentEntity = toad;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null && this.parentEntity.func_184188_bt().isEmpty();
        }

        public boolean func_75253_b() {
            return this.parentEntity.func_70638_az() != null && this.parentEntity.func_184188_bt().isEmpty();
        }

        public void func_75251_c() {
            this.spitCooldown = 20;
            this.parentEntity.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            LivingEntity entityIn;
            if (this.spitCooldown > 0) {
                --this.spitCooldown;
            }
            if ((entityIn = this.parentEntity.func_70638_az()) != null) {
                double dist = this.parentEntity.func_70032_d((Entity)entityIn);
                if (dist < 8.0 && this.parentEntity.func_70685_l((Entity)entityIn) && !this.parentEntity.isTongueOut() && this.parentEntity.attackProgress == 0.0f && this.spitCooldown == 0) {
                    this.parentEntity.setTongueLength((float)Math.max(1.0, dist + 2.0));
                    this.spitCooldown = 10;
                    this.parentEntity.setTongueOut(true);
                }
                this.parentEntity.func_70661_as().func_75497_a((Entity)entityIn, (double)1.4f);
            }
        }
    }

    public class JumpHelperController
    extends JumpController {
        private final EntityWarpedToad toad;
        private boolean canJump;

        public JumpHelperController(EntityWarpedToad toad) {
            super((MobEntity)toad);
            this.toad = toad;
        }

        public boolean getIsJumping() {
            return this.field_75662_b;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJumpIn) {
            this.canJump = canJumpIn;
        }

        public void func_75661_b() {
            if (this.field_75662_b) {
                this.toad.startJumping();
                this.field_75662_b = false;
            }
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final EntityWarpedToad warpedToad;
        private double nextJumpSpeed;

        public MoveHelperController(EntityWarpedToad warpedToad) {
            super((MobEntity)warpedToad);
            this.warpedToad = warpedToad;
        }

        public void func_75641_c() {
            if (this.warpedToad.hasJumper() && this.warpedToad.field_70122_E && !this.warpedToad.field_70703_bu && !((JumpHelperController)this.warpedToad.field_70767_i).getIsJumping()) {
                this.warpedToad.setMovementSpeed(0.0);
            } else if (this.func_75640_a()) {
                this.warpedToad.setMovementSpeed(this.nextJumpSpeed);
            }
            super.func_75641_c();
        }

        public void func_75642_a(double x, double y, double z, double speedIn) {
            if (this.warpedToad.func_70090_H()) {
                speedIn = 1.5;
            }
            super.func_75642_a(x, y, z, speedIn);
            if (speedIn > 0.0) {
                this.nextJumpSpeed = speedIn;
            }
        }
    }
}

