/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.entity.EntityCrow;
import com.github.alexthe666.alexsmobs.message.MessageCrowMountPlayer;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class CrowAIFollowOwner
extends Goal {
    private final EntityCrow crow;
    private final IWorldReader world;
    private final double followSpeed;
    private final PathNavigator navigator;
    private final float maxDist;
    private final float minDist;
    private final boolean teleportToLeaves;
    float circlingTime = 0.0f;
    float circleDistance = 1.0f;
    float yLevel = 2.0f;
    boolean clockwise = false;
    private LivingEntity owner;
    private int timeToRecalcPath;
    private float oldWaterCost;
    private int maxCircleTime;

    public CrowAIFollowOwner(EntityCrow p_i225711_1_, double p_i225711_2_, float p_i225711_4_, float p_i225711_5_, boolean p_i225711_6_) {
        this.crow = p_i225711_1_;
        this.world = p_i225711_1_.field_70170_p;
        this.followSpeed = p_i225711_2_;
        this.navigator = p_i225711_1_.func_70661_as();
        this.minDist = p_i225711_4_;
        this.maxDist = p_i225711_5_;
        this.teleportToLeaves = p_i225711_6_;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        LivingEntity lvt_1_1_ = this.crow.func_70902_q();
        if (lvt_1_1_ == null) {
            return false;
        }
        if (lvt_1_1_.func_175149_v()) {
            return false;
        }
        if (this.crow.func_233685_eM_() || this.crow.func_184218_aH()) {
            return false;
        }
        if (this.crow.getCommand() != 1) {
            return false;
        }
        if (this.crow.func_70068_e((Entity)lvt_1_1_) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = lvt_1_1_;
        return this.crow.func_70638_az() == null || !this.crow.func_70638_az().func_70089_S();
    }

    public boolean func_75253_b() {
        if (this.crow.func_233685_eM_()) {
            return false;
        }
        return this.crow.getCommand() == 1 && !this.crow.func_184218_aH() && (this.crow.func_70638_az() == null || !this.crow.func_70638_az().func_70089_S());
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.crow.func_184643_a(PathNodeType.WATER);
        this.crow.func_184644_a(PathNodeType.WATER, 0.0f);
        this.clockwise = this.crow.func_70681_au().nextBoolean();
        this.yLevel = this.crow.func_70681_au().nextInt(1);
        this.circlingTime = 0.0f;
        this.maxCircleTime = 20 + this.crow.func_70681_au().nextInt(100);
        this.circleDistance = 1.0f + this.crow.func_70681_au().nextFloat() * 2.0f;
    }

    public void func_75251_c() {
        this.owner = null;
        this.navigator.func_75499_g();
        this.circlingTime = 0.0f;
        this.crow.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.crow.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.crow.func_70646_bf());
        if (!this.crow.func_110167_bD() && !this.crow.func_184218_aH()) {
            double dist = this.crow.func_70068_e((Entity)this.owner);
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                if (dist >= 144.0 && !this.crow.aiItemFlag) {
                    this.crow.setFlying(true);
                    this.crow.func_70605_aq().func_75642_a(this.owner.func_226277_ct_(), this.owner.func_226278_cu_() + (double)this.owner.func_70047_e() + (double)0.2f, this.owner.func_226281_cx_(), 1.0);
                    this.tryToTeleportNearEntity();
                    this.circlingTime = 0.0f;
                }
            }
            if (!this.crow.aiItemFlag) {
                if (this.crow.isFlying()) {
                    this.circlingTime += 1.0f;
                }
                if (this.circlingTime > (float)this.maxCircleTime && this.crow.getRidingCrows(this.owner) < 2) {
                    this.crow.func_70605_aq().func_75642_a(this.owner.func_226277_ct_(), this.owner.func_226278_cu_() + (double)this.owner.func_70047_e() + (double)0.2f, this.owner.func_226281_cx_(), (double)0.7f);
                    if (this.crow.func_70032_d((Entity)this.owner) < 2.0f) {
                        this.crow.func_184205_a((Entity)this.owner, true);
                        if (!this.crow.field_70170_p.field_72995_K) {
                            AlexsMobs.sendMSGToAll(new MessageCrowMountPlayer(this.crow.func_145782_y(), this.owner.func_145782_y()));
                        }
                    }
                } else {
                    Vector3d circlePos = this.getVultureCirclePos(this.owner.func_213303_ch());
                    if (circlePos == null) {
                        circlePos = this.owner.func_213303_ch();
                    }
                    this.crow.setFlying(true);
                    this.crow.func_70605_aq().func_75642_a(circlePos.func_82615_a(), circlePos.func_82617_b() + (double)this.owner.func_70047_e() + (double)0.2f, circlePos.func_82616_c(), (double)0.7f);
                }
            }
        }
    }

    public Vector3d getVultureCirclePos(Vector3d target) {
        float angle = 0.13962634f * (this.clockwise ? -this.circlingTime : this.circlingTime);
        double extraX = this.circleDistance * MathHelper.func_76126_a((float)angle);
        double extraZ = this.circleDistance * MathHelper.func_76134_b((float)angle);
        Vector3d pos = new Vector3d(target.func_82615_a() + extraX, target.func_82617_b() + (double)this.yLevel, target.func_82616_c() + extraZ);
        if (this.crow.field_70170_p.func_175623_d(new BlockPos(pos))) {
            return pos;
        }
        return null;
    }

    private void tryToTeleportNearEntity() {
        BlockPos lvt_1_1_ = this.owner.func_233580_cy_();
        for (int lvt_2_1_ = 0; lvt_2_1_ < 10; ++lvt_2_1_) {
            int lvt_3_1_ = this.getRandomNumber(-3, 3);
            int lvt_4_1_ = this.getRandomNumber(-1, 1);
            int lvt_5_1_ = this.getRandomNumber(-3, 3);
            boolean lvt_6_1_ = this.tryToTeleportToLocation(lvt_1_1_.func_177958_n() + lvt_3_1_, lvt_1_1_.func_177956_o() + lvt_4_1_, lvt_1_1_.func_177952_p() + lvt_5_1_);
            if (!lvt_6_1_) continue;
            return;
        }
    }

    private boolean tryToTeleportToLocation(int p_226328_1_, int p_226328_2_, int p_226328_3_) {
        if (Math.abs((double)p_226328_1_ - this.owner.func_226277_ct_()) < 2.0 && Math.abs((double)p_226328_3_ - this.owner.func_226281_cx_()) < 2.0) {
            return false;
        }
        if (!this.isTeleportFriendlyBlock(new BlockPos(p_226328_1_, p_226328_2_, p_226328_3_))) {
            return false;
        }
        this.crow.func_70012_b((double)p_226328_1_ + 0.5, p_226328_2_, (double)p_226328_3_ + 0.5, this.crow.field_70177_z, this.crow.field_70125_A);
        this.navigator.func_75499_g();
        return true;
    }

    private boolean isTeleportFriendlyBlock(BlockPos p_226329_1_) {
        PathNodeType lvt_2_1_ = WalkNodeProcessor.func_237231_a_((IBlockReader)this.world, (BlockPos.Mutable)p_226329_1_.func_239590_i_());
        if (lvt_2_1_ != PathNodeType.WALKABLE) {
            return false;
        }
        BlockState lvt_3_1_ = this.world.func_180495_p(p_226329_1_.func_177977_b());
        if (!this.teleportToLeaves && lvt_3_1_.func_177230_c() instanceof LeavesBlock) {
            return false;
        }
        BlockPos lvt_4_1_ = p_226329_1_.func_177973_b((Vector3i)this.crow.func_233580_cy_());
        return this.world.func_226665_a__((Entity)this.crow, this.crow.func_174813_aQ().func_186670_a(lvt_4_1_));
    }

    private int getRandomNumber(int p_226327_1_, int p_226327_2_) {
        return this.crow.func_70681_au().nextInt(p_226327_2_ - p_226327_1_ + 1) + p_226327_1_;
    }
}

