/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityOrca;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.JumpGoal;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class OrcaAIJump
extends JumpGoal {
    private static final int[] JUMP_DISTANCES = new int[]{0, 1, 4, 5, 6, 7};
    private final EntityOrca dolphin;
    private final int field_220712_c;
    private boolean inWater;

    public OrcaAIJump(EntityOrca dolphin, int p_i50329_2_) {
        this.dolphin = dolphin;
        this.field_220712_c = p_i50329_2_;
    }

    public boolean func_75250_a() {
        if (this.dolphin.func_70681_au().nextInt(this.field_220712_c) != 0 || this.dolphin.func_70638_az() != null || this.dolphin.jumpCooldown != 0) {
            return false;
        }
        Direction direction = this.dolphin.func_184172_bi();
        int i = direction.func_82601_c();
        int j = direction.func_82599_e();
        BlockPos blockpos = this.dolphin.func_233580_cy_();
        for (int k : JUMP_DISTANCES) {
            if (this.canJumpTo(blockpos, i, j, k) && this.isAirAbove(blockpos, i, j, k)) continue;
            return false;
        }
        return true;
    }

    private boolean canJumpTo(BlockPos pos, int dx, int dz, int scale) {
        BlockPos blockpos = pos.func_177982_a(dx * scale, 0, dz * scale);
        return this.dolphin.field_70170_p.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a) && !this.dolphin.field_70170_p.func_180495_p(blockpos).func_185904_a().func_76230_c();
    }

    private boolean isAirAbove(BlockPos pos, int dx, int dz, int scale) {
        return this.dolphin.field_70170_p.func_180495_p(pos.func_177982_a(dx * scale, 1, dz * scale)).func_196958_f() && this.dolphin.field_70170_p.func_180495_p(pos.func_177982_a(dx * scale, 2, dz * scale)).func_196958_f();
    }

    public boolean func_75253_b() {
        double d0 = this.dolphin.func_213322_ci().field_72448_b;
        return !(this.dolphin.jumpCooldown <= 0 || d0 * d0 < (double)0.03f && this.dolphin.field_70125_A != 0.0f && Math.abs(this.dolphin.field_70125_A) < 10.0f && this.dolphin.func_70090_H() || this.dolphin.func_233570_aj_());
    }

    public boolean func_220685_C_() {
        return false;
    }

    public void func_75249_e() {
        Direction direction = this.dolphin.func_184172_bi();
        float up = 0.7f + this.dolphin.func_70681_au().nextFloat() * 0.8f;
        this.dolphin.func_213317_d(this.dolphin.func_213322_ci().func_72441_c((double)direction.func_82601_c() * 0.6, (double)up, (double)direction.func_82599_e() * 0.6));
        this.dolphin.func_70661_as().func_75499_g();
        this.dolphin.jumpCooldown = this.dolphin.func_70681_au().nextInt(256) + 256;
    }

    public void func_75251_c() {
        this.dolphin.field_70125_A = 0.0f;
    }

    public void func_75246_d() {
        boolean flag = this.inWater;
        if (!flag) {
            FluidState fluidstate = this.dolphin.field_70170_p.func_204610_c(this.dolphin.func_233580_cy_());
            this.inWater = fluidstate.func_206884_a((ITag)FluidTags.field_206959_a);
        }
        if (this.inWater && !flag) {
            this.dolphin.func_184185_a(SoundEvents.field_205209_aZ, 1.0f, 1.0f);
        }
        Vector3d vector3d = this.dolphin.func_213322_ci();
        if (vector3d.field_72448_b * vector3d.field_72448_b < (double)0.1f && this.dolphin.field_70125_A != 0.0f) {
            this.dolphin.field_70125_A = MathHelper.func_226167_j_((float)this.dolphin.field_70125_A, (float)0.0f, (float)0.2f);
        } else {
            double d0 = Math.sqrt(Entity.func_213296_b((Vector3d)vector3d));
            double d1 = Math.signum(-vector3d.field_72448_b) * Math.acos(d0 / vector3d.func_72433_c()) * 57.2957763671875;
            this.dolphin.field_70125_A = (float)d1;
        }
    }
}

