/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.item;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityBlobfish;
import com.github.alexthe666.alexsmobs.entity.EntityLobster;
import com.github.alexthe666.alexsmobs.entity.EntityPlatypus;
import com.github.alexthe666.alexsmobs.entity.EntityStradpole;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemModFishBucket
extends BucketItem {
    private final EntityType<?> fishType;
    private final Supplier<? extends EntityType<?>> fishTypeSupplier;

    public ItemModFishBucket(EntityType<?> fishTypeIn, Fluid fluid, Item.Properties builder) {
        super(fluid, builder);
        this.fishType = fishTypeIn;
        this.fishTypeSupplier = () -> fishTypeIn;
    }

    public void func_203792_a(World worldIn, ItemStack p_203792_2_, BlockPos pos) {
        if (worldIn instanceof ServerWorld) {
            this.placeFish((ServerWorld)worldIn, p_203792_2_, pos);
        }
    }

    protected void func_203791_b(@Nullable PlayerEntity player, IWorld worldIn, BlockPos pos) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_203819_X, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    private void placeFish(ServerWorld worldIn, ItemStack stack, BlockPos pos) {
        CompoundNBT compoundnbt;
        Entity entity = this.fishType.func_220331_a(worldIn, stack, (PlayerEntity)null, pos, SpawnReason.BUCKET, true, false);
        if (entity != null && entity instanceof EntityLobster) {
            ((EntityLobster)entity).setFromBucket(true);
            compoundnbt = stack.func_196082_o();
            if (compoundnbt.func_150297_b("BucketVariantTag", 3)) {
                int i = compoundnbt.func_74762_e("BucketVariantTag");
                ((EntityLobster)entity).setVariant(i);
            }
        }
        if (entity != null && entity instanceof EntityBlobfish) {
            ((EntityBlobfish)entity).setFromBucket(true);
            compoundnbt = stack.func_196082_o();
            if (compoundnbt.func_74764_b("BucketScale")) {
                ((EntityBlobfish)entity).setBlobfishScale(compoundnbt.func_74760_g("BucketScale"));
            }
            if (compoundnbt.func_74764_b("Slimed")) {
                ((EntityBlobfish)entity).setSlimed(compoundnbt.func_74767_n("Slimed"));
            }
        }
        if (entity != null && entity instanceof EntityStradpole) {
            ((EntityStradpole)entity).setFromBucket(true);
        }
        if (entity != null && entity instanceof EntityPlatypus && (compoundnbt = stack.func_196082_o()).func_74764_b("PlatypusData")) {
            ((EntityPlatypus)entity).func_70037_a(compoundnbt.func_74775_l("PlatypusData"));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT compoundnbt;
        if (this.fishType == AMEntityRegistry.LOBSTER && (compoundnbt = stack.func_77978_p()) != null && compoundnbt.func_150297_b("BucketVariantTag", 3)) {
            int i = compoundnbt.func_74762_e("BucketVariantTag");
            String s = "entity.alexsmobs.lobster.variant_" + EntityLobster.getVariantName(i);
            tooltip.add((ITextComponent)new TranslationTextComponent(s).func_240699_a_(TextFormatting.GRAY).func_240699_a_(TextFormatting.ITALIC));
        }
    }

    protected EntityType<?> getFishType() {
        return this.fishTypeSupplier.get();
    }
}

