/*
 * Decompiled with CFR 0.152.
 */
package uk.co.hexeption.rsinfinitybooster.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    private ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    private ForgeConfigSpec spec;
    private InfinityCard infinityCard = new InfinityCard();
    private DimensionCard dimensionCard = new DimensionCard();

    public ServerConfig() {
        this.spec = this.builder.build();
    }

    public InfinityCard getInfinityCard() {
        return this.infinityCard;
    }

    public DimensionCard getDimensionCard() {
        return this.dimensionCard;
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public class DimensionCard {
        private final ForgeConfigSpec.IntValue energyUsage;

        public DimensionCard() {
            ServerConfig.this.builder.push("dimensionCard");
            this.energyUsage = ServerConfig.this.builder.comment("The energy need to run the Dimension Card").defineInRange("energyUsage", 8000, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getEnergyUsage() {
            return (Integer)this.energyUsage.get();
        }
    }

    public class InfinityCard {
        private final ForgeConfigSpec.IntValue energyUsage;

        public InfinityCard() {
            ServerConfig.this.builder.push("infinityCard");
            this.energyUsage = ServerConfig.this.builder.comment("The energy need to run the Infinity Card").defineInRange("energyUsage", 4000, 0, Integer.MAX_VALUE);
            ServerConfig.this.builder.pop();
        }

        public int getEnergyUsage() {
            return (Integer)this.energyUsage.get();
        }
    }
}

