/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.experimental.module;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.GossipManager;
import net.minecraft.village.GossipType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.EXPERIMENTAL, enabledByDefault=false, hasSubscriptions=true)
public class GameNerfsModule
extends QuarkModule {
    private static final String TAG_TRADES_ADJUSTED = "quark:zombie_trades_adjusted";
    @Config(description="Makes Mending act like the Unmending mod\nhttps://www.curseforge.com/minecraft/mc-mods/unmending")
    public static boolean nerfMending = true;
    @Config(description="Resets all villager discounts when zombified to prevent reducing prices to ridiculous levels")
    public static boolean nerfVillagerDiscount = true;
    @Config(description="Makes Iron Golems not drop Iron Ingots")
    public static boolean disableIronFarms = true;
    @Config(description="Makes Boats not glide on ice")
    public static boolean disableIceRoads = true;
    @Config(description="Makes Sheep not drop Wool when killed")
    public static boolean disableWoolDrops = true;
    private static boolean staticEnabled;

    @Override
    public void configChanged() {
        staticEnabled = this.enabled;
    }

    public static float getBoatGlide(float glide) {
        return staticEnabled && disableIceRoads ? 0.45f : glide;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void killMending(PlayerXpEvent.PickupXp event) {
        if (!nerfMending) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ExperienceOrbEntity orb = event.getOrb();
        player.field_71090_bL = 2;
        player.func_71001_a((Entity)orb, 1);
        if (orb.field_70530_e > 0) {
            player.func_195068_e(orb.field_70530_e);
        }
        orb.func_70106_y();
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        if (!nerfMending) {
            return;
        }
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        ItemStack out = event.getOutput();
        if (out.func_190926_b() && (left.func_190926_b() || right.func_190926_b())) {
            return;
        }
        boolean isMended = false;
        Map enchLeft = EnchantmentHelper.func_82781_a((ItemStack)left);
        Map enchRight = EnchantmentHelper.func_82781_a((ItemStack)right);
        if (enchLeft.containsKey(Enchantments.field_185296_A) || enchRight.containsKey(Enchantments.field_185296_A)) {
            if (left.func_77973_b() == right.func_77973_b()) {
                isMended = true;
            }
            if (right.func_77973_b() == Items.field_151134_bR) {
                isMended = true;
            }
        }
        if (isMended) {
            if (out.func_190926_b()) {
                out = left.func_77946_l();
            }
            if (!out.func_77942_o()) {
                out.func_77982_d(new CompoundNBT());
            }
            Map enchOutput = EnchantmentHelper.func_82781_a((ItemStack)out);
            enchOutput.putAll(enchRight);
            enchOutput.remove(Enchantments.field_185296_A);
            EnchantmentHelper.func_82782_a((Map)enchOutput, (ItemStack)out);
            out.func_82841_c(0);
            if (out.func_77984_f()) {
                out.func_196085_b(0);
            }
            event.setOutput(out);
            if (event.getCost() == 0) {
                event.setCost(1);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onTooltip(ItemTooltipEvent event) {
        if (!nerfMending) {
            return;
        }
        IFormattableTextComponent itemgotmodified = new TranslationTextComponent("quark.misc.repaired").func_240699_a_(TextFormatting.YELLOW);
        int repairCost = event.getItemStack().func_82838_A();
        if (repairCost > 0) {
            event.getToolTip().add(itemgotmodified);
        }
    }

    @SubscribeEvent
    public void onTick(LivingEvent.LivingUpdateEvent event) {
        if (nerfVillagerDiscount && event.getEntity().func_200600_R() == EntityType.field_200727_aF && !event.getEntity().getPersistentData().func_74764_b(TAG_TRADES_ADJUSTED)) {
            ZombieVillagerEntity zombie = (ZombieVillagerEntity)event.getEntity();
            INBT gossipsNbt = zombie.field_223728_bB;
            GossipManager manager = new GossipManager();
            manager.func_234057_a_(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)gossipsNbt));
            for (UUID uuid : manager.field_220928_a.keySet()) {
                GossipManager.Gossips gossips = (GossipManager.Gossips)manager.field_220928_a.get(uuid);
                gossips.func_223528_b(GossipType.MAJOR_POSITIVE);
                gossips.func_223528_b(GossipType.MINOR_POSITIVE);
            }
            zombie.getPersistentData().func_74757_a(TAG_TRADES_ADJUSTED, true);
        }
    }

    @SubscribeEvent
    public void onLoot(LivingDropsEvent event) {
        if (disableIronFarms && event.getEntity().func_200600_R() == EntityType.field_200757_aw) {
            event.getDrops().removeIf(e -> e.func_92059_d().func_77973_b() == Items.field_151042_j);
        }
        if (disableWoolDrops && event.getEntity().func_200600_R() == EntityType.field_200737_ac) {
            event.getDrops().removeIf(e -> e.func_92059_d().func_77973_b().func_206844_a((ITag)ItemTags.field_199904_a));
        }
    }
}

