/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.experimental.module;

import com.mojang.text2speech.Narrator;
import java.util.List;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.util.ClientTicker;
import vazkii.quark.base.client.handler.ModKeybindHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;

@LoadModule(category=ModuleCategory.EXPERIMENTAL, enabledByDefault=false, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class NarratorReadoutModule
extends QuarkModule {
    @OnlyIn(value=Dist.CLIENT)
    private KeyBinding keybind;
    @OnlyIn(value=Dist.CLIENT)
    private KeyBinding keybindFull;
    float last;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        if (this.enabled) {
            this.keybind = ModKeybindHandler.init("narrator_readout", "n", "quark.gui.keygroup.accessibility");
            this.keybindFull = ModKeybindHandler.init("narrator_full_readout", "m", "quark.gui.keygroup.accessibility");
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onMouseInput(InputEvent.MouseInputEvent event) {
        boolean down = this.isDown(event.getButton(), 0, true, this.keybind);
        boolean full = this.isDown(event.getButton(), 0, true, this.keybindFull);
        this.acceptInput(down || full, down);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        boolean down = this.isDown(event.getKey(), event.getScanCode(), false, this.keybind);
        boolean full = this.isDown(event.getKey(), event.getScanCode(), false, this.keybindFull);
        this.acceptInput(down || full, down);
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isDown(int key, int scancode, boolean mouse, KeyBinding keybind) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null) {
            if (mouse) {
                return keybind.func_197984_a(key) && (keybind.getKeyModifier() == KeyModifier.NONE || keybind.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI));
            }
            return keybind.func_197976_a(key, scancode) && (keybind.getKeyModifier() == KeyModifier.NONE || keybind.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI));
        }
        return keybind.func_151470_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void acceptInput(boolean down, boolean full) {
        Minecraft mc = Minecraft.func_71410_x();
        float curr = ClientTicker.total;
        if (down && curr - this.last > 10.0f) {
            Narrator narrator = Narrator.getNarrator();
            String readout = this.getReadout(mc, full);
            if (readout != null) {
                narrator.say(readout, true);
                this.last = curr;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private String getReadout(Minecraft mc, boolean full) {
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return I18n.func_135052_a((String)"quark.readout.not_ingame", (Object[])new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        if (mc.field_71462_r == null) {
            RayTraceResult ray = mc.field_71476_x;
            if (ray != null && ray instanceof BlockRayTraceResult) {
                BlockPos pos = ((BlockRayTraceResult)ray).func_216350_a();
                BlockState state = mc.field_71441_e.func_180495_p(pos);
                Item item = state.func_177230_c().func_199767_j();
                if (item != null) {
                    sb.append(I18n.func_135052_a((String)"quark.readout.looking", (Object[])new Object[]{item.func_200295_i(new ItemStack((IItemProvider)item)).getString()}));
                    if (full) {
                        sb.append(", ");
                    }
                }
                if (state.func_177230_c() instanceof AbstractSignBlock) {
                    SignTileEntity tile = (SignTileEntity)mc.field_71441_e.func_175625_s(pos);
                    sb.append(I18n.func_135052_a((String)"quark.readout.sign_says", (Object[])new Object[0]));
                    for (ITextComponent cmp : tile.field_145915_a) {
                        String msg = cmp.getString().trim();
                        if (msg.isEmpty()) continue;
                        sb.append(cmp.getString());
                        sb.append(" ");
                    }
                    sb.append(". ");
                }
            }
            if (full) {
                ItemStack stack = player.func_184614_ca();
                ItemStack stack2 = player.func_184592_cb();
                if (stack.func_190926_b()) {
                    stack = stack2;
                    stack2 = ItemStack.field_190927_a;
                }
                if (!stack.func_190926_b()) {
                    if (!stack2.func_190926_b()) {
                        sb.append(I18n.func_135052_a((String)"quark.readout.holding_with_off", (Object[])new Object[]{stack.func_190916_E(), stack.func_200301_q().getString(), stack2.func_190916_E(), stack2.func_200301_q().getString()}));
                    } else {
                        sb.append(I18n.func_135052_a((String)"quark.readout.holding", (Object[])new Object[]{stack.func_190916_E(), stack.func_200301_q().getString()}));
                    }
                    sb.append(", ");
                }
                sb.append(I18n.func_135052_a((String)"quark.readout.health", (Object[])new Object[]{(int)mc.field_71439_g.func_110143_aJ()}));
                sb.append(", ");
                sb.append(I18n.func_135052_a((String)"quark.readout.food", (Object[])new Object[]{mc.field_71439_g.func_71024_bL().func_75116_a()}));
            }
        } else if (mc.field_71462_r instanceof ContainerScreen) {
            ItemStack stack;
            ContainerScreen cnt = (ContainerScreen)mc.field_71462_r;
            Slot slot = cnt.getSlotUnderMouse();
            ItemStack itemStack = stack = slot == null ? ItemStack.field_190927_a : slot.func_75211_c();
            if (stack.func_190926_b()) {
                sb.append(I18n.func_135052_a((String)"quark.readout.no_item", (Object[])new Object[0]));
            } else {
                List tooltip = cnt.func_231151_a_(stack);
                for (ITextComponent t : tooltip) {
                    IFormattableTextComponent print = t.func_230532_e_();
                    List bros = print.func_150253_a();
                    for (ITextComponent sib : bros) {
                        TranslationTextComponent ttc;
                        if (!(sib instanceof TranslationTextComponent) || !(ttc = (TranslationTextComponent)sib).func_150268_i().contains("enchantment.level.")) continue;
                        bros.set(bros.indexOf(sib), new StringTextComponent(ttc.func_150268_i().substring("enchantment.level.".length())));
                        break;
                    }
                    sb.append(print.getString());
                    if (full) {
                        sb.append(", ");
                        continue;
                    }
                    break;
                }
            }
        } else {
            sb.append(mc.field_71462_r.func_231167_h_());
        }
        return sb.toString();
    }
}

