/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.gen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import vazkii.quark.base.world.config.DimensionConfig;
import vazkii.quark.base.world.generator.multichunk.MultiChunkFeatureGenerator;
import vazkii.quark.content.world.module.ChorusVegetationModule;

public class ChorusVegetationGenerator
extends MultiChunkFeatureGenerator {
    public ChorusVegetationGenerator() {
        super(DimensionConfig.end(false), () -> true, 2093L);
    }

    @Override
    public int getFeatureRadius() {
        return ChorusVegetationModule.radius;
    }

    @Override
    public BlockPos[] getSourcesInChunk(WorldGenRegion world, Random random, ChunkGenerator generator, BlockPos chunkCorner) {
        Biome b;
        if (!chunkCorner.func_218141_a(Vector3i.field_177959_e, 1050.0) && ChorusVegetationModule.rarity > 0 && random.nextInt(ChorusVegetationModule.rarity) == 0 && (b = this.getBiome((IWorld)world, chunkCorner)).getRegistryName().equals((Object)Biomes.field_201938_R.func_240901_a_())) {
            return new BlockPos[]{chunkCorner};
        }
        return new BlockPos[0];
    }

    @Override
    public void generateChunkPart(BlockPos src, ChunkGenerator generator, Random rand, BlockPos pos, WorldGenRegion worldIn) {
        for (int i = 0; i < ChorusVegetationModule.chunkAttempts; ++i) {
            BlockState stateAt;
            BlockPos placePos = pos.func_177982_a(rand.nextInt(16), 100, rand.nextInt(16));
            Biome b = this.getBiome((IWorld)worldIn, placePos);
            double chance = this.getChance(b);
            double dist = (placePos.func_177958_n() - src.func_177958_n()) * (placePos.func_177958_n() - src.func_177958_n()) + (placePos.func_177952_p() - src.func_177952_p()) * (placePos.func_177952_p() - src.func_177952_p());
            int ditherStart = 6;
            if (dist > (double)(ditherStart *= ditherStart)) {
                chance *= 1.0 - Math.atan((dist - (double)ditherStart) / 50.0) / 1.5707963267948966;
            }
            if (!(chance > 0.0) || !(rand.nextDouble() < chance)) continue;
            while (placePos.func_177956_o() > 40 && (stateAt = worldIn.func_180495_p(placePos)).func_177230_c() != Blocks.field_150377_bs) {
                placePos = placePos.func_177977_b();
            }
            if (worldIn.func_180495_p(placePos).func_177230_c() != Blocks.field_150377_bs || !worldIn.func_180495_p(placePos.func_177984_a()).func_196958_f()) continue;
            Block block = rand.nextDouble() < 0.1 ? ChorusVegetationModule.chorus_twist : ChorusVegetationModule.chorus_weeds;
            worldIn.func_180501_a(placePos.func_177984_a(), block.func_176223_P(), 2);
        }
    }

    private double getChance(Biome b) {
        ResourceLocation res = b.getRegistryName();
        if (res.equals((Object)Biomes.field_201938_R.func_240901_a_())) {
            return ChorusVegetationModule.highlandsChance;
        }
        if (res.equals((Object)Biomes.field_201937_Q.func_240901_a_())) {
            return ChorusVegetationModule.midlandsChance;
        }
        return ChorusVegetationModule.otherEndBiomesChance;
    }
}

