/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.client.render;

import com.minecraftabnormals.upgrade_aquatic.client.model.PikeModel;
import com.minecraftabnormals.upgrade_aquatic.client.render.overlay.GlowingPikeRenderLayer;
import com.minecraftabnormals.upgrade_aquatic.client.render.overlay.PikeCarriedItemRenderLayer;
import com.minecraftabnormals.upgrade_aquatic.common.entities.pike.PikeEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PikeRenderer
extends MobRenderer<PikeEntity, PikeModel<PikeEntity>> {
    public PikeRenderer(EntityRendererManager manager) {
        super(manager, new PikeModel(), 0.6f);
        this.func_177094_a(new GlowingPikeRenderLayer(this));
        this.func_177094_a(new PikeCarriedItemRenderLayer((IEntityRenderer<PikeEntity, PikeModel<PikeEntity>>)this));
    }

    public ResourceLocation getEntityTexture(PikeEntity pike) {
        return new ResourceLocation("upgrade_aquatic", String.format("textures/entity/pike/%s.png", pike.getPikeType().name().toLowerCase()));
    }

    protected void applyRotations(PikeEntity pike, MatrixStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_225621_a_((LivingEntity)pike, matrixStack, ageInTicks, rotationYaw, partialTicks);
        float f = 4.3f * MathHelper.func_76126_a((float)(0.6f * ageInTicks));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f));
        if (!pike.func_70090_H()) {
            matrixStack.func_227861_a_((double)0.1f, (double)0.1f, (double)-0.1f);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
        }
    }

    protected void preRenderCallback(PikeEntity pike, MatrixStack matrixStack, float partialTickTime) {
        float scale = pike.getPikeType().pikeSize.renderSize;
        matrixStack.func_227862_a_(scale, scale, scale);
    }
}

