/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish;

import com.google.common.collect.ImmutableMap;
import com.minecraftabnormals.abnormals_core.core.api.IAgeableEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.AbstractJellyfishEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.helper.JellyfishSizeMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public abstract class ColoredSizableJellyfishEntity
extends AbstractJellyfishEntity
implements IAgeableEntity {
    protected static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(ColoredSizableJellyfishEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(ColoredSizableJellyfishEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final JellyfishSizeMap NATURAL_SIZES = new JellyfishSizeMap(new TreeMap<Float, Integer>((Map<Float, Integer>)ImmutableMap.of((Object)Float.valueOf(0.5f), (Object)3, (Object)Float.valueOf(0.65f), (Object)3, (Object)Float.valueOf(1.0f), (Object)34)));
    private final ColoredSizableBucketProcessor bucketProcessor = new ColoredSizableBucketProcessor(this);

    public ColoredSizableJellyfishEntity(EntityType<? extends AbstractJellyfishEntity> type, World world) {
        super(type, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(this.getDefaultSize()));
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (SIZE.equals(key)) {
            this.func_213323_x_();
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("JellyColor", this.getColor());
        compound.func_74776_a("Size", this.getSize());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setColor(compound.func_74762_e("JellyColor"));
        this.setSize(compound.func_74760_g("Size"), false);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        boolean updateSize = false;
        Random rand = this.func_70681_au();
        int color = rand.nextInt(3);
        float size = this.getNaturalSizeMap().randomSize(rand);
        if (dataTag == null || !this.isFromBucket()) {
            if (spawnDataIn instanceof SpawnData) {
                size = ((SpawnData)spawnDataIn).size;
                color = ((SpawnData)spawnDataIn).color;
            } else if (!this.isFromBucket()) {
                spawnDataIn = new SpawnData(size, color);
                updateSize = true;
            }
        }
        this.setSize(size, updateSize);
        this.setColor(color);
        return spawnDataIn;
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public void setColor(int color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
    }

    public JellyfishSizeMap getNaturalSizeMap() {
        return NATURAL_SIZES;
    }

    public void setSize(float size, boolean updateHealth) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(size));
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)(this.getHealthSizeMultiplier() * size));
        if (updateHealth) {
            this.func_70606_j(this.func_110138_aP());
        }
    }

    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    public boolean hasGrowthProgress() {
        return false;
    }

    public void resetGrowthProgress() {
    }

    public boolean canAge(boolean isGrowing) {
        float size = this.getSize();
        JellyfishSizeMap map = this.getNaturalSizeMap();
        if (map.containsKey(Float.valueOf(size))) {
            return (isGrowing ? map.higherKey(Float.valueOf(size)) : map.lowerKey(Float.valueOf(size))) != null;
        }
        return false;
    }

    public LivingEntity attemptAging(boolean isGrowing) {
        float size = this.getSize();
        JellyfishSizeMap map = this.getNaturalSizeMap();
        if (map.containsKey(Float.valueOf(size))) {
            Float newSize;
            Float f = newSize = isGrowing ? map.higherKey(Float.valueOf(size)) : map.lowerKey(Float.valueOf(size));
            if (newSize != null) {
                this.setSize(newSize.floatValue(), false);
            }
        }
        return this;
    }

    @Override
    public AbstractJellyfishEntity.BucketProcessor<?> getBucketProcessor() {
        return this.bucketProcessor;
    }

    protected abstract String getBucketEntityId();

    protected abstract float getDefaultSize();

    protected abstract float getHealthSizeMultiplier();

    static class SpawnData
    implements ILivingEntityData {
        private final float size;
        private final int color;

        private SpawnData(float size, int color) {
            this.size = size;
            this.color = color;
        }
    }

    protected static class ColoredSizableBucketProcessor
    extends AbstractJellyfishEntity.BucketProcessor<ColoredSizableJellyfishEntity> {
        public ColoredSizableBucketProcessor(ColoredSizableJellyfishEntity jellyfish) {
            super(jellyfish.getBucketEntityId(), jellyfish);
        }

        @Override
        public CompoundNBT write() {
            CompoundNBT nbt = super.write();
            nbt.func_74768_a("Color", ((ColoredSizableJellyfishEntity)this.jellyfish).getColor());
            nbt.func_74776_a("Size", ((ColoredSizableJellyfishEntity)this.jellyfish).getSize());
            return nbt;
        }

        @Override
        public void read(CompoundNBT nbt) {
            ((ColoredSizableJellyfishEntity)this.jellyfish).setColor(nbt.func_74762_e("Color"));
            ((ColoredSizableJellyfishEntity)this.jellyfish).setSize(nbt.func_74760_g("Size"), true);
        }
    }
}

