/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.world.gen.feature;

import com.minecraftabnormals.abnormals_core.core.util.MathUtil;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class SearocketFeature
extends Feature<NoFeatureConfig> {
    private static final Supplier<BlockState> SEAROCKET(boolean pink) {
        return pink ? () -> ((Block)UABlocks.PINK_SEAROCKET.get()).func_176223_P() : () -> ((Block)UABlocks.WHITE_SEAROCKET.get()).func_176223_P();
    }

    public SearocketFeature(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if ((double)worldIn.func_226691_t_(pos).func_242445_k() < 0.2) {
            boolean colorType;
            boolean bl = colorType = rand.nextFloat() <= 0.25f;
            if (SearocketFeature.SEAROCKET(colorType).get().func_196955_c((IWorldReader)worldIn, pos)) {
                this.generateSearocketPatch((IWorld)worldIn, pos, colorType, rand.nextInt(8));
                return true;
            }
        } else {
            boolean colorType;
            boolean bl = colorType = rand.nextFloat() <= 0.75f;
            if (SearocketFeature.SEAROCKET(colorType).get().func_196955_c((IWorldReader)worldIn, pos)) {
                this.generateSearocketPatch((IWorld)worldIn, pos, colorType, rand.nextInt(8));
                return true;
            }
        }
        return false;
    }

    public void generateSearocketPatch(IWorld world, BlockPos pos, boolean pink, int randomDesign) {
        int[] patterns = new int[3];
        switch (randomDesign) {
            default: {
                patterns[0] = 3;
                patterns[1] = 4;
                patterns[2] = 9;
            }
            case 1: {
                patterns[0] = 2;
                patterns[1] = 8;
                patterns[2] = 5;
            }
            case 2: {
                patterns[0] = 3;
                patterns[1] = 4;
                patterns[2] = 7;
            }
            case 3: {
                patterns[0] = 3;
                patterns[1] = 13;
                patterns[2] = 12;
            }
            case 4: {
                patterns[0] = 3;
                patterns[1] = 12;
                patterns[2] = 12;
            }
            case 5: {
                patterns[0] = 2;
                patterns[1] = 12;
                patterns[2] = 12;
            }
            case 6: {
                patterns[0] = 3;
                patterns[1] = 5;
                patterns[2] = 3;
            }
            case 7: 
        }
        patterns[0] = 3;
        patterns[1] = 3;
        patterns[2] = 6;
        BlockPos startPos = pos;
        MathUtil.Equation r = theta -> (Math.cos((double)patterns[1] * theta) / (double)patterns[2] + 1.0) * (double)patterns[0];
        if (!(world.func_175623_d(startPos.func_177977_b()) || world.func_175623_d(startPos.func_177979_c(2)) || world.func_175623_d(startPos.func_177979_c(3)))) {
            int repeatsDown = world.func_201674_k().nextInt(2) + 2;
            for (int repeats = 0; repeats < repeatsDown; ++repeats) {
                pos = pos.func_177982_a(0, -repeats, 0);
                for (int i = -(patterns[0] / patterns[2] + patterns[0]); i < patterns[0] / patterns[2] + patterns[0]; ++i) {
                    for (int j = -(patterns[0] / patterns[2] + patterns[0]); j < patterns[0] / patterns[2] + patterns[0]; ++j) {
                        double radius = r.compute(Math.atan2(j, i));
                        BlockPos placingPos = pos.func_177982_a(i, 0, j);
                        if (!world.func_180495_p(placingPos).func_185904_a().func_76222_j() || !((double)(i * i + j * j) < radius * radius) || !SearocketFeature.SEAROCKET(pink).get().func_196955_c((IWorldReader)world, placingPos) || !world.func_204610_c(placingPos).func_206888_e()) continue;
                        world.func_180501_a(placingPos, SearocketFeature.SEAROCKET(pink).get(), 2);
                    }
                }
            }
        }
    }
}

