/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.core;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class UAConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Integer> daysTillRenderInsomniaOverlay;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("misc");
            this.daysTillRenderInsomniaOverlay = builder.comment(new String[]{"The amount of days till the insomnia overlay is rendered", "Setting to 3 will make the overlay indicate phantom spawns", "Setting to 0 will disable the overlay"}).define("Days until insomnia overlay", (Object)0);
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> clericsBuyThrasherTeeth;
        public final ForgeConfigSpec.ConfigValue<Boolean> drownedSwimmingAnimation;
        public final ForgeConfigSpec.ConfigValue<Boolean> leatherworkersSellBedrolls;
        public final ForgeConfigSpec.ConfigValue<Integer> deepOceanMobMaxHeight;
        public final ForgeConfigSpec.ConfigValue<Integer> glowSquidWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> thrasherWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> nautilusWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> lionfishWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> pikeWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> perchWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> pikeSwampWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> squidSwampWeight;
        public final ForgeConfigSpec.ConfigValue<Integer> beachgrassFrequency;
        public final ForgeConfigSpec.ConfigValue<Integer> searocketFrequency;
        public final ForgeConfigSpec.ConfigValue<Integer> pickerelweedFrequency;
        public final ForgeConfigSpec.ConfigValue<Integer> pickerelweedExtraFrequency;
        public final ForgeConfigSpec.ConfigValue<Integer> floweringRushFrequency;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("items");
            builder.push("trades");
            this.clericsBuyThrasherTeeth = builder.define("Clerics buy thrasher teeth", true);
            this.leatherworkersSellBedrolls = builder.define("Leatherworkers sell bedrolls", true);
            builder.pop();
            builder.pop();
            builder.push("mobs");
            this.drownedSwimmingAnimation = builder.comment("Give Drowneds a swimming animation, like in bedrock edition").define("Drowned swimming animation", true);
            this.deepOceanMobMaxHeight = builder.comment("The max height that deep ocean mobs can spawn at").defineInRange("Deep ocean mob max height", 30, 0, 255);
            builder.push("spawns");
            this.glowSquidWeight = builder.define("Glow Squid spawn weight (oceans)", (Object)67);
            this.thrasherWeight = builder.define("Thrasher spawn weight (cold oceans)", (Object)90);
            this.nautilusWeight = builder.define("Nautilus spawn weight (warm oceans)", (Object)51);
            this.lionfishWeight = builder.define("Lionfish spawn weight (coral reefs)", (Object)15);
            this.pikeWeight = builder.define("Pike spawn weight (rivers)", (Object)11);
            this.perchWeight = builder.define("Perch spawn weight (swamps)", (Object)5);
            this.pikeSwampWeight = builder.define("Pike spawn weight (swamps)", (Object)5);
            this.squidSwampWeight = builder.define("Squid spawn weight (swamps)", (Object)5);
            builder.pop();
            builder.pop();
            builder.push("world");
            builder.push("generation");
            this.beachgrassFrequency = builder.define("Beachgrass frequency (beaches)", (Object)18);
            this.searocketFrequency = builder.define("Searocket frequency (beaches)", (Object)15);
            this.pickerelweedFrequency = builder.define("Pickerelweed frequency (jungles, swamps, rivers)", (Object)28);
            this.pickerelweedExtraFrequency = builder.define("Pickerelweed frequency (flower forests)", (Object)90);
            this.floweringRushFrequency = builder.define("Flowering Rush frequency (rivers)", (Object)15);
            builder.pop();
            builder.pop();
        }
    }
}

