/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.core.mixin;

import net.minecraft.client.renderer.entity.model.DrownedModel;
import net.minecraft.client.renderer.entity.model.ZombieModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DrownedModel.class})
public class DrownedModelMixin<T extends ZombieEntity>
extends ZombieModel<T> {
    private DrownedModelMixin(float p_i48914_1_, float p_i48914_2_, int p_i48914_3_, int p_i48914_4_) {
        super(p_i48914_1_, p_i48914_2_, p_i48914_3_, p_i48914_4_);
    }

    @Inject(at={@At(value="TAIL")}, method={"setRotationAngles(Lnet/minecraft/entity/monster/ZombieEntity;FFFFF)V"})
    private void setRotationAngles(T drowned, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo info) {
        if (drowned.func_213314_bj() && drowned.func_70090_H() && drowned.func_184187_bx() == null && this.getHorizontalMotion(drowned.func_213322_ci()) >= 0.025f && drowned.func_130014_f_().func_204610_c(drowned.func_233580_cy_().func_177977_b()).func_206884_a((ITag)FluidTags.field_206959_a)) {
            float leftArmSwimAnimTicks;
            float limbSwingRemainder = limbSwing % 26.0f;
            HandSide handside = this.func_217147_a((LivingEntity)drowned);
            float rightArmSwimAnimTicks = handside == HandSide.RIGHT && this.field_217112_c > 0.0f ? 0.0f : this.field_205061_a;
            float f = leftArmSwimAnimTicks = handside == HandSide.LEFT && this.field_217112_c > 0.0f ? 0.0f : this.field_205061_a;
            if (limbSwingRemainder < 14.0f) {
                this.field_178724_i.field_78795_f = this.func_205060_a(leftArmSwimAnimTicks, this.field_178724_i.field_78795_f, 0.0f);
                this.field_178723_h.field_78795_f = MathHelper.func_219799_g((float)rightArmSwimAnimTicks, (float)this.field_178723_h.field_78795_f, (float)0.0f);
                this.field_178724_i.field_78796_g = this.func_205060_a(leftArmSwimAnimTicks, this.field_178724_i.field_78796_g, (float)Math.PI);
                this.field_178723_h.field_78796_g = MathHelper.func_219799_g((float)rightArmSwimAnimTicks, (float)this.field_178723_h.field_78796_g, (float)((float)Math.PI));
                this.field_178724_i.field_78808_h = this.func_205060_a(leftArmSwimAnimTicks, this.field_178724_i.field_78808_h, (float)Math.PI + 1.8707964f * this.getArmAngleSq(limbSwingRemainder) / this.getArmAngleSq(14.0f));
                this.field_178723_h.field_78808_h = MathHelper.func_219799_g((float)rightArmSwimAnimTicks, (float)this.field_178723_h.field_78808_h, (float)((float)Math.PI - 1.8707964f * this.getArmAngleSq(limbSwingRemainder) / this.getArmAngleSq(14.0f)));
            } else if (limbSwingRemainder >= 14.0f && limbSwingRemainder < 22.0f) {
                float multiplier1 = (limbSwingRemainder - 14.0f) / 8.0f;
                this.field_178724_i.field_78795_f = this.func_205060_a(leftArmSwimAnimTicks, this.field_178724_i.field_78795_f, 1.5707964f * multiplier1);
                this.field_178723_h.field_78795_f = MathHelper.func_219799_g((float)rightArmSwimAnimTicks, (float)this.field_178723_h.field_78795_f, (float)(1.5707964f * multiplier1));
                this.field_178724_i.field_78796_g = this.func_205060_a(leftArmSwimAnimTicks, this.field_178724_i.field_78796_g, (float)Math.PI);
                this.field_178723_h.field_78796_g = MathHelper.func_219799_g((float)rightArmSwimAnimTicks, (float)this.field_178723_h.field_78796_g, (float)((float)Math.PI));
                this.field_178724_i.field_78808_h = this.func_205060_a(leftArmSwimAnimTicks, this.field_178724_i.field_78808_h, 5.012389f - 1.8707964f * multiplier1);
                this.field_178723_h.field_78808_h = MathHelper.func_219799_g((float)rightArmSwimAnimTicks, (float)this.field_178723_h.field_78808_h, (float)(1.2707963f + 1.8707964f * multiplier1));
            } else if (limbSwingRemainder >= 22.0f && limbSwingRemainder < 26.0f) {
                float multiplier2 = (limbSwingRemainder - 22.0f) / 4.0f;
                this.field_178724_i.field_78795_f = this.func_205060_a(leftArmSwimAnimTicks, this.field_178724_i.field_78795_f, 1.5707964f - 1.5707964f * multiplier2);
                this.field_178723_h.field_78795_f = MathHelper.func_219799_g((float)rightArmSwimAnimTicks, (float)this.field_178723_h.field_78795_f, (float)(1.5707964f - 1.5707964f * multiplier2));
                this.field_178724_i.field_78796_g = this.func_205060_a(leftArmSwimAnimTicks, this.field_178724_i.field_78796_g, (float)Math.PI);
                this.field_178723_h.field_78796_g = MathHelper.func_219799_g((float)rightArmSwimAnimTicks, (float)this.field_178723_h.field_78796_g, (float)((float)Math.PI));
                this.field_178724_i.field_78808_h = this.func_205060_a(leftArmSwimAnimTicks, this.field_178724_i.field_78808_h, (float)Math.PI);
                this.field_178723_h.field_78808_h = MathHelper.func_219799_g((float)rightArmSwimAnimTicks, (float)this.field_178723_h.field_78808_h, (float)((float)Math.PI));
            }
            this.field_78116_c.field_78795_f = drowned.func_213314_bj() ? this.func_205060_a(this.field_205061_a, this.field_78116_c.field_78795_f, -0.7853982f) : this.func_205060_a(this.field_205061_a, this.field_78116_c.field_78795_f, headPitch * ((float)Math.PI / 180));
            this.field_178722_k.field_78795_f = MathHelper.func_219799_g((float)this.field_205061_a, (float)this.field_178722_k.field_78795_f, (float)(0.3f * MathHelper.func_76134_b((float)(limbSwing * 0.33333334f + (float)Math.PI))));
            this.field_178721_j.field_78795_f = MathHelper.func_219799_g((float)this.field_205061_a, (float)this.field_178721_j.field_78795_f, (float)(0.3f * MathHelper.func_76134_b((float)(limbSwing * 0.33333334f))));
        }
    }

    private float getArmAngleSq(float limbSwing) {
        return -65.0f * limbSwing + limbSwing * limbSwing;
    }

    private float getHorizontalMotion(Vector3d motion) {
        double x = motion.func_82615_a();
        double z = motion.func_82616_c();
        return MathHelper.func_76133_a((double)(x * x + z * z));
    }
}

