/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enchancedcelestials.lunarevent;

import corgitaco.enchancedcelestials.config.EnhancedCelestialsConfig;
import corgitaco.enchancedcelestials.lunarevent.LunarEvent;
import corgitaco.enchancedcelestials.util.EnhancedCelestialsClientUtils;
import corgitaco.enchancedcelestials.util.EnhancedCelestialsUtils;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class HarvestMoon
extends LunarEvent {
    private static double cropGrowthMultiplier = (Double)EnhancedCelestialsConfig.harvestMoonCropGrowthChanceMultiplier.get();
    private static double cropDropMultiplier = (Double)EnhancedCelestialsConfig.harvestMoonCropDropsMultiplier.get();
    private static boolean displayNotification = (Boolean)EnhancedCelestialsConfig.harvestMoonNotification.get();

    public HarvestMoon() {
        super("HARVEST_MOON", (Double)EnhancedCelestialsConfig.harvestMoonChance.get());
    }

    @Override
    public boolean modifySkyLightMapColor(Vector3f originalLightmapColor) {
        originalLightmapColor.func_229190_a_(EnhancedCelestialsClientUtils.transformToVectorColor(new Color(255, 219, 99)), 1.0f);
        return true;
    }

    @Override
    public Color modifyMoonColor() {
        return new Color(255, 219, 99, 255);
    }

    @Override
    public void blockTick(ServerWorld world, BlockPos pos, Block block, BlockState blockState) {
        int i = 0;
        while ((double)i < cropGrowthMultiplier) {
            if (i > 0) {
                blockState = world.func_180495_p(pos);
                block = blockState.func_177230_c();
            }
            if (!EnhancedCelestialsUtils.HARVEST_MOON_BLACKLISTED_CROP_GROWTH.func_230235_a_((Object)block) && EnhancedCelestialsUtils.HARVEST_MOON_WHITELISTED_CROP_GROWTH.func_230235_a_((Object)block)) {
                block.func_225542_b_(blockState, world, pos, world.field_73012_v);
            }
            ++i;
        }
    }

    @Override
    public void multiplyDrops(ServerWorld world, ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        try {
            if (!EnhancedCelestialsUtils.HARVEST_MOON_BLACKLISTED_CROP_DROPS.isDefaulted() && !EnhancedCelestialsUtils.HARVEST_MOON_WHITELISTED_CROP_DROPS.isDefaulted() && !EnhancedCelestialsUtils.HARVEST_MOON_BLACKLISTED_CROP_DROPS.func_230235_a_((Object)item) && EnhancedCelestialsUtils.HARVEST_MOON_WHITELISTED_CROP_DROPS.func_230235_a_((Object)item)) {
                itemStack.func_190920_e((int)((double)itemStack.func_190916_E() * cropDropMultiplier));
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void sendRisingNotification(PlayerEntity player) {
        if (displayNotification) {
            TranslationTextComponent component = new TranslationTextComponent("enhancedcelestials.notification.harvest_moon.rise");
            component.func_230530_a_(component.func_150256_b().func_240721_b_(TextFormatting.GOLD));
            player.func_145747_a((ITextComponent)component, Util.field_240973_b_);
        }
    }

    @Override
    public void sendSettingNotification(PlayerEntity player) {
        if (displayNotification) {
            TranslationTextComponent component = new TranslationTextComponent("enhancedcelestials.notification.harvest_moon.set");
            component.func_230530_a_(component.func_150256_b().func_240721_b_(TextFormatting.GOLD));
            player.func_145747_a((ITextComponent)component, Util.field_240973_b_);
        }
    }
}

