/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enchancedcelestials.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import corgitaco.enchancedcelestials.EnhancedCelestials;
import corgitaco.enchancedcelestials.data.network.NetworkHandler;
import corgitaco.enchancedcelestials.data.network.packet.LunarEventPacket;
import corgitaco.enchancedcelestials.lunarevent.LunarEvent;
import corgitaco.enchancedcelestials.lunarevent.LunarEventSystem;
import corgitaco.enchancedcelestials.util.EnhancedCelestialsUtils;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SetLunarEventCommand {
    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        List weatherTypes = LunarEventSystem.LUNAR_EVENTS.stream().map(LunarEvent::getID).collect(Collectors.toList());
        return Commands.func_197057_a((String)"setlunarevent").then(Commands.func_197056_a((String)"lunarevent", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> ISuggestionProvider.func_197013_a(weatherTypes.stream(), (SuggestionsBuilder)sb)).executes(cs -> SetLunarEventCommand.betterWeatherSetWeatherType((CommandSource)cs.getSource(), (String)cs.getArgument("lunarevent", String.class))));
    }

    public static int betterWeatherSetWeatherType(CommandSource source, String lunarType) {
        LunarEvent weatherEvent = LunarEventSystem.LUNAR_EVENTS_MAP.get(lunarType);
        if (weatherEvent != null) {
            long dayTime = EnhancedCelestialsUtils.modulosDaytime(source.func_197023_e().func_201672_e().func_72912_H().func_76073_f());
            if (dayTime < 12000L || dayTime > 24000L) {
                source.func_197030_a((ITextComponent)new TranslationTextComponent("enhancedcelestials.commands.failed.requiresnight", new Object[]{dayTime}), true);
                return 0;
            }
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("enhancedcelestials.commands.failed", new Object[]{lunarType}), true);
            return 0;
        }
        EnhancedCelestials.lunarData.setEvent(weatherEvent.getID());
        source.func_197030_a((ITextComponent)weatherEvent.successTranslationTextComponent(), true);
        source.func_197023_e().func_217369_A().forEach(player -> NetworkHandler.sendToClient(player, new LunarEventPacket(lunarType)));
        return 1;
    }
}

