/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.render;

import artifacts.common.config.ModConfig;
import artifacts.common.item.GloveItem;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class FirstPersonGloveRenderHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderHand(RenderHandEvent event) {
        if (!event.isCanceled() && Minecraft.func_71410_x().field_71439_g != null && ((Boolean)ModConfig.client.showFirstPersonGloves.get()).booleanValue()) {
            HandSide handside;
            event.getMatrixStack().func_227860_a_();
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            HandSide handSide = handside = event.getHand() == Hand.MAIN_HAND ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
            if (event.getItemStack().func_190926_b()) {
                if (event.getHand() == Hand.MAIN_HAND) {
                    FirstPersonGloveRenderHandler.renderGloveOnHand(event.getMatrixStack(), event.getBuffers(), event.getLight(), event.getEquipProgress(), event.getSwingProgress(), player, handside, event.getHand());
                }
            } else if (event.getItemStack().func_77973_b() == Items.field_151098_aY) {
                if (event.getHand() == Hand.MAIN_HAND && player.func_184592_cb().func_190926_b()) {
                    FirstPersonGloveRenderHandler.renderTwoHandedMapGloves(event.getMatrixStack(), event.getBuffers(), event.getLight(), event.getInterpolatedPitch(), event.getEquipProgress(), event.getSwingProgress(), player, handside);
                } else {
                    FirstPersonGloveRenderHandler.renderSingleHandedMapGlove(event.getMatrixStack(), event.getBuffers(), event.getLight(), event.getEquipProgress(), event.getSwingProgress(), player, handside, event.getHand());
                }
            }
            event.getMatrixStack().func_227865_b_();
        }
    }

    private static ItemStack getEquippedGlove(ClientPlayerEntity entity, Hand hand) {
        int slot;
        LazyOptional optionalHandler = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)entity);
        if (!optionalHandler.isPresent()) {
            return ItemStack.field_190927_a;
        }
        ICuriosItemHandler handler = (ICuriosItemHandler)optionalHandler.orElse(null);
        ICurioStacksHandler stacksHandler = (ICurioStacksHandler)handler.getCurios().get("hands");
        if (stacksHandler == null) {
            return ItemStack.field_190927_a;
        }
        IDynamicStackHandler stacks = stacksHandler.getStacks();
        IDynamicStackHandler cosmeticStacks = stacksHandler.getCosmeticStacks();
        int n = slot = hand == Hand.MAIN_HAND ? 0 : 1;
        while (slot < stacks.getSlots()) {
            block8: {
                ItemStack stack;
                block7: {
                    stack = cosmeticStacks.getStackInSlot(slot);
                    if (!stack.func_190926_b()) break block7;
                    if (!((Boolean)stacksHandler.getRenders().get(slot)).booleanValue()) break block8;
                    stack = stacks.getStackInSlot(slot);
                }
                if (stack.func_77973_b() instanceof GloveItem) {
                    return stack;
                }
            }
            slot += 2;
        }
        return ItemStack.field_190927_a;
    }

    private static void renderGloveOnHand(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, float equipProgress, float swingProgress, ClientPlayerEntity player, HandSide handSide, Hand hand) {
        ItemStack glove = FirstPersonGloveRenderHandler.getEquippedGlove(player, hand);
        if (glove.func_190926_b()) {
            return;
        }
        int side = handSide == HandSide.RIGHT ? 1 : -1;
        float swingProgressRoot = MathHelper.func_76129_c((float)swingProgress);
        float xOffset = -0.3f * MathHelper.func_76126_a((float)(swingProgressRoot * (float)Math.PI));
        float yOffset = 0.4f * MathHelper.func_76126_a((float)(swingProgressRoot * ((float)Math.PI * 2)));
        float zOffset = -0.4f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        matrixStack.func_227861_a_((double)side * ((double)xOffset + 0.64), (double)yOffset - 0.6 + (double)equipProgress * -0.6, (double)zOffset - 0.72);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(side * 45)));
        float zRotation = MathHelper.func_76126_a((float)(swingProgress * swingProgress * (float)Math.PI));
        float yRotation = MathHelper.func_76126_a((float)(swingProgressRoot * (float)Math.PI));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)side * yRotation * 70.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)side * zRotation * -20.0f));
        matrixStack.func_227861_a_((double)(side * -1), 3.6, 3.5);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(side * 120)));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(200.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(side * -135)));
        matrixStack.func_227861_a_((double)side * 5.6, 0.0, 0.0);
        ((GloveItem)glove.func_77973_b()).renderArm(matrixStack, buffer, combinedLight, (AbstractClientPlayerEntity)player, handSide, glove.func_77962_s());
    }

    private static void renderSingleHandedMapGlove(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, float equippedProgress, float swingProgress, ClientPlayerEntity player, HandSide handSide, Hand hand) {
        float side = handSide == HandSide.RIGHT ? 1.0f : -1.0f;
        matrixStack.func_227861_a_((double)side * 0.125, -0.125, 0.0);
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(side * 10.0f));
        FirstPersonGloveRenderHandler.renderGloveOnHand(matrixStack, buffer, combinedLight, equippedProgress, swingProgress, player, handSide, hand);
        matrixStack.func_227865_b_();
    }

    private static void renderTwoHandedMapGloves(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, float pitch, float equippedProgress, float swingProgress, ClientPlayerEntity player, HandSide mainHandSide) {
        float swingProgressRoot = MathHelper.func_76129_c((float)swingProgress);
        float yOffset = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        float zOffset = -0.4f * MathHelper.func_76126_a((float)(swingProgressRoot * (float)Math.PI));
        matrixStack.func_227861_a_(0.0, (double)(-yOffset / 2.0f), (double)zOffset);
        float mapAngle = FirstPersonGloveRenderHandler.getMapAngle(pitch);
        matrixStack.func_227861_a_(0.0, 0.04 + (double)equippedProgress * -1.2 + (double)mapAngle * -0.5, -0.72);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(mapAngle * -85.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        FirstPersonGloveRenderHandler.renderTwoHandedMapGlove(matrixStack, buffer, combinedLight, player, mainHandSide, Hand.MAIN_HAND);
        FirstPersonGloveRenderHandler.renderTwoHandedMapGlove(matrixStack, buffer, combinedLight, player, mainHandSide.func_188468_a(), Hand.OFF_HAND);
    }

    private static float getMapAngle(float pitch) {
        float f = 1.0f - pitch / 45.0f + 0.1f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        return -MathHelper.func_76134_b((float)(f * (float)Math.PI)) * 0.5f + 0.5f;
    }

    private static void renderTwoHandedMapGlove(MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, ClientPlayerEntity player, HandSide handSide, Hand hand) {
        ItemStack glove = FirstPersonGloveRenderHandler.getEquippedGlove(player, hand);
        if (glove.func_190926_b()) {
            if (hand == Hand.OFF_HAND) {
                System.out.println("glove = " + glove);
            }
            return;
        }
        matrixStack.func_227860_a_();
        float side = handSide == HandSide.RIGHT ? 1.0f : -1.0f;
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(92.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(45.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(side * -41.0f));
        matrixStack.func_227861_a_((double)side * 0.3, -1.1, 0.45);
        ((GloveItem)glove.func_77973_b()).renderArm(matrixStack, buffer, combinedLight, (AbstractClientPlayerEntity)player, handSide, glove.func_77962_s());
        matrixStack.func_227865_b_();
    }
}

