/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.capability.swimhandler;

import artifacts.common.capability.swimhandler.ISwimHandler;
import artifacts.common.capability.swimhandler.SwimHandler;
import artifacts.common.capability.swimhandler.SwimHandlerProvider;
import be.florens.expandability.api.forge.PlayerSwimEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class SwimHandlerCapability {
    @CapabilityInject(value=ISwimHandler.class)
    public static Capability<ISwimHandler> INSTANCE = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(ISwimHandler.class, (Capability.IStorage)new Storage(), SwimHandler::new);
    }

    @Mod.EventBusSubscriber(modid="artifacts")
    public static class CapabilityEventHandler {
        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof PlayerEntity) {
                SwimHandlerProvider provider = new SwimHandlerProvider();
                event.addCapability(new ResourceLocation("artifacts", "swim_handler"), (ICapabilityProvider)provider);
                event.addListener(provider::invalidate);
            }
        }

        @SubscribeEvent
        public static void onPlayerSwim(PlayerSwimEvent event) {
            event.getPlayer().getCapability(INSTANCE).ifPresent(handler -> {
                if (event.getResult() == Event.Result.DEFAULT) {
                    if (handler.isSwimming()) {
                        event.setResult(Event.Result.ALLOW);
                    } else if (handler.isSinking()) {
                        event.setResult(Event.Result.DENY);
                    }
                }
            });
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            event.player.getCapability(INSTANCE).ifPresent(handler -> {
                if (event.player.func_70090_H() || event.player.func_180799_ab()) {
                    if (!handler.isWet()) {
                        handler.setWet(true);
                    }
                } else if (event.player.func_233570_aj_() || event.player.field_71075_bZ.field_75100_b) {
                    handler.setWet(false);
                }
            });
        }
    }

    public static class Storage
    implements Capability.IStorage<ISwimHandler> {
        public INBT writeNBT(Capability<ISwimHandler> capability, ISwimHandler handler, Direction side) {
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_74757_a("ShouldSwim", handler.isSwimming());
            compoundNBT.func_74757_a("ShouldSink", handler.isSinking());
            compoundNBT.func_74757_a("IsWet", handler.isWet());
            return compoundNBT;
        }

        public void readNBT(Capability<ISwimHandler> capability, ISwimHandler handler, Direction side, INBT nbt) {
            if (nbt instanceof CompoundNBT) {
                CompoundNBT compoundNBT = (CompoundNBT)nbt;
                handler.setSwimming(compoundNBT.func_74767_n("ShouldSwim"));
                handler.setSinking(compoundNBT.func_74767_n("ShouldSink"));
                handler.setWet(compoundNBT.func_74767_n("IsWet"));
            }
        }
    }
}

