/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.config;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    private Set<ResourceLocation> worldGenBiomeBlacklist;
    private Set<String> worldGenModIdBlacklist;
    private final ForgeConfigSpec.ConfigValue<List<String>> biomeBlacklist;
    public final ForgeConfigSpec.IntValue campsiteRarity;
    public final ForgeConfigSpec.DoubleValue campsiteMimicChance;
    public final ForgeConfigSpec.DoubleValue campsiteOreChance;
    public final ForgeConfigSpec.IntValue campsiteMinY;
    public final ForgeConfigSpec.IntValue campsiteMaxY;
    public final ForgeConfigSpec.BooleanValue useModdedChests;

    CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("campsite");
        this.biomeBlacklist = builder.worldRestart().comment(new String[]{"List of biome IDs in which campsites are not allowed to generate", "End and nether biomes are excluded by default", "To blacklist all biomes from a single mod, use \"modid:*\""}).translation("artifacts.config.common.campsite.biome_blacklist").define("biome_blacklist", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:void", "undergarden:*", "the_bumblezone:*", "twilightforest:*"}));
        this.campsiteRarity = builder.worldRestart().comment(new String[]{"Rarity of campsites generating in the world", "The chance a campsite generates in a specific chunk is 1/rarity", "A rarity of 1 will generate a campsite in every chunk, while 10000 will generate no campsites", "Not every attempt at generating a campsite succeeds, this also depends on the density and shape of caves"}).translation("artifacts.config.common.campsite.rarity").defineInRange("rarity", 12, 1, 10000);
        this.campsiteMinY = builder.comment("The minimum y-level at which a campsite can generate").translation("artifacts.config.common.campsite.min_y").defineInRange("min_y", 1, 1, 255);
        this.campsiteMaxY = builder.comment("The maximum y-level at which a campsite can generate").translation("artifacts.config.common.campsite.max_y").defineInRange("max_y", 45, 1, 255);
        this.campsiteMimicChance = builder.comment("Probability for a container of a campsite to be replaced by a mimic").translation("artifacts.config.common.campsite.mimic_chance").defineInRange("mimic_chance", 0.3, 0.0, 1.0);
        this.campsiteOreChance = builder.comment("Probability for an ore vein to generate underneath a campsite").translation("artifacts.config.common.campsite.ore_chance").defineInRange("ore_chance", 0.25, 0.0, 1.0);
        this.useModdedChests = builder.comment(new String[]{"Whether to use wooden chests from other mods when generating campsites", "(keeping this enabled may make it easier to distinguish them from mimics)"}).translation("artifacts.config.common.campsite.use_modded_chests").define("use_modded_chests", true);
        builder.pop();
    }

    public void bake() {
        this.worldGenBiomeBlacklist = ((List)this.biomeBlacklist.get()).stream().filter(string -> !string.endsWith(":*")).map(ResourceLocation::new).collect(Collectors.toSet());
        this.worldGenModIdBlacklist = ((List)this.biomeBlacklist.get()).stream().filter(string -> string.endsWith(":*")).map(string -> string.substring(0, string.length() - 2)).collect(Collectors.toSet());
    }

    public boolean isBlacklisted(@Nullable ResourceLocation biome) {
        return biome != null && (this.worldGenBiomeBlacklist.contains(biome) || this.worldGenModIdBlacklist.contains(biome.func_110624_b()));
    }
}

