/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.config;

import artifacts.common.config.item.AntidoteVesselConfig;
import artifacts.common.config.item.BunnyHoppersConfig;
import artifacts.common.config.item.CloudInABottleConfig;
import artifacts.common.config.item.CrossNecklaceConfig;
import artifacts.common.config.item.CrystalHeartConfig;
import artifacts.common.config.item.DiggingClawsConfig;
import artifacts.common.config.item.DrinkingHatConfig;
import artifacts.common.config.item.EverlastingFoodConfig;
import artifacts.common.config.item.FeralClawsConfig;
import artifacts.common.config.item.FireGauntletConfig;
import artifacts.common.config.item.FlamePendantConfig;
import artifacts.common.config.item.FlippersConfig;
import artifacts.common.config.item.GoldenHookConfig;
import artifacts.common.config.item.HeliumFlamingoConfig;
import artifacts.common.config.item.ItemConfig;
import artifacts.common.config.item.LuckyScarfConfig;
import artifacts.common.config.item.ObsidianSkullConfig;
import artifacts.common.config.item.PanicNecklaceConfig;
import artifacts.common.config.item.PendantConfig;
import artifacts.common.config.item.PocketPistonConfig;
import artifacts.common.config.item.PowerGloveConfig;
import artifacts.common.config.item.RunningShoesConfig;
import artifacts.common.config.item.ShockPendantConfig;
import artifacts.common.config.item.SuperstitiousHatConfig;
import artifacts.common.config.item.ThornPendantConfig;
import artifacts.common.config.item.UmbrellaConfig;
import artifacts.common.config.item.UniversalAttractorConfig;
import artifacts.common.config.item.VampiricGloveConfig;
import artifacts.common.config.item.VillagerHatConfig;
import artifacts.common.config.item.WhoopeeCushionConfig;
import artifacts.common.init.ModItems;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ServerConfig {
    public Set<Item> cosmetics = Collections.emptySet();
    public final Map<Item, ItemConfig> items;
    public final AntidoteVesselConfig antidoteVessel;
    public final BunnyHoppersConfig bunnyHoppers;
    public final CloudInABottleConfig cloudInABottle;
    public final CrossNecklaceConfig crossNecklace;
    public final CrystalHeartConfig crystalHeart;
    public final DiggingClawsConfig diggingClaws;
    public final Map<Item, DrinkingHatConfig> drinkingHats;
    public final Map<Item, EverlastingFoodConfig> everlastingFoods;
    public final FeralClawsConfig feralClaws;
    public final FireGauntletConfig fireGauntlet;
    public final FlamePendantConfig flamePendant;
    public final FlippersConfig flippers;
    public final GoldenHookConfig goldenHook;
    public final HeliumFlamingoConfig heliumFlamingo;
    public final LuckyScarfConfig luckyScarf;
    public final ObsidianSkullConfig obsidianSkull;
    public final PanicNecklaceConfig panicNecklace;
    public final Map<Item, PendantConfig> pendants;
    public final PocketPistonConfig pocketPiston;
    public final PowerGloveConfig powerGlove;
    public final RunningShoesConfig runningShoes;
    public final SuperstitiousHatConfig superstitiousHat;
    public final ThornPendantConfig thornPendant;
    public final UmbrellaConfig umbrella;
    public final UniversalAttractorConfig universalAttractor;
    public final VampiricGloveConfig vampiricGlove;
    public final VillagerHatConfig villagerHat;
    public final WhoopeeCushionConfig whoopeeCushion;
    private final ForgeConfigSpec.ConfigValue<List<String>> cosmeticsValue;

    ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("items");
        this.cosmeticsValue = builder.worldRestart().comment(new String[]{"List of cosmetic-only items. All items in this list will have their effects disabled", "To blacklist all items, use \"artifacts:*\"", "Note: blacklisting an item while it is equipped may have unintended side effects", "To completely prevent items from appearing, use a data pack"}).translation("artifacts.config.server.cosmetics").define("cosmetics", (Object)Lists.newArrayList((Object[])new String[]{""}));
        this.items = new HashMap<Item, ItemConfig>();
        this.drinkingHats = new HashMap<Item, DrinkingHatConfig>();
        this.everlastingFoods = new HashMap<Item, EverlastingFoodConfig>();
        this.pendants = new HashMap<Item, PendantConfig>();
        this.antidoteVessel = this.addItemConfig(new AntidoteVesselConfig(builder));
        this.addItemConfig(new ItemConfig(builder, (Item)ModItems.AQUA_DASHERS.get(), "Affects how many seconds the player can run on fluids using the aqua dashers before breaking"));
        this.bunnyHoppers = this.addItemConfig(new BunnyHoppersConfig(builder));
        this.addItemConfig(new ItemConfig(builder, (Item)ModItems.CHARM_OF_SINKING.get(), "Affects how many seconds the player can stay underwater using the charm of sinking before breaking"));
        this.cloudInABottle = this.addItemConfig(new CloudInABottleConfig(builder));
        this.crossNecklace = this.addItemConfig(new CrossNecklaceConfig(builder));
        this.crystalHeart = this.addItemConfig(new CrystalHeartConfig(builder));
        this.diggingClaws = this.addItemConfig(new DiggingClawsConfig(builder));
        this.drinkingHats.put((Item)ModItems.PLASTIC_DRINKING_HAT.get(), this.addItemConfig(new DrinkingHatConfig(builder, (Item)ModItems.PLASTIC_DRINKING_HAT.get())));
        this.drinkingHats.put((Item)ModItems.NOVELTY_DRINKING_HAT.get(), this.addItemConfig(new DrinkingHatConfig(builder, (Item)ModItems.NOVELTY_DRINKING_HAT.get())));
        this.everlastingFoods.put((Item)ModItems.EVERLASTING_BEEF.get(), this.addItemConfig(new EverlastingFoodConfig(builder, (Item)ModItems.EVERLASTING_BEEF.get())));
        this.everlastingFoods.put((Item)ModItems.ETERNAL_STEAK.get(), this.addItemConfig(new EverlastingFoodConfig(builder, (Item)ModItems.ETERNAL_STEAK.get())));
        this.feralClaws = this.addItemConfig(new FeralClawsConfig(builder));
        this.fireGauntlet = this.addItemConfig(new FireGauntletConfig(builder));
        this.flamePendant = this.addItemConfig(new FlamePendantConfig(builder));
        this.pendants.put((Item)ModItems.FLAME_PENDANT.get(), this.flamePendant);
        this.flippers = this.addItemConfig(new FlippersConfig(builder));
        this.goldenHook = this.addItemConfig(new GoldenHookConfig(builder));
        this.heliumFlamingo = this.addItemConfig(new HeliumFlamingoConfig(builder));
        this.addItemConfig(new ItemConfig(builder, (Item)ModItems.KITTY_SLIPPERS.get(), "Affects how many creepers the player can attack using the kitty slippers before breaking"));
        this.luckyScarf = this.addItemConfig(new LuckyScarfConfig(builder));
        this.addItemConfig(new ItemConfig(builder, (Item)ModItems.NIGHT_VISION_GOGGLES.get(), "Affects how many seconds the night vision effect should apply before breaking"));
        this.obsidianSkull = this.addItemConfig(new ObsidianSkullConfig(builder));
        this.panicNecklace = this.addItemConfig(new PanicNecklaceConfig(builder));
        this.pocketPiston = this.addItemConfig(new PocketPistonConfig(builder));
        this.powerGlove = this.addItemConfig(new PowerGloveConfig(builder));
        this.runningShoes = this.addItemConfig(new RunningShoesConfig(builder));
        this.addItemConfig(new ItemConfig(builder, (Item)ModItems.SCARF_OF_INVISIBILITY.get(), "Affects how many seconds the invisibility effect should apply before breaking"));
        this.pendants.put((Item)ModItems.SHOCK_PENDANT.get(), this.addItemConfig(new ShockPendantConfig(builder)));
        this.addItemConfig(new ItemConfig(builder, (Item)ModItems.SNORKEL.get(), "Affects how many seconds the player can stay underwater using the snorkel before breaking"));
        this.addItemConfig(new ItemConfig(builder, (Item)ModItems.STEADFAST_SPIKES.get(), "Affects how many times the player can be hit while wearing steadfast spikes before breaking"));
        this.superstitiousHat = this.addItemConfig(new SuperstitiousHatConfig(builder));
        this.thornPendant = this.addItemConfig(new ThornPendantConfig(builder));
        this.pendants.put((Item)ModItems.THORN_PENDANT.get(), this.thornPendant);
        this.umbrella = this.addItemConfig(new UmbrellaConfig(builder));
        this.universalAttractor = this.addItemConfig(new UniversalAttractorConfig(builder));
        this.vampiricGlove = this.addItemConfig(new VampiricGloveConfig(builder));
        this.villagerHat = this.addItemConfig(new VillagerHatConfig(builder));
        this.whoopeeCushion = this.addItemConfig(new WhoopeeCushionConfig(builder));
        builder.pop();
    }

    private <T extends ItemConfig> T addItemConfig(T config) {
        this.items.put(config.getItem(), config);
        return config;
    }

    public void bake() {
        this.cosmetics = ((List)this.cosmeticsValue.get()).contains("artifacts:*") ? ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.getRegistryName().func_110624_b().equals("artifacts")).collect(Collectors.toSet()) : ((List)this.cosmeticsValue.get()).stream().map(ResourceLocation::new).filter(registryName -> registryName.func_110624_b().equals("artifacts")).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).collect(Collectors.toSet());
        this.items.forEach((item, config) -> config.bake());
    }

    public boolean isCosmetic(Item item) {
        return this.cosmetics.contains(item);
    }
}

