/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.config.item;

import artifacts.common.config.item.ItemConfig;
import artifacts.common.init.ModItems;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;

public class DiggingClawsConfig
extends ItemConfig {
    public ForgeConfigSpec.DoubleValue miningSpeedBonus;
    public ForgeConfigSpec.IntValue harvestLevel;
    public ForgeConfigSpec.ConfigValue<List<String>> toolTypes;

    public DiggingClawsConfig(ForgeConfigSpec.Builder builder) {
        super(builder, (Item)ModItems.DIGGING_CLAWS.get(), "Affects how many blocks the player can break using the digging claws before breaking");
    }

    @Override
    public void addConfigs(ForgeConfigSpec.Builder builder) {
        this.miningSpeedBonus = builder.worldRestart().comment("Mining speed bonus applied by digging claws").translation(this.translate("mining_speed_bonus")).defineInRange("mining_speed_bonus", 3.2, 0.0, Double.POSITIVE_INFINITY);
        this.harvestLevel = builder.comment(new String[]{"The player's base harvest level when wearing digging claws", "The player's harvest level is equal to MAX(<digging claws harvest level>, <tool harvest level>)", "Harvest level 0 is no tool, 1 for a wooden tool, 2 stone etc."}).translation(this.translate("harvest_level")).defineInRange("harvest_level", 2, 0, Integer.MAX_VALUE);
        this.toolTypes = builder.comment(new String[]{"The tool types of the digging claws", "Blocks that do not have these tool types are not affected by the digging claws", "Use \"*\" to give digging claws all tool types"}).translation(this.translate("tool_types")).define("tool_types", (Object)Lists.newArrayList((Object[])new String[]{"*"}));
    }
}

