/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.config.item;

import artifacts.common.config.item.ItemConfig;
import artifacts.common.init.ModItems;
import net.minecraft.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;

public class GoldenHookConfig
extends ItemConfig {
    public ForgeConfigSpec.IntValue trackedEntities;
    public ForgeConfigSpec.DoubleValue maximumKillRatio;
    public ForgeConfigSpec.DoubleValue minExperienceMultiplier;
    public ForgeConfigSpec.DoubleValue maxExperienceMultiplier;
    public ForgeConfigSpec.IntValue maxExperience;

    public GoldenHookConfig(ForgeConfigSpec.Builder builder) {
        super(builder, (Item)ModItems.GOLDEN_HOOK.get(), "Affects how many enemies can be killed using the golden hook");
    }

    @Override
    public void addConfigs(ForgeConfigSpec.Builder builder) {
        this.trackedEntities = builder.worldRestart().comment(new String[]{"Affects the amount of recently killed entities to track", "The amount of extra experience gained from using the golden hook depends on the last x amount of entities killed", "The fewer entities of the same type recently killed, the more experience is dropped"}).translation(this.translate("tracked_entities")).defineInRange("tracked_entities", 25, 1, Integer.MAX_VALUE);
        this.maximumKillRatio = builder.comment(new String[]{"Affects the amount of entities of a type that can be killed before entities of that type will no longer drop extra experience", "If the ratio of entities of the same type recently killed over the total amount of entities recently killed is greater than this value,", "the extra experience dropped is equal to min_experience_multiplier"}).translation(this.translate("maximum_kill_ratio")).defineInRange("maximum_kill_ratio", 0.5, 0.0, 1.0);
        this.maxExperienceMultiplier = builder.comment(new String[]{"The maximum amount of extra experience (multiplied with total xp) dropped from entities while wearing the golden hook", "The maximum amount is only dropped when none of the recently killed entities are of the same type", "Otherwise the amount of experience dropped will be somewhere between the maximum and minimum"}).translation(this.translate("max_experience_multiplier")).defineInRange("max_experience_multiplier", 5.0, 0.0, Double.POSITIVE_INFINITY);
        this.minExperienceMultiplier = builder.comment(new String[]{"The minimum amount of extra experience (multiplied with total xp) dropped from entities while wearing the golden hook", "1 if entities should drop no extra experience if the maximum kill ratio has been reached"}).translation(this.translate("min_experience_multiplier")).defineInRange("min_experience_multiplier", 0.0, 0.0, Double.POSITIVE_INFINITY);
        this.maxExperience = builder.comment("The maximum amount of extra experience dropped by entities").translation(this.translate("max_experience")).defineInRange("max_experience", 50, 0, Integer.MAX_VALUE);
    }
}

