/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.config.item;

import artifacts.common.config.item.PendantConfig;
import artifacts.common.init.ModItems;
import net.minecraft.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;

public class ThornPendantConfig
extends PendantConfig {
    public ForgeConfigSpec.IntValue minDamage;
    public ForgeConfigSpec.IntValue maxDamage;

    public ThornPendantConfig(ForgeConfigSpec.Builder builder) {
        super(builder, (Item)ModItems.THORN_PENDANT.get());
    }

    @Override
    public void addConfigs(ForgeConfigSpec.Builder builder) {
        super.addConfigs(builder);
        this.minDamage = builder.comment(new String[]{"Minimum damage dealt by thorn pendant", "Damage dealt is a random number between min_damage and max_damage"}).translation(this.translate("min_damage")).defineInRange("min_damage", 2, 0, Integer.MAX_VALUE);
        this.maxDamage = builder.comment("Maximum damage dealt by thorn pendant").translation(this.translate("max_damage")).defineInRange("max_damage", 6, 0, Integer.MAX_VALUE);
    }

    @Override
    protected double getDefaultStrikeChance() {
        return 0.5;
    }
}

