/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.config.item;

import artifacts.common.config.item.ItemConfig;
import artifacts.common.init.ModItems;
import net.minecraft.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;

public class UniversalAttractorConfig
extends ItemConfig {
    public ForgeConfigSpec.IntValue range;
    public ForgeConfigSpec.DoubleValue motionMultiplier;
    public ForgeConfigSpec.IntValue cooldown;

    public UniversalAttractorConfig(ForgeConfigSpec.Builder builder) {
        super(builder, (Item)ModItems.UNIVERSAL_ATTRACTOR.get(), "Affects how many items can be picked up using the universal attractor");
    }

    @Override
    public void addConfigs(ForgeConfigSpec.Builder builder) {
        this.range = builder.worldRestart().comment("The range (in blocks) of the universal attractor").translation(this.translate("range")).defineInRange("range", 5, 0, Integer.MAX_VALUE);
        this.motionMultiplier = builder.comment("Affects how fast items are moved towards the player").translation(this.translate("motion_multiplier")).defineInRange("motionMultiplier", 0.6, 0.0, Double.POSITIVE_INFINITY);
        this.cooldown = builder.comment("The cooldown (in ticks) after throwing an item").translation("artifacts.server.items.cooldown").defineInRange("cooldown", 200, 0, Integer.MAX_VALUE);
    }
}

