/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item;

import artifacts.client.render.model.curio.belt.AntidoteVesselModel;
import artifacts.common.config.ModConfig;
import artifacts.common.item.CurioItem;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class AntidoteVesselItem
extends CurioItem {
    private static final ResourceLocation TEXTURE = new ResourceLocation("artifacts", "textures/entity/curio/antidote_vessel.png");

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.field_187615_H, 1.0f, 1.0f);
    }

    public void curioTick(String identifier, int index, LivingEntity entity, ItemStack stack) {
        if (!ModConfig.server.isCosmetic(this)) {
            HashMap<Effect, EffectInstance> effects = new HashMap<Effect, EffectInstance>();
            int maxEffectDuration = (Integer)ModConfig.server.antidoteVessel.maxEffectDuration.get();
            entity.func_193076_bZ().forEach((effect, instance) -> {
                Set<Effect> negativeEffects = ModConfig.server.antidoteVessel.negativeEffects;
                if (negativeEffects.contains(effect) && instance.func_76459_b() > maxEffectDuration) {
                    effects.put((Effect)effect, (EffectInstance)instance);
                }
            });
            effects.forEach((effect, instance) -> {
                this.damageStack(identifier, index, entity, stack);
                entity.func_184596_c(effect);
                if (maxEffectDuration > 0) {
                    entity.func_195064_c(new EffectInstance(effect, maxEffectDuration, instance.func_76458_c(), instance.func_82720_e(), instance.func_188418_e(), instance.func_205348_f()));
                }
            });
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected BipedModel<LivingEntity> createModel() {
        return new AntidoteVesselModel();
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }
}

